/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.flatfile.schema.test;

import com.mulesoft.flatfile.schema.EdiSchema;
import com.mulesoft.flatfile.schema.SchemaJavaValues;
import com.mulesoft.flatfile.schema.YamlReader;
import com.mulesoft.flatfile.schema.tools.Decode997;
import com.mulesoft.flatfile.schema.tools.Decode999;
import com.mulesoft.flatfile.schema.tools.DocumentTest;
import com.mulesoft.flatfile.schema.tools.DocumentTestX12;
import com.mulesoft.flatfile.schema.tools.YamlSupport;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class TestX12Document {
    private static final String CHARSET = "ISO8859-1";

    private static EdiSchema loadSchema(String path) {
        try {
            YamlReader yamlrdr = new YamlReader();
            InputStream is = yamlrdr.findSchema(path, new String[]{""});
            return yamlrdr.loadYaml((Reader)new InputStreamReader(is, "ASCII"), new String[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not load schema file " + path, e);
        }
    }

    private static String readAsString(String path) throws IOException {
        int actual;
        File file = new File(path);
        if (!file.exists()) {
            throw new IllegalArgumentException("Path " + path + " not found");
        }
        FileInputStream is = new FileInputStream(file);
        InputStreamReader reader = new InputStreamReader((InputStream)is, CHARSET);
        StringWriter writer = new StringWriter();
        char[] buff = new char[2048];
        while ((actual = reader.read(buff)) > 0) {
            writer.write(buff, 0, actual);
        }
        ((InputStream)is).close();
        return writer.toString();
    }

    private static void printAcknowledgments(Map<String, Object> result, boolean ack999) {
        List acks = (List)result.get(SchemaJavaValues.functionalAcksGenerated());
        if (acks != null) {
            for (Map ack : acks) {
                if (ack999) {
                    System.out.println(Decode999.decode((Map)ack));
                    continue;
                }
                System.out.println(Decode997.decode((Map)ack));
            }
        }
    }

    private static String stripLineBreaks(String text) {
        int length = text.length();
        StringBuilder builder = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char chr = text.charAt(i);
            if (chr == '\r' || chr == '\n') continue;
            builder.append(chr);
        }
        return builder.toString();
    }

    private static void checkWrite(DocumentTest test, String text, Map<String, Object> result) {
        String input = TestX12Document.stripLineBreaks(text);
        String output = TestX12Document.stripLineBreaks(test.printDoc(result));
        System.out.println("\nOutput comparison:");
        if (output.length() != input.length()) {
            System.out.println("Different lengths (" + output.length() + " vs " + input.length() + ")");
        }
        int length = Math.min(input.length(), output.length());
        int index = -1;
        while (++index < length) {
            if (input.charAt(index) == output.charAt(index)) continue;
            System.out.println("Different text starting at " + index);
            int base = Math.max(index - 40, 0);
            int limit = Math.min(index + 40, length);
            System.out.println("output '" + output.substring(base, limit) + "'");
            System.out.println("input  '" + input.substring(base, limit) + "'");
        }
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            throw new IllegalArgumentException("Missing required argument(s): schema-path file-path");
        }
        if (args.length > 4) {
            throw new IllegalArgumentException("Too many argument(s): schema-path file-path [997/999] [print/noprint]");
        }
        boolean ack999 = args.length > 2 && "999".equals(args[2]);
        boolean print = args.length > 3 && "print".equals(args[3]);
        EdiSchema schema = TestX12Document.loadSchema(args[0]);
        DocumentTestX12 test = new DocumentTestX12(schema, ack999);
        try {
            String input = TestX12Document.readAsString(args[1]);
            ByteArrayInputStream is = new ByteArrayInputStream(input.getBytes(CHARSET));
            Map result = test.parse((InputStream)is);
            System.out.println("Interchange acknowledgement(s):");
            System.out.println(test.printInterchangeAcks("*>U~", (Collection)((List)result.get(SchemaJavaValues.interchangeAcksGenerated()))));
            System.out.println("\nFunctional acknowledgement(s):");
            TestX12Document.printAcknowledgments(result, ack999);
            test.prepareOutput(result);
            if (!result.containsKey(SchemaJavaValues.delimiterCharacters())) {
                result.put(SchemaJavaValues.delimiterCharacters(), "*>U~");
            }
            System.out.println(test.printAck(result));
            if (print) {
                StringWriter writer = new StringWriter();
                YamlSupport.writeMap((Map)result, (Writer)writer);
                String output = writer.toString();
                System.out.println("\nMessage data:");
                System.out.println(output);
            }
            TestX12Document.checkWrite((DocumentTest)test, input, result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

