/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.flatfile.lexical.formats;

import com.mulesoft.flatfile.lexical.ErrorHandler;
import com.mulesoft.flatfile.lexical.LexerBase;
import com.mulesoft.flatfile.lexical.LexicalException;
import com.mulesoft.flatfile.lexical.TypeFormatConstants;
import com.mulesoft.flatfile.lexical.WriterBase;
import com.mulesoft.flatfile.lexical.formats.StringFormatBase;

public class RestrictedCharacterStringFormat
extends StringFormatBase {
    private final boolean[] allowedChars;
    private final boolean openEnded;

    public RestrictedCharacterStringFormat(String code2, int min2, int max2, TypeFormatConstants.FillMode fill2, boolean[] allowed, boolean open) {
        super(code2, min2, max2, fill2);
        this.allowedChars = allowed;
        this.openEnded = open;
    }

    @Override
    public TypeFormatConstants.GenericType genericType() {
        return TypeFormatConstants.GenericType.STRING;
    }

    @Override
    public Object parseToken(LexerBase lexer) throws LexicalException {
        if (this.allowedChars != null) {
            StringBuilder builder = lexer.tokenBuilder();
            for (int i = 0; i < builder.length(); ++i) {
                char chr = builder.charAt(i);
                boolean invalid = false;
                if (chr >= this.allowedChars.length) {
                    invalid = !this.openEnded;
                } else if (!this.allowedChars[chr]) {
                    invalid = true;
                }
                if (!invalid) continue;
                this.invalidCharacter(chr, lexer);
                int subst2 = lexer.getSubstitutionChar();
                if (subst2 > 0) {
                    builder.setCharAt(i, (char)lexer.getSubstitutionChar());
                    continue;
                }
                if (subst2 != 0) continue;
                builder.deleteCharAt(i--);
            }
        }
        return lexer.token();
    }

    @Override
    public String buildToken(Object value2, WriterBase writer) throws LexicalException {
        if (!(value2 instanceof String)) {
            writer.error(this, ErrorHandler.ErrorCondition.WRONG_TYPE, "wrong value type " + value2.getClass().getName());
        }
        String text2 = value2.toString();
        if (this.allowedChars != null) {
            for (int i = 0; i < text2.length(); ++i) {
                char chr = text2.charAt(i);
                boolean invalid = false;
                if (chr >= this.allowedChars.length) {
                    invalid = !this.openEnded;
                } else if (!this.allowedChars[chr]) {
                    invalid = true;
                }
                if (!invalid) continue;
                this.invalidCharacter(chr, writer);
                int subst2 = writer.getSubstitutionChar();
                if (subst2 > 0) {
                    text2 = text2.substring(0, i) + (char)subst2 + text2.substring(i + 1);
                    continue;
                }
                if (subst2 != 0) continue;
                text2 = text2.substring(0, i) + text2.substring(i + 1);
            }
        }
        return text2;
    }
}

