/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.flatfile.lexical.formats;

import com.mulesoft.flatfile.lexical.ErrorHandler;
import com.mulesoft.flatfile.lexical.LexerBase;
import com.mulesoft.flatfile.lexical.LexicalException;
import com.mulesoft.flatfile.lexical.TypeFormatConstants;
import com.mulesoft.flatfile.lexical.WriteException;
import com.mulesoft.flatfile.lexical.WriterBase;
import com.mulesoft.flatfile.lexical.formats.TypeFormatBase;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.threeten.bp.Instant;
import org.threeten.bp.LocalDate;
import org.threeten.bp.ZoneId;
import org.threeten.bp.ZonedDateTime;

public class X12DateFormat
extends TypeFormatBase {
    public X12DateFormat(String code2, int min2, int max2) {
        super(code2, min2, max2);
    }

    @Override
    public TypeFormatConstants.GenericType genericType() {
        return TypeFormatConstants.GenericType.DATE;
    }

    @Override
    public Object parse(LexerBase lexer) throws LexicalException {
        int year;
        StringBuilder builder = lexer.tokenBuilder();
        int length = builder.length();
        if (length != 6 && length != 8) {
            lexer.error(this, ErrorHandler.ErrorCondition.INVALID_DATE, "date value must be either 6 or 8 characters");
        }
        this.checkInputLength(lexer);
        this.verifyDigits(lexer);
        int day = builder.charAt(length - 1) - 48 + (builder.charAt(length - 2) - 48) * 10;
        int month = builder.charAt(length - 3) - 48 + (builder.charAt(length - 4) - 48) * 10;
        if (month == 0 || month > 12 || day == 0 || day > 31) {
            lexer.error(this, ErrorHandler.ErrorCondition.INVALID_DATE, "month or day out of allowed range");
        }
        if (length == 8) {
            year = Integer.parseInt(builder.substring(0, 4));
        } else {
            year = 2000 + (builder.charAt(1) - 48) + (builder.charAt(0) - 48) * 10;
            if (year > 2070) {
                year -= 100;
            }
        }
        return new GregorianCalendar(year, month - 1, day);
    }

    public void writeDate(Calendar calendar, WriterBase writer) throws IOException {
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        int day = calendar.get(5);
        StringBuilder builder = new StringBuilder();
        builder.append(year);
        if (this.maxLength == 6) {
            if (year > 2070 || year <= 1970) {
                throw new WriteException("year out of range for short form date");
            }
            builder.delete(0, 2);
        } else {
            if (builder.length() > 4) {
                throw new WriteException("year outside of allowed range");
            }
            while (builder.length() < 4) {
                builder.insert(0, '0');
            }
        }
        X12DateFormat.appendTwoDigit(month, builder);
        X12DateFormat.appendTwoDigit(day, builder);
        writer.startToken();
        writer.writeUnchecked(builder.toString());
    }

    @Override
    public void write(Object value2, WriterBase writer) throws IOException {
        if (value2 instanceof Calendar) {
            this.writeDate((Calendar)value2, writer);
        } else if (value2 instanceof Date) {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime((Date)value2);
            this.writeDate(calendar, writer);
        } else if (value2 instanceof Instant) {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTimeInMillis(((Instant)value2).toEpochMilli());
            this.writeDate(calendar, writer);
        } else if (value2 instanceof LocalDate) {
            LocalDate localDate = (LocalDate)value2;
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTimeInMillis(localDate.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant().toEpochMilli());
            this.writeDate(calendar, writer);
        } else if (value2 instanceof ZonedDateTime) {
            ZonedDateTime zoned = (ZonedDateTime)value2;
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTimeInMillis(zoned.toInstant().toEpochMilli());
            this.writeDate(calendar, writer);
        } else {
            this.wrongType(value2, writer);
        }
    }
}

