/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.flatfile.lexical.formats;

import com.mulesoft.flatfile.lexical.LexerBase;
import com.mulesoft.flatfile.lexical.LexicalException;
import com.mulesoft.flatfile.lexical.TypeFormatConstants;
import com.mulesoft.flatfile.lexical.WriterBase;
import com.mulesoft.flatfile.lexical.formats.NumberFormatBase;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;

public class ImpliedDecimalFormat
extends NumberFormatBase {
    private final int decimalPosition;

    public ImpliedDecimalFormat(String code, int min2, int max2, TypeFormatConstants.NumberSign sign, boolean count2, TypeFormatConstants.FillMode mode, int pos) {
        super(code, min2, max2, sign, count2, mode, '0');
        this.decimalPosition = pos;
    }

    @Override
    public TypeFormatConstants.GenericType genericType() {
        return TypeFormatConstants.GenericType.REAL;
    }

    @Override
    public Object parse(LexerBase lexer) throws LexicalException {
        this.checkIntegerFormat(lexer);
        return new BigDecimal(new BigInteger(lexer.token()), this.decimalPosition);
    }

    @Override
    public void write(Object value, WriterBase writer) throws IOException {
        writer.startToken();
        if (value instanceof BigDecimal) {
            BigDecimal decimal = (BigDecimal)value;
            decimal = decimal.movePointRight(this.decimalPosition).setScale(this.decimalPosition, RoundingMode.HALF_UP);
            this.writeBigInteger(decimal.toBigIntegerExact(), writer);
        } else {
            this.wrongType(value, writer);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ImpliedDecimalFormat && super.equals(obj)) {
            return this.decimalPosition == ((ImpliedDecimalFormat)obj).decimalPosition;
        }
        return false;
    }
}

