/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.2.12.3.simple;

import java.io.PrintStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.apache.logging.log4j.2.12.3.Level;
import org.apache.logging.log4j.2.12.3.Marker;
import org.apache.logging.log4j.2.12.3.ThreadContext;
import org.apache.logging.log4j.2.12.3.message.Message;
import org.apache.logging.log4j.2.12.3.message.MessageFactory;
import org.apache.logging.log4j.2.12.3.spi.AbstractLogger;
import org.apache.logging.log4j.2.12.3.util.PropertiesUtil;
import org.apache.logging.log4j.2.12.3.util.Strings;

public class SimpleLogger
extends AbstractLogger {
    private static final long serialVersionUID = 1L;
    private static final char SPACE = ' ';
    private final DateFormat dateFormatter;
    private Level level;
    private final boolean showDateTime;
    private final boolean showContextMap;
    private PrintStream stream;
    private final String logName;

    public SimpleLogger(String name, Level defaultLevel, boolean showLogName, boolean showShortLogName, boolean showDateTime, boolean showContextMap, String dateTimeFormat, MessageFactory messageFactory, PropertiesUtil props, PrintStream stream2) {
        super(name, messageFactory);
        int index2;
        String lvl = props.getStringProperty("org.apache.logging.log4j.2.12.3.simplelog." + name + ".level");
        this.level = Level.toLevel(lvl, defaultLevel);
        this.logName = showShortLogName ? ((index2 = name.lastIndexOf(".")) > 0 && index2 < name.length() ? name.substring(index2 + 1) : name) : (showLogName ? name : null);
        this.showDateTime = showDateTime;
        this.showContextMap = showContextMap;
        this.stream = stream2;
        if (showDateTime) {
            SimpleDateFormat format2;
            try {
                format2 = new SimpleDateFormat(dateTimeFormat);
            }
            catch (IllegalArgumentException e) {
                format2 = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss:SSS zzz");
            }
            this.dateFormatter = format2;
        } else {
            this.dateFormatter = null;
        }
    }

    @Override
    public Level getLevel() {
        return this.level;
    }

    @Override
    public boolean isEnabled(Level testLevel, Marker marker, Message msg, Throwable t) {
        return this.level.intLevel() >= testLevel.intLevel();
    }

    @Override
    public boolean isEnabled(Level testLevel, Marker marker, CharSequence msg, Throwable t) {
        return this.level.intLevel() >= testLevel.intLevel();
    }

    @Override
    public boolean isEnabled(Level testLevel, Marker marker, Object msg, Throwable t) {
        return this.level.intLevel() >= testLevel.intLevel();
    }

    @Override
    public boolean isEnabled(Level testLevel, Marker marker, String msg) {
        return this.level.intLevel() >= testLevel.intLevel();
    }

    @Override
    public boolean isEnabled(Level testLevel, Marker marker, String msg, Object ... p1) {
        return this.level.intLevel() >= testLevel.intLevel();
    }

    @Override
    public boolean isEnabled(Level testLevel, Marker marker, String message, Object p0) {
        return this.level.intLevel() >= testLevel.intLevel();
    }

    @Override
    public boolean isEnabled(Level testLevel, Marker marker, String message, Object p0, Object p1) {
        return this.level.intLevel() >= testLevel.intLevel();
    }

    @Override
    public boolean isEnabled(Level testLevel, Marker marker, String message, Object p0, Object p1, Object p2) {
        return this.level.intLevel() >= testLevel.intLevel();
    }

    @Override
    public boolean isEnabled(Level testLevel, Marker marker, String message, Object p0, Object p1, Object p2, Object p3) {
        return this.level.intLevel() >= testLevel.intLevel();
    }

    @Override
    public boolean isEnabled(Level testLevel, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4) {
        return this.level.intLevel() >= testLevel.intLevel();
    }

    @Override
    public boolean isEnabled(Level testLevel, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5) {
        return this.level.intLevel() >= testLevel.intLevel();
    }

    @Override
    public boolean isEnabled(Level testLevel, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6) {
        return this.level.intLevel() >= testLevel.intLevel();
    }

    @Override
    public boolean isEnabled(Level testLevel, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7) {
        return this.level.intLevel() >= testLevel.intLevel();
    }

    @Override
    public boolean isEnabled(Level testLevel, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8) {
        return this.level.intLevel() >= testLevel.intLevel();
    }

    @Override
    public boolean isEnabled(Level testLevel, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8, Object p9) {
        return this.level.intLevel() >= testLevel.intLevel();
    }

    @Override
    public boolean isEnabled(Level testLevel, Marker marker, String msg, Throwable t) {
        return this.level.intLevel() >= testLevel.intLevel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logMessage(String fqcn, Level mgsLevel, Marker marker, Message msg, Throwable throwable) {
        Map<String, String> mdc;
        StringBuilder sb = new StringBuilder();
        if (this.showDateTime) {
            String dateText;
            Date now = new Date();
            DateFormat dateFormat = this.dateFormatter;
            synchronized (dateFormat) {
                dateText = this.dateFormatter.format(now);
            }
            sb.append(dateText);
            sb.append(' ');
        }
        sb.append(mgsLevel.toString());
        sb.append(' ');
        if (Strings.isNotEmpty(this.logName)) {
            sb.append(this.logName);
            sb.append(' ');
        }
        sb.append(msg.getFormattedMessage());
        if (this.showContextMap && (mdc = ThreadContext.getImmutableContext()).size() > 0) {
            sb.append(' ');
            sb.append(mdc.toString());
            sb.append(' ');
        }
        Object[] params2 = msg.getParameters();
        Throwable t = throwable == null && params2 != null && params2.length > 0 && params2[params2.length - 1] instanceof Throwable ? (Throwable)params2[params2.length - 1] : throwable;
        this.stream.println(sb.toString());
        if (t != null) {
            this.stream.print(' ');
            t.printStackTrace(this.stream);
        }
    }

    public void setLevel(Level level) {
        if (level != null) {
            this.level = level;
        }
    }

    public void setStream(PrintStream stream2) {
        this.stream = stream2;
    }
}

