/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.util;

import java.util.Collection;
import java.util.Map;

public final class Assert {
    private Assert() {
    }

    public static boolean isEmpty(Object o) {
        if (o == null) {
            return true;
        }
        if (o instanceof CharSequence) {
            return ((CharSequence)o).length() == 0;
        }
        if (o.getClass().isArray()) {
            return ((Object[])o).length == 0;
        }
        if (o instanceof Collection) {
            return ((Collection)o).isEmpty();
        }
        if (o instanceof Map) {
            return ((Map)o).isEmpty();
        }
        return false;
    }

    public static boolean isNonEmpty(Object o) {
        return !Assert.isEmpty(o);
    }

    public static <T> T requireNonEmpty(T value2) {
        return Assert.requireNonEmpty(value2, "");
    }

    public static <T> T requireNonEmpty(T value2, String message) {
        if (Assert.isEmpty(value2)) {
            throw new IllegalArgumentException(message);
        }
        return value2;
    }

    public static int valueIsAtLeast(int value2, int minValue) {
        if (value2 < minValue) {
            throw new IllegalArgumentException("Value should be at least " + minValue + " but was " + value2);
        }
        return value2;
    }
}

