/*
 * Decompiled with CFR 0.152.
 */
package com.lmax.disruptor;

import com.lmax.disruptor.RhsPadding;
import com.lmax.disruptor.Value;
import com.lmax.disruptor.util.Util;
import sun.misc.Unsafe;

public class Sequence
extends RhsPadding {
    static final long INITIAL_VALUE = -1L;
    private static final Unsafe UNSAFE = Util.getUnsafe();
    private static final long VALUE_OFFSET;

    public Sequence() {
        this(-1L);
    }

    public Sequence(long initialValue) {
        UNSAFE.putOrderedLong(this, VALUE_OFFSET, initialValue);
    }

    public long get() {
        return this.value;
    }

    public void set(long value2) {
        UNSAFE.putOrderedLong(this, VALUE_OFFSET, value2);
    }

    public void setVolatile(long value2) {
        UNSAFE.putLongVolatile(this, VALUE_OFFSET, value2);
    }

    public boolean compareAndSet(long expectedValue, long newValue) {
        return UNSAFE.compareAndSwapLong(this, VALUE_OFFSET, expectedValue, newValue);
    }

    public long incrementAndGet() {
        return this.addAndGet(1L);
    }

    public long addAndGet(long increment) {
        long newValue;
        long currentValue;
        while (!this.compareAndSet(currentValue = this.get(), newValue = currentValue + increment)) {
        }
        return newValue;
    }

    public String toString() {
        return Long.toString(this.get());
    }

    static {
        try {
            VALUE_OFFSET = UNSAFE.objectFieldOffset(Value.class.getDeclaredField("value"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

