/*
 * Decompiled with CFR 0.152.
 */
package spire.math;

import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.BigDecimal;
import scala.math.BigDecimal$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import spire.math.ConvertableTo$;
import spire.math.FixedPoint;
import spire.math.FixedPointInstances;
import spire.math.FixedPointInstances$class;
import spire.math.FixedPointOverflow;
import spire.math.FixedScale;
import spire.math.Fractional;
import spire.math.NumberTag;
import spire.math.Rational;
import spire.math.Rational$;
import spire.math.SafeLong;
import spire.math.SafeLong$;
import spire.math.package$;
import spire.syntax.LiteralLongOrderOps$;
import spire.syntax.package$order$;

public final class FixedPoint$
implements FixedPointInstances {
    public static final FixedPoint$ MODULE$;
    private final long zero;
    private final long MaxValue;
    private final long MinValue;
    private final NumberTag.CustomTag<FixedPoint> FixedPointTag;

    static {
        new FixedPoint$();
    }

    @Override
    public final NumberTag.CustomTag<FixedPoint> FixedPointTag() {
        return this.FixedPointTag;
    }

    @Override
    public final void spire$math$FixedPointInstances$_setter_$FixedPointTag_$eq(NumberTag.CustomTag x$1) {
        this.FixedPointTag = x$1;
    }

    @Override
    public Object algebra(FixedScale scale) {
        return FixedPointInstances$class.algebra(this, scale);
    }

    public long zero() {
        return this.zero;
    }

    public long MaxValue() {
        return this.MaxValue;
    }

    public long MinValue() {
        return this.MinValue;
    }

    public long one(FixedScale scale) {
        return scale.denom();
    }

    public long apply(long n, FixedScale scale) {
        return this.$times$extension1(n, scale.denom());
    }

    public long apply(Rational n, FixedScale scale) {
        Rational x = n.$times(Rational$.MODULE$.apply(scale.denom())).round();
        if (x.$less(Rational$.MODULE$.apply(Long.MIN_VALUE)) || x.$greater(Rational$.MODULE$.apply(Long.MAX_VALUE))) {
            throw new FixedPointOverflow(x.toLong());
        }
        return x.toLong();
    }

    public long apply(String s2, FixedScale scale) {
        return this.apply(Rational$.MODULE$.apply(s2), scale);
    }

    public <A> long apply(A a, FixedScale scale, Fractional<A> fr) {
        A x = fr.times(a, fr.fromInt(scale.denom()));
        if (fr.lt(x, fr.fromLong(Long.MIN_VALUE)) || fr.lt(fr.fromLong(Long.MAX_VALUE), x)) {
            throw new FixedPointOverflow(fr.toLong(x));
        }
        return fr.toLong(x);
    }

    public final long unary_$minus$extension(long $this) {
        if ($this != Long.MIN_VALUE) {
            return -$this;
        }
        throw new FixedPointOverflow($this);
    }

    public final boolean $eq$eq$extension(long $this, long rhs) {
        return $this == rhs;
    }

    public final boolean $bang$eq$extension(long $this, long rhs) {
        return $this != rhs;
    }

    public final long abs$extension(long $this) {
        block4: {
            long l;
            block3: {
                block2: {
                    if ($this < 0L) break block2;
                    l = $this;
                    break block3;
                }
                if ($this == Long.MIN_VALUE) break block4;
                l = -$this;
            }
            return l;
        }
        throw new FixedPointOverflow($this);
    }

    public final int signum$extension(long $this) {
        return Long.signum($this);
    }

    public final int compare$extension(long $this, long rhs) {
        return $this < rhs ? -1 : ($this == rhs ? 0 : 1);
    }

    public final boolean $less$extension(long $this, long rhs) {
        return $this < rhs;
    }

    public final boolean $less$eq$extension(long $this, long rhs) {
        return $this <= rhs;
    }

    public final boolean $greater$extension(long $this, long rhs) {
        return $this > rhs;
    }

    public final boolean $greater$eq$extension(long $this, long rhs) {
        return $this >= rhs;
    }

    public final long $plus$extension0(long $this, long rhs) {
        long n = $this + rhs;
        if ((($this ^ rhs ^ 0xFFFFFFFFFFFFFFFFL) & ($this ^ n)) < 0L) {
            throw new FixedPointOverflow(n);
        }
        return n;
    }

    public final long $plus$extension1(long $this, long rhs, FixedScale scale) {
        int d = scale.denom();
        long p = rhs * (long)d;
        Object object = rhs == 0L || d == 0 || rhs == p / (long)d && ((rhs ^ (long)d ^ p) & Long.MIN_VALUE) == 0L ? new FixedPoint(this.$plus$extension0($this, p)) : BoxedUnit.UNIT;
        SafeLong n = SafeLong$.MODULE$.apply(rhs).$times(d).$plus($this);
        if (n.$less(SafeLong$.MODULE$.apply(Long.MIN_VALUE)) || LiteralLongOrderOps$.MODULE$.$less$extension(package$order$.MODULE$.literalLongOrderOps(Long.MAX_VALUE), n, SafeLong$.MODULE$.SafeLongIsReal(), ConvertableTo$.MODULE$.ConvertableToSafeLong())) {
            throw new FixedPointOverflow(n.toLong());
        }
        return n.toLong();
    }

    public final long $minus$extension0(long $this, long rhs) {
        long n = $this - rhs;
        if ((($this ^ rhs) & ($this ^ n)) < 0L) {
            throw new FixedPointOverflow(n);
        }
        return n;
    }

    public final long $minus$extension1(long $this, long rhs, FixedScale scale) {
        int d = scale.denom();
        long p = rhs * (long)d;
        if (rhs == 0L || d == 0 || rhs == p / (long)d && ((rhs ^ (long)d ^ p) & Long.MIN_VALUE) == 0L) {
            return this.$minus$extension0($this, p);
        }
        SafeLong n = SafeLong$.MODULE$.apply($this).$minus(SafeLong$.MODULE$.apply(rhs).$times(d));
        if (n.$less(SafeLong$.MODULE$.apply(Long.MIN_VALUE)) || LiteralLongOrderOps$.MODULE$.$less$extension(package$order$.MODULE$.literalLongOrderOps(Long.MAX_VALUE), n, SafeLong$.MODULE$.SafeLongIsReal(), ConvertableTo$.MODULE$.ConvertableToSafeLong())) {
            throw new FixedPointOverflow(n.toLong());
        }
        return n.toLong();
    }

    public final long $times$extension0(long $this, long rhs, FixedScale scale) {
        SafeLong n;
        block3: {
            long l;
            if ($this < rhs) {
                return this.$times$extension0(rhs, $this, scale);
            }
            int d = scale.denom();
            long q = $this / (long)d;
            long r = $this % (long)d;
            long qq = this.$times$extension1(rhs, q);
            try {
                l = this.$div$extension1(this.$times$extension1(rhs, r), d);
            }
            catch (FixedPointOverflow fixedPointOverflow) {
                n = SafeLong$.MODULE$.apply(rhs).$times(r).$div(d);
                if (!n.isLong()) break block3;
                l = n.toLong();
            }
            long rr = l;
            return this.$plus$extension0(qq, rr);
        }
        throw new FixedPointOverflow(n.toLong());
    }

    public final long $times$extension1(long $this, long rhs) {
        long n = $this * rhs;
        if ($this == 0L || rhs == 0L || rhs == n / $this && (($this ^ rhs ^ n) & Long.MIN_VALUE) == 0L) {
            return n;
        }
        throw new FixedPointOverflow(n);
    }

    public final long $div$extension0(long $this, long rhs, FixedScale scale) {
        long l;
        try {
            l = this.$div$extension1(this.$times$extension1($this, scale.denom()), rhs);
        }
        catch (FixedPointOverflow fixedPointOverflow) {
            SafeLong n = SafeLong$.MODULE$.apply($this).$times(scale.denom()).$div(rhs);
            if (n.$less(SafeLong$.MODULE$.apply(Long.MIN_VALUE)) || LiteralLongOrderOps$.MODULE$.$less$extension(package$order$.MODULE$.literalLongOrderOps(Long.MAX_VALUE), n, SafeLong$.MODULE$.SafeLongIsReal(), ConvertableTo$.MODULE$.ConvertableToSafeLong())) {
                throw new FixedPointOverflow(n.toLong());
            }
            l = n.toLong();
        }
        return l;
    }

    public final long $div$extension1(long $this, long rhs) {
        if ($this == Long.MIN_VALUE && rhs == -1L) {
            throw new FixedPointOverflow($this);
        }
        return $this / rhs;
    }

    public final long $percent$extension0(long $this, long rhs) {
        return $this % rhs;
    }

    public final long $percent$extension1(long $this, long rhs, FixedScale scale) {
        int d = scale.denom();
        long p = rhs * (long)d;
        return rhs == 0L || d == 0 || (long)d == p / rhs && ((rhs ^ (long)d ^ p) & Long.MIN_VALUE) == 0L ? $this % p : $this;
    }

    public final long $div$tilde$extension(long $this, long rhs, FixedScale scale) {
        return this.$div$extension0(this.$minus$extension0($this, this.$percent$extension0($this, rhs)), rhs, scale);
    }

    public final Tuple2<FixedPoint, FixedPoint> $div$percent$extension(long $this, long rhs, FixedScale scale) {
        long rem = this.$percent$extension0($this, rhs);
        return new Tuple2<FixedPoint, FixedPoint>(new FixedPoint(this.$div$extension0(this.$minus$extension0($this, rem), rhs, scale)), new FixedPoint(rem));
    }

    public final boolean isWhole$extension(long $this, FixedScale scale) {
        return $this % (long)scale.denom() == 0L;
    }

    public final long floor$extension(long $this, FixedScale scale) {
        return $this % (long)scale.denom() == 0L ? $this : ($this > 0L ? this.apply($this / (long)scale.denom(), scale) : this.apply($this / (long)scale.denom() - 1L, scale));
    }

    public final long ceil$extension(long $this, FixedScale scale) {
        return $this % (long)scale.denom() == 0L ? $this : ($this > 0L ? this.apply($this / (long)scale.denom() + 1L, scale) : this.apply($this / (long)scale.denom(), scale));
    }

    public final long round$extension(long $this, FixedScale scale) {
        long m;
        long m2;
        int d = scale.denom();
        long l = $this % (long)d == 0L ? $this : ($this > 0L ? ((m2 = $this % (long)d) >= (long)d - m2 ? this.apply($this / (long)d + 1L, scale) : this.apply($this / (long)d, scale)) : ((m = -($this % (long)d)) >= (long)d - m ? this.apply($this / (long)d - 1L, scale) : this.apply($this / (long)d, scale)));
        return l;
    }

    public final long gcd$extension(long $this, long rhs) {
        return package$.MODULE$.gcd($this, rhs);
    }

    public final long toLong$extension(long $this, FixedScale scale) {
        return $this / (long)scale.denom();
    }

    public final double toDouble$extension(long $this, FixedScale scale) {
        return (double)$this / (double)scale.denom();
    }

    public final BigDecimal toBigDecimal$extension(long $this, FixedScale scale) {
        return scala.package$.MODULE$.BigDecimal().apply($this).$div(BigDecimal$.MODULE$.int2bigDecimal(scale.denom()));
    }

    public final Rational toRational$extension(long $this, FixedScale scale) {
        return Rational$.MODULE$.apply($this, scale.denom());
    }

    public final long $times$times$extension(long $this, int k, FixedScale scale) {
        return this.pow$extension($this, k, scale);
    }

    public final long pow$extension(long $this, int k, FixedScale scale) {
        long l;
        if (k < 0) {
            Predef$ predef$ = Predef$.MODULE$;
            throw new IllegalArgumentException(new StringOps("exponent %s not allowed").format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(k)})));
        }
        switch (k) {
            default: {
                long g = package$.MODULE$.gcd($this, scale.denom());
                double n = package$.MODULE$.pow((double)($this / g), (double)k) * (double)g;
                double d = package$.MODULE$.pow((double)((long)scale.denom() / g), (double)(k - 1));
                double x = n / d;
                if (x < (double)Long.MIN_VALUE || (double)Long.MAX_VALUE < x) {
                    throw new FixedPointOverflow((long)x);
                }
                if (($this > (long)scale.denom() || $this < (long)(-scale.denom())) && (long)x == 0L) {
                    throw new FixedPointOverflow(0L);
                }
                l = (long)x;
                break;
            }
            case 1: {
                l = $this;
                break;
            }
            case 0: {
                l = scale.denom();
            }
        }
        return l;
    }

    public final long sqrt$extension(long $this, FixedScale scale) {
        return this.apply((Rational)Rational$.MODULE$.RationalIsNRoot(scale.ctxt()).sqrt(this.toRational$extension($this, scale)), scale);
    }

    public final long nroot$extension(long $this, int k, FixedScale scale) {
        return this.apply(this.toRational$extension($this, scale).nroot(k, scale.ctxt()), scale);
    }

    public final long fpow$extension(long $this, long y, FixedScale scale) {
        return this.apply(Rational$.MODULE$.RationalIsNRoot(scale.ctxt()).fpow(this.toRational$extension($this, scale), this.toRational$extension(y, scale)), scale);
    }

    public final String toString$extension0(long $this) {
        return new StringBuilder().append((Object)((Object)BoxesRunTime.boxToLong($this)).toString()).append((Object)"/?").toString();
    }

    public final String toString$extension1(long $this, FixedScale scale) {
        return ((Object)BoxesRunTime.boxToDouble(this.toDouble$extension($this, scale))).toString();
    }

    public final int hashCode$extension(long $this) {
        return ((Object)BoxesRunTime.boxToLong($this)).hashCode();
    }

    public final boolean equals$extension(long $this, Object x$1) {
        long l;
        boolean bl = x$1 instanceof FixedPoint;
        return bl && $this == (l = ((FixedPoint)x$1).long());
    }

    public long apply$mDc$sp(double a, FixedScale scale, Fractional<Object> fr) {
        double x = fr.times$mcD$sp(a, fr.fromInt$mcD$sp(scale.denom()));
        if (fr.lt$mcD$sp(x, fr.fromLong$mcD$sp(Long.MIN_VALUE)) || fr.lt$mcD$sp(fr.fromLong$mcD$sp(Long.MAX_VALUE), x)) {
            throw new FixedPointOverflow(fr.toLong$mcD$sp(x));
        }
        return fr.toLong$mcD$sp(x);
    }

    public long apply$mFc$sp(float a, FixedScale scale, Fractional<Object> fr) {
        float x = fr.times$mcF$sp(a, fr.fromInt$mcF$sp(scale.denom()));
        if (fr.lt$mcF$sp(x, fr.fromLong$mcF$sp(Long.MIN_VALUE)) || fr.lt$mcF$sp(fr.fromLong$mcF$sp(Long.MAX_VALUE), x)) {
            throw new FixedPointOverflow(fr.toLong$mcF$sp(x));
        }
        return fr.toLong$mcF$sp(x);
    }

    private FixedPoint$() {
        MODULE$ = this;
        FixedPointInstances$class.$init$(this);
        this.zero = 0L;
        this.MaxValue = Long.MAX_VALUE;
        this.MinValue = Long.MIN_VALUE;
    }
}

