/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.spi;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.spi.MutableThreadContextStack;
import org.apache.logging.log4j.spi.ThreadContextStack;
import org.apache.logging.log4j.util.StringBuilderFormattable;
import org.apache.logging.log4j.util.StringBuilders;

public class DefaultThreadContextStack
implements ThreadContextStack,
StringBuilderFormattable {
    private static final long serialVersionUID = 5050501L;
    private static final ThreadLocal<MutableThreadContextStack> STACK = new ThreadLocal();
    private final boolean useStack;

    public DefaultThreadContextStack(boolean useStack) {
        this.useStack = useStack;
    }

    private MutableThreadContextStack getNonNullStackCopy() {
        MutableThreadContextStack values = STACK.get();
        return values == null ? new MutableThreadContextStack() : values.copy();
    }

    @Override
    public boolean add(String s2) {
        if (!this.useStack) {
            return false;
        }
        MutableThreadContextStack copy2 = this.getNonNullStackCopy();
        copy2.add(s2);
        copy2.freeze();
        STACK.set(copy2);
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends String> strings) {
        if (!this.useStack || strings.isEmpty()) {
            return false;
        }
        MutableThreadContextStack copy2 = this.getNonNullStackCopy();
        copy2.addAll(strings);
        copy2.freeze();
        STACK.set(copy2);
        return true;
    }

    @Override
    public List<String> asList() {
        MutableThreadContextStack values = STACK.get();
        if (values == null) {
            return Collections.emptyList();
        }
        return values.asList();
    }

    @Override
    public void clear() {
        STACK.remove();
    }

    @Override
    public boolean contains(Object o) {
        MutableThreadContextStack values = STACK.get();
        return values != null && values.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> objects) {
        if (objects.isEmpty()) {
            return true;
        }
        MutableThreadContextStack values = STACK.get();
        return values != null && values.containsAll(objects);
    }

    @Override
    public ThreadContextStack copy() {
        MutableThreadContextStack values = null;
        if (!this.useStack || (values = STACK.get()) == null) {
            return new MutableThreadContextStack();
        }
        return values.copy();
    }

    @Override
    public boolean equals(Object obj) {
        ThreadContextStack other;
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof DefaultThreadContextStack) {
            other = (DefaultThreadContextStack)obj;
            if (this.useStack != other.useStack) {
                return false;
            }
        }
        if (!(obj instanceof ThreadContextStack)) {
            return false;
        }
        other = (ThreadContextStack)obj;
        MutableThreadContextStack values = STACK.get();
        if (values == null) {
            return false;
        }
        return values.equals(other);
    }

    @Override
    public int getDepth() {
        MutableThreadContextStack values = STACK.get();
        return values == null ? 0 : values.getDepth();
    }

    @Override
    public int hashCode() {
        MutableThreadContextStack values = STACK.get();
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + (values == null ? 0 : values.hashCode());
        return result2;
    }

    @Override
    public boolean isEmpty() {
        MutableThreadContextStack values = STACK.get();
        return values == null || values.isEmpty();
    }

    @Override
    public Iterator<String> iterator() {
        MutableThreadContextStack values = STACK.get();
        if (values == null) {
            List empty = Collections.emptyList();
            return empty.iterator();
        }
        return values.iterator();
    }

    @Override
    public String peek() {
        MutableThreadContextStack values = STACK.get();
        if (values == null || values.size() == 0) {
            return "";
        }
        return values.peek();
    }

    @Override
    public String pop() {
        if (!this.useStack) {
            return "";
        }
        MutableThreadContextStack values = STACK.get();
        if (values == null || values.size() == 0) {
            return "";
        }
        MutableThreadContextStack copy2 = (MutableThreadContextStack)values.copy();
        String result2 = copy2.pop();
        copy2.freeze();
        STACK.set(copy2);
        return result2;
    }

    @Override
    public void push(String message) {
        if (!this.useStack) {
            return;
        }
        this.add(message);
    }

    @Override
    public boolean remove(Object o) {
        if (!this.useStack) {
            return false;
        }
        MutableThreadContextStack values = STACK.get();
        if (values == null || values.size() == 0) {
            return false;
        }
        MutableThreadContextStack copy2 = (MutableThreadContextStack)values.copy();
        boolean result2 = copy2.remove(o);
        copy2.freeze();
        STACK.set(copy2);
        return result2;
    }

    @Override
    public boolean removeAll(Collection<?> objects) {
        if (!this.useStack || objects.isEmpty()) {
            return false;
        }
        MutableThreadContextStack values = STACK.get();
        if (values == null || values.isEmpty()) {
            return false;
        }
        MutableThreadContextStack copy2 = (MutableThreadContextStack)values.copy();
        boolean result2 = copy2.removeAll(objects);
        copy2.freeze();
        STACK.set(copy2);
        return result2;
    }

    @Override
    public boolean retainAll(Collection<?> objects) {
        if (!this.useStack || objects.isEmpty()) {
            return false;
        }
        MutableThreadContextStack values = STACK.get();
        if (values == null || values.isEmpty()) {
            return false;
        }
        MutableThreadContextStack copy2 = (MutableThreadContextStack)values.copy();
        boolean result2 = copy2.retainAll(objects);
        copy2.freeze();
        STACK.set(copy2);
        return result2;
    }

    @Override
    public int size() {
        MutableThreadContextStack values = STACK.get();
        return values == null ? 0 : values.size();
    }

    @Override
    public Object[] toArray() {
        MutableThreadContextStack result2 = STACK.get();
        if (result2 == null) {
            return new String[0];
        }
        return result2.toArray(new Object[result2.size()]);
    }

    @Override
    public <T> T[] toArray(T[] ts) {
        MutableThreadContextStack result2 = STACK.get();
        if (result2 == null) {
            if (ts.length > 0) {
                ts[0] = null;
            }
            return ts;
        }
        return result2.toArray(ts);
    }

    public String toString() {
        MutableThreadContextStack values = STACK.get();
        return values == null ? "[]" : values.toString();
    }

    @Override
    public void formatTo(StringBuilder buffer) {
        MutableThreadContextStack values = STACK.get();
        if (values == null) {
            buffer.append("[]");
        } else {
            StringBuilders.appendValue(buffer, values);
        }
    }

    @Override
    public void trim(int depth) {
        if (depth < 0) {
            throw new IllegalArgumentException("Maximum stack depth cannot be negative");
        }
        MutableThreadContextStack values = STACK.get();
        if (values == null) {
            return;
        }
        MutableThreadContextStack copy2 = (MutableThreadContextStack)values.copy();
        copy2.trim(depth);
        copy2.freeze();
        STACK.set(copy2);
    }

    @Override
    public ThreadContext.ContextStack getImmutableStackOrNull() {
        return STACK.get();
    }
}

