/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.flatfile.schema.test;

import com.mulesoft.flatfile.schema.EdiSchema;
import com.mulesoft.flatfile.schema.YamlReader;
import com.mulesoft.flatfile.schema.tools.DocumentTestHL7;
import com.mulesoft.flatfile.schema.tools.YamlSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.Map;

public class TestHL7Document {
    private static EdiSchema loadSchema(String path) {
        try {
            YamlReader yamlrdr = new YamlReader();
            InputStream is = yamlrdr.findSchema(path, new String[]{""});
            return yamlrdr.loadYaml(new InputStreamReader(is, "ASCII"), new String[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not load schema file " + path, e);
        }
    }

    private static InputStream loadFile(String path) {
        InputStream is = TestHL7Document.class.getResourceAsStream(path);
        if (is == null) {
            throw new IllegalArgumentException("File " + path + " not found");
        }
        return is;
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            throw new IllegalArgumentException("Missing required argument(s): schema-path file-path");
        }
        if (args.length > 2) {
            throw new IllegalArgumentException("Too many argument(s): schema-path file-path");
        }
        EdiSchema schema = TestHL7Document.loadSchema(args[0]);
        DocumentTestHL7 test = new DocumentTestHL7(schema, (String)schema.structures().keySet().iterator().next());
        try {
            FileInputStream is = new FileInputStream(new File(args[1]));
            Map<String, Object> result2 = test.parse(is);
            System.out.println("\nMessage data:");
            StringWriter writer = new StringWriter();
            YamlSupport.writeMap(result2, writer);
            System.out.println(writer.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

