/*
 * Decompiled with CFR 0.152.
 */
package spire.math.prime;

import java.math.BigInteger;
import java.util.Random;
import scala.MatchError;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenMap;
import scala.collection.immutable.Map;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Stream$;
import scala.collection.mutable.Map$;
import scala.math.BigInt$;
import scala.runtime.BoxesRunTime;
import spire.algebra.Sign;
import spire.algebra.Sign$;
import spire.algebra.Sign$Positive$;
import spire.math.SafeLong;
import spire.math.SafeLong$;
import spire.math.prime.Factors;
import spire.math.prime.Factors$;
import spire.math.prime.Siever;
import spire.math.prime.package$;

public final class package$ {
    public static final package$ MODULE$;
    private final Random srand;
    private final int SieveSize;

    static {
        new package$();
    }

    public boolean isPrime(SafeLong n) {
        return n.isProbablePrime(40);
    }

    public Factors factor(SafeLong n) {
        return this.factorPollardRho(n);
    }

    public Factors factorTrialDivision(SafeLong n0) {
        SafeLong safeLong = n0;
        Integer n = BoxesRunTime.boxToInteger(0);
        if (safeLong != null && safeLong.equals(n)) {
            return Factors$.MODULE$.zero();
        }
        SafeLong n2 = n0.abs();
        Sign sign = Sign$.MODULE$.apply(n0.signum());
        SafeLong safeLong2 = n2;
        SafeLong safeLong3 = SafeLong$.MODULE$.one();
        if (!(safeLong2 != null ? !safeLong2.equals(safeLong3) : safeLong3 != null)) {
            return new Factors((Map<SafeLong, Object>)Predef$.MODULE$.Map().empty(), sign);
        }
        GenMap facts = Map$.MODULE$.empty();
        SafeLong x = n2;
        Tuple2<SafeLong, Object> tuple22 = this.findPowers(n2, SafeLong$.MODULE$.apply(2L));
        if (tuple22 != null) {
            Tuple2<SafeLong, Integer> tuple23 = new Tuple2<SafeLong, Integer>(tuple22._1(), BoxesRunTime.boxToInteger(tuple22._2$mcI$sp()));
            SafeLong x1 = tuple23._1();
            int e1 = tuple23._2$mcI$sp();
            if (e1 > 0) {
                facts.update(SafeLong$.MODULE$.apply(2L), BoxesRunTime.boxToInteger(e1));
                x = x1;
            }
            SafeLong limit = (SafeLong)SafeLong$.MODULE$.SafeLongAlgebra().sqrt(x);
            SafeLong index$macro$213 = SafeLong$.MODULE$.apply(3L);
            while (index$macro$213.$less$eq(limit) && x.$greater(SafeLong$.MODULE$.apply(1L))) {
                Tuple2<SafeLong, Object> tuple24 = this.findPowers(x, index$macro$213);
                if (tuple24 != null) {
                    Tuple2<SafeLong, Integer> tuple25 = new Tuple2<SafeLong, Integer>(tuple24._1(), BoxesRunTime.boxToInteger(tuple24._2$mcI$sp()));
                    SafeLong x2 = tuple25._1();
                    int e2 = tuple25._2$mcI$sp();
                    if (e2 > 0) {
                        facts.update(index$macro$213, BoxesRunTime.boxToInteger(e2));
                        x = x2;
                        limit = (SafeLong)SafeLong$.MODULE$.SafeLongAlgebra().sqrt(x2);
                    }
                    index$macro$213 = index$macro$213.$plus(2L);
                    continue;
                }
                throw new MatchError(tuple24);
            }
            if (x.$greater(SafeLong$.MODULE$.apply(1L))) {
                facts.update(x, BoxesRunTime.boxToInteger(1));
            }
            return new Factors(facts.toMap(Predef$.MODULE$.$conforms()), sign);
        }
        throw new MatchError(tuple22);
    }

    public Factors factorWheelDivision(SafeLong n0) {
        SafeLong safeLong = n0;
        Integer n = BoxesRunTime.boxToInteger(0);
        if (safeLong != null && safeLong.equals(n)) {
            return Factors$.MODULE$.zero();
        }
        SafeLong n2 = n0.abs();
        Sign sign = Sign$.MODULE$.apply(n0.signum());
        SafeLong safeLong2 = n2;
        Integer n3 = BoxesRunTime.boxToInteger(1);
        if (safeLong2 != null && safeLong2.equals(n3)) {
            return new Factors((Map<SafeLong, Object>)Predef$.MODULE$.Map().empty(), sign);
        }
        GenMap facts = Map$.MODULE$.empty();
        SafeLong x = n2;
        Tuple2<SafeLong, Object> tuple22 = this.findPowers(n2, SafeLong$.MODULE$.apply(2L));
        if (tuple22 != null) {
            Tuple2<SafeLong, Integer> tuple23 = new Tuple2<SafeLong, Integer>(tuple22._1(), BoxesRunTime.boxToInteger(tuple22._2$mcI$sp()));
            SafeLong x1 = tuple23._1();
            int e1 = tuple23._2$mcI$sp();
            if (e1 > 0) {
                facts.update(SafeLong$.MODULE$.apply(2L), BoxesRunTime.boxToInteger(e1));
                x = x1;
            }
            SafeLong index$macro$214 = SafeLong$.MODULE$.apply(3L);
            while (index$macro$214.$less(SafeLong$.MODULE$.apply(30L)) && x.$greater(SafeLong$.MODULE$.apply(1L))) {
                Tuple2<SafeLong, Object> tuple24 = this.findPowers(x, index$macro$214);
                if (tuple24 != null) {
                    Tuple2<SafeLong, Integer> tuple25 = new Tuple2<SafeLong, Integer>(tuple24._1(), BoxesRunTime.boxToInteger(tuple24._2$mcI$sp()));
                    SafeLong x2 = tuple25._1();
                    int e2 = tuple25._2$mcI$sp();
                    if (e2 > 0) {
                        facts.update(index$macro$214, BoxesRunTime.boxToInteger(e2));
                        x = x2;
                    }
                    index$macro$214 = index$macro$214.$plus(2L);
                    continue;
                }
                throw new MatchError(tuple24);
            }
            SafeLong limit = (SafeLong)SafeLong$.MODULE$.SafeLongAlgebra().sqrt(x);
            SafeLong b = SafeLong$.MODULE$.apply(31L);
            int i = 0;
            int[] offsets = new int[]{2, 2, 2, 4, 2, 4, 2, 4, 6, 2};
            while (b.$less$eq(limit) && x.$greater(SafeLong$.MODULE$.apply(1L))) {
                Tuple2<SafeLong, Object> tuple26 = this.findPowers(x, b);
                if (tuple26 != null) {
                    Tuple2<SafeLong, Integer> tuple27 = new Tuple2<SafeLong, Integer>(tuple26._1(), BoxesRunTime.boxToInteger(tuple26._2$mcI$sp()));
                    SafeLong x2 = tuple27._1();
                    int e2 = tuple27._2$mcI$sp();
                    if (e2 > 0) {
                        facts.update(b, BoxesRunTime.boxToInteger(e2));
                        x = x2;
                        limit = (SafeLong)SafeLong$.MODULE$.SafeLongAlgebra().sqrt(x2);
                    }
                    b = b.$plus(offsets[i]);
                    i = (i + 1) % 10;
                    continue;
                }
                throw new MatchError(tuple26);
            }
            if (x.$greater(SafeLong$.MODULE$.apply(1L))) {
                facts.update(x, BoxesRunTime.boxToInteger(1));
            }
            return new Factors(facts.toMap(Predef$.MODULE$.$conforms()), sign);
        }
        throw new MatchError(tuple22);
    }

    public Factors factorPollardRho(SafeLong n0) {
        SafeLong n;
        SafeLong safeLong = n0;
        Integer n2 = BoxesRunTime.boxToInteger(0);
        if (safeLong != null && safeLong.equals(n2)) {
            return Factors$.MODULE$.zero();
        }
        SafeLong safeLong2 = n = n0.abs();
        Integer n3 = BoxesRunTime.boxToInteger(1);
        if (safeLong2 != null && safeLong2.equals(n3)) {
            return new Factors((Map<SafeLong, Object>)Predef$.MODULE$.Map().empty(), Sign$.MODULE$.apply(n0.signum()));
        }
        return n0.$less(SafeLong$.MODULE$.apply(0L)) ? this.factor$1(n).unary_$minus() : this.factor$1(n);
    }

    private Random srand() {
        return this.srand;
    }

    private SafeLong rand(SafeLong n) {
        int bits2 = n.bitLength();
        BigInteger x = new BigInteger(bits2, this.srand());
        while (x.signum() == 0) {
            x = new BigInteger(bits2, this.srand());
        }
        return SafeLong$.MODULE$.apply(BigInt$.MODULE$.javaBigInteger2bigInt(x));
    }

    private Tuple2<SafeLong, Object> findPowers(SafeLong x0, SafeLong b) {
        SafeLong x = x0;
        int e = 0;
        while (x.$greater(SafeLong$.MODULE$.apply(1L))) {
            SafeLong safeLong = x.$percent(b);
            Integer n = BoxesRunTime.boxToInteger(0);
            if (safeLong == null || !safeLong.equals(n)) break;
            ++e;
            x = x.$div(b);
        }
        return new Tuple2<SafeLong, Object>(x, BoxesRunTime.boxToInteger(e));
    }

    private int SieveSize() {
        return this.SieveSize;
    }

    public Siever sieverUpToNth(long n) {
        double upper = (double)n * spire.math.package$.MODULE$.log(n) + (double)n * spire.math.package$.MODULE$.log(spire.math.package$.MODULE$.log((double)n - 0.9385));
        long cutoff = spire.math.package$.MODULE$.max(1000L, (long)(spire.math.package$.MODULE$.sqrt(upper) + (double)512L));
        return new Siever(this.SieveSize(), SafeLong$.MODULE$.apply(cutoff));
    }

    public SafeLong nth(long n) {
        return this.sieverUpToNth(n).nth(n);
    }

    /*
     * WARNING - void declaration
     */
    public SafeLong[] fill(int n) {
        SafeLong[] safeLongArray;
        if (n <= 0) {
            throw new IllegalArgumentException(((Object)BoxesRunTime.boxToInteger(n)).toString());
        }
        if (n == 1) {
            safeLongArray = (SafeLong[])((Object[])new SafeLong[]{SafeLong$.MODULE$.two()});
        } else {
            void var3_3;
            Siever siever = this.sieverUpToNth(n);
            SafeLong[] arr = new SafeLong[n];
            arr[0] = SafeLong$.MODULE$.two();
            arr[1] = SafeLong$.MODULE$.three();
            this.loop$1(2, SafeLong$.MODULE$.three(), siever, arr);
            safeLongArray = var3_3;
        }
        return safeLongArray;
    }

    public SafeLong[] fill(int start, int limit) {
        SafeLong[] safeLongArray;
        if (start == 0) {
            safeLongArray = this.fill(limit);
        } else {
            Siever siever = this.sieverUpToNth(start + limit);
            safeLongArray = this.loop$2(1, SafeLong$.MODULE$.three(), start, limit, siever);
        }
        return safeLongArray;
    }

    public Stream<SafeLong> stream() {
        return this.stream(this.SieveSize(), SafeLong$.MODULE$.apply(1000000L));
    }

    public Stream<SafeLong> stream(int chunkSize, SafeLong cutoff) {
        SafeLong safeLong = SafeLong$.MODULE$.two();
        return Stream$.MODULE$.consWrapper(new Serializable(chunkSize, cutoff){
            public final int chunkSize$1;
            public final SafeLong cutoff$1;

            public final Stream<SafeLong> apply() {
                SafeLong safeLong = SafeLong$.MODULE$.three();
                return Stream$.MODULE$.consWrapper(new Serializable(this){
                    private final /* synthetic */ anonfun.stream.1 $outer;

                    public final Stream<SafeLong> apply() {
                        return new Siever(this.$outer.chunkSize$1, this.$outer.cutoff$1).streamAfter(SafeLong$.MODULE$.three());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }).$hash$colon$colon(safeLong);
            }
            {
                this.chunkSize$1 = chunkSize$1;
                this.cutoff$1 = cutoff$1;
            }
        }).$hash$colon$colon(safeLong);
    }

    private final SafeLong f$1(SafeLong x, SafeLong n$1, SafeLong c$1) {
        return x.$times(x).$percent(n$1).$plus(c$1).$percent(n$1);
    }

    private final SafeLong fastRho$1(SafeLong x, SafeLong q0, SafeLong r, SafeLong m, SafeLong n$1, SafeLong c$1) {
        SafeLong ys;
        SafeLong g;
        while (true) {
            SafeLong y = x;
            SafeLong q = q0;
            int index$macro$215 = 0;
            while (r.$greater(SafeLong$.MODULE$.apply(index$macro$215))) {
                y = y.$times(y).$percent(n$1).$plus(c$1).$percent(n$1);
                ++index$macro$215;
            }
            g = SafeLong$.MODULE$.one();
            SafeLong k = SafeLong$.MODULE$.zero();
            ys = y;
            while (r.$greater(k)) {
                SafeLong safeLong = g;
                Integer n = BoxesRunTime.boxToInteger(1);
                if (safeLong == null || !safeLong.equals(n)) break;
                ys = y;
                SafeLong limit = m.min(r.$minus(k));
                int index$macro$216 = 0;
                while (limit.$greater(SafeLong$.MODULE$.apply(index$macro$216))) {
                    y = y.$times(y).$percent(n$1).$plus(c$1).$percent(n$1);
                    q = q.$times(x.$minus(y).abs()).$percent(n$1);
                    ++index$macro$216;
                }
                SafeLong safeLong2 = q;
                Integer n2 = BoxesRunTime.boxToInteger(0);
                g = safeLong2 != null && safeLong2.equals(n2) ? n$1 : n$1.gcd(q);
                k = k.$plus(m);
            }
            SafeLong safeLong = g;
            Integer n = BoxesRunTime.boxToInteger(1);
            if (safeLong == null || !safeLong.equals(n)) break;
            r = r.$times(2L);
            q0 = q;
            x = y;
        }
        SafeLong safeLong = g;
        return !(safeLong != null ? !safeLong.equals(n$1) : n$1 != null) ? this.slowRho$1(x, ys, n$1, c$1) : g;
    }

    private final SafeLong slowRho$1(SafeLong x, SafeLong ys, SafeLong n$1, SafeLong c$1) {
        SafeLong g;
        while (true) {
            SafeLong yys = ys.$times(ys).$percent(n$1).$plus(c$1).$percent(n$1);
            SafeLong safeLong = g = n$1.gcd(x.$minus(yys).abs());
            Integer n = BoxesRunTime.boxToInteger(1);
            if (safeLong == null || !safeLong.equals(n)) break;
            ys = yys;
        }
        return g;
    }

    private final SafeLong rho$1(SafeLong n, SafeLong c) {
        return this.fastRho$1(this.rand(n), SafeLong$.MODULE$.one(), SafeLong$.MODULE$.one(), this.rand(n), n, c);
    }

    private final Factors factor$1(SafeLong n) {
        Factors factors;
        SafeLong safeLong = n;
        Integer n2 = BoxesRunTime.boxToInteger(1);
        if (safeLong != null && safeLong.equals(n2)) {
            factors = Factors$.MODULE$.one();
        } else if (this.isPrime(n)) {
            Tuple2[] tuple2Array = new Tuple2[1];
            Integer n3 = BoxesRunTime.boxToInteger(1);
            SafeLong safeLong2 = Predef$.MODULE$.ArrowAssoc(n);
            Predef$ArrowAssoc$ predef$ArrowAssoc$ = Predef$ArrowAssoc$.MODULE$;
            tuple2Array[0] = new Tuple2<SafeLong, Integer>(safeLong2, n3);
            factors = new Factors((Map)Predef$.MODULE$.Map().apply(Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)), Sign$Positive$.MODULE$);
        } else {
            SafeLong safeLong3 = n.$percent(2L);
            Integer n4 = BoxesRunTime.boxToInteger(0);
            if (safeLong3 != null && safeLong3.equals(n4)) {
                SafeLong x = n.$div(2L);
                int e = 1;
                while (true) {
                    SafeLong safeLong4 = x.$percent(2L);
                    Integer n5 = BoxesRunTime.boxToInteger(0);
                    if (safeLong4 == null || !safeLong4.equals(n5)) break;
                    x = x.$div(2L);
                    ++e;
                }
                Tuple2[] tuple2Array = new Tuple2[1];
                Integer n6 = BoxesRunTime.boxToInteger(e);
                SafeLong safeLong5 = Predef$.MODULE$.ArrowAssoc(SafeLong$.MODULE$.apply(2L));
                Predef$ArrowAssoc$ predef$ArrowAssoc$ = Predef$ArrowAssoc$.MODULE$;
                tuple2Array[0] = new Tuple2<SafeLong, Integer>(safeLong5, n6);
                factors = new Factors((Map)Predef$.MODULE$.Map().apply(Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)), Sign$Positive$.MODULE$).$times(this.factor$1(x));
            } else {
                SafeLong divisor = this.rho$1(n, this.rand(n));
                while (true) {
                    SafeLong safeLong6 = divisor;
                    if (safeLong6 != null ? !safeLong6.equals(n) : n != null) break;
                    divisor = this.rho$1(n, this.rand(n));
                }
                factors = this.factor$1(divisor).$times(this.factor$1(n.$div(divisor)));
            }
        }
        return factors;
    }

    private final void loop$1(int i, SafeLong last2, Siever siever$1, SafeLong[] arr$1) {
        while (i < arr$1.length) {
            SafeLong p;
            arr$1[i] = p = siever$1.nextAfter(last2);
            last2 = p;
            ++i;
        }
    }

    private final SafeLong[] loop$2(int i, SafeLong p, int start$1, int limit$1, Siever siever$2) {
        while (i < start$1) {
            p = siever$2.nextAfter(p);
            ++i;
        }
        return siever$2.arrayAt(p, limit$1);
    }

    private package$() {
        MODULE$ = this;
        this.srand = new Random();
        this.SieveSize = 9600000;
    }
}

