/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.util;

import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.AbstractLifeCycle;
import org.apache.logging.log4j.core.config.ConfigurationScheduler;
import org.apache.logging.log4j.core.util.FileWatcher;
import org.apache.logging.log4j.status.StatusLogger;

public class WatchManager
extends AbstractLifeCycle {
    private static Logger logger = StatusLogger.getLogger();
    private final ConcurrentMap<File, FileMonitor> watchers = new ConcurrentHashMap<File, FileMonitor>();
    private int intervalSeconds = 0;
    private ScheduledFuture<?> future;
    private final ConfigurationScheduler scheduler;

    public WatchManager(ConfigurationScheduler scheduler) {
        this.scheduler = scheduler;
    }

    public void reset() {
        logger.debug("Resetting {}", (Object)this);
        for (File file : this.watchers.keySet()) {
            this.reset(file);
        }
    }

    public void reset(File file) {
        long lastModifiedMillis;
        if (file == null) {
            return;
        }
        FileMonitor fileMonitor = (FileMonitor)this.watchers.get(file);
        if (fileMonitor != null && (lastModifiedMillis = file.lastModified()) != fileMonitor.lastModifiedMillis) {
            if (logger.isDebugEnabled()) {
                logger.debug("Resetting file monitor for '{}' from {} ({}) to {} ({})", (Object)file, (Object)this.millisToString(fileMonitor.lastModifiedMillis), (Object)fileMonitor.lastModifiedMillis, (Object)this.millisToString(lastModifiedMillis), (Object)lastModifiedMillis);
            }
            fileMonitor.setLastModifiedMillis(lastModifiedMillis);
        }
    }

    public void setIntervalSeconds(int intervalSeconds) {
        if (!this.isStarted()) {
            if (this.intervalSeconds > 0 && intervalSeconds == 0) {
                this.scheduler.decrementScheduledItems();
            } else if (this.intervalSeconds == 0 && intervalSeconds > 0) {
                this.scheduler.incrementScheduledItems();
            }
            this.intervalSeconds = intervalSeconds;
        }
    }

    public int getIntervalSeconds() {
        return this.intervalSeconds;
    }

    @Override
    public void start() {
        super.start();
        if (this.intervalSeconds > 0) {
            this.future = this.scheduler.scheduleWithFixedDelay(new WatchRunnable(), this.intervalSeconds, this.intervalSeconds, TimeUnit.SECONDS);
        }
    }

    @Override
    public boolean stop(long timeout, TimeUnit timeUnit) {
        this.setStopping();
        boolean stopped = this.stop(this.future);
        this.setStopped();
        return stopped;
    }

    public void unwatchFile(File file) {
        logger.debug("Unwatching file '{}'", (Object)file);
        this.watchers.remove(file);
    }

    public void watchFile(File file, FileWatcher watcher) {
        long lastModified = file.lastModified();
        if (logger.isDebugEnabled()) {
            logger.debug("Watching file '{}' for lastModified {} ({})", (Object)file, (Object)this.millisToString(lastModified), (Object)lastModified);
        }
        this.watchers.put(file, new FileMonitor(lastModified, watcher));
    }

    public Map<File, FileWatcher> getWatchers() {
        HashMap<File, FileWatcher> map2 = new HashMap<File, FileWatcher>(this.watchers.size());
        for (Map.Entry entry : this.watchers.entrySet()) {
            map2.put((File)entry.getKey(), ((FileMonitor)entry.getValue()).fileWatcher);
        }
        return map2;
    }

    private String millisToString(long millis) {
        return new Date(millis).toString();
    }

    public String toString() {
        return "WatchManager [intervalSeconds=" + this.intervalSeconds + ", watchers=" + this.watchers + ", scheduler=" + this.scheduler + ", future=" + this.future + "]";
    }

    private final class FileMonitor {
        private final FileWatcher fileWatcher;
        private volatile long lastModifiedMillis;

        public FileMonitor(long lastModifiedMillis, FileWatcher fileWatcher) {
            this.fileWatcher = fileWatcher;
            this.lastModifiedMillis = lastModifiedMillis;
        }

        private void setLastModifiedMillis(long lastModifiedMillis) {
            this.lastModifiedMillis = lastModifiedMillis;
        }

        public String toString() {
            return "FileMonitor [fileWatcher=" + this.fileWatcher + ", lastModifiedMillis=" + this.lastModifiedMillis + "]";
        }
    }

    private final class WatchRunnable
    implements Runnable {
        private final String SIMPLE_NAME = WatchRunnable.class.getSimpleName();

        private WatchRunnable() {
        }

        @Override
        public void run() {
            logger.trace("{} run triggered.", (Object)this.SIMPLE_NAME);
            for (Map.Entry entry : WatchManager.this.watchers.entrySet()) {
                long lastModfied;
                File file = (File)entry.getKey();
                FileMonitor fileMonitor = (FileMonitor)entry.getValue();
                if (!this.fileModified(fileMonitor, lastModfied = file.lastModified())) continue;
                if (logger.isInfoEnabled()) {
                    logger.info("File '{}' was modified on {} ({}), previous modification was on {} ({})", (Object)file, (Object)WatchManager.this.millisToString(lastModfied), (Object)lastModfied, (Object)WatchManager.this.millisToString(fileMonitor.lastModifiedMillis), (Object)fileMonitor.lastModifiedMillis);
                }
                fileMonitor.lastModifiedMillis = lastModfied;
                fileMonitor.fileWatcher.fileModified(file);
            }
            logger.trace("{} run ended.", (Object)this.SIMPLE_NAME);
        }

        private boolean fileModified(FileMonitor fileMonitor, long lastModifiedMillis) {
            return lastModifiedMillis != fileMonitor.lastModifiedMillis;
        }
    }
}

