/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.net;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.appender.AppenderLoggingException;
import org.apache.logging.log4j.core.appender.ManagerFactory;
import org.apache.logging.log4j.core.appender.OutputStreamManager;
import org.apache.logging.log4j.core.net.AbstractSocketManager;
import org.apache.logging.log4j.core.net.SocketOptions;
import org.apache.logging.log4j.core.util.Closer;
import org.apache.logging.log4j.core.util.Log4jThread;
import org.apache.logging.log4j.core.util.NullOutputStream;
import org.apache.logging.log4j.util.Strings;

public class TcpSocketManager
extends AbstractSocketManager {
    public static final int DEFAULT_RECONNECTION_DELAY_MILLIS = 30000;
    private static final int DEFAULT_PORT = 4560;
    private static final TcpSocketManagerFactory<TcpSocketManager, FactoryData> FACTORY = new TcpSocketManagerFactory();
    private final int reconnectionDelayMillis;
    private Reconnector reconnector;
    private Socket socket;
    private final SocketOptions socketOptions;
    private final boolean retry;
    private final boolean immediateFail;
    private final int connectTimeoutMillis;

    @Deprecated
    public TcpSocketManager(String name, OutputStream os, Socket socket, InetAddress inetAddress, String host, int port, int connectTimeoutMillis, int reconnectionDelayMillis, boolean immediateFail, Layout<? extends Serializable> layout, int bufferSize) {
        this(name, os, socket, inetAddress, host, port, connectTimeoutMillis, reconnectionDelayMillis, immediateFail, layout, bufferSize, null);
    }

    public TcpSocketManager(String name, OutputStream os, Socket socket, InetAddress inetAddress, String host, int port, int connectTimeoutMillis, int reconnectionDelayMillis, boolean immediateFail, Layout<? extends Serializable> layout, int bufferSize, SocketOptions socketOptions) {
        super(name, os, inetAddress, host, port, layout, true, bufferSize);
        this.connectTimeoutMillis = connectTimeoutMillis;
        this.reconnectionDelayMillis = reconnectionDelayMillis;
        this.socket = socket;
        this.immediateFail = immediateFail;
        boolean bl = this.retry = reconnectionDelayMillis > 0;
        if (socket == null) {
            this.reconnector = this.createReconnector();
            this.reconnector.start();
        }
        this.socketOptions = socketOptions;
    }

    @Deprecated
    public static TcpSocketManager getSocketManager(String host, int port, int connectTimeoutMillis, int reconnectDelayMillis, boolean immediateFail, Layout<? extends Serializable> layout, int bufferSize) {
        return TcpSocketManager.getSocketManager(host, port, connectTimeoutMillis, reconnectDelayMillis, immediateFail, layout, bufferSize, null);
    }

    public static TcpSocketManager getSocketManager(String host, int port, int connectTimeoutMillis, int reconnectDelayMillis, boolean immediateFail, Layout<? extends Serializable> layout, int bufferSize, SocketOptions socketOptions) {
        if (Strings.isEmpty(host)) {
            throw new IllegalArgumentException("A host name is required");
        }
        if (port <= 0) {
            port = 4560;
        }
        if (reconnectDelayMillis == 0) {
            reconnectDelayMillis = 30000;
        }
        return (TcpSocketManager)TcpSocketManager.getManager("TCP:" + host + ':' + port, new FactoryData(host, port, connectTimeoutMillis, reconnectDelayMillis, immediateFail, layout, bufferSize, socketOptions), FACTORY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void write(byte[] bytes2, int offset, int length, boolean immediateFlush) {
        if (this.socket == null) {
            if (this.reconnector != null && !this.immediateFail) {
                this.reconnector.latch();
            }
            if (this.socket == null) {
                throw new AppenderLoggingException("Error writing to " + this.getName() + ": socket not available");
            }
        }
        TcpSocketManager tcpSocketManager = this;
        synchronized (tcpSocketManager) {
            block12: {
                try {
                    this.writeAndFlush(bytes2, offset, length, immediateFlush);
                }
                catch (IOException causeEx) {
                    if (!this.retry || this.reconnector != null) break block12;
                    String config = this.inetAddress + ":" + this.port;
                    this.reconnector = this.createReconnector();
                    try {
                        this.reconnector.reconnect();
                    }
                    catch (IOException reconnEx) {
                        LOGGER.debug("Cannot reestablish socket connection to {}: {}; starting reconnector thread {}", (Object)config, (Object)reconnEx.getLocalizedMessage(), (Object)this.reconnector.getName(), (Object)reconnEx);
                        this.reconnector.start();
                        throw new AppenderLoggingException(String.format("Error sending to %s for %s", this.getName(), config), causeEx);
                    }
                    try {
                        this.writeAndFlush(bytes2, offset, length, immediateFlush);
                    }
                    catch (IOException e) {
                        throw new AppenderLoggingException(String.format("Error writing to %s after reestablishing connection for %s", this.getName(), config), causeEx);
                    }
                }
            }
        }
    }

    private void writeAndFlush(byte[] bytes2, int offset, int length, boolean immediateFlush) throws IOException {
        OutputStream outputStream = this.getOutputStream();
        outputStream.write(bytes2, offset, length);
        if (immediateFlush) {
            outputStream.flush();
        }
    }

    @Override
    protected synchronized boolean closeOutputStream() {
        boolean closed = super.closeOutputStream();
        if (this.reconnector != null) {
            this.reconnector.shutdown();
            this.reconnector.interrupt();
            this.reconnector = null;
        }
        Socket oldSocket = this.socket;
        this.socket = null;
        if (oldSocket != null) {
            try {
                oldSocket.close();
            }
            catch (IOException e) {
                LOGGER.error("Could not close socket {}", (Object)this.socket);
                return false;
            }
        }
        return closed;
    }

    public int getConnectTimeoutMillis() {
        return this.connectTimeoutMillis;
    }

    @Override
    public Map<String, String> getContentFormat() {
        HashMap<String, String> result2 = new HashMap<String, String>(super.getContentFormat());
        result2.put("protocol", "tcp");
        result2.put("direction", "out");
        return result2;
    }

    private Reconnector createReconnector() {
        Reconnector recon = new Reconnector(this);
        recon.setDaemon(true);
        recon.setPriority(1);
        return recon;
    }

    protected Socket createSocket(String host, int port) throws IOException {
        return TcpSocketManager.createSocket(host, port, this.socketOptions, this.connectTimeoutMillis);
    }

    protected static Socket createSocket(String host, int port, SocketOptions socketOptions, int connectTimeoutMillis) throws IOException {
        LOGGER.debug("Creating socket {}:{}", (Object)host, (Object)port);
        Socket newSocket = new Socket();
        if (socketOptions != null) {
            socketOptions.apply(newSocket);
        }
        newSocket.connect(new InetSocketAddress(host, port), connectTimeoutMillis);
        if (socketOptions != null) {
            socketOptions.apply(newSocket);
        }
        return newSocket;
    }

    public SocketOptions getSocketOptions() {
        return this.socketOptions;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public int getReconnectionDelayMillis() {
        return this.reconnectionDelayMillis;
    }

    public String toString() {
        return "TcpSocketManager [reconnectionDelayMillis=" + this.reconnectionDelayMillis + ", reconnector=" + this.reconnector + ", socket=" + this.socket + ", socketOptions=" + this.socketOptions + ", retry=" + this.retry + ", immediateFail=" + this.immediateFail + ", connectTimeoutMillis=" + this.connectTimeoutMillis + ", inetAddress=" + this.inetAddress + ", host=" + this.host + ", port=" + this.port + ", layout=" + this.layout + ", byteBuffer=" + this.byteBuffer + ", count=" + this.count + "]";
    }

    protected static class TcpSocketManagerFactory<M extends TcpSocketManager, T extends FactoryData>
    implements ManagerFactory<M, T> {
        protected TcpSocketManagerFactory() {
        }

        @Override
        public M createManager(String name, T data2) {
            InetAddress inetAddress;
            try {
                inetAddress = InetAddress.getByName(((FactoryData)data2).host);
            }
            catch (UnknownHostException ex) {
                LOGGER.error("Could not find address of {}: {}", (Object)((FactoryData)data2).host, (Object)ex, (Object)ex);
                return null;
            }
            Socket socket = null;
            try {
                socket = this.createSocket(data2);
                OutputStream os = socket.getOutputStream();
                return this.createManager(name, os, socket, inetAddress, data2);
            }
            catch (IOException ex) {
                LOGGER.error("TcpSocketManager ({}) caught exception and will continue:", (Object)name, (Object)ex, (Object)ex);
                NullOutputStream os = NullOutputStream.getInstance();
                if (((FactoryData)data2).reconnectDelayMillis == 0) {
                    Closer.closeSilently(socket);
                    return null;
                }
                return this.createManager(name, os, null, inetAddress, data2);
            }
        }

        M createManager(String name, OutputStream os, Socket socket, InetAddress inetAddress, T data2) {
            return (M)new TcpSocketManager(name, os, socket, inetAddress, ((FactoryData)data2).host, ((FactoryData)data2).port, ((FactoryData)data2).connectTimeoutMillis, ((FactoryData)data2).reconnectDelayMillis, ((FactoryData)data2).immediateFail, ((FactoryData)data2).layout, ((FactoryData)data2).bufferSize, ((FactoryData)data2).socketOptions);
        }

        Socket createSocket(T data2) throws IOException {
            return TcpSocketManager.createSocket(((FactoryData)data2).host, ((FactoryData)data2).port, ((FactoryData)data2).socketOptions, ((FactoryData)data2).connectTimeoutMillis);
        }
    }

    static class FactoryData {
        protected final String host;
        protected final int port;
        protected final int connectTimeoutMillis;
        protected final int reconnectDelayMillis;
        protected final boolean immediateFail;
        protected final Layout<? extends Serializable> layout;
        protected final int bufferSize;
        protected final SocketOptions socketOptions;

        public FactoryData(String host, int port, int connectTimeoutMillis, int reconnectDelayMillis, boolean immediateFail, Layout<? extends Serializable> layout, int bufferSize, SocketOptions socketOptions) {
            this.host = host;
            this.port = port;
            this.connectTimeoutMillis = connectTimeoutMillis;
            this.reconnectDelayMillis = reconnectDelayMillis;
            this.immediateFail = immediateFail;
            this.layout = layout;
            this.bufferSize = bufferSize;
            this.socketOptions = socketOptions;
        }

        public String toString() {
            return "FactoryData [host=" + this.host + ", port=" + this.port + ", connectTimeoutMillis=" + this.connectTimeoutMillis + ", reconnectDelayMillis=" + this.reconnectDelayMillis + ", immediateFail=" + this.immediateFail + ", layout=" + this.layout + ", bufferSize=" + this.bufferSize + ", socketOptions=" + this.socketOptions + "]";
        }
    }

    private class Reconnector
    extends Log4jThread {
        private final CountDownLatch latch;
        private boolean shutdown;
        private final Object owner;

        public Reconnector(OutputStreamManager owner2) {
            super("TcpSocketManager-Reconnector");
            this.latch = new CountDownLatch(1);
            this.shutdown = false;
            this.owner = owner2;
        }

        public void latch() {
            try {
                this.latch.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void shutdown() {
            this.shutdown = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.shutdown) {
                try {
                    Reconnector.sleep(TcpSocketManager.this.reconnectionDelayMillis);
                    this.reconnect();
                }
                catch (InterruptedException ie) {
                    LOGGER.debug("Reconnection interrupted.");
                }
                catch (ConnectException ex) {
                    LOGGER.debug("{}:{} refused connection", (Object)TcpSocketManager.this.host, (Object)TcpSocketManager.this.port);
                }
                catch (IOException ioe) {
                    LOGGER.debug("Unable to reconnect to {}:{}", (Object)TcpSocketManager.this.host, (Object)TcpSocketManager.this.port);
                }
                finally {
                    this.latch.countDown();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void reconnect() throws IOException {
            Socket sock = TcpSocketManager.this.createSocket(TcpSocketManager.this.inetAddress.getHostName(), TcpSocketManager.this.port);
            OutputStream newOS = sock.getOutputStream();
            Object object = this.owner;
            synchronized (object) {
                Closer.closeSilently(TcpSocketManager.this.getOutputStream());
                TcpSocketManager.this.setOutputStream(newOS);
                TcpSocketManager.this.socket = sock;
                TcpSocketManager.this.reconnector = null;
                this.shutdown = true;
            }
            LOGGER.debug("Connection to {}:{} reestablished: {}", (Object)TcpSocketManager.this.host, (Object)TcpSocketManager.this.port, (Object)TcpSocketManager.this.socket);
        }

        @Override
        public String toString() {
            return "Reconnector [latch=" + this.latch + ", shutdown=" + this.shutdown + ", owner=" + this.owner + "]";
        }
    }
}

