/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml.v1_15.tokens;

import java.util.List;
import org.yaml.snakeyaml.v1_15.error.Mark;
import org.yaml.snakeyaml.v1_15.error.YAMLException;
import org.yaml.snakeyaml.v1_15.tokens.Token;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DirectiveToken<T>
extends Token {
    private final String name;
    private final List<T> value;

    public DirectiveToken(String name, List<T> value2, Mark startMark, Mark endMark) {
        super(startMark, endMark);
        this.name = name;
        if (value2 != null && value2.size() != 2) {
            throw new YAMLException("Two strings must be provided instead of " + String.valueOf(value2.size()));
        }
        this.value = value2;
    }

    public String getName() {
        return this.name;
    }

    public List<T> getValue() {
        return this.value;
    }

    @Override
    protected String getArguments() {
        if (this.value != null) {
            return "name=" + this.name + ", value=[" + this.value.get(0) + ", " + this.value.get(1) + "]";
        }
        return "name=" + this.name;
    }

    @Override
    public Token.ID getTokenId() {
        return Token.ID.Directive;
    }
}

