/*
 * Decompiled with CFR 0.152.
 */
package spire.math;

import cats.kernel.Comparison;
import cats.kernel.Eq;
import cats.kernel.Eq$class;
import cats.kernel.Order;
import cats.kernel.Order$class;
import cats.kernel.PartialOrder$class;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.math.BigDecimal;
import scala.math.BigInt;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import spire.math.Algebraic;
import spire.math.AlgebraicAlgebra;
import spire.math.AlgebraicInstances;
import spire.math.AlgebraicInstances$class;
import spire.math.Bounded;
import spire.math.Interval;
import spire.math.NumberTag;
import spire.math.Point;
import spire.math.Polynomial;
import spire.math.Rational;
import spire.math.package$;
import spire.math.poly.RootIsolator$;
import spire.math.poly.Roots$;

public final class Algebraic$
implements AlgebraicInstances,
Serializable {
    public static final Algebraic$ MODULE$;
    private final Algebraic Zero;
    private final Algebraic One;
    private final double spire$math$Algebraic$$bits2dec;
    private final Order<java.math.BigDecimal> JBigDecimalOrder;
    private final BigInteger spire$math$Algebraic$$MaxIntValue;
    private final BigInteger spire$math$Algebraic$$MinIntValue;
    private final BigInteger spire$math$Algebraic$$MaxLongValue;
    private final BigInteger spire$math$Algebraic$$MinLongValue;
    private final AlgebraicAlgebra AlgebraicAlgebra;
    private final NumberTag.LargeTag<Algebraic> AlgebraicTag;

    static {
        new Algebraic$();
    }

    @Override
    public final AlgebraicAlgebra AlgebraicAlgebra() {
        return this.AlgebraicAlgebra;
    }

    @Override
    public final NumberTag.LargeTag<Algebraic> AlgebraicTag() {
        return this.AlgebraicTag;
    }

    @Override
    public final void spire$math$AlgebraicInstances$_setter_$AlgebraicAlgebra_$eq(AlgebraicAlgebra x$1) {
        this.AlgebraicAlgebra = x$1;
    }

    @Override
    public final void spire$math$AlgebraicInstances$_setter_$AlgebraicTag_$eq(NumberTag.LargeTag x$1) {
        this.AlgebraicTag = x$1;
    }

    public Algebraic Zero() {
        return this.Zero;
    }

    public Algebraic One() {
        return this.One;
    }

    public Algebraic apply(int n) {
        return new Algebraic(new Algebraic.Expr.ConstantLong(n));
    }

    public Algebraic apply(long n) {
        return new Algebraic(new Algebraic.Expr.ConstantLong(n));
    }

    public Algebraic apply(float n) {
        return this.apply((double)n);
    }

    public Algebraic apply(double n) {
        if (Double.isInfinite(n)) {
            throw new IllegalArgumentException("cannot construct inifinite Algebraic");
        }
        if (Double.isNaN(n)) {
            throw new IllegalArgumentException("cannot construct Algebraic from NaN");
        }
        return new Algebraic(new Algebraic.Expr.ConstantDouble(n));
    }

    public Algebraic apply(BigInt n) {
        return new Algebraic(new Algebraic.Expr.ConstantBigDecimal(scala.package$.MODULE$.BigDecimal().apply(n)));
    }

    public Algebraic apply(BigDecimal n) {
        return new Algebraic(new Algebraic.Expr.ConstantBigDecimal(n));
    }

    public Algebraic apply(Rational n) {
        return new Algebraic(new Algebraic.Expr.ConstantRational(n));
    }

    public Algebraic root(Polynomial<Rational> poly, int i) {
        block7: {
            Algebraic algebraic;
            block6: {
                Interval<Rational> interval2;
                Polynomial<BigInt> zpoly;
                block5: {
                    if (i < 0) {
                        throw new ArithmeticException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"invalid real root index: ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(i)})));
                    }
                    zpoly = Roots$.MODULE$.removeFractions(poly);
                    Vector<Interval<Rational>> intervals = Roots$.MODULE$.isolateRoots(zpoly, RootIsolator$.MODULE$.BigIntRootIsolator());
                    if (i >= intervals.size()) {
                        throw new ArithmeticException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cannot extract root ", ", there are only ", " roots"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(i), BoxesRunTime.boxToInteger(intervals.size())})));
                    }
                    interval2 = intervals.apply(i);
                    if (!(interval2 instanceof Point)) break block5;
                    Point point = (Point)interval2;
                    algebraic = new Algebraic(new Algebraic.Expr.ConstantRational((Rational)point.value()));
                    break block6;
                }
                if (!(interval2 instanceof Bounded)) break block7;
                Bounded bounded = (Bounded)interval2;
                algebraic = new Algebraic(new Algebraic.Expr.ConstantRoot(zpoly, i, (Rational)bounded.lower(), (Rational)bounded.upper()));
            }
            return algebraic;
        }
        throw new RuntimeException("invalid isolated root interval");
    }

    public Vector<Algebraic> roots(Polynomial<Rational> poly) {
        Polynomial<BigInt> zpoly = Roots$.MODULE$.removeFractions(poly);
        Vector<Interval<Rational>> intervals = Roots$.MODULE$.isolateRoots(zpoly, RootIsolator$.MODULE$.BigIntRootIsolator());
        return ((TraversableLike)intervals.zipWithIndex(Vector$.MODULE$.canBuildFrom())).map(new Serializable(zpoly){
            public static final long serialVersionUID = 0L;
            private final Polynomial zpoly$1;

            public final Algebraic apply(Tuple2<Interval<Rational>, Object> x0$1) {
                block4: {
                    Algebraic algebraic;
                    block3: {
                        block2: {
                            if (x0$1 == null || !(x0$1._1() instanceof Point)) break block2;
                            Point point = (Point)x0$1._1();
                            algebraic = new Algebraic(new Algebraic.Expr.ConstantRational((Rational)point.value()));
                            break block3;
                        }
                        if (x0$1 == null || !(x0$1._1() instanceof Bounded)) break block4;
                        Bounded bounded = (Bounded)x0$1._1();
                        algebraic = new Algebraic(new Algebraic.Expr.ConstantRoot(this.zpoly$1, x0$1._2$mcI$sp(), (Rational)bounded.lower(), (Rational)bounded.upper()));
                    }
                    return algebraic;
                }
                throw new RuntimeException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"invalid isolated root interval: ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{x0$1})));
            }
            {
                this.zpoly$1 = zpoly$1;
            }
        }, Vector$.MODULE$.canBuildFrom());
    }

    public Algebraic unsafeRoot(Polynomial<BigInt> poly, int i, Rational lb, Rational ub) {
        return new Algebraic(new Algebraic.Expr.ConstantRoot(poly, i, lb, ub));
    }

    public Algebraic apply(String n) {
        return this.apply(scala.package$.MODULE$.BigDecimal().apply(new java.math.BigDecimal(n)));
    }

    public final java.math.BigDecimal nrootApprox(java.math.BigDecimal x, int n) {
        int k = package$.MODULE$.min(n, 306);
        int width = (int)(package$.MODULE$.ceil((double)x.unscaledValue().bitLength() * package$.MODULE$.log(2.0) / package$.MODULE$.log(10.0)) - 1.0);
        int safeWidth = width + (x.scale() - width) % k;
        double approx = new java.math.BigDecimal(x.unscaledValue().abs(), safeWidth).doubleValue();
        return new java.math.BigDecimal((double)x.signum() * package$.MODULE$.pow(approx, 1.0 / (double)k)).scaleByPowerOfTen(-(x.scale() - safeWidth) / k).round(MathContext.DECIMAL64);
    }

    private final java.math.BigDecimal nroot(java.math.BigDecimal signedValue, int k, Function1<java.math.BigDecimal, Object> getEps) {
        if (signedValue.compareTo(java.math.BigDecimal.ZERO) == 0) {
            return java.math.BigDecimal.ZERO;
        }
        java.math.BigDecimal value = signedValue.abs();
        java.math.BigDecimal n = new java.math.BigDecimal(k);
        java.math.BigDecimal init2 = this.nrootApprox(value, k);
        java.math.BigDecimal unsignedResult = this.loop$2(init2, Integer.MIN_VALUE, java.math.BigDecimal.ZERO, k, getEps, value, n);
        return signedValue.signum() < 0 ? unsignedResult.negate() : unsignedResult;
    }

    public double spire$math$Algebraic$$bits2dec() {
        return this.spire$math$Algebraic$$bits2dec;
    }

    public final java.math.BigDecimal nroot(java.math.BigDecimal value, int n, MathContext mc) {
        java.math.BigDecimal result2 = this.nroot(value, n, (Function1<java.math.BigDecimal, Object>)((Object)new Serializable(mc){
            public static final long serialVersionUID = 0L;
            private final MathContext mc$1;

            public final int apply(java.math.BigDecimal x) {
                return x.scale() - (int)package$.MODULE$.ceil((double)x.unscaledValue().bitLength() * Algebraic$.MODULE$.spire$math$Algebraic$$bits2dec()) + this.mc$1.getPrecision() + 1;
            }
            {
                this.mc$1 = mc$1;
            }
        }));
        return result2.round(mc);
    }

    public final java.math.BigDecimal nroot(java.math.BigDecimal value, int n, int scale, RoundingMode roundingMode) {
        return this.nroot(value, n, (Function1<java.math.BigDecimal, Object>)((Object)new Serializable(scale){
            public static final long serialVersionUID = 0L;
            private final int scale$1;

            public final int apply(java.math.BigDecimal x$4) {
                return this.scale$1 + 1;
            }
            {
                this.scale$1 = scale$1;
            }
        })).setScale(scale, roundingMode);
    }

    private Order<java.math.BigDecimal> JBigDecimalOrder() {
        return this.JBigDecimalOrder;
    }

    public java.math.BigDecimal spire$math$Algebraic$$roundExact(Algebraic exact, java.math.BigDecimal approx, int scale, RoundingMode mode) {
        java.math.BigDecimal bigDecimal;
        if (approx.signum() == 0) {
            java.math.BigDecimal bigDecimal2;
            boolean bl = ((Object)((Object)RoundingMode.UP)).equals((Object)mode) ? true : ((Object)((Object)RoundingMode.CEILING)).equals((Object)mode);
            if (bl && exact.signum() > 0) {
                bigDecimal2 = new java.math.BigDecimal(BigInteger.ONE, scale);
            } else {
                boolean bl2 = ((Object)((Object)RoundingMode.UP)).equals((Object)mode) ? true : ((Object)((Object)RoundingMode.FLOOR)).equals((Object)mode);
                bigDecimal2 = bl2 && exact.signum() < 0 ? new java.math.BigDecimal(BigInteger.ONE.negate(), scale) : approx.setScale(scale, RoundingMode.DOWN);
            }
            bigDecimal = bigDecimal2;
        } else if (approx.signum() > 0) {
            bigDecimal = this.roundPositive(exact, approx, scale, mode);
        } else {
            RoundingMode roundingMode = ((Object)((Object)RoundingMode.CEILING)).equals((Object)mode) ? RoundingMode.FLOOR : (((Object)((Object)RoundingMode.FLOOR)).equals((Object)mode) ? RoundingMode.CEILING : mode);
            bigDecimal = this.roundPositive(exact.unary_$minus(), approx.abs(), scale, roundingMode).negate();
        }
        return bigDecimal;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private java.math.BigDecimal roundPositive(Algebraic exact, java.math.BigDecimal approx, int scale, RoundingMode mode) {
        java.math.BigDecimal bigDecimal;
        java.math.BigDecimal bigDecimal2;
        int cutoff;
        while (true) {
            if ((cutoff = approx.scale() - scale) == 0) {
                bigDecimal2 = approx;
                return bigDecimal2;
            }
            if (cutoff < 0) {
                bigDecimal2 = approx.setScale(scale, RoundingMode.DOWN);
                return bigDecimal2;
            }
            if (cutoff <= 18) break;
            approx = approx.setScale(scale + 18, RoundingMode.DOWN);
        }
        long unscale = package$.MODULE$.pow(10L, cutoff);
        BigInteger[] bigIntegerArray = approx.unscaledValue().divideAndRemainder(BigInteger.valueOf(unscale));
        Option option2 = Array$.MODULE$.unapplySeq(bigIntegerArray);
        if (option2.isEmpty() || option2.get() == null || ((SeqLike)option2.get()).lengthCompare(2) != 0) throw new MatchError(bigIntegerArray);
        BigInteger truncatedUnscaledValue = (BigInteger)((SeqLike)option2.get()).apply(0);
        BigInteger bigRemainder = (BigInteger)((SeqLike)option2.get()).apply(1);
        Tuple2<BigInteger, BigInteger> tuple22 = new Tuple2<BigInteger, BigInteger>(truncatedUnscaledValue, bigRemainder);
        BigInteger truncatedUnscaledValue2 = tuple22._1();
        BigInteger bigRemainder2 = tuple22._2();
        java.math.BigDecimal truncated = new java.math.BigDecimal(truncatedUnscaledValue2, scale);
        long remainder = bigRemainder2.longValue();
        if (((Object)((Object)RoundingMode.UNNECESSARY)).equals((Object)mode)) {
            bigDecimal = truncated;
        } else {
            boolean bl = ((Object)((Object)RoundingMode.HALF_DOWN)).equals((Object)mode) ? true : (((Object)((Object)RoundingMode.HALF_UP)).equals((Object)mode) ? true : ((Object)((Object)RoundingMode.HALF_EVEN)).equals((Object)mode));
            if (bl) {
                java.math.BigDecimal bigDecimal3;
                long dangerZoneStart = unscale / 2L - 1L;
                long dangerZoneStop = dangerZoneStart + 2L;
                if (remainder >= dangerZoneStart && remainder <= dangerZoneStop) {
                    boolean bl2;
                    BigDecimal splitter2 = scala.package$.MODULE$.BigDecimal().apply(new java.math.BigDecimal(truncatedUnscaledValue2.multiply(BigInteger.TEN).add(BigInteger.valueOf(5L)), scale + 1));
                    int cmp = exact.compare(this.apply(splitter2));
                    if (((Object)((Object)RoundingMode.HALF_DOWN)).equals((Object)mode)) {
                        bl2 = cmp > 0;
                    } else if (((Object)((Object)RoundingMode.HALF_UP)).equals((Object)mode)) {
                        bl2 = cmp >= 0;
                    } else {
                        if (!((Object)((Object)RoundingMode.HALF_EVEN)).equals((Object)mode)) throw new MatchError((Object)mode);
                        boolean bl3 = bl2 = cmp > 0 || cmp == 0 && truncatedUnscaledValue2.testBit(0);
                    }
                    bigDecimal3 = bl2 ? truncated.add(this.epsilon$1(scale)) : truncated;
                } else {
                    bigDecimal3 = remainder < dangerZoneStart ? truncated : truncated.add(this.epsilon$1(scale));
                }
                bigDecimal = bigDecimal3;
            } else {
                boolean bl4 = ((Object)((Object)RoundingMode.CEILING)).equals((Object)mode) ? true : ((Object)((Object)RoundingMode.UP)).equals((Object)mode);
                if (bl4) {
                    bigDecimal = remainder <= 1L && exact.$less$eq(this.apply(scala.package$.MODULE$.BigDecimal().apply(truncated))) ? truncated : truncated.add(this.epsilon$1(scale));
                } else {
                    java.math.BigDecimal bigDecimal4;
                    boolean bl5 = ((Object)((Object)RoundingMode.FLOOR)).equals((Object)mode) ? true : ((Object)((Object)RoundingMode.DOWN)).equals((Object)mode);
                    if (!bl5) throw new MatchError((Object)mode);
                    if (remainder <= 0L) {
                        bigDecimal4 = exact.$less(this.apply(scala.package$.MODULE$.BigDecimal().apply(truncated))) ? truncated.subtract(this.epsilon$1(scale)) : truncated;
                    } else if (remainder >= unscale - 1L) {
                        java.math.BigDecimal roundedUp = truncated.add(this.epsilon$1(scale));
                        bigDecimal4 = exact.$greater$eq(this.apply(scala.package$.MODULE$.BigDecimal().apply(roundedUp))) ? roundedUp : truncated;
                    } else {
                        bigDecimal4 = truncated;
                    }
                    bigDecimal = bigDecimal4;
                }
            }
        }
        bigDecimal2 = bigDecimal;
        return bigDecimal2;
    }

    public BigInteger spire$math$Algebraic$$MaxIntValue() {
        return this.spire$math$Algebraic$$MaxIntValue;
    }

    public BigInteger spire$math$Algebraic$$MinIntValue() {
        return this.spire$math$Algebraic$$MinIntValue;
    }

    public BigInteger spire$math$Algebraic$$MaxLongValue() {
        return this.spire$math$Algebraic$$MaxLongValue;
    }

    public BigInteger spire$math$Algebraic$$MinLongValue() {
        return this.spire$math$Algebraic$$MinLongValue;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private final java.math.BigDecimal loop$2(java.math.BigDecimal prev, int prevDigits, java.math.BigDecimal prevEps, int k$1, Function1 getEps$1, java.math.BigDecimal value$1, java.math.BigDecimal n$1) {
        while (true) {
            int digits;
            java.math.BigDecimal eps = (digits = BoxesRunTime.unboxToInt(getEps$1.apply(prev))) == prevDigits ? prevEps : java.math.BigDecimal.ONE.movePointLeft(digits);
            java.math.BigDecimal prevExp = prev.pow(k$1 - 1);
            java.math.BigDecimal delta = value$1.divide(prevExp, digits, RoundingMode.HALF_UP).subtract(prev).divide(n$1, digits, RoundingMode.HALF_UP);
            if (delta.abs().compareTo(eps) <= 0) {
                return prev;
            }
            prevEps = eps;
            prevDigits = digits;
            prev = prev.add(delta);
        }
    }

    private final java.math.BigDecimal epsilon$1(int scale$2) {
        return new java.math.BigDecimal(BigInteger.ONE, scale$2);
    }

    private Algebraic$() {
        MODULE$ = this;
        AlgebraicInstances$class.$init$(this);
        this.Zero = new Algebraic(new Algebraic.Expr.ConstantLong(0L));
        this.One = new Algebraic(new Algebraic.Expr.ConstantLong(1L));
        this.spire$math$Algebraic$$bits2dec = package$.MODULE$.log(2.0, 10);
        this.JBigDecimalOrder = new Order<java.math.BigDecimal>(){

            public int compare$mcZ$sp(boolean x, boolean y) {
                return Order$class.compare$mcZ$sp(this, x, y);
            }

            public int compare$mcB$sp(byte x, byte y) {
                return Order$class.compare$mcB$sp(this, x, y);
            }

            public int compare$mcC$sp(char x, char y) {
                return Order$class.compare$mcC$sp(this, x, y);
            }

            public int compare$mcD$sp(double x, double y) {
                return Order$class.compare$mcD$sp(this, x, y);
            }

            public int compare$mcF$sp(float x, float y) {
                return Order$class.compare$mcF$sp(this, x, y);
            }

            public int compare$mcI$sp(int x, int y) {
                return Order$class.compare$mcI$sp(this, x, y);
            }

            public int compare$mcJ$sp(long x, long y) {
                return Order$class.compare$mcJ$sp(this, x, y);
            }

            public int compare$mcS$sp(short x, short y) {
                return Order$class.compare$mcS$sp(this, x, y);
            }

            public int compare$mcV$sp(BoxedUnit x, BoxedUnit y) {
                return Order$class.compare$mcV$sp(this, x, y);
            }

            public Comparison comparison(Object x, Object y) {
                return Order$class.comparison(this, x, y);
            }

            public Comparison comparison$mcZ$sp(boolean x, boolean y) {
                return Order$class.comparison$mcZ$sp(this, x, y);
            }

            public Comparison comparison$mcB$sp(byte x, byte y) {
                return Order$class.comparison$mcB$sp(this, x, y);
            }

            public Comparison comparison$mcC$sp(char x, char y) {
                return Order$class.comparison$mcC$sp(this, x, y);
            }

            public Comparison comparison$mcD$sp(double x, double y) {
                return Order$class.comparison$mcD$sp(this, x, y);
            }

            public Comparison comparison$mcF$sp(float x, float y) {
                return Order$class.comparison$mcF$sp(this, x, y);
            }

            public Comparison comparison$mcI$sp(int x, int y) {
                return Order$class.comparison$mcI$sp(this, x, y);
            }

            public Comparison comparison$mcJ$sp(long x, long y) {
                return Order$class.comparison$mcJ$sp(this, x, y);
            }

            public Comparison comparison$mcS$sp(short x, short y) {
                return Order$class.comparison$mcS$sp(this, x, y);
            }

            public Comparison comparison$mcV$sp(BoxedUnit x, BoxedUnit y) {
                return Order$class.comparison$mcV$sp(this, x, y);
            }

            public double partialCompare(Object x, Object y) {
                return Order$class.partialCompare(this, x, y);
            }

            public double partialCompare$mcZ$sp(boolean x, boolean y) {
                return Order$class.partialCompare$mcZ$sp(this, x, y);
            }

            public double partialCompare$mcB$sp(byte x, byte y) {
                return Order$class.partialCompare$mcB$sp(this, x, y);
            }

            public double partialCompare$mcC$sp(char x, char y) {
                return Order$class.partialCompare$mcC$sp(this, x, y);
            }

            public double partialCompare$mcD$sp(double x, double y) {
                return Order$class.partialCompare$mcD$sp(this, x, y);
            }

            public double partialCompare$mcF$sp(float x, float y) {
                return Order$class.partialCompare$mcF$sp(this, x, y);
            }

            public double partialCompare$mcI$sp(int x, int y) {
                return Order$class.partialCompare$mcI$sp(this, x, y);
            }

            public double partialCompare$mcJ$sp(long x, long y) {
                return Order$class.partialCompare$mcJ$sp(this, x, y);
            }

            public double partialCompare$mcS$sp(short x, short y) {
                return Order$class.partialCompare$mcS$sp(this, x, y);
            }

            public double partialCompare$mcV$sp(BoxedUnit x, BoxedUnit y) {
                return Order$class.partialCompare$mcV$sp(this, x, y);
            }

            public Object min(Object x, Object y) {
                return Order$class.min(this, x, y);
            }

            public boolean min$mcZ$sp(boolean x, boolean y) {
                return Order$class.min$mcZ$sp(this, x, y);
            }

            public byte min$mcB$sp(byte x, byte y) {
                return Order$class.min$mcB$sp(this, x, y);
            }

            public char min$mcC$sp(char x, char y) {
                return Order$class.min$mcC$sp(this, x, y);
            }

            public double min$mcD$sp(double x, double y) {
                return Order$class.min$mcD$sp(this, x, y);
            }

            public float min$mcF$sp(float x, float y) {
                return Order$class.min$mcF$sp(this, x, y);
            }

            public int min$mcI$sp(int x, int y) {
                return Order$class.min$mcI$sp(this, x, y);
            }

            public long min$mcJ$sp(long x, long y) {
                return Order$class.min$mcJ$sp(this, x, y);
            }

            public short min$mcS$sp(short x, short y) {
                return Order$class.min$mcS$sp(this, x, y);
            }

            public void min$mcV$sp(BoxedUnit x, BoxedUnit y) {
                Order$class.min$mcV$sp(this, x, y);
            }

            public Object max(Object x, Object y) {
                return Order$class.max(this, x, y);
            }

            public boolean max$mcZ$sp(boolean x, boolean y) {
                return Order$class.max$mcZ$sp(this, x, y);
            }

            public byte max$mcB$sp(byte x, byte y) {
                return Order$class.max$mcB$sp(this, x, y);
            }

            public char max$mcC$sp(char x, char y) {
                return Order$class.max$mcC$sp(this, x, y);
            }

            public double max$mcD$sp(double x, double y) {
                return Order$class.max$mcD$sp(this, x, y);
            }

            public float max$mcF$sp(float x, float y) {
                return Order$class.max$mcF$sp(this, x, y);
            }

            public int max$mcI$sp(int x, int y) {
                return Order$class.max$mcI$sp(this, x, y);
            }

            public long max$mcJ$sp(long x, long y) {
                return Order$class.max$mcJ$sp(this, x, y);
            }

            public short max$mcS$sp(short x, short y) {
                return Order$class.max$mcS$sp(this, x, y);
            }

            public void max$mcV$sp(BoxedUnit x, BoxedUnit y) {
                Order$class.max$mcV$sp(this, x, y);
            }

            public <B> Order<B> on(Function1<B, java.math.BigDecimal> f) {
                return Order$class.on(this, f);
            }

            public <B> Order<B> on$mcZ$sp(Function1<B, Object> f) {
                return Order$class.on$mcZ$sp(this, f);
            }

            public <B> Order<B> on$mcB$sp(Function1<B, Object> f) {
                return Order$class.on$mcB$sp(this, f);
            }

            public <B> Order<B> on$mcC$sp(Function1<B, Object> f) {
                return Order$class.on$mcC$sp(this, f);
            }

            public <B> Order<B> on$mcD$sp(Function1<B, Object> f) {
                return Order$class.on$mcD$sp(this, f);
            }

            public <B> Order<B> on$mcF$sp(Function1<B, Object> f) {
                return Order$class.on$mcF$sp(this, f);
            }

            public <B> Order<B> on$mcI$sp(Function1<B, Object> f) {
                return Order$class.on$mcI$sp(this, f);
            }

            public <B> Order<B> on$mcJ$sp(Function1<B, Object> f) {
                return Order$class.on$mcJ$sp(this, f);
            }

            public <B> Order<B> on$mcS$sp(Function1<B, Object> f) {
                return Order$class.on$mcS$sp(this, f);
            }

            public <B> Order<B> on$mcV$sp(Function1<B, BoxedUnit> f) {
                return Order$class.on$mcV$sp(this, f);
            }

            public Order<Object> on$mZc$sp(Function1<Object, java.math.BigDecimal> f) {
                return Order$class.on$mZc$sp(this, f);
            }

            public Order<Object> on$mZcZ$sp(Function1<Object, Object> f) {
                return Order$class.on$mZcZ$sp(this, f);
            }

            public Order<Object> on$mZcB$sp(Function1<Object, Object> f) {
                return Order$class.on$mZcB$sp(this, f);
            }

            public Order<Object> on$mZcC$sp(Function1<Object, Object> f) {
                return Order$class.on$mZcC$sp(this, f);
            }

            public Order<Object> on$mZcD$sp(Function1<Object, Object> f) {
                return Order$class.on$mZcD$sp(this, f);
            }

            public Order<Object> on$mZcF$sp(Function1<Object, Object> f) {
                return Order$class.on$mZcF$sp(this, f);
            }

            public Order<Object> on$mZcI$sp(Function1<Object, Object> f) {
                return Order$class.on$mZcI$sp(this, f);
            }

            public Order<Object> on$mZcJ$sp(Function1<Object, Object> f) {
                return Order$class.on$mZcJ$sp(this, f);
            }

            public Order<Object> on$mZcS$sp(Function1<Object, Object> f) {
                return Order$class.on$mZcS$sp(this, f);
            }

            public Order<Object> on$mZcV$sp(Function1<Object, BoxedUnit> f) {
                return Order$class.on$mZcV$sp(this, f);
            }

            public Order<Object> on$mBc$sp(Function1<Object, java.math.BigDecimal> f) {
                return Order$class.on$mBc$sp(this, f);
            }

            public Order<Object> on$mBcZ$sp(Function1<Object, Object> f) {
                return Order$class.on$mBcZ$sp(this, f);
            }

            public Order<Object> on$mBcB$sp(Function1<Object, Object> f) {
                return Order$class.on$mBcB$sp(this, f);
            }

            public Order<Object> on$mBcC$sp(Function1<Object, Object> f) {
                return Order$class.on$mBcC$sp(this, f);
            }

            public Order<Object> on$mBcD$sp(Function1<Object, Object> f) {
                return Order$class.on$mBcD$sp(this, f);
            }

            public Order<Object> on$mBcF$sp(Function1<Object, Object> f) {
                return Order$class.on$mBcF$sp(this, f);
            }

            public Order<Object> on$mBcI$sp(Function1<Object, Object> f) {
                return Order$class.on$mBcI$sp(this, f);
            }

            public Order<Object> on$mBcJ$sp(Function1<Object, Object> f) {
                return Order$class.on$mBcJ$sp(this, f);
            }

            public Order<Object> on$mBcS$sp(Function1<Object, Object> f) {
                return Order$class.on$mBcS$sp(this, f);
            }

            public Order<Object> on$mBcV$sp(Function1<Object, BoxedUnit> f) {
                return Order$class.on$mBcV$sp(this, f);
            }

            public Order<Object> on$mCc$sp(Function1<Object, java.math.BigDecimal> f) {
                return Order$class.on$mCc$sp(this, f);
            }

            public Order<Object> on$mCcZ$sp(Function1<Object, Object> f) {
                return Order$class.on$mCcZ$sp(this, f);
            }

            public Order<Object> on$mCcB$sp(Function1<Object, Object> f) {
                return Order$class.on$mCcB$sp(this, f);
            }

            public Order<Object> on$mCcC$sp(Function1<Object, Object> f) {
                return Order$class.on$mCcC$sp(this, f);
            }

            public Order<Object> on$mCcD$sp(Function1<Object, Object> f) {
                return Order$class.on$mCcD$sp(this, f);
            }

            public Order<Object> on$mCcF$sp(Function1<Object, Object> f) {
                return Order$class.on$mCcF$sp(this, f);
            }

            public Order<Object> on$mCcI$sp(Function1<Object, Object> f) {
                return Order$class.on$mCcI$sp(this, f);
            }

            public Order<Object> on$mCcJ$sp(Function1<Object, Object> f) {
                return Order$class.on$mCcJ$sp(this, f);
            }

            public Order<Object> on$mCcS$sp(Function1<Object, Object> f) {
                return Order$class.on$mCcS$sp(this, f);
            }

            public Order<Object> on$mCcV$sp(Function1<Object, BoxedUnit> f) {
                return Order$class.on$mCcV$sp(this, f);
            }

            public Order<Object> on$mDc$sp(Function1<Object, java.math.BigDecimal> f) {
                return Order$class.on$mDc$sp(this, f);
            }

            public Order<Object> on$mDcZ$sp(Function1<Object, Object> f) {
                return Order$class.on$mDcZ$sp(this, f);
            }

            public Order<Object> on$mDcB$sp(Function1<Object, Object> f) {
                return Order$class.on$mDcB$sp(this, f);
            }

            public Order<Object> on$mDcC$sp(Function1<Object, Object> f) {
                return Order$class.on$mDcC$sp(this, f);
            }

            public Order<Object> on$mDcD$sp(Function1<Object, Object> f) {
                return Order$class.on$mDcD$sp(this, f);
            }

            public Order<Object> on$mDcF$sp(Function1<Object, Object> f) {
                return Order$class.on$mDcF$sp(this, f);
            }

            public Order<Object> on$mDcI$sp(Function1<Object, Object> f) {
                return Order$class.on$mDcI$sp(this, f);
            }

            public Order<Object> on$mDcJ$sp(Function1<Object, Object> f) {
                return Order$class.on$mDcJ$sp(this, f);
            }

            public Order<Object> on$mDcS$sp(Function1<Object, Object> f) {
                return Order$class.on$mDcS$sp(this, f);
            }

            public Order<Object> on$mDcV$sp(Function1<Object, BoxedUnit> f) {
                return Order$class.on$mDcV$sp(this, f);
            }

            public Order<Object> on$mFc$sp(Function1<Object, java.math.BigDecimal> f) {
                return Order$class.on$mFc$sp(this, f);
            }

            public Order<Object> on$mFcZ$sp(Function1<Object, Object> f) {
                return Order$class.on$mFcZ$sp(this, f);
            }

            public Order<Object> on$mFcB$sp(Function1<Object, Object> f) {
                return Order$class.on$mFcB$sp(this, f);
            }

            public Order<Object> on$mFcC$sp(Function1<Object, Object> f) {
                return Order$class.on$mFcC$sp(this, f);
            }

            public Order<Object> on$mFcD$sp(Function1<Object, Object> f) {
                return Order$class.on$mFcD$sp(this, f);
            }

            public Order<Object> on$mFcF$sp(Function1<Object, Object> f) {
                return Order$class.on$mFcF$sp(this, f);
            }

            public Order<Object> on$mFcI$sp(Function1<Object, Object> f) {
                return Order$class.on$mFcI$sp(this, f);
            }

            public Order<Object> on$mFcJ$sp(Function1<Object, Object> f) {
                return Order$class.on$mFcJ$sp(this, f);
            }

            public Order<Object> on$mFcS$sp(Function1<Object, Object> f) {
                return Order$class.on$mFcS$sp(this, f);
            }

            public Order<Object> on$mFcV$sp(Function1<Object, BoxedUnit> f) {
                return Order$class.on$mFcV$sp(this, f);
            }

            public Order<Object> on$mIc$sp(Function1<Object, java.math.BigDecimal> f) {
                return Order$class.on$mIc$sp(this, f);
            }

            public Order<Object> on$mIcZ$sp(Function1<Object, Object> f) {
                return Order$class.on$mIcZ$sp(this, f);
            }

            public Order<Object> on$mIcB$sp(Function1<Object, Object> f) {
                return Order$class.on$mIcB$sp(this, f);
            }

            public Order<Object> on$mIcC$sp(Function1<Object, Object> f) {
                return Order$class.on$mIcC$sp(this, f);
            }

            public Order<Object> on$mIcD$sp(Function1<Object, Object> f) {
                return Order$class.on$mIcD$sp(this, f);
            }

            public Order<Object> on$mIcF$sp(Function1<Object, Object> f) {
                return Order$class.on$mIcF$sp(this, f);
            }

            public Order<Object> on$mIcI$sp(Function1<Object, Object> f) {
                return Order$class.on$mIcI$sp(this, f);
            }

            public Order<Object> on$mIcJ$sp(Function1<Object, Object> f) {
                return Order$class.on$mIcJ$sp(this, f);
            }

            public Order<Object> on$mIcS$sp(Function1<Object, Object> f) {
                return Order$class.on$mIcS$sp(this, f);
            }

            public Order<Object> on$mIcV$sp(Function1<Object, BoxedUnit> f) {
                return Order$class.on$mIcV$sp(this, f);
            }

            public Order<Object> on$mJc$sp(Function1<Object, java.math.BigDecimal> f) {
                return Order$class.on$mJc$sp(this, f);
            }

            public Order<Object> on$mJcZ$sp(Function1<Object, Object> f) {
                return Order$class.on$mJcZ$sp(this, f);
            }

            public Order<Object> on$mJcB$sp(Function1<Object, Object> f) {
                return Order$class.on$mJcB$sp(this, f);
            }

            public Order<Object> on$mJcC$sp(Function1<Object, Object> f) {
                return Order$class.on$mJcC$sp(this, f);
            }

            public Order<Object> on$mJcD$sp(Function1<Object, Object> f) {
                return Order$class.on$mJcD$sp(this, f);
            }

            public Order<Object> on$mJcF$sp(Function1<Object, Object> f) {
                return Order$class.on$mJcF$sp(this, f);
            }

            public Order<Object> on$mJcI$sp(Function1<Object, Object> f) {
                return Order$class.on$mJcI$sp(this, f);
            }

            public Order<Object> on$mJcJ$sp(Function1<Object, Object> f) {
                return Order$class.on$mJcJ$sp(this, f);
            }

            public Order<Object> on$mJcS$sp(Function1<Object, Object> f) {
                return Order$class.on$mJcS$sp(this, f);
            }

            public Order<Object> on$mJcV$sp(Function1<Object, BoxedUnit> f) {
                return Order$class.on$mJcV$sp(this, f);
            }

            public Order<Object> on$mSc$sp(Function1<Object, java.math.BigDecimal> f) {
                return Order$class.on$mSc$sp(this, f);
            }

            public Order<Object> on$mScZ$sp(Function1<Object, Object> f) {
                return Order$class.on$mScZ$sp(this, f);
            }

            public Order<Object> on$mScB$sp(Function1<Object, Object> f) {
                return Order$class.on$mScB$sp(this, f);
            }

            public Order<Object> on$mScC$sp(Function1<Object, Object> f) {
                return Order$class.on$mScC$sp(this, f);
            }

            public Order<Object> on$mScD$sp(Function1<Object, Object> f) {
                return Order$class.on$mScD$sp(this, f);
            }

            public Order<Object> on$mScF$sp(Function1<Object, Object> f) {
                return Order$class.on$mScF$sp(this, f);
            }

            public Order<Object> on$mScI$sp(Function1<Object, Object> f) {
                return Order$class.on$mScI$sp(this, f);
            }

            public Order<Object> on$mScJ$sp(Function1<Object, Object> f) {
                return Order$class.on$mScJ$sp(this, f);
            }

            public Order<Object> on$mScS$sp(Function1<Object, Object> f) {
                return Order$class.on$mScS$sp(this, f);
            }

            public Order<Object> on$mScV$sp(Function1<Object, BoxedUnit> f) {
                return Order$class.on$mScV$sp(this, f);
            }

            public Order<BoxedUnit> on$mVc$sp(Function1<BoxedUnit, java.math.BigDecimal> f) {
                return Order$class.on$mVc$sp(this, f);
            }

            public Order<BoxedUnit> on$mVcZ$sp(Function1<BoxedUnit, Object> f) {
                return Order$class.on$mVcZ$sp(this, f);
            }

            public Order<BoxedUnit> on$mVcB$sp(Function1<BoxedUnit, Object> f) {
                return Order$class.on$mVcB$sp(this, f);
            }

            public Order<BoxedUnit> on$mVcC$sp(Function1<BoxedUnit, Object> f) {
                return Order$class.on$mVcC$sp(this, f);
            }

            public Order<BoxedUnit> on$mVcD$sp(Function1<BoxedUnit, Object> f) {
                return Order$class.on$mVcD$sp(this, f);
            }

            public Order<BoxedUnit> on$mVcF$sp(Function1<BoxedUnit, Object> f) {
                return Order$class.on$mVcF$sp(this, f);
            }

            public Order<BoxedUnit> on$mVcI$sp(Function1<BoxedUnit, Object> f) {
                return Order$class.on$mVcI$sp(this, f);
            }

            public Order<BoxedUnit> on$mVcJ$sp(Function1<BoxedUnit, Object> f) {
                return Order$class.on$mVcJ$sp(this, f);
            }

            public Order<BoxedUnit> on$mVcS$sp(Function1<BoxedUnit, Object> f) {
                return Order$class.on$mVcS$sp(this, f);
            }

            public Order<BoxedUnit> on$mVcV$sp(Function1<BoxedUnit, BoxedUnit> f) {
                return Order$class.on$mVcV$sp(this, f);
            }

            public Order<java.math.BigDecimal> reverse() {
                return Order$class.reverse(this);
            }

            public Order<Object> reverse$mcZ$sp() {
                return Order$class.reverse$mcZ$sp(this);
            }

            public Order<Object> reverse$mcB$sp() {
                return Order$class.reverse$mcB$sp(this);
            }

            public Order<Object> reverse$mcC$sp() {
                return Order$class.reverse$mcC$sp(this);
            }

            public Order<Object> reverse$mcD$sp() {
                return Order$class.reverse$mcD$sp(this);
            }

            public Order<Object> reverse$mcF$sp() {
                return Order$class.reverse$mcF$sp(this);
            }

            public Order<Object> reverse$mcI$sp() {
                return Order$class.reverse$mcI$sp(this);
            }

            public Order<Object> reverse$mcJ$sp() {
                return Order$class.reverse$mcJ$sp(this);
            }

            public Order<Object> reverse$mcS$sp() {
                return Order$class.reverse$mcS$sp(this);
            }

            public Order<BoxedUnit> reverse$mcV$sp() {
                return Order$class.reverse$mcV$sp(this);
            }

            public boolean eqv(Object x, Object y) {
                return Order$class.eqv(this, x, y);
            }

            public boolean eqv$mcZ$sp(boolean x, boolean y) {
                return Order$class.eqv$mcZ$sp(this, x, y);
            }

            public boolean eqv$mcB$sp(byte x, byte y) {
                return Order$class.eqv$mcB$sp(this, x, y);
            }

            public boolean eqv$mcC$sp(char x, char y) {
                return Order$class.eqv$mcC$sp(this, x, y);
            }

            public boolean eqv$mcD$sp(double x, double y) {
                return Order$class.eqv$mcD$sp(this, x, y);
            }

            public boolean eqv$mcF$sp(float x, float y) {
                return Order$class.eqv$mcF$sp(this, x, y);
            }

            public boolean eqv$mcI$sp(int x, int y) {
                return Order$class.eqv$mcI$sp(this, x, y);
            }

            public boolean eqv$mcJ$sp(long x, long y) {
                return Order$class.eqv$mcJ$sp(this, x, y);
            }

            public boolean eqv$mcS$sp(short x, short y) {
                return Order$class.eqv$mcS$sp(this, x, y);
            }

            public boolean eqv$mcV$sp(BoxedUnit x, BoxedUnit y) {
                return Order$class.eqv$mcV$sp(this, x, y);
            }

            public boolean neqv(Object x, Object y) {
                return Order$class.neqv(this, x, y);
            }

            public boolean neqv$mcZ$sp(boolean x, boolean y) {
                return Order$class.neqv$mcZ$sp(this, x, y);
            }

            public boolean neqv$mcB$sp(byte x, byte y) {
                return Order$class.neqv$mcB$sp(this, x, y);
            }

            public boolean neqv$mcC$sp(char x, char y) {
                return Order$class.neqv$mcC$sp(this, x, y);
            }

            public boolean neqv$mcD$sp(double x, double y) {
                return Order$class.neqv$mcD$sp(this, x, y);
            }

            public boolean neqv$mcF$sp(float x, float y) {
                return Order$class.neqv$mcF$sp(this, x, y);
            }

            public boolean neqv$mcI$sp(int x, int y) {
                return Order$class.neqv$mcI$sp(this, x, y);
            }

            public boolean neqv$mcJ$sp(long x, long y) {
                return Order$class.neqv$mcJ$sp(this, x, y);
            }

            public boolean neqv$mcS$sp(short x, short y) {
                return Order$class.neqv$mcS$sp(this, x, y);
            }

            public boolean neqv$mcV$sp(BoxedUnit x, BoxedUnit y) {
                return Order$class.neqv$mcV$sp(this, x, y);
            }

            public boolean lteqv(Object x, Object y) {
                return Order$class.lteqv(this, x, y);
            }

            public boolean lteqv$mcZ$sp(boolean x, boolean y) {
                return Order$class.lteqv$mcZ$sp(this, x, y);
            }

            public boolean lteqv$mcB$sp(byte x, byte y) {
                return Order$class.lteqv$mcB$sp(this, x, y);
            }

            public boolean lteqv$mcC$sp(char x, char y) {
                return Order$class.lteqv$mcC$sp(this, x, y);
            }

            public boolean lteqv$mcD$sp(double x, double y) {
                return Order$class.lteqv$mcD$sp(this, x, y);
            }

            public boolean lteqv$mcF$sp(float x, float y) {
                return Order$class.lteqv$mcF$sp(this, x, y);
            }

            public boolean lteqv$mcI$sp(int x, int y) {
                return Order$class.lteqv$mcI$sp(this, x, y);
            }

            public boolean lteqv$mcJ$sp(long x, long y) {
                return Order$class.lteqv$mcJ$sp(this, x, y);
            }

            public boolean lteqv$mcS$sp(short x, short y) {
                return Order$class.lteqv$mcS$sp(this, x, y);
            }

            public boolean lteqv$mcV$sp(BoxedUnit x, BoxedUnit y) {
                return Order$class.lteqv$mcV$sp(this, x, y);
            }

            public boolean lt(Object x, Object y) {
                return Order$class.lt(this, x, y);
            }

            public boolean lt$mcZ$sp(boolean x, boolean y) {
                return Order$class.lt$mcZ$sp(this, x, y);
            }

            public boolean lt$mcB$sp(byte x, byte y) {
                return Order$class.lt$mcB$sp(this, x, y);
            }

            public boolean lt$mcC$sp(char x, char y) {
                return Order$class.lt$mcC$sp(this, x, y);
            }

            public boolean lt$mcD$sp(double x, double y) {
                return Order$class.lt$mcD$sp(this, x, y);
            }

            public boolean lt$mcF$sp(float x, float y) {
                return Order$class.lt$mcF$sp(this, x, y);
            }

            public boolean lt$mcI$sp(int x, int y) {
                return Order$class.lt$mcI$sp(this, x, y);
            }

            public boolean lt$mcJ$sp(long x, long y) {
                return Order$class.lt$mcJ$sp(this, x, y);
            }

            public boolean lt$mcS$sp(short x, short y) {
                return Order$class.lt$mcS$sp(this, x, y);
            }

            public boolean lt$mcV$sp(BoxedUnit x, BoxedUnit y) {
                return Order$class.lt$mcV$sp(this, x, y);
            }

            public boolean gteqv(Object x, Object y) {
                return Order$class.gteqv(this, x, y);
            }

            public boolean gteqv$mcZ$sp(boolean x, boolean y) {
                return Order$class.gteqv$mcZ$sp(this, x, y);
            }

            public boolean gteqv$mcB$sp(byte x, byte y) {
                return Order$class.gteqv$mcB$sp(this, x, y);
            }

            public boolean gteqv$mcC$sp(char x, char y) {
                return Order$class.gteqv$mcC$sp(this, x, y);
            }

            public boolean gteqv$mcD$sp(double x, double y) {
                return Order$class.gteqv$mcD$sp(this, x, y);
            }

            public boolean gteqv$mcF$sp(float x, float y) {
                return Order$class.gteqv$mcF$sp(this, x, y);
            }

            public boolean gteqv$mcI$sp(int x, int y) {
                return Order$class.gteqv$mcI$sp(this, x, y);
            }

            public boolean gteqv$mcJ$sp(long x, long y) {
                return Order$class.gteqv$mcJ$sp(this, x, y);
            }

            public boolean gteqv$mcS$sp(short x, short y) {
                return Order$class.gteqv$mcS$sp(this, x, y);
            }

            public boolean gteqv$mcV$sp(BoxedUnit x, BoxedUnit y) {
                return Order$class.gteqv$mcV$sp(this, x, y);
            }

            public boolean gt(Object x, Object y) {
                return Order$class.gt(this, x, y);
            }

            public boolean gt$mcZ$sp(boolean x, boolean y) {
                return Order$class.gt$mcZ$sp(this, x, y);
            }

            public boolean gt$mcB$sp(byte x, byte y) {
                return Order$class.gt$mcB$sp(this, x, y);
            }

            public boolean gt$mcC$sp(char x, char y) {
                return Order$class.gt$mcC$sp(this, x, y);
            }

            public boolean gt$mcD$sp(double x, double y) {
                return Order$class.gt$mcD$sp(this, x, y);
            }

            public boolean gt$mcF$sp(float x, float y) {
                return Order$class.gt$mcF$sp(this, x, y);
            }

            public boolean gt$mcI$sp(int x, int y) {
                return Order$class.gt$mcI$sp(this, x, y);
            }

            public boolean gt$mcJ$sp(long x, long y) {
                return Order$class.gt$mcJ$sp(this, x, y);
            }

            public boolean gt$mcS$sp(short x, short y) {
                return Order$class.gt$mcS$sp(this, x, y);
            }

            public boolean gt$mcV$sp(BoxedUnit x, BoxedUnit y) {
                return Order$class.gt$mcV$sp(this, x, y);
            }

            public Order<java.math.BigDecimal> whenEqual(Order<java.math.BigDecimal> o) {
                return Order$class.whenEqual(this, o);
            }

            public Order<Object> whenEqual$mcZ$sp(Order<Object> o) {
                return Order$class.whenEqual$mcZ$sp(this, o);
            }

            public Order<Object> whenEqual$mcB$sp(Order<Object> o) {
                return Order$class.whenEqual$mcB$sp(this, o);
            }

            public Order<Object> whenEqual$mcC$sp(Order<Object> o) {
                return Order$class.whenEqual$mcC$sp(this, o);
            }

            public Order<Object> whenEqual$mcD$sp(Order<Object> o) {
                return Order$class.whenEqual$mcD$sp(this, o);
            }

            public Order<Object> whenEqual$mcF$sp(Order<Object> o) {
                return Order$class.whenEqual$mcF$sp(this, o);
            }

            public Order<Object> whenEqual$mcI$sp(Order<Object> o) {
                return Order$class.whenEqual$mcI$sp(this, o);
            }

            public Order<Object> whenEqual$mcJ$sp(Order<Object> o) {
                return Order$class.whenEqual$mcJ$sp(this, o);
            }

            public Order<Object> whenEqual$mcS$sp(Order<Object> o) {
                return Order$class.whenEqual$mcS$sp(this, o);
            }

            public Order<BoxedUnit> whenEqual$mcV$sp(Order<BoxedUnit> o) {
                return Order$class.whenEqual$mcV$sp(this, o);
            }

            public Ordering<java.math.BigDecimal> toOrdering() {
                return Order$class.toOrdering(this);
            }

            public Option partialComparison(Object x, Object y) {
                return PartialOrder$class.partialComparison(this, x, y);
            }

            public Option<Comparison> partialComparison$mcZ$sp(boolean x, boolean y) {
                return PartialOrder$class.partialComparison$mcZ$sp(this, x, y);
            }

            public Option<Comparison> partialComparison$mcB$sp(byte x, byte y) {
                return PartialOrder$class.partialComparison$mcB$sp(this, x, y);
            }

            public Option<Comparison> partialComparison$mcC$sp(char x, char y) {
                return PartialOrder$class.partialComparison$mcC$sp(this, x, y);
            }

            public Option<Comparison> partialComparison$mcD$sp(double x, double y) {
                return PartialOrder$class.partialComparison$mcD$sp(this, x, y);
            }

            public Option<Comparison> partialComparison$mcF$sp(float x, float y) {
                return PartialOrder$class.partialComparison$mcF$sp(this, x, y);
            }

            public Option<Comparison> partialComparison$mcI$sp(int x, int y) {
                return PartialOrder$class.partialComparison$mcI$sp(this, x, y);
            }

            public Option<Comparison> partialComparison$mcJ$sp(long x, long y) {
                return PartialOrder$class.partialComparison$mcJ$sp(this, x, y);
            }

            public Option<Comparison> partialComparison$mcS$sp(short x, short y) {
                return PartialOrder$class.partialComparison$mcS$sp(this, x, y);
            }

            public Option<Comparison> partialComparison$mcV$sp(BoxedUnit x, BoxedUnit y) {
                return PartialOrder$class.partialComparison$mcV$sp(this, x, y);
            }

            public Option tryCompare(Object x, Object y) {
                return PartialOrder$class.tryCompare(this, x, y);
            }

            public Option<Object> tryCompare$mcZ$sp(boolean x, boolean y) {
                return PartialOrder$class.tryCompare$mcZ$sp(this, x, y);
            }

            public Option<Object> tryCompare$mcB$sp(byte x, byte y) {
                return PartialOrder$class.tryCompare$mcB$sp(this, x, y);
            }

            public Option<Object> tryCompare$mcC$sp(char x, char y) {
                return PartialOrder$class.tryCompare$mcC$sp(this, x, y);
            }

            public Option<Object> tryCompare$mcD$sp(double x, double y) {
                return PartialOrder$class.tryCompare$mcD$sp(this, x, y);
            }

            public Option<Object> tryCompare$mcF$sp(float x, float y) {
                return PartialOrder$class.tryCompare$mcF$sp(this, x, y);
            }

            public Option<Object> tryCompare$mcI$sp(int x, int y) {
                return PartialOrder$class.tryCompare$mcI$sp(this, x, y);
            }

            public Option<Object> tryCompare$mcJ$sp(long x, long y) {
                return PartialOrder$class.tryCompare$mcJ$sp(this, x, y);
            }

            public Option<Object> tryCompare$mcS$sp(short x, short y) {
                return PartialOrder$class.tryCompare$mcS$sp(this, x, y);
            }

            public Option<Object> tryCompare$mcV$sp(BoxedUnit x, BoxedUnit y) {
                return PartialOrder$class.tryCompare$mcV$sp(this, x, y);
            }

            public Option pmin(Object x, Object y) {
                return PartialOrder$class.pmin(this, x, y);
            }

            public Option<Object> pmin$mcZ$sp(boolean x, boolean y) {
                return PartialOrder$class.pmin$mcZ$sp(this, x, y);
            }

            public Option<Object> pmin$mcB$sp(byte x, byte y) {
                return PartialOrder$class.pmin$mcB$sp(this, x, y);
            }

            public Option<Object> pmin$mcC$sp(char x, char y) {
                return PartialOrder$class.pmin$mcC$sp(this, x, y);
            }

            public Option<Object> pmin$mcD$sp(double x, double y) {
                return PartialOrder$class.pmin$mcD$sp(this, x, y);
            }

            public Option<Object> pmin$mcF$sp(float x, float y) {
                return PartialOrder$class.pmin$mcF$sp(this, x, y);
            }

            public Option<Object> pmin$mcI$sp(int x, int y) {
                return PartialOrder$class.pmin$mcI$sp(this, x, y);
            }

            public Option<Object> pmin$mcJ$sp(long x, long y) {
                return PartialOrder$class.pmin$mcJ$sp(this, x, y);
            }

            public Option<Object> pmin$mcS$sp(short x, short y) {
                return PartialOrder$class.pmin$mcS$sp(this, x, y);
            }

            public Option<BoxedUnit> pmin$mcV$sp(BoxedUnit x, BoxedUnit y) {
                return PartialOrder$class.pmin$mcV$sp(this, x, y);
            }

            public Option pmax(Object x, Object y) {
                return PartialOrder$class.pmax(this, x, y);
            }

            public Option<Object> pmax$mcZ$sp(boolean x, boolean y) {
                return PartialOrder$class.pmax$mcZ$sp(this, x, y);
            }

            public Option<Object> pmax$mcB$sp(byte x, byte y) {
                return PartialOrder$class.pmax$mcB$sp(this, x, y);
            }

            public Option<Object> pmax$mcC$sp(char x, char y) {
                return PartialOrder$class.pmax$mcC$sp(this, x, y);
            }

            public Option<Object> pmax$mcD$sp(double x, double y) {
                return PartialOrder$class.pmax$mcD$sp(this, x, y);
            }

            public Option<Object> pmax$mcF$sp(float x, float y) {
                return PartialOrder$class.pmax$mcF$sp(this, x, y);
            }

            public Option<Object> pmax$mcI$sp(int x, int y) {
                return PartialOrder$class.pmax$mcI$sp(this, x, y);
            }

            public Option<Object> pmax$mcJ$sp(long x, long y) {
                return PartialOrder$class.pmax$mcJ$sp(this, x, y);
            }

            public Option<Object> pmax$mcS$sp(short x, short y) {
                return PartialOrder$class.pmax$mcS$sp(this, x, y);
            }

            public Option<BoxedUnit> pmax$mcV$sp(BoxedUnit x, BoxedUnit y) {
                return PartialOrder$class.pmax$mcV$sp(this, x, y);
            }

            public Eq<java.math.BigDecimal> and(Eq<java.math.BigDecimal> that) {
                return Eq$class.and(this, that);
            }

            public Eq<Object> and$mcZ$sp(Eq<Object> that) {
                return Eq$class.and$mcZ$sp(this, that);
            }

            public Eq<Object> and$mcB$sp(Eq<Object> that) {
                return Eq$class.and$mcB$sp(this, that);
            }

            public Eq<Object> and$mcC$sp(Eq<Object> that) {
                return Eq$class.and$mcC$sp(this, that);
            }

            public Eq<Object> and$mcD$sp(Eq<Object> that) {
                return Eq$class.and$mcD$sp(this, that);
            }

            public Eq<Object> and$mcF$sp(Eq<Object> that) {
                return Eq$class.and$mcF$sp(this, that);
            }

            public Eq<Object> and$mcI$sp(Eq<Object> that) {
                return Eq$class.and$mcI$sp(this, that);
            }

            public Eq<Object> and$mcJ$sp(Eq<Object> that) {
                return Eq$class.and$mcJ$sp(this, that);
            }

            public Eq<Object> and$mcS$sp(Eq<Object> that) {
                return Eq$class.and$mcS$sp(this, that);
            }

            public Eq<BoxedUnit> and$mcV$sp(Eq<BoxedUnit> that) {
                return Eq$class.and$mcV$sp(this, that);
            }

            public Eq<java.math.BigDecimal> or(Eq<java.math.BigDecimal> that) {
                return Eq$class.or(this, that);
            }

            public Eq<Object> or$mcZ$sp(Eq<Object> that) {
                return Eq$class.or$mcZ$sp(this, that);
            }

            public Eq<Object> or$mcB$sp(Eq<Object> that) {
                return Eq$class.or$mcB$sp(this, that);
            }

            public Eq<Object> or$mcC$sp(Eq<Object> that) {
                return Eq$class.or$mcC$sp(this, that);
            }

            public Eq<Object> or$mcD$sp(Eq<Object> that) {
                return Eq$class.or$mcD$sp(this, that);
            }

            public Eq<Object> or$mcF$sp(Eq<Object> that) {
                return Eq$class.or$mcF$sp(this, that);
            }

            public Eq<Object> or$mcI$sp(Eq<Object> that) {
                return Eq$class.or$mcI$sp(this, that);
            }

            public Eq<Object> or$mcJ$sp(Eq<Object> that) {
                return Eq$class.or$mcJ$sp(this, that);
            }

            public Eq<Object> or$mcS$sp(Eq<Object> that) {
                return Eq$class.or$mcS$sp(this, that);
            }

            public Eq<BoxedUnit> or$mcV$sp(Eq<BoxedUnit> that) {
                return Eq$class.or$mcV$sp(this, that);
            }

            public int compare(java.math.BigDecimal x, java.math.BigDecimal y) {
                return x.compareTo(y);
            }
            {
                Eq$class.$init$(this);
                PartialOrder$class.$init$(this);
                Order$class.$init$(this);
            }
        };
        this.spire$math$Algebraic$$MaxIntValue = BigInteger.valueOf(Integer.MAX_VALUE);
        this.spire$math$Algebraic$$MinIntValue = BigInteger.valueOf(Integer.MIN_VALUE);
        this.spire$math$Algebraic$$MaxLongValue = BigInteger.valueOf(Long.MAX_VALUE);
        this.spire$math$Algebraic$$MinLongValue = BigInteger.valueOf(Long.MIN_VALUE);
    }
}

