/*
 * Decompiled with CFR 0.152.
 */
package spire.math;

import algebra.ring.Rig;
import algebra.ring.Ring;
import algebra.ring.Rng;
import algebra.ring.Semiring;
import cats.kernel.Eq;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2$mcID$sp;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.MapBuilder;
import scala.reflect.ClassTag;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import spire.algebra.Field;
import spire.algebra.Sign;
import spire.algebra.Sign$Zero$;
import spire.algebra.Signed;
import spire.math.Polynomial;
import spire.math.Polynomial$;
import spire.math.Polynomial$mcD$sp;
import spire.math.SafeLong;
import spire.math.SafeLong$;
import spire.math.poly.Term;
import spire.math.poly.Term$mcD$sp;

public abstract class Polynomial$mcD$sp$class {
    public static void foreachNonZero(Polynomial$mcD$sp $this, Function2 f, Semiring ring, Eq eq2) {
        $this.foreachNonZero$mcD$sp(f, ring, eq2);
    }

    public static void foreachNonZero$mcD$sp(Polynomial$mcD$sp $this, Function2 f, Semiring ring, Eq eq2) {
        $this.foreach(new Serializable($this, f, ring, eq2){
            private final Function2 f$3;
            private final Semiring ring$6;
            private final Eq eq$4;

            public final Object apply(int e, double c) {
                return this.eq$4.neqv$mcD$sp(c, this.ring$6.zero$mcD$sp()) ? this.f$3.apply(BoxesRunTime.boxToInteger(e), BoxesRunTime.boxToDouble(c)) : BoxedUnit.UNIT;
            }
            {
                this.f$3 = f$3;
                this.ring$6 = ring$6;
                this.eq$4 = eq$4;
            }
        });
    }

    public static List terms(Polynomial$mcD$sp $this, Semiring ring, Eq eq2) {
        return $this.terms$mcD$sp(ring, eq2);
    }

    public static List terms$mcD$sp(Polynomial$mcD$sp $this, Semiring ring, Eq eq2) {
        ListBuffer lb = new ListBuffer();
        $this.foreachNonZero$mcD$sp(new Serializable($this, lb){
            private final ListBuffer lb$2;

            public final ListBuffer<Term<Object>> apply(int e, double c) {
                return this.lb$2.$plus$eq(new Term$mcD$sp(c, e));
            }
            {
                this.lb$2 = lb$2;
            }
        }, ring, eq2);
        return lb.result();
    }

    public static Map data(Polynomial$mcD$sp $this, Semiring ring, Eq eq2) {
        return $this.data$mcD$sp(ring, eq2);
    }

    public static Map data$mcD$sp(Polynomial$mcD$sp $this, Semiring ring, Eq eq2) {
        MapBuilder bldr = new MapBuilder(Predef$.MODULE$.Map().empty());
        $this.foreachNonZero$mcD$sp(new Serializable($this, bldr){
            private final MapBuilder bldr$3;

            public final MapBuilder<Object, Object, Map<Object, Object>> apply(int e, double c) {
                return this.bldr$3.$plus$eq(new Tuple2$mcID$sp(e, c));
            }
            {
                this.bldr$3 = bldr$3;
            }
        }, ring, eq2);
        return (Map)bldr.result();
    }

    public static Term maxTerm(Polynomial$mcD$sp $this, Semiring ring) {
        return $this.maxTerm$mcD$sp(ring);
    }

    public static Term maxTerm$mcD$sp(Polynomial$mcD$sp $this, Semiring ring) {
        return new Term$mcD$sp($this.maxOrderTermCoeff(ring), $this.degree());
    }

    public static Term minTerm(Polynomial$mcD$sp $this, Semiring ring, Eq eq2) {
        return $this.minTerm$mcD$sp(ring, eq2);
    }

    public static Term minTerm$mcD$sp(Polynomial$mcD$sp $this, Semiring ring, Eq eq2) {
        NonLocalReturnControl nonLocalReturnControl;
        block2: {
            Term term;
            Object object = new Object();
            try {
                $this.foreachNonZero$mcD$sp(new Serializable($this, object){
                    private final Object nonLocalReturnKey1$2;

                    public final Nothing$ apply(int n, double c) {
                        throw new NonLocalReturnControl<Term$mcD$sp>(this.nonLocalReturnKey1$2, new Term$mcD$sp(c, n));
                    }
                    {
                        this.nonLocalReturnKey1$2 = nonLocalReturnKey1$2;
                    }
                }, ring, eq2);
                term = new Term$mcD$sp(ring.zero$mcD$sp(), 0);
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                nonLocalReturnControl = nonLocalReturnControl2;
                if (nonLocalReturnControl2.key() != object) break block2;
                term = (Term)nonLocalReturnControl.value();
            }
            return term;
        }
        throw nonLocalReturnControl;
    }

    public static Object evalWith(Polynomial$mcD$sp $this, Object x, Function1 f, Semiring evidence$56, Eq evidence$57, ClassTag evidence$58, Semiring ring, Eq eq2) {
        return $this.evalWith$mcD$sp(x, f, evidence$56, evidence$57, evidence$58, ring, eq2);
    }

    public static Object evalWith$mcD$sp(Polynomial$mcD$sp $this, Object x, Function1 f, Semiring evidence$56, Eq evidence$57, ClassTag evidence$58, Semiring ring, Eq eq2) {
        return $this.map$mcD$sp(f, evidence$56, evidence$57, evidence$58, ring, eq2).apply(x, evidence$56);
    }

    public static Polynomial compose(Polynomial$mcD$sp $this, Polynomial y, Rig ring, Eq eq2) {
        return $this.compose$mcD$sp(y, ring, eq2);
    }

    public static Polynomial compose$mcD$sp(Polynomial$mcD$sp $this, Polynomial y, Rig ring, Eq eq2) {
        ObjectRef<Polynomial<Object>> polynomial = ObjectRef.create(Polynomial$.MODULE$.zero$mDc$sp(eq2, ring, $this.ct()));
        $this.foreachNonZero$mcD$sp(new Serializable($this, polynomial, y, ring, eq2){
            private final ObjectRef polynomial$2;
            private final Polynomial y$2;
            private final Rig ring$7;
            private final Eq eq$5;

            public final void apply(int e, double c) {
                this.apply$mcVID$sp(e, c);
            }

            public void apply$mcVID$sp(int e, double c) {
                Polynomial<Object> z = this.y$2.pow$mcD$sp(e, this.ring$7, this.eq$5).$colon$times$mcD$sp(c, this.ring$7, this.eq$5);
                this.polynomial$2.elem = ((Polynomial)this.polynomial$2.elem).$plus$mcD$sp(z, this.ring$7, this.eq$5);
            }
            {
                this.polynomial$2 = polynomial$2;
                this.y$2 = y$2;
                this.ring$7 = ring$7;
                this.eq$5 = eq$5;
            }
        }, ring, eq2);
        return (Polynomial)polynomial.elem;
    }

    public static Polynomial shift(Polynomial$mcD$sp $this, double h, Ring ring, Eq eq2) {
        return $this.shift$mcD$sp(h, ring, eq2);
    }

    public static Polynomial shift$mcD$sp(Polynomial$mcD$sp $this, double h, Ring ring, Eq eq2) {
        double[] coeffs = (double[])$this.coeffsArray(ring).clone();
        $this.foreachNonZero$mcD$sp(new Serializable($this, coeffs, h, ring){
            private final /* synthetic */ Polynomial$mcD$sp $outer;
            private final double[] coeffs$2;
            private final double h$2;
            private final Ring ring$8;

            public final void apply(int deg, double c) {
                this.apply$mcVID$sp(deg, c);
            }

            public void apply$mcVID$sp(int deg, double c) {
                int i = 1;
                int d = deg - 1;
                SafeLong m = SafeLong$.MODULE$.apply(1L);
                double k = c;
                while (d >= 0) {
                    m = m.$times(d + 1).$div(i);
                    k = this.ring$8.times$mcD$sp(k, this.h$2);
                    this.coeffs$2[d] = this.ring$8.plus$mcD$sp(this.coeffs$2[d], this.ring$8.times$mcD$sp(Polynomial$mcD$sp$class.fromSafeLong$2(this.$outer, m, this.ring$8), k));
                    --d;
                    ++i;
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.coeffs$2 = coeffs$2;
                this.h$2 = h$2;
                this.ring$8 = ring$8;
            }
        }, ring, eq2);
        return Polynomial$.MODULE$.dense$mDc$sp(coeffs, ring, eq2, $this.ct());
    }

    public static Polynomial monic(Polynomial$mcD$sp $this, Field f, Eq eq2) {
        return $this.monic$mcD$sp(f, eq2);
    }

    public static Polynomial monic$mcD$sp(Polynomial$mcD$sp $this, Field f, Eq eq2) {
        return $this.$colon$div$mcD$sp($this.maxOrderTermCoeff(f), f, eq2);
    }

    public static int signVariations(Polynomial$mcD$sp $this, Semiring ring, Eq eq2, Signed signed) {
        return $this.signVariations$mcD$sp(ring, eq2, signed);
    }

    public static int signVariations$mcD$sp(Polynomial$mcD$sp $this, Semiring ring, Eq eq2, Signed signed) {
        ObjectRef<Sign$Zero$> prevSign = ObjectRef.create(Sign$Zero$.MODULE$);
        IntRef variations = IntRef.create(0);
        $this.foreachNonZero$mcD$sp(new Serializable($this, prevSign, variations, signed){
            private final ObjectRef prevSign$2;
            private final IntRef variations$2;
            private final Signed signed$2;

            public final void apply(int x$8, double c) {
                this.apply$mcVID$sp(x$8, c);
            }

            public void apply$mcVID$sp(int x$8, double c) {
                Sign sign = this.signed$2.sign$mcD$sp(c);
                if (!Sign$Zero$.MODULE$.equals((Sign)this.prevSign$2.elem)) {
                    Sign sign2 = sign;
                    Sign sign3 = (Sign)this.prevSign$2.elem;
                    if (sign2 == null ? sign3 != null : !sign2.equals(sign3)) {
                        ++this.variations$2.elem;
                    }
                }
                this.prevSign$2.elem = sign;
            }
            {
                this.prevSign$2 = prevSign$2;
                this.variations$2 = variations$2;
                this.signed$2 = signed$2;
            }
        }, ring, signed);
        return variations.elem;
    }

    public static Polynomial removeZeroRoots(Polynomial$mcD$sp $this, Semiring ring, Eq eq2) {
        return $this.removeZeroRoots$mcD$sp(ring, eq2);
    }

    public static Polynomial removeZeroRoots$mcD$sp(Polynomial$mcD$sp $this, Semiring ring, Eq eq2) {
        Term<Object> term = $this.minTerm$mcD$sp(ring, eq2);
        if (term != null) {
            int n = term.exp();
            return $this.mapTerms$mcD$sp(new Serializable($this, n){
                private final int k$2;

                public final Term<Object> apply(Term<Object> x0$1) {
                    if (x0$1 != null) {
                        return new Term$mcD$sp(x0$1.coeff$mcD$sp(), x0$1.exp() - this.k$2);
                    }
                    throw new MatchError(x0$1);
                }
                {
                    this.k$2 = k$2;
                }
            }, ring, eq2, $this.ct(), ring, eq2);
        }
        throw new MatchError(term);
    }

    public static Polynomial map(Polynomial$mcD$sp $this, Function1 f, Semiring evidence$59, Eq evidence$60, ClassTag evidence$61, Semiring ring, Eq eq2) {
        return $this.map$mcD$sp(f, evidence$59, evidence$60, evidence$61, ring, eq2);
    }

    public static Polynomial map$mcD$sp(Polynomial$mcD$sp $this, Function1 f, Semiring evidence$59, Eq evidence$60, ClassTag evidence$61, Semiring ring, Eq eq2) {
        return $this.mapTerms$mcD$sp(new Serializable($this, f){
            private final Function1 f$4;

            public final Term<D> apply(Term<Object> x0$2) {
                if (x0$2 != null) {
                    return new Term<R>(this.f$4.apply(BoxesRunTime.boxToDouble(x0$2.coeff$mcD$sp())), x0$2.exp());
                }
                throw new MatchError(x0$2);
            }
            {
                this.f$4 = f$4;
            }
        }, evidence$59, evidence$60, evidence$61, ring, eq2);
    }

    public static Polynomial mapTerms(Polynomial$mcD$sp $this, Function1 f, Semiring evidence$62, Eq evidence$63, ClassTag evidence$64, Semiring ring, Eq eq2) {
        return $this.mapTerms$mcD$sp(f, evidence$62, evidence$63, evidence$64, ring, eq2);
    }

    public static Polynomial mapTerms$mcD$sp(Polynomial$mcD$sp $this, Function1 f, Semiring evidence$62, Eq evidence$63, ClassTag evidence$64, Semiring ring, Eq eq2) {
        return Polynomial$.MODULE$.apply($this.termsIterator().map(f), evidence$62, evidence$63, evidence$64);
    }

    public static Polynomial flip(Polynomial$mcD$sp $this, Rng ring, Eq eq2) {
        return $this.flip$mcD$sp(ring, eq2);
    }

    public static Polynomial flip$mcD$sp(Polynomial$mcD$sp $this, Rng ring, Eq eq2) {
        return $this.mapTerms$mcD$sp(new Serializable($this, ring){
            private final Rng ring$9;

            public final Term<Object> apply(Term<Object> x0$3) {
                if (x0$3 != null) {
                    return x0$3.exp() % 2 == 0 ? x0$3 : new Term$mcD$sp(this.ring$9.negate$mcD$sp(((Term)x0$3).coeff$mcD$sp()), x0$3.exp());
                }
                throw new MatchError(x0$3);
            }
            {
                this.ring$9 = ring$9;
            }
        }, ring, eq2, $this.ct(), ring, eq2);
    }

    public static Polynomial reciprocal(Polynomial$mcD$sp $this, Semiring ring, Eq eq2) {
        return $this.reciprocal$mcD$sp(ring, eq2);
    }

    public static Polynomial reciprocal$mcD$sp(Polynomial$mcD$sp $this, Semiring ring, Eq eq2) {
        int d = $this.degree();
        return $this.mapTerms$mcD$sp(new Serializable($this, d){
            private final int d$4;

            public final Term<Object> apply(Term<Object> x0$4) {
                if (x0$4 != null) {
                    return new Term$mcD$sp(x0$4.coeff$mcD$sp(), this.d$4 - x0$4.exp());
                }
                throw new MatchError(x0$4);
            }
            {
                this.d$4 = d$4;
            }
        }, ring, eq2, $this.ct(), ring, eq2);
    }

    public static Polynomial $minus(Polynomial$mcD$sp $this, Polynomial rhs, Rng ring, Eq eq2) {
        return $this.$minus$mcD$sp(rhs, ring, eq2);
    }

    public static Polynomial $minus$mcD$sp(Polynomial$mcD$sp $this, Polynomial rhs, Rng ring, Eq eq2) {
        return $this.$plus(rhs.unary_$minus$mcD$sp(ring), ring, eq2);
    }

    public static Polynomial $times$times(Polynomial$mcD$sp $this, int k, Rig ring, Eq eq2) {
        return $this.$times$times$mcD$sp(k, ring, eq2);
    }

    public static Polynomial $times$times$mcD$sp(Polynomial$mcD$sp $this, int k, Rig ring, Eq eq2) {
        return $this.pow$mcD$sp(k, ring, eq2);
    }

    public static Polynomial pow(Polynomial$mcD$sp $this, int k, Rig ring, Eq eq2) {
        return $this.pow$mcD$sp(k, ring, eq2);
    }

    public static Polynomial pow$mcD$sp(Polynomial$mcD$sp $this, int k, Rig ring, Eq eq2) {
        if (k < 0) {
            throw new IllegalArgumentException("negative exponent");
        }
        return k == 0 ? Polynomial$.MODULE$.one$mDc$sp(eq2, ring, $this.ct()) : (k == 1 ? $this : Polynomial$mcD$sp$class.loop$7($this, $this, k - 1, $this, ring, eq2));
    }

    public static Polynomial $colon$times(Polynomial$mcD$sp $this, double k, Semiring ring, Eq eq2) {
        return $this.$colon$times$mcD$sp(k, ring, eq2);
    }

    public static Polynomial $colon$times$mcD$sp(Polynomial$mcD$sp $this, double k, Semiring ring, Eq eq2) {
        return $this.$times$colon(k, ring, eq2);
    }

    public static Polynomial $colon$div(Polynomial$mcD$sp $this, double k, Field field2, Eq eq2) {
        return $this.$colon$div$mcD$sp(k, field2, eq2);
    }

    public static Polynomial $colon$div$mcD$sp(Polynomial$mcD$sp $this, double k, Field field2, Eq eq2) {
        return $this.$colon$times$mcD$sp(field2.reciprocal$mcD$sp(k), field2, eq2);
    }

    private static final double loop$6(Polynomial$mcD$sp $this, double k, SafeLong y, double acc, double d$3, long mask$2, Ring ring$8) {
        while (!y.isValidInt()) {
            SafeLong z = y.$greater$greater(30);
            double r = ring$8.fromInt$mcD$sp(y.$amp(mask$2).toInt());
            acc = ring$8.plus$mcD$sp(ring$8.times$mcD$sp(k, r), acc);
            y = z;
            k = ring$8.times$mcD$sp(d$3, k);
        }
        return ring$8.plus$mcD$sp(ring$8.times$mcD$sp(k, ring$8.fromInt$mcD$sp(y.toInt())), acc);
    }

    public static final double fromSafeLong$2(Polynomial$mcD$sp $this, SafeLong x, Ring ring$8) {
        double d;
        if (x.isValidInt()) {
            d = ring$8.fromInt$mcD$sp(x.toInt());
        } else {
            double d2 = ring$8.fromInt$mcD$sp(0x40000000);
            d = Polynomial$mcD$sp$class.loop$6($this, ring$8.one$mcD$sp(), x, ring$8.zero$mcD$sp(), d2, 0x3FFFFFFFL, ring$8);
        }
        return d;
    }

    private static final Polynomial loop$7(Polynomial$mcD$sp $this, Polynomial b, int k, Polynomial extra, Rig ring$10, Eq eq$6) {
        while (k != 1) {
            extra = (k & 1) == 1 ? b.$times$mcD$sp(extra, ring$10, eq$6) : extra;
            k >>>= 1;
            b = b.$times$mcD$sp(b, ring$10, eq$6);
        }
        return b.$times$mcD$sp(extra, ring$10, eq$6);
    }

    public static void $init$(Polynomial$mcD$sp $this) {
    }
}

