/*
 * Decompiled with CFR 0.152.
 */
package spire.math;

import algebra.ring.AdditiveMonoid;
import algebra.ring.Rng;
import algebra.ring.Semiring;
import cats.kernel.Eq;
import scala.Tuple2;
import scala.Tuple2$mcDD$sp;
import spire.algebra.Field;
import spire.algebra.IsReal;
import spire.algebra.NRoot;
import spire.algebra.Signed;
import spire.algebra.Trig;
import spire.math.Complex;
import spire.math.Complex$;
import spire.math.Quaternion;
import spire.math.Quaternion$mcD$sp;
import spire.math.package$;

public final class Complex$mcD$sp
extends Complex<Object> {
    public static final long serialVersionUID = 0L;
    public final double real$mcD$sp;
    public final double imag$mcD$sp;

    @Override
    public double real$mcD$sp() {
        return this.real$mcD$sp;
    }

    @Override
    public double real() {
        return this.real$mcD$sp();
    }

    @Override
    public double imag$mcD$sp() {
        return this.imag$mcD$sp;
    }

    @Override
    public double imag() {
        return this.imag$mcD$sp();
    }

    @Override
    public Complex<Object> complexSignum(Field<Object> f, NRoot<Object> n, Signed<Object> s) {
        return this.complexSignum$mcD$sp(f, n, s);
    }

    @Override
    public Complex<Object> complexSignum$mcD$sp(Field<Object> f, NRoot<Object> n, Signed<Object> s) {
        return this.isZero$mcD$sp(s) ? this : this.$div$mcD$sp(this.abs$mcD$sp(f, n, s), f);
    }

    @Override
    public double abs(Field<Object> f, NRoot<Object> n, Signed<Object> s) {
        return this.abs$mcD$sp(f, n, s);
    }

    @Override
    public double abs$mcD$sp(Field<Object> f, NRoot<Object> n, Signed<Object> s) {
        return n.sqrt$mcD$sp(f.plus$mcD$sp(f.times$mcD$sp(this.real(), this.real()), f.times$mcD$sp(this.imag(), this.imag())));
    }

    @Override
    public double arg(Field<Object> f, Signed<Object> s, Trig<Object> t) {
        return this.arg$mcD$sp(f, s, t);
    }

    @Override
    public double arg$mcD$sp(Field<Object> f, Signed<Object> s, Trig<Object> t) {
        return this.isZero$mcD$sp(s) ? f.zero$mcD$sp() : t.atan2$mcD$sp(this.imag(), this.real());
    }

    @Override
    public double norm(Field<Object> f, NRoot<Object> n, Signed<Object> s) {
        return this.norm$mcD$sp(f, n, s);
    }

    @Override
    public double norm$mcD$sp(Field<Object> f, NRoot<Object> n, Signed<Object> s) {
        return package$.MODULE$.hypot$mDc$sp(this.real(), this.imag(), f, n, s);
    }

    @Override
    public Complex<Object> conjugate(Rng<Object> f) {
        return this.conjugate$mcD$sp(f);
    }

    @Override
    public Complex<Object> conjugate$mcD$sp(Rng<Object> f) {
        return new Complex$mcD$sp(this.real(), f.negate$mcD$sp(this.imag()));
    }

    @Override
    public Tuple2<Object, Object> asTuple() {
        return this.asTuple$mcD$sp();
    }

    @Override
    public Tuple2<Object, Object> asTuple$mcD$sp() {
        return new Tuple2$mcDD$sp(this.real(), this.imag());
    }

    @Override
    public Tuple2<Object, Object> asPolarTuple(Field<Object> f, NRoot<Object> n, Signed<Object> s, Trig<Object> t) {
        return this.asPolarTuple$mcD$sp(f, n, s, t);
    }

    @Override
    public Tuple2<Object, Object> asPolarTuple$mcD$sp(Field<Object> f, NRoot<Object> n, Signed<Object> s, Trig<Object> t) {
        return new Tuple2$mcDD$sp(this.abs$mcD$sp(f, n, s), this.arg$mcD$sp(f, s, t));
    }

    @Override
    public boolean isZero(Signed<Object> s) {
        return this.isZero$mcD$sp(s);
    }

    @Override
    public boolean isZero$mcD$sp(Signed<Object> s) {
        return s.isSignZero$mcD$sp(this.real()) && s.isSignZero$mcD$sp(this.imag());
    }

    @Override
    public boolean isImaginary(Signed<Object> s) {
        return this.isImaginary$mcD$sp(s);
    }

    @Override
    public boolean isImaginary$mcD$sp(Signed<Object> s) {
        return s.isSignZero$mcD$sp(this.real());
    }

    @Override
    public boolean isReal(Signed<Object> s) {
        return this.isReal$mcD$sp(s);
    }

    @Override
    public boolean isReal$mcD$sp(Signed<Object> s) {
        return s.isSignZero$mcD$sp(this.imag());
    }

    @Override
    public boolean eqv(Complex<Object> b, Eq<Object> o) {
        return this.eqv$mcD$sp(b, o);
    }

    @Override
    public boolean eqv$mcD$sp(Complex<Object> b, Eq<Object> o) {
        return o.eqv$mcD$sp(this.real(), b.real$mcD$sp()) && o.eqv$mcD$sp(this.imag(), b.imag$mcD$sp());
    }

    @Override
    public boolean neqv(Complex<Object> b, Eq<Object> o) {
        return this.neqv$mcD$sp(b, o);
    }

    @Override
    public boolean neqv$mcD$sp(Complex<Object> b, Eq<Object> o) {
        return o.neqv$mcD$sp(this.real(), b.real$mcD$sp()) || o.neqv$mcD$sp(this.imag(), b.imag$mcD$sp());
    }

    @Override
    public Complex<Object> unary_$minus(Rng<Object> r) {
        return this.unary_$minus$mcD$sp(r);
    }

    @Override
    public Complex<Object> unary_$minus$mcD$sp(Rng<Object> r) {
        return new Complex$mcD$sp(r.negate$mcD$sp(this.real()), r.negate$mcD$sp(this.imag()));
    }

    @Override
    public Complex<Object> $plus(double rhs, Semiring<Object> r) {
        return this.$plus$mcD$sp(rhs, r);
    }

    @Override
    public Complex<Object> $plus$mcD$sp(double rhs, Semiring<Object> r) {
        return new Complex$mcD$sp(r.plus$mcD$sp(this.real(), rhs), this.imag());
    }

    @Override
    public Complex<Object> $minus(double rhs, Rng<Object> r) {
        return this.$minus$mcD$sp(rhs, r);
    }

    @Override
    public Complex<Object> $minus$mcD$sp(double rhs, Rng<Object> r) {
        return new Complex$mcD$sp(r.minus$mcD$sp(this.real(), rhs), this.imag());
    }

    @Override
    public Complex<Object> $times(double rhs, Semiring<Object> r) {
        return this.$times$mcD$sp(rhs, r);
    }

    @Override
    public Complex<Object> $times$mcD$sp(double rhs, Semiring<Object> r) {
        return new Complex$mcD$sp(r.times$mcD$sp(this.real(), rhs), r.times$mcD$sp(this.imag(), rhs));
    }

    @Override
    public Complex<Object> $div(double rhs, Field<Object> r) {
        return this.$div$mcD$sp(rhs, r);
    }

    @Override
    public Complex<Object> $div$mcD$sp(double rhs, Field<Object> r) {
        return new Complex$mcD$sp(r.div$mcD$sp(this.real(), rhs), r.div$mcD$sp(this.imag(), rhs));
    }

    @Override
    public Complex<Object> $times$times(double e, Field<Object> f, NRoot<Object> n, Signed<Object> s, Trig<Object> t) {
        return this.$times$times$mcD$sp(e, f, n, s, t);
    }

    @Override
    public Complex<Object> $times$times$mcD$sp(double e, Field<Object> f, NRoot<Object> n, Signed<Object> s, Trig<Object> t) {
        return this.pow$mcD$sp(e, f, n, s, t);
    }

    @Override
    public Complex<Object> pow(double e, Field<Object> f, NRoot<Object> n, Signed<Object> s, Trig<Object> t) {
        return this.pow$mcD$sp(e, f, n, s, t);
    }

    @Override
    public Complex<Object> pow$mcD$sp(double e, Field<Object> f, NRoot<Object> n, Signed<Object> s, Trig<Object> t) {
        Complex<Object> complex;
        if (s.isSignZero$mcD$sp(e)) {
            complex = Complex$.MODULE$.one$mDc$sp(f);
        } else if (this.isZero$mcD$sp(s)) {
            if (s.lt$mcD$sp(e, f.zero$mcD$sp())) {
                throw new Exception("raising 0 to negative/complex power");
            }
            complex = Complex$.MODULE$.zero$mDc$sp(f);
        } else {
            complex = Complex$.MODULE$.polar$mDc$sp(n.fpow$mcD$sp(this.abs$mcD$sp(f, n, s), e), f.times$mcD$sp(this.arg$mcD$sp(f, s, t), e), f, t);
        }
        return complex;
    }

    @Override
    public Complex<Object> $plus(Complex<Object> b, Semiring<Object> r) {
        return this.$plus$mcD$sp(b, r);
    }

    @Override
    public Complex<Object> $plus$mcD$sp(Complex<Object> b, Semiring<Object> r) {
        return new Complex$mcD$sp(r.plus$mcD$sp(this.real(), b.real$mcD$sp()), r.plus$mcD$sp(this.imag(), b.imag$mcD$sp()));
    }

    @Override
    public Complex<Object> $minus(Complex<Object> b, Rng<Object> r) {
        return this.$minus$mcD$sp(b, r);
    }

    @Override
    public Complex<Object> $minus$mcD$sp(Complex<Object> b, Rng<Object> r) {
        return new Complex$mcD$sp(r.minus$mcD$sp(this.real(), b.real$mcD$sp()), r.minus$mcD$sp(this.imag(), b.imag$mcD$sp()));
    }

    @Override
    public Complex<Object> $times(Complex<Object> b, Rng<Object> r) {
        return this.$times$mcD$sp(b, r);
    }

    @Override
    public Complex<Object> $times$mcD$sp(Complex<Object> b, Rng<Object> r) {
        return new Complex$mcD$sp(r.minus$mcD$sp(r.times$mcD$sp(this.real(), b.real$mcD$sp()), r.times$mcD$sp(this.imag(), b.imag$mcD$sp())), r.plus$mcD$sp(r.times$mcD$sp(this.imag(), b.real$mcD$sp()), r.times$mcD$sp(this.real(), b.imag$mcD$sp())));
    }

    @Override
    public Complex<Object> $div(Complex<Object> b, Field<Object> f, Signed<Object> s) {
        return this.$div$mcD$sp(b, f, s);
    }

    @Override
    public Complex<Object> $div$mcD$sp(Complex<Object> b, Field<Object> f, Signed<Object> s) {
        Complex$mcD$sp complex$mcD$sp;
        double abs_bimag;
        double abs_breal = s.abs$mcD$sp(b.real$mcD$sp());
        if (s.gteqv$mcD$sp(abs_breal, abs_bimag = s.abs$mcD$sp(b.imag$mcD$sp()))) {
            if (s.eqv$mcD$sp(abs_breal, f.zero$mcD$sp())) {
                throw new Exception("/ by zero");
            }
            double ratio = f.div$mcD$sp(b.imag$mcD$sp(), b.real$mcD$sp());
            double denom = f.plus$mcD$sp(b.real$mcD$sp(), f.times$mcD$sp(b.imag$mcD$sp(), ratio));
            complex$mcD$sp = new Complex$mcD$sp(f.div$mcD$sp(f.plus$mcD$sp(this.real(), f.times$mcD$sp(this.imag(), ratio)), denom), f.div$mcD$sp(f.minus$mcD$sp(this.imag(), f.times$mcD$sp(this.real(), ratio)), denom));
        } else {
            if (s.eqv$mcD$sp(abs_bimag, f.zero$mcD$sp())) {
                throw new Exception("/ by zero");
            }
            double ratio = f.div$mcD$sp(b.real$mcD$sp(), b.imag$mcD$sp());
            double denom = f.plus$mcD$sp(f.times$mcD$sp(b.real$mcD$sp(), ratio), b.imag$mcD$sp());
            complex$mcD$sp = new Complex$mcD$sp(f.div$mcD$sp(f.plus$mcD$sp(f.times$mcD$sp(this.real(), ratio), this.imag()), denom), f.div$mcD$sp(f.minus$mcD$sp(f.times$mcD$sp(this.imag(), ratio), this.real()), denom));
        }
        return complex$mcD$sp;
    }

    @Override
    public Complex<Object> $times$times(int b, Field<Object> f, NRoot<Object> n, Signed<Object> s, Trig<Object> t) {
        return this.$times$times$mcD$sp(b, f, n, s, t);
    }

    @Override
    public Complex<Object> $times$times$mcD$sp(int b, Field<Object> f, NRoot<Object> n, Signed<Object> s, Trig<Object> t) {
        return this.pow$mcD$sp(b, f, n, s, t);
    }

    @Override
    public Complex<Object> nroot(int k, Field<Object> f, NRoot<Object> n, Signed<Object> s, Trig<Object> t) {
        return this.nroot$mcD$sp(k, f, n, s, t);
    }

    @Override
    public Complex<Object> nroot$mcD$sp(int k, Field<Object> f, NRoot<Object> n, Signed<Object> s, Trig<Object> t) {
        return this.isZero$mcD$sp(s) ? Complex$.MODULE$.zero$mDc$sp(f) : this.pow$mcD$sp(new Complex$mcD$sp(f.reciprocal$mcD$sp(f.fromInt$mcD$sp(k)), f.zero$mcD$sp()), f, n, s, t);
    }

    @Override
    public Complex<Object> pow(int b, Field<Object> f, NRoot<Object> n, Signed<Object> s, Trig<Object> t) {
        return this.pow$mcD$sp(b, f, n, s, t);
    }

    @Override
    public Complex<Object> pow$mcD$sp(int b, Field<Object> f, NRoot<Object> n, Signed<Object> s, Trig<Object> t) {
        return this.isZero$mcD$sp(s) ? Complex$.MODULE$.zero$mDc$sp(f) : Complex$.MODULE$.polar$mDc$sp(f.pow$mcD$sp(this.abs$mcD$sp(f, n, s), b), f.times$mcD$sp(this.arg$mcD$sp(f, s, t), f.fromInt$mcD$sp(b)), f, t);
    }

    @Override
    public Complex<Object> $times$times(Complex<Object> b, Field<Object> f, NRoot<Object> n, Signed<Object> s, Trig<Object> t) {
        return this.$times$times$mcD$sp(b, f, n, s, t);
    }

    @Override
    public Complex<Object> $times$times$mcD$sp(Complex<Object> b, Field<Object> f, NRoot<Object> n, Signed<Object> s, Trig<Object> t) {
        return this.pow$mcD$sp(b, f, n, s, t);
    }

    @Override
    public Complex<Object> pow(Complex<Object> b, Field<Object> f, NRoot<Object> n, Signed<Object> s, Trig<Object> t) {
        return this.pow$mcD$sp(b, f, n, s, t);
    }

    @Override
    public Complex<Object> pow$mcD$sp(Complex<Object> b, Field<Object> f, NRoot<Object> n, Signed<Object> s, Trig<Object> t) {
        Complex<Object> complex;
        if (b.isZero$mcD$sp(s)) {
            complex = Complex$.MODULE$.one$mDc$sp(f);
        } else if (this.isZero$mcD$sp(s)) {
            if (s.neqv$mcD$sp(b.imag$mcD$sp(), f.zero$mcD$sp()) || s.lt$mcD$sp(b.real$mcD$sp(), f.zero$mcD$sp())) {
                throw new Exception("raising 0 to negative/complex power");
            }
            complex = Complex$.MODULE$.zero$mDc$sp(f);
        } else if (s.neqv$mcD$sp(b.imag$mcD$sp(), f.zero$mcD$sp())) {
            double len = f.div$mcD$sp(n.fpow$mcD$sp(this.abs$mcD$sp(f, n, s), b.real$mcD$sp()), t.exp$mcD$sp(f.times$mcD$sp(this.arg$mcD$sp(f, s, t), b.imag$mcD$sp())));
            double phase = f.plus$mcD$sp(f.times$mcD$sp(this.arg$mcD$sp(f, s, t), b.real$mcD$sp()), f.times$mcD$sp(t.log$mcD$sp(this.abs$mcD$sp(f, n, s)), b.imag$mcD$sp()));
            complex = Complex$.MODULE$.polar$mDc$sp(len, phase, f, t);
        } else {
            complex = Complex$.MODULE$.polar$mDc$sp(n.fpow$mcD$sp(this.abs$mcD$sp(f, n, s), b.real$mcD$sp()), f.times$mcD$sp(this.arg$mcD$sp(f, s, t), b.real$mcD$sp()), f, t);
        }
        return complex;
    }

    @Override
    public Complex<Object> log(Field<Object> f, NRoot<Object> n, Trig<Object> t, Signed<Object> s) {
        return this.log$mcD$sp(f, n, t, s);
    }

    @Override
    public Complex<Object> log$mcD$sp(Field<Object> f, NRoot<Object> n, Trig<Object> t, Signed<Object> s) {
        if (this.isZero$mcD$sp(s)) {
            throw new IllegalArgumentException("log(0) undefined");
        }
        return new Complex$mcD$sp(t.log$mcD$sp(this.abs$mcD$sp(f, n, s)), this.arg$mcD$sp(f, s, t));
    }

    @Override
    public Complex<Object> sqrt(Field<Object> f, NRoot<Object> n0, Signed<Object> s) {
        return this.sqrt$mcD$sp(f, n0, s);
    }

    @Override
    public Complex<Object> sqrt$mcD$sp(Field<Object> f, NRoot<Object> n0, Signed<Object> s) {
        Complex$mcD$sp complex$mcD$sp;
        if (this.isZero$mcD$sp(s)) {
            complex$mcD$sp = Complex$.MODULE$.zero$mDc$sp(f);
        } else {
            double two = f.fromInt$mcD$sp(2);
            double a = n0.sqrt$mcD$sp(f.div$mcD$sp(f.plus$mcD$sp(this.abs$mcD$sp(f, n0, s), s.abs$mcD$sp(this.real())), two));
            int n = s.signum$mcD$sp(this.imag());
            switch (n) {
                case 0: {
                    if (s.lt$mcD$sp(this.real(), f.zero$mcD$sp())) {
                        complex$mcD$sp = new Complex$mcD$sp(f.zero$mcD$sp(), a);
                        break;
                    }
                    complex$mcD$sp = new Complex$mcD$sp(a, f.zero$mcD$sp());
                    break;
                }
                default: {
                    double b = n0.sqrt$mcD$sp(f.div$mcD$sp(f.minus$mcD$sp(this.abs$mcD$sp(f, n0, s), s.abs$mcD$sp(this.real())), two));
                    if (n < 0) {
                        complex$mcD$sp = new Complex$mcD$sp(a, f.negate$mcD$sp(b));
                        break;
                    }
                    complex$mcD$sp = new Complex$mcD$sp(a, b);
                    break;
                }
            }
        }
        return complex$mcD$sp;
    }

    @Override
    public Complex<Object> floor(IsReal<Object> o) {
        return this.floor$mcD$sp(o);
    }

    @Override
    public Complex<Object> floor$mcD$sp(IsReal<Object> o) {
        return new Complex$mcD$sp(o.floor$mcD$sp(this.real()), o.floor$mcD$sp(this.imag()));
    }

    @Override
    public Complex<Object> ceil(IsReal<Object> o) {
        return this.ceil$mcD$sp(o);
    }

    @Override
    public Complex<Object> ceil$mcD$sp(IsReal<Object> o) {
        return new Complex$mcD$sp(o.ceil$mcD$sp(this.real()), o.ceil$mcD$sp(this.imag()));
    }

    @Override
    public Complex<Object> round(IsReal<Object> o) {
        return this.round$mcD$sp(o);
    }

    @Override
    public Complex<Object> round$mcD$sp(IsReal<Object> o) {
        return new Complex$mcD$sp(o.round$mcD$sp(this.real()), o.round$mcD$sp(this.imag()));
    }

    @Override
    public Complex<Object> acos(Field<Object> f, NRoot<Object> n, Trig<Object> t, Signed<Object> s0) {
        return this.acos$mcD$sp(f, n, t, s0);
    }

    @Override
    public Complex<Object> acos$mcD$sp(Field<Object> f, NRoot<Object> n, Trig<Object> t, Signed<Object> s0) {
        Complex<Object> z2 = this.$times$mcD$sp(this, f);
        Complex<Object> s = new Complex$mcD$sp(f.minus$mcD$sp(f.one$mcD$sp(), z2.real$mcD$sp()), f.negate$mcD$sp(z2.imag$mcD$sp())).sqrt$mcD$sp(f, n, s0);
        Complex<Object> l = new Complex$mcD$sp(f.plus$mcD$sp(this.real(), s.imag$mcD$sp()), f.plus$mcD$sp(this.imag(), s.real$mcD$sp())).log$mcD$sp(f, n, t, s0);
        return new Complex$mcD$sp(l.imag$mcD$sp(), f.negate$mcD$sp(l.real$mcD$sp()));
    }

    @Override
    public Complex<Object> asin(Field<Object> f, NRoot<Object> n, Trig<Object> t, Signed<Object> s0) {
        return this.asin$mcD$sp(f, n, t, s0);
    }

    @Override
    public Complex<Object> asin$mcD$sp(Field<Object> f, NRoot<Object> n, Trig<Object> t, Signed<Object> s0) {
        Complex<Object> z2 = this.$times$mcD$sp(this, f);
        Complex<Object> s = new Complex$mcD$sp(f.minus$mcD$sp(f.one$mcD$sp(), z2.real$mcD$sp()), f.negate$mcD$sp(z2.imag$mcD$sp())).sqrt$mcD$sp(f, n, s0);
        Complex<Object> l = new Complex$mcD$sp(f.plus$mcD$sp(s.real$mcD$sp(), f.negate$mcD$sp(this.imag())), f.plus$mcD$sp(s.imag$mcD$sp(), this.real())).log$mcD$sp(f, n, t, s0);
        return new Complex$mcD$sp(l.imag$mcD$sp(), f.negate$mcD$sp(l.real$mcD$sp()));
    }

    @Override
    public Complex<Object> atan(Field<Object> f, NRoot<Object> r, Trig<Object> t, Signed<Object> s0) {
        return this.atan$mcD$sp(f, r, t, s0);
    }

    @Override
    public Complex<Object> atan$mcD$sp(Field<Object> f, NRoot<Object> r, Trig<Object> t, Signed<Object> s0) {
        Complex$mcD$sp n = new Complex$mcD$sp(this.real(), f.plus$mcD$sp(this.imag(), f.one$mcD$sp()));
        Complex$mcD$sp d = new Complex$mcD$sp(f.negate$mcD$sp(this.real()), f.minus$mcD$sp(f.one$mcD$sp(), this.imag()));
        Complex<Object> l = ((Complex)n).$div$mcD$sp(d, f, s0).log$mcD$sp(f, r, t, s0);
        return new Complex$mcD$sp(f.div$mcD$sp(l.imag$mcD$sp(), f.fromInt$mcD$sp(-2)), f.div$mcD$sp(l.real$mcD$sp(), f.fromInt$mcD$sp(2)));
    }

    @Override
    public Complex<Object> exp(Field<Object> f, Trig<Object> t) {
        return this.exp$mcD$sp(f, t);
    }

    @Override
    public Complex<Object> exp$mcD$sp(Field<Object> f, Trig<Object> t) {
        return new Complex$mcD$sp(f.times$mcD$sp(t.exp$mcD$sp(this.real()), t.cos$mcD$sp(this.imag())), f.times$mcD$sp(t.exp$mcD$sp(this.real()), t.sin$mcD$sp(this.imag())));
    }

    @Override
    public Complex<Object> sin(Field<Object> f, Trig<Object> t) {
        return this.sin$mcD$sp(f, t);
    }

    @Override
    public Complex<Object> sin$mcD$sp(Field<Object> f, Trig<Object> t) {
        return new Complex$mcD$sp(f.times$mcD$sp(t.sin$mcD$sp(this.real()), t.cosh$mcD$sp(this.imag())), f.times$mcD$sp(t.cos$mcD$sp(this.real()), t.sinh$mcD$sp(this.imag())));
    }

    @Override
    public Complex<Object> sinh(Field<Object> f, Trig<Object> t) {
        return this.sinh$mcD$sp(f, t);
    }

    @Override
    public Complex<Object> sinh$mcD$sp(Field<Object> f, Trig<Object> t) {
        return new Complex$mcD$sp(f.times$mcD$sp(t.sinh$mcD$sp(this.real()), t.cos$mcD$sp(this.imag())), f.times$mcD$sp(t.cosh$mcD$sp(this.real()), t.sin$mcD$sp(this.imag())));
    }

    @Override
    public Complex<Object> cos(Field<Object> f, Trig<Object> t) {
        return this.cos$mcD$sp(f, t);
    }

    @Override
    public Complex<Object> cos$mcD$sp(Field<Object> f, Trig<Object> t) {
        return new Complex$mcD$sp(f.times$mcD$sp(t.cos$mcD$sp(this.real()), t.cosh$mcD$sp(this.imag())), f.times$mcD$sp(f.negate$mcD$sp(t.sin$mcD$sp(this.real())), t.sinh$mcD$sp(this.imag())));
    }

    @Override
    public Complex<Object> cosh(Field<Object> f, Trig<Object> t) {
        return this.cosh$mcD$sp(f, t);
    }

    @Override
    public Complex<Object> cosh$mcD$sp(Field<Object> f, Trig<Object> t) {
        return new Complex$mcD$sp(f.times$mcD$sp(t.cosh$mcD$sp(this.real()), t.cos$mcD$sp(this.imag())), f.times$mcD$sp(t.sinh$mcD$sp(this.real()), t.sin$mcD$sp(this.imag())));
    }

    @Override
    public Complex<Object> tan(Field<Object> f, Trig<Object> t) {
        return this.tan$mcD$sp(f, t);
    }

    @Override
    public Complex<Object> tan$mcD$sp(Field<Object> f, Trig<Object> t) {
        double r2 = f.plus$mcD$sp(this.real(), this.real());
        double i2 = f.plus$mcD$sp(this.imag(), this.imag());
        double d = f.plus$mcD$sp(t.cos$mcD$sp(r2), t.cosh$mcD$sp(i2));
        return new Complex$mcD$sp(f.div$mcD$sp(t.sin$mcD$sp(r2), d), f.div$mcD$sp(t.sinh$mcD$sp(i2), d));
    }

    @Override
    public Complex<Object> tanh(Field<Object> f, Trig<Object> t) {
        return this.tanh$mcD$sp(f, t);
    }

    @Override
    public Complex<Object> tanh$mcD$sp(Field<Object> f, Trig<Object> t) {
        double r2 = f.plus$mcD$sp(this.real(), this.real());
        double i2 = f.plus$mcD$sp(this.imag(), this.imag());
        double d = f.plus$mcD$sp(t.cos$mcD$sp(r2), t.cosh$mcD$sp(i2));
        return new Complex$mcD$sp(f.div$mcD$sp(t.sinh$mcD$sp(r2), d), f.div$mcD$sp(t.sin$mcD$sp(i2), d));
    }

    @Override
    public Quaternion<Object> toQuaternion(AdditiveMonoid<Object> ev) {
        return this.toQuaternion$mcD$sp(ev);
    }

    @Override
    public Quaternion<Object> toQuaternion$mcD$sp(AdditiveMonoid<Object> ev) {
        return new Quaternion$mcD$sp(this.real(), this.imag(), ev.zero$mcD$sp(), ev.zero$mcD$sp());
    }

    @Override
    public <T> double copy$default$1() {
        return this.copy$default$1$mcD$sp();
    }

    @Override
    public <T> double copy$default$1$mcD$sp() {
        return this.real();
    }

    @Override
    public <T> double copy$default$2() {
        return this.copy$default$2$mcD$sp();
    }

    @Override
    public <T> double copy$default$2$mcD$sp() {
        return this.imag();
    }

    @Override
    public boolean specInstance$() {
        return true;
    }

    public Complex$mcD$sp(double real$mcD$sp, double imag$mcD$sp) {
        this.real$mcD$sp = real$mcD$sp;
        this.imag$mcD$sp = imag$mcD$sp;
        super(null, null);
    }
}

