/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.flatfile.lexical;

import com.mulesoft.flatfile.lexical.ErrorHandler;
import com.mulesoft.flatfile.lexical.LexicalDataException;
import com.mulesoft.flatfile.lexical.LexicalException;
import com.mulesoft.flatfile.lexical.TypeFormat;
import com.mulesoft.flatfile.lexical.WriterBase;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FlatFileWriter
extends WriterBase {
    protected static final Logger logger = LogManager.getLogger(FlatFileWriter.class);
    private static final char[] SPACES = "                                                                                               ".toCharArray();
    private static final char[] NULLS = new char[32];
    private final Charset encoding;
    private final String segmentSeparator;
    private Boolean supportsRaw;
    private char[] rawTransform;

    public FlatFileWriter(OutputStream os, Charset enc, String segsep) {
        super(new BufferedWriter(new OutputStreamWriter(os, enc)), '.');
        this.encoding = enc;
        this.segmentSeparator = segsep;
    }

    @Override
    public void init(Map<String, Object> props) {
    }

    @Override
    public void term(Map<String, Object> props) {
    }

    @Override
    public void writeToken(String text) throws IOException {
        this.writer.write(text);
    }

    @Override
    public void error(TypeFormat typ, ErrorHandler.ErrorCondition err, String text) throws LexicalException {
        boolean abort = false;
        try {
            if (this.errorHandler == null) {
                throw new LexicalDataException(typ, err, text);
            }
            this.errorHandler.error(typ, err, text);
        }
        catch (LexicalException e) {
            abort = true;
            throw e;
        }
        finally {
            if (abort) {
                logger.error("Unrecoverable lexer error " + text);
            } else {
                logger.info("Recoverable lexer error " + text);
            }
        }
    }

    @Override
    public void startToken() throws IOException {
    }

    @Override
    public void writeUnchecked(char[] chars, int offset, int length) throws IOException {
        this.writer.write(chars, offset, length);
    }

    @Override
    public void writeUnchecked(String text) throws IOException {
        this.writer.write(text);
    }

    @Override
    public void writeEscaped(String text) throws IOException {
        this.writer.write(text);
    }

    public void writeRaw(byte[] bytes) throws IOException {
        char[] chars;
        if (this.supportsRaw == null) {
            ByteBuffer bbuf = ByteBuffer.allocate(256);
            for (int i = 0; i < 256; ++i) {
                bbuf.put((byte)i);
            }
            bbuf.position(0);
            CharBuffer cbuf = this.encoding.decode(bbuf);
            byte[] rbytes = this.encoding.encode(cbuf).array();
            this.supportsRaw = Boolean.FALSE;
            if (rbytes.length == 256) {
                this.supportsRaw = Boolean.TRUE;
                for (int i = 0; i < 256; ++i) {
                    if ((rbytes[i] & 0xFF) == i) continue;
                    this.supportsRaw = Boolean.FALSE;
                    break;
                }
                this.rawTransform = cbuf.array();
            }
        }
        if (this.supportsRaw.booleanValue()) {
            chars = new char[bytes.length];
            for (int i = 0; i < chars.length; ++i) {
                chars[i] = this.rawTransform[bytes[i] & 0xFF];
            }
        } else {
            throw new IllegalStateException("Raw data is not supported for character encoding " + this.encoding.name());
        }
        this.writer.write(chars);
    }

    private void writeFill(int size, char[] chrs) throws IOException {
        int rem;
        for (rem = size; rem >= chrs.length; rem -= chrs.length) {
            this.writer.write(chrs);
        }
        if (rem > 0) {
            this.writer.write(chrs, 0, rem);
        }
    }

    public void writeBlank(int size) throws IOException {
        this.writeFill(size, SPACES);
    }

    public void writeNull(int size) throws IOException {
        this.writeFill(size, NULLS);
    }

    public void writeChar(int size, char chr) throws IOException {
        if (chr == '\u0000') {
            this.writeNull(size);
        } else if (chr == ' ') {
            this.writeBlank(size);
        } else {
            for (int i = 0; i < size; ++i) {
                this.writer.write(chr);
            }
        }
    }

    @Override
    public void writeSegmentTerminator() throws IOException {
        if (this.segmentSeparator != null) {
            this.writer.write(this.segmentSeparator);
        }
        ++this.segmentCount;
    }
}

