/*
 * Decompiled with CFR 0.152.
 */
package algebra.ring;

import algebra.ring.MultiplicativeGroup;
import algebra.ring.Ring;
import algebra.ring.RingFunctions;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.math.package$;
import scala.runtime.RichDouble$;

public abstract class RingFunctions$class {
    public static Object fromInt(RingFunctions $this, int n, Ring ev) {
        return ev.fromInt(n);
    }

    public static Object fromBigInt(RingFunctions $this, BigInt n, Ring ev) {
        return ev.fromBigInt(n);
    }

    public static final Object defaultFromBigInt(RingFunctions $this, BigInt n, Ring ev) {
        Object object;
        if (n.isValidInt()) {
            object = ev.fromInt(n.toInt());
        } else {
            Object d = ev.fromInt(0x40000000);
            long mask = 0x3FFFFFFFL;
            Object absValue = RingFunctions$class.loop$1($this, $this.one(ev), n.abs(), $this.zero(ev), d, mask, ev);
            object = n.signum() < 0 ? ev.negate(absValue) : absValue;
        }
        return object;
    }

    public static final Object defaultFromDouble(RingFunctions $this, double a, Ring ringA, MultiplicativeGroup mgA) {
        Object a2;
        if (a == 0.0) {
            a2 = ringA.zero();
        } else if (RichDouble$.MODULE$.isValidInt$extension(Predef$.MODULE$.doubleWrapper(a))) {
            a2 = ringA.fromInt((int)a);
        } else {
            Predef$.MODULE$.require(!Double.isInfinite(a) && !Double.isNaN(a), (Function0<Object>)((Object)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Double must be representable as a fraction.";
                }
            }));
            long bits2 = Double.doubleToLongBits(a);
            int expBits = (int)(bits2 >> 52 & 0x7FFL);
            long mBits = bits2 & 0xFFFFFFFFFFFFFL;
            long m = expBits > 0 ? mBits | 0x10000000000000L : mBits;
            int zeros = Long.numberOfTrailingZeros(m);
            long value2 = m >>> zeros;
            int exp = package$.MODULE$.max(1, expBits) - 1075 + zeros;
            Object high = ringA.times(ringA.fromInt((int)(value2 >>> 30)), ringA.fromInt(0x40000000));
            Object low = ringA.fromInt((int)(value2 & 0x3FFFFFFFL));
            Object num = ringA.plus(high, low);
            Object unsigned = exp > 0 ? ringA.times(num, ringA.pow(ringA.fromInt(2), exp)) : (exp < 0 ? mgA.div(num, ringA.pow(ringA.fromInt(2), -exp)) : num);
            a2 = a < 0.0 ? ringA.negate(unsigned) : unsigned;
        }
        return a2;
    }

    public static double fromInt$mDc$sp(RingFunctions $this, int n, Ring ev) {
        return ev.fromInt$mcD$sp(n);
    }

    public static float fromInt$mFc$sp(RingFunctions $this, int n, Ring ev) {
        return ev.fromInt$mcF$sp(n);
    }

    public static int fromInt$mIc$sp(RingFunctions $this, int n, Ring ev) {
        return ev.fromInt$mcI$sp(n);
    }

    public static long fromInt$mJc$sp(RingFunctions $this, int n, Ring ev) {
        return ev.fromInt$mcJ$sp(n);
    }

    public static double fromBigInt$mDc$sp(RingFunctions $this, BigInt n, Ring ev) {
        return ev.fromBigInt$mcD$sp(n);
    }

    public static float fromBigInt$mFc$sp(RingFunctions $this, BigInt n, Ring ev) {
        return ev.fromBigInt$mcF$sp(n);
    }

    public static int fromBigInt$mIc$sp(RingFunctions $this, BigInt n, Ring ev) {
        return ev.fromBigInt$mcI$sp(n);
    }

    public static long fromBigInt$mJc$sp(RingFunctions $this, BigInt n, Ring ev) {
        return ev.fromBigInt$mcJ$sp(n);
    }

    public static final double defaultFromBigInt$mDc$sp(RingFunctions $this, BigInt n, Ring ev) {
        double d;
        if (n.isValidInt()) {
            d = ev.fromInt$mcD$sp(n.toInt());
        } else {
            double d2 = ev.fromInt$mcD$sp(0x40000000);
            long mask = 0x3FFFFFFFL;
            double absValue = RingFunctions$class.loop$2($this, $this.one$mDc$sp(ev), n.abs(), $this.zero$mDc$sp(ev), d2, mask, ev);
            d = n.signum() < 0 ? ev.negate$mcD$sp(absValue) : absValue;
        }
        return d;
    }

    public static final float defaultFromBigInt$mFc$sp(RingFunctions $this, BigInt n, Ring ev) {
        float f;
        if (n.isValidInt()) {
            f = ev.fromInt$mcF$sp(n.toInt());
        } else {
            float d = ev.fromInt$mcF$sp(0x40000000);
            long mask = 0x3FFFFFFFL;
            float absValue = RingFunctions$class.loop$3($this, $this.one$mFc$sp(ev), n.abs(), $this.zero$mFc$sp(ev), d, mask, ev);
            f = n.signum() < 0 ? ev.negate$mcF$sp(absValue) : absValue;
        }
        return f;
    }

    public static final int defaultFromBigInt$mIc$sp(RingFunctions $this, BigInt n, Ring ev) {
        int n2;
        if (n.isValidInt()) {
            n2 = ev.fromInt$mcI$sp(n.toInt());
        } else {
            int d = ev.fromInt$mcI$sp(0x40000000);
            long mask = 0x3FFFFFFFL;
            int absValue = RingFunctions$class.loop$4($this, $this.one$mIc$sp(ev), n.abs(), $this.zero$mIc$sp(ev), d, mask, ev);
            n2 = n.signum() < 0 ? ev.negate$mcI$sp(absValue) : absValue;
        }
        return n2;
    }

    public static final long defaultFromBigInt$mJc$sp(RingFunctions $this, BigInt n, Ring ev) {
        long l;
        if (n.isValidInt()) {
            l = ev.fromInt$mcJ$sp(n.toInt());
        } else {
            long d = ev.fromInt$mcJ$sp(0x40000000);
            long mask = 0x3FFFFFFFL;
            long absValue = RingFunctions$class.loop$5($this, $this.one$mJc$sp(ev), n.abs(), $this.zero$mJc$sp(ev), d, mask, ev);
            l = n.signum() < 0 ? ev.negate$mcJ$sp(absValue) : absValue;
        }
        return l;
    }

    private static final Object loop$1(RingFunctions $this, Object k, BigInt x, Object acc, Object d$1, long mask$1, Ring ev$1) {
        while (!x.isValidInt()) {
            BigInt y = x.$greater$greater(30);
            Object r = ev$1.fromInt(x.$amp(BigInt$.MODULE$.long2bigInt(mask$1)).toInt());
            acc = ev$1.plus(ev$1.times(k, r), acc);
            x = y;
            k = ev$1.times(d$1, k);
        }
        return ev$1.plus(ev$1.times(k, ev$1.fromInt(x.toInt())), acc);
    }

    private static final double loop$2(RingFunctions $this, double k, BigInt x, double acc, double d$2, long mask$2, Ring ev$2) {
        while (!x.isValidInt()) {
            BigInt y = x.$greater$greater(30);
            double r = ev$2.fromInt$mcD$sp(x.$amp(BigInt$.MODULE$.long2bigInt(mask$2)).toInt());
            acc = ev$2.plus$mcD$sp(ev$2.times$mcD$sp(k, r), acc);
            x = y;
            k = ev$2.times$mcD$sp(d$2, k);
        }
        return ev$2.plus$mcD$sp(ev$2.times$mcD$sp(k, ev$2.fromInt$mcD$sp(x.toInt())), acc);
    }

    private static final float loop$3(RingFunctions $this, float k, BigInt x, float acc, float d$3, long mask$3, Ring ev$3) {
        while (!x.isValidInt()) {
            BigInt y = x.$greater$greater(30);
            float r = ev$3.fromInt$mcF$sp(x.$amp(BigInt$.MODULE$.long2bigInt(mask$3)).toInt());
            acc = ev$3.plus$mcF$sp(ev$3.times$mcF$sp(k, r), acc);
            x = y;
            k = ev$3.times$mcF$sp(d$3, k);
        }
        return ev$3.plus$mcF$sp(ev$3.times$mcF$sp(k, ev$3.fromInt$mcF$sp(x.toInt())), acc);
    }

    private static final int loop$4(RingFunctions $this, int k, BigInt x, int acc, int d$4, long mask$4, Ring ev$4) {
        while (!x.isValidInt()) {
            BigInt y = x.$greater$greater(30);
            int r = ev$4.fromInt$mcI$sp(x.$amp(BigInt$.MODULE$.long2bigInt(mask$4)).toInt());
            acc = ev$4.plus$mcI$sp(ev$4.times$mcI$sp(k, r), acc);
            x = y;
            k = ev$4.times$mcI$sp(d$4, k);
        }
        return ev$4.plus$mcI$sp(ev$4.times$mcI$sp(k, ev$4.fromInt$mcI$sp(x.toInt())), acc);
    }

    private static final long loop$5(RingFunctions $this, long k, BigInt x, long acc, long d$5, long mask$5, Ring ev$5) {
        while (!x.isValidInt()) {
            BigInt y = x.$greater$greater(30);
            long r = ev$5.fromInt$mcJ$sp(x.$amp(BigInt$.MODULE$.long2bigInt(mask$5)).toInt());
            acc = ev$5.plus$mcJ$sp(ev$5.times$mcJ$sp(k, r), acc);
            x = y;
            k = ev$5.times$mcJ$sp(d$5, k);
        }
        return ev$5.plus$mcJ$sp(ev$5.times$mcJ$sp(k, ev$5.fromInt$mcJ$sp(x.toInt())), acc);
    }

    public static void $init$(RingFunctions $this) {
    }
}

