/*
 * Decompiled with CFR 0.152.
 */
package spire.math;

import cats.kernel.Eq;
import cats.kernel.Order;
import java.math.MathContext;
import java.math.RoundingMode;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversable;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range$;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Stream$;
import scala.collection.immutable.Stream$cons$;
import scala.collection.immutable.StringOps;
import scala.math.BigDecimal;
import scala.math.BigDecimal$;
import scala.math.BigDecimal$RoundingMode$;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.math.ScalaNumericConversions;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichDouble$;
import scala.runtime.RichFloat$;
import scala.runtime.RichLong$;
import spire.algebra.Field;
import spire.algebra.GCDRing;
import spire.algebra.IsReal;
import spire.algebra.NRoot;
import spire.algebra.Signed;
import spire.algebra.Trig;
import spire.implicits$;
import spire.std.package$bigDecimal$;
import spire.syntax.LiteralIntAdditiveSemigroupOps$;

public final class package$ {
    public static final package$ MODULE$;
    private final int radix;

    static {
        new package$();
    }

    public final byte abs(byte n) {
        return (byte)Math.abs(n);
    }

    public final short abs(short n) {
        return (short)Math.abs(n);
    }

    public final int abs(int n) {
        return Math.abs(n);
    }

    public final long abs(long n) {
        return Math.abs(n);
    }

    public final float abs(float n) {
        return Math.abs(n);
    }

    public final double abs(double n) {
        return Math.abs(n);
    }

    public final <A> A abs(A a, Signed<A> ev) {
        return ev.abs(a);
    }

    public final float ceil(float n) {
        return (float)Math.ceil(n);
    }

    public final double ceil(double n) {
        return Math.ceil(n);
    }

    public final BigDecimal ceil(BigDecimal n) {
        return n.setScale(0, BigDecimal$RoundingMode$.MODULE$.CEILING());
    }

    public final <A> A ceil(A a, IsReal<A> ev) {
        return ev.ceil(a);
    }

    public BigInt choose(long n, long k) {
        if (n < 0L || k < 0L) {
            throw new IllegalArgumentException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"n=", ", k=", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(n), BoxesRunTime.boxToLong(k)})));
        }
        if (k == 0L || k == n) {
            return scala.package$.MODULE$.BigInt().apply(1);
        }
        if (k > n) {
            return scala.package$.MODULE$.BigInt().apply(0);
        }
        if (n - k > k) {
            return this.choose(n, n - k);
        }
        return (n - k & 1L) == 1L ? this.loop$1(k + 1L, n - 1L, scala.package$.MODULE$.BigInt().apply(n)).$div(this.fact(n - k)) : this.loop$1(k + 1L, n, scala.package$.MODULE$.BigInt().apply(1)).$div(this.fact(n - k));
    }

    public BigInt fact(long n) {
        if (n < 0L) {
            throw new IllegalArgumentException(((Object)BoxesRunTime.boxToLong(n)).toString());
        }
        return n == 0L ? scala.package$.MODULE$.BigInt().apply(1) : ((n & 1L) == 1L ? this.loop$2(1L, n - 1L, scala.package$.MODULE$.BigInt().apply(n)) : this.loop$2(2L, n - 1L, scala.package$.MODULE$.BigInt().apply(n)));
    }

    public BigInt fib(long n) {
        int i;
        if (n < 0L) {
            throw new IllegalArgumentException(((Object)BoxesRunTime.boxToLong(n)).toString());
        }
        for (i = 63; (n >>> i & 1L) == 0L && i >= 0; --i) {
        }
        return this.loop$3(scala.package$.MODULE$.BigInt().apply(1), scala.package$.MODULE$.BigInt().apply(0), i, n);
    }

    public final float floor(float n) {
        return (float)Math.floor(n);
    }

    public final double floor(double n) {
        return Math.floor(n);
    }

    public final BigDecimal floor(BigDecimal n) {
        return n.setScale(0, BigDecimal$RoundingMode$.MODULE$.FLOOR());
    }

    public final <A> A floor(A a, IsReal<A> ev) {
        return ev.floor(a);
    }

    public final float round(float a) {
        return Math.abs(a) >= 1.6777216E7f ? a : (float)Math.round(a);
    }

    public final double round(double a) {
        return Math.abs(a) >= 4.503599627370496E15 ? a : (double)Math.round(a);
    }

    public final BigDecimal round(BigDecimal a) {
        return a.setScale(0, BigDecimal$RoundingMode$.MODULE$.HALF_UP());
    }

    public final <A> A round(A a, IsReal<A> ev) {
        return ev.round(a);
    }

    public final double exp(double n) {
        return Math.exp(n);
    }

    public final BigDecimal exp(int k, int precision) {
        MathContext mc = new MathContext(precision + 1, RoundingMode.HALF_UP);
        int i = 2;
        BigInt num = scala.package$.MODULE$.BigInt().apply(2);
        BigInt denom = scala.package$.MODULE$.BigInt().apply(1);
        BigInt limit = scala.package$.MODULE$.BigInt().apply(10).pow(precision);
        while (denom.$less(limit)) {
            denom = denom.$times(BigInt$.MODULE$.int2bigInt(i));
            num = num.$times(BigInt$.MODULE$.int2bigInt(i)).$plus(scala.package$.MODULE$.BigInt().apply(1));
            ++i;
        }
        BigDecimal sum2 = scala.package$.MODULE$.BigDecimal().apply(num, mc).$div(scala.package$.MODULE$.BigDecimal().apply(denom, mc));
        return sum2.setScale(precision - sum2.precision() + sum2.scale(), BigDecimal$RoundingMode$.MODULE$.FLOOR()).pow(k);
    }

    public final BigDecimal exp(BigDecimal k) {
        if (k.signum() == 0) {
            return scala.package$.MODULE$.BigDecimal().apply(1);
        }
        if (k.signum() == -1) {
            return scala.package$.MODULE$.BigDecimal().apply(1).$div(this.exp(k.unary_$minus()));
        }
        BigDecimal whole = k.setScale(0, BigDecimal$RoundingMode$.MODULE$.FLOOR());
        if (whole.signum() > 1) {
            BigDecimal part = this.exp(scala.package$.MODULE$.BigDecimal().apply(1).$plus(k.$minus(whole).$div(whole)));
            return this.power$1(scala.package$.MODULE$.BigDecimal().apply(1), part, whole.toBigInt());
        }
        k.mc().getPrecision();
        BigDecimal r = this.doit$1(k.mc().getPrecision() + 3, 1000, k);
        return new BigDecimal(r.bigDecimal(), k.mc());
    }

    public final <A> A exp(A a, Trig<A> t) {
        return t.exp(a);
    }

    public final double log(double n) {
        return Math.log(n);
    }

    public final double log(double n, int base) {
        return Math.log(n) / Math.log(base);
    }

    public final BigDecimal log(BigDecimal n) {
        int scale = n.mc().getPrecision();
        if (n.signum() < 1) {
            throw new IllegalArgumentException("argument <= 0");
        }
        Tuple2 tuple22 = this.rescale$1(n, 0);
        if (tuple22 != null) {
            Tuple2 tuple23 = new Tuple2(tuple22._1(), BoxesRunTime.boxToInteger(tuple22._2$mcI$sp()));
            BigDecimal x = (BigDecimal)tuple23._1();
            int i = tuple23._2$mcI$sp();
            return this.ln$1(x, scale).$times(scala.package$.MODULE$.BigDecimal().apply(2).pow(i)).setScale(scale, BigDecimal$RoundingMode$.MODULE$.HALF_UP());
        }
        throw new MatchError(tuple22);
    }

    public BigDecimal log(BigDecimal n, int base) {
        return this.log(n).$div(this.log(scala.package$.MODULE$.BigDecimal().apply(base)));
    }

    public final <A> A log(A a, Trig<A> t) {
        return t.log(a);
    }

    public final <A> A log(A a, int base, Field<A> f, Trig<A> t) {
        return f.div(t.log(a), t.log(f.fromInt(base)));
    }

    public final BigDecimal pow(BigDecimal base, BigDecimal exponent2) {
        return exponent2.abs().$less$eq(BigDecimal$.MODULE$.int2bigDecimal(99999999)) && exponent2.isWhole() ? base.pow(exponent2.toInt()) : this.exp(this.log(base).$times(exponent2));
    }

    public final BigInt pow(BigInt base, BigInt ex) {
        BigInt bigInt;
        if (ex.signum() < 0) {
            Integer n;
            if (base.signum() == 0) {
                throw new ArithmeticException("zero can't be raised to negative power");
            }
            Integer n2 = BoxesRunTime.boxToInteger(1);
            bigInt = (base != n2 ? (base != null ? (!(base instanceof Number) ? (!(base instanceof Character) ? ((Object)base).equals(n2) : BoxesRunTime.equalsCharObject((Character)((Object)base), n2)) : BoxesRunTime.equalsNumObject(base, n2)) : false) : true) ? base : ((base != (n = BoxesRunTime.boxToInteger(-1)) ? (base != null ? (!(base instanceof Number) ? (!(base instanceof Character) ? ((Object)base).equals(n) : BoxesRunTime.equalsCharObject((Character)((Object)base), n)) : BoxesRunTime.equalsNumObject(base, n)) : false) : true) ? (ex.testBit(0) ? scala.package$.MODULE$.BigInt().apply(1) : base) : scala.package$.MODULE$.BigInt().apply(0));
        } else {
            bigInt = ex.isValidInt() ? base.pow(ex.toInt()) : this.bigIntPow$1(scala.package$.MODULE$.BigInt().apply(1), base, ex);
        }
        return bigInt;
    }

    public final long pow(long base, long exponent2) {
        long l;
        if (exponent2 < 0L) {
            if (base == 0L) {
                throw new ArithmeticException("zero can't be raised to negative power");
            }
            l = base == 1L ? 1L : (base == -1L ? ((exponent2 & 1L) == 0L ? -1L : 1L) : 0L);
        } else {
            l = this.longPow$1(1L, base, exponent2);
        }
        return l;
    }

    public final double pow(double base, double exponent2) {
        return Math.pow(base, exponent2);
    }

    public final long gcd(long _x, long _y) {
        if (_x == 0L) {
            return Math.abs(_y);
        }
        if (_x == 1L) {
            return 1L;
        }
        if (_y == 0L) {
            return Math.abs(_x);
        }
        if (_y == 1L) {
            return 1L;
        }
        int xz = Long.numberOfTrailingZeros(_x);
        long x = Math.abs(_x >> xz);
        int yz = Long.numberOfTrailingZeros(_y);
        long y = Math.abs(_y >> yz);
        while (x != y) {
            if (x > y) {
                long l = x - y;
                x = l >> Long.numberOfTrailingZeros(l);
                continue;
            }
            long l = y - x;
            y = l >> Long.numberOfTrailingZeros(l);
        }
        return xz < yz ? x << xz : x << yz;
    }

    public final BigInt gcd(BigInt a, BigInt b) {
        return a.gcd(b);
    }

    public final <A> A gcd(A x, A y, Eq<A> evidence$1, GCDRing<A> ev) {
        return ev.gcd(x, y, evidence$1);
    }

    public final <A> A gcd(Seq<A> xs, Eq<A> evidence$2, GCDRing<A> ev) {
        return (A)xs.reduceLeft(new Serializable(evidence$2, ev){
            public static final long serialVersionUID = 0L;
            private final Eq evidence$2$1;
            private final GCDRing ev$1;

            public final A apply(A a, A b) {
                return this.ev$1.gcd(a, b, this.evidence$2$1);
            }
            {
                this.evidence$2$1 = evidence$2$1;
                this.ev$1 = ev$1;
            }
        });
    }

    public final <A> A gcd(A x, A y, A z, Seq<A> rest, Eq<A> evidence$3, GCDRing<A> ev) {
        return rest.isEmpty() ? ev.gcd(ev.gcd(x, y, evidence$3), z, evidence$3) : ev.gcd(ev.gcd(ev.gcd(x, y, evidence$3), z, evidence$3), this.gcd(rest, evidence$3, ev), evidence$3);
    }

    public final long lcm(long x, long y) {
        return x == 0L || y == 0L ? 0L : x / this.gcd(x, y) * y;
    }

    public final BigInt lcm(BigInt a, BigInt b) {
        return a.signum() == 0 || b.signum() == 0 ? BigInt$.MODULE$.int2bigInt(0) : a.$div(a.gcd(b)).$times(b);
    }

    public final <A> A lcm(A x, A y, Eq<A> evidence$4, GCDRing<A> ev) {
        return ev.lcm(x, y, evidence$4);
    }

    public final byte min(byte x, byte y) {
        return (byte)Math.min(x, y);
    }

    public final short min(short x, short y) {
        return (short)Math.min(x, y);
    }

    public final int min(int x, int y) {
        return Math.min(x, y);
    }

    public final long min(long x, long y) {
        return Math.min(x, y);
    }

    public final float min(float x, float y) {
        return Math.min(x, y);
    }

    public final double min(double x, double y) {
        return Math.min(x, y);
    }

    public final <A> A min(A x, A y, Order<A> ev) {
        return ev.min(x, y);
    }

    public final byte max(byte x, byte y) {
        return (byte)Math.max(x, y);
    }

    public final short max(short x, short y) {
        return (short)Math.max(x, y);
    }

    public final int max(int x, int y) {
        return Math.max(x, y);
    }

    public final long max(long x, long y) {
        return Math.max(x, y);
    }

    public final float max(float x, float y) {
        return Math.max(x, y);
    }

    public final double max(double x, double y) {
        return Math.max(x, y);
    }

    public final <A> A max(A x, A y, Order<A> ev) {
        return ev.max(x, y);
    }

    public final double signum(double x) {
        return Math.signum(x);
    }

    public final float signum(float x) {
        return Math.signum(x);
    }

    public final <A> int signum(A a, Signed<A> ev) {
        return ev.signum(a);
    }

    public final double sqrt(double x) {
        return Math.sqrt(x);
    }

    public final <A> A sqrt(A a, NRoot<A> ev) {
        return ev.sqrt(a);
    }

    public final double e() {
        return Math.E;
    }

    public final <A> A e(Trig<A> ev) {
        return ev.e();
    }

    public final double pi() {
        return Math.PI;
    }

    public final <A> A pi(Trig<A> ev) {
        return ev.pi();
    }

    public final <A> A sin(A a, Trig<A> ev) {
        return ev.sin(a);
    }

    public final <A> A cos(A a, Trig<A> ev) {
        return ev.cos(a);
    }

    public final <A> A tan(A a, Trig<A> ev) {
        return ev.tan(a);
    }

    public final <A> A asin(A a, Trig<A> ev) {
        return ev.asin(a);
    }

    public final <A> A acos(A a, Trig<A> ev) {
        return ev.acos(a);
    }

    public final <A> A atan(A a, Trig<A> ev) {
        return ev.atan(a);
    }

    public final <A> A atan2(A y, A x, Trig<A> ev) {
        return ev.atan2(y, x);
    }

    public final <A> A sinh(A x, Trig<A> ev) {
        return ev.sinh(x);
    }

    public final <A> A cosh(A x, Trig<A> ev) {
        return ev.cosh(x);
    }

    public final <A> A tanh(A x, Trig<A> ev) {
        return ev.tanh(x);
    }

    public final double cbrt(double x) {
        return Math.cbrt(x);
    }

    public final double copySign(double m, double s2) {
        return Math.copySign(m, s2);
    }

    public final float copySign(float m, float s2) {
        return Math.copySign(m, s2);
    }

    public final double cosh(double x) {
        return Math.cosh(x);
    }

    public final double expm1(double x) {
        return Math.expm1(x);
    }

    public final int getExponent(double x) {
        return Math.getExponent(x);
    }

    public final int getExponent(float x) {
        return Math.getExponent(x);
    }

    public final double IEEEremainder(double x, double d) {
        return Math.IEEEremainder(x, d);
    }

    public final double log10(double x) {
        return Math.log10(x);
    }

    public final double log1p(double x) {
        return Math.log1p(x);
    }

    public final double nextAfter(double x, double y) {
        return Math.nextAfter(x, y);
    }

    public final float nextAfter(float x, float y) {
        return Math.nextAfter(x, (double)y);
    }

    public final double nextUp(double x) {
        return Math.nextUp(x);
    }

    public final float nextUp(float x) {
        return Math.nextUp(x);
    }

    public final double random() {
        return Math.random();
    }

    public final double rint(double x) {
        return Math.rint(x);
    }

    public final double scalb(double d, int s2) {
        return Math.scalb(d, s2);
    }

    public final float scalb(float d, int s2) {
        return Math.scalb(d, s2);
    }

    public final double toDegrees(double a) {
        return Math.toDegrees(a);
    }

    public final double toRadians(double a) {
        return Math.toRadians(a);
    }

    public final double ulp(double x) {
        return Math.ulp(x);
    }

    public final double ulp(float x) {
        return Math.ulp(x);
    }

    public final <A> A hypot(A x, A y, Field<A> f, NRoot<A> n, Signed<A> s2) {
        return (A)(s2.gt(x, y) ? f.times(this.abs$1(x, f, s2), n.sqrt(LiteralIntAdditiveSemigroupOps$.MODULE$.$plus$extension(implicits$.MODULE$.literalIntAdditiveSemigroupOps(1), f.pow(f.div(y, x), 2), f))) : f.times(this.abs$1(y, f, s2), n.sqrt(LiteralIntAdditiveSemigroupOps$.MODULE$.$plus$extension(implicits$.MODULE$.literalIntAdditiveSemigroupOps(1), f.pow(f.div(x, y), 2), f))));
    }

    private int intSearch(Function1<Object, Object> f) {
        int n;
        Predef$ predef$ = Predef$.MODULE$;
        Option<Object> option2 = Range$.MODULE$.apply(0, 32).find(new Serializable(f){
            public static final long serialVersionUID = 0L;
            private final Function1 f$2;

            public final boolean apply(int i) {
                return this.apply$mcZI$sp(i);
            }

            public boolean apply$mcZI$sp(int i) {
                return !this.f$2.apply$mcZI$sp(1 << i);
            }
            {
                this.f$2 = f$2;
            }
        });
        int ceil2 = BoxesRunTime.unboxToInt(!option2.isEmpty() ? option2.get() : BoxesRunTime.boxToInteger(33));
        if (ceil2 == 0) {
            n = 0;
        } else {
            int n2 = ceil2 - 1;
            Predef$ predef$2 = Predef$.MODULE$;
            n = BoxesRunTime.unboxToInt(Range$.MODULE$.inclusive(n2, 0).by(-1).$div$colon(BoxesRunTime.boxToInteger(0), new Serializable(f){
                public static final long serialVersionUID = 0L;
                private final Function1 f$2;

                public final int apply(int x, int i) {
                    return this.apply$mcIII$sp(x, i);
                }

                public int apply$mcIII$sp(int x, int i) {
                    int y = x | 1 << i;
                    return this.f$2.apply$mcZI$sp(y) ? y : x;
                }
                {
                    this.f$2 = f$2;
                }
            }));
        }
        return n;
    }

    public Stream<BigInt> spire$math$package$$decDiv(BigInt x, BigInt y, int r) {
        Integer n;
        BigInt quot2;
        BigInt expanded = x.$times(BigInt$.MODULE$.int2bigInt(r));
        BigInt rem = expanded.$minus((quot2 = expanded.$div(y)).$times(y));
        return (rem != (n = BoxesRunTime.boxToInteger(0)) ? (rem != null ? (!(rem instanceof Number) ? (!(rem instanceof Character) ? ((Object)rem).equals(n) : BoxesRunTime.equalsCharObject((Character)((Object)rem), n)) : BoxesRunTime.equalsNumObject(rem, n)) : false) : true) ? Stream$cons$.MODULE$.apply(quot2, new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Stream<Nothing$> apply() {
                return scala.package$.MODULE$.Stream().empty();
            }
        }) : Stream$cons$.MODULE$.apply(quot2, new Serializable(y, r, rem){
            public static final long serialVersionUID = 0L;
            private final BigInt y$1;
            private final int r$1;
            private final BigInt rem$1;

            public final Stream<BigInt> apply() {
                return package$.MODULE$.spire$math$package$$decDiv(this.rem$1, this.y$1, this.r$1);
            }
            {
                this.y$1 = y$1;
                this.r$1 = r$1;
                this.rem$1 = rem$1;
            }
        });
    }

    private List<Object> digitize(BigInt x, int r, List<Object> prev) {
        while (true) {
            Integer n;
            boolean bl = x != (n = BoxesRunTime.boxToInteger(0)) ? (x != null ? (!(x instanceof Number) ? (!(x instanceof Character) ? ((Object)x).equals(n) : BoxesRunTime.equalsCharObject((Character)((Object)x), n)) : BoxesRunTime.equalsNumObject(x, n)) : false) : true;
            if (bl) {
                return prev;
            }
            BigInt bigInt = x.$div(BigInt$.MODULE$.int2bigInt(r));
            int n2 = x.$percent(BigInt$.MODULE$.int2bigInt(r)).toInt();
            prev = prev.$colon$colon(BoxesRunTime.boxToInteger(n2));
            x = bigInt;
        }
    }

    private List<Object> digitize$default$3() {
        return Nil$.MODULE$;
    }

    private BigInt undigitize(Seq<Object> digits, int r) {
        BigInt bigInt = scala.package$.MODULE$.BigInt().apply(0);
        return digits.$div$colon(bigInt, new Serializable(r){
            public static final long serialVersionUID = 0L;
            private final int r$2;

            public final BigInt apply(BigInt x$5, int x$6) {
                return x$5.$times(BigInt$.MODULE$.int2bigInt(this.r$2)).$plus(BigInt$.MODULE$.int2bigInt(x$6));
            }
            {
                this.r$2 = r$2;
            }
        });
    }

    private int radix() {
        return this.radix;
    }

    public BigDecimal nroot(BigDecimal a, int k, MathContext ctxt) {
        Tuple2 tuple22;
        block7: {
            BigDecimal bigDecimal;
            block5: {
                block6: {
                    block4: {
                        if (k != 0) break block4;
                        bigDecimal = scala.package$.MODULE$.BigDecimal().apply(1);
                        break block5;
                    }
                    if (a.signum() >= 0) break block6;
                    if (k % 2 == 0) {
                        Predef$ predef$ = Predef$.MODULE$;
                        throw new ArithmeticException(new StringOps("%d-root of negative number").format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(k)})));
                    }
                    bigDecimal = this.nroot(a.unary_$minus(), k, ctxt).unary_$minus();
                    break block5;
                }
                BigInt underlying = scala.package$.MODULE$.BigInt().apply(a.bigDecimal().unscaledValue().toByteArray());
                BigInt scale = scala.package$.MODULE$.BigInt().apply(10).pow(a.scale());
                List<Object> intPart2 = this.digitize(underlying.$div(scale), this.radix(), this.digitize$default$3());
                Stream fracPart2 = this.spire$math$package$$decDiv(underlying.$percent(scale), scale, this.radix()).map(new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final int apply(BigInt x$7) {
                        return x$7.toInt();
                    }
                }, Stream$.MODULE$.canBuildFrom());
                GenTraversable leader = intPart2.size() % k == 0 ? scala.package$.MODULE$.Stream().empty() : scala.package$.MODULE$.Stream().fill(k - intPart2.size() % k, (Function0)((Object)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final int apply() {
                        return 0;
                    }

                    public int apply$mcI$sp() {
                        return 0;
                    }
                }));
                Stream digits = ((Stream)leader).$plus$plus(intPart2.toStream(), Stream$.MODULE$.canBuildFrom()).$plus$plus(fracPart2, Stream$.MODULE$.canBuildFrom()).$plus$plus(scala.package$.MODULE$.Stream().continually(new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final int apply() {
                        return 0;
                    }

                    public int apply$mcI$sp() {
                        return 0;
                    }
                }), Stream$.MODULE$.canBuildFrom());
                BigInt radixPowK = scala.package$.MODULE$.BigInt().apply(this.radix()).pow(k);
                int maxSize = (ctxt.getPrecision() + 8) / 9 + 2;
                tuple22 = this.findRoot$1(digits, BigInt$.MODULE$.int2bigInt(0), BigInt$.MODULE$.int2bigInt(0), 1, k, radixPowK, maxSize);
                if (tuple22 == null) break block7;
                Tuple2 tuple23 = new Tuple2(BoxesRunTime.boxToInteger(tuple22._1$mcI$sp()), tuple22._2());
                int size2 = tuple23._1$mcI$sp();
                BigInt unscaled = (BigInt)tuple23._2();
                int newscale = (size2 - (intPart2.size() + k - 1) / k) * 9;
                bigDecimal = scala.package$.MODULE$.BigDecimal().apply(unscaled, newscale, ctxt);
            }
            return bigDecimal;
        }
        throw new MatchError(tuple22);
    }

    public boolean anyIsZero(Object n) {
        ScalaNumericConversions scalaNumericConversions;
        Integer n2 = BoxesRunTime.boxToInteger(0);
        boolean bl = (n != n2 ? (n != null ? (!(n instanceof Number) ? (!(n instanceof Character) ? n.equals(n2) : BoxesRunTime.equalsCharObject((Character)n, n2)) : BoxesRunTime.equalsNumObject((Number)n, n2)) : false) : true) ? true : (n instanceof ScalaNumericConversions ? (scalaNumericConversions = (ScalaNumericConversions)n).isValidInt() && scalaNumericConversions.toInt() == 0 : false);
        return bl;
    }

    public double anyToDouble(Object n) {
        block10: {
            double d;
            block3: {
                block9: {
                    double d2;
                    block8: {
                        block7: {
                            block6: {
                                block5: {
                                    block4: {
                                        block2: {
                                            if (!(n instanceof Byte)) break block2;
                                            byte by2 = BoxesRunTime.unboxToByte(n);
                                            d = by2;
                                            break block3;
                                        }
                                        if (!(n instanceof Short)) break block4;
                                        short s2 = BoxesRunTime.unboxToShort(n);
                                        d = s2;
                                        break block3;
                                    }
                                    if (!(n instanceof Character)) break block5;
                                    char c = BoxesRunTime.unboxToChar(n);
                                    d = c;
                                    break block3;
                                }
                                if (!(n instanceof Integer)) break block6;
                                int n2 = BoxesRunTime.unboxToInt(n);
                                d = n2;
                                break block3;
                            }
                            if (!(n instanceof Long)) break block7;
                            long l = BoxesRunTime.unboxToLong(n);
                            d = l;
                            break block3;
                        }
                        if (!(n instanceof Float)) break block8;
                        float f = BoxesRunTime.unboxToFloat(n);
                        d = f;
                        break block3;
                    }
                    if (!(n instanceof Double)) break block9;
                    d = d2 = BoxesRunTime.unboxToDouble(n);
                    break block3;
                }
                if (!(n instanceof ScalaNumericConversions)) break block10;
                ScalaNumericConversions scalaNumericConversions = (ScalaNumericConversions)n;
                d = scalaNumericConversions.toDouble();
            }
            return d;
        }
        throw new UnsupportedOperationException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is not a ScalaNumber"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{n})));
    }

    public long anyToLong(Object n) {
        block10: {
            long l;
            block3: {
                block9: {
                    block8: {
                        block7: {
                            long l2;
                            block6: {
                                block5: {
                                    block4: {
                                        block2: {
                                            if (!(n instanceof Byte)) break block2;
                                            byte by2 = BoxesRunTime.unboxToByte(n);
                                            l = by2;
                                            break block3;
                                        }
                                        if (!(n instanceof Short)) break block4;
                                        short s2 = BoxesRunTime.unboxToShort(n);
                                        l = s2;
                                        break block3;
                                    }
                                    if (!(n instanceof Character)) break block5;
                                    char c = BoxesRunTime.unboxToChar(n);
                                    l = c;
                                    break block3;
                                }
                                if (!(n instanceof Integer)) break block6;
                                int n2 = BoxesRunTime.unboxToInt(n);
                                l = n2;
                                break block3;
                            }
                            if (!(n instanceof Long)) break block7;
                            l = l2 = BoxesRunTime.unboxToLong(n);
                            break block3;
                        }
                        if (!(n instanceof Float)) break block8;
                        float f = BoxesRunTime.unboxToFloat(n);
                        l = (long)f;
                        break block3;
                    }
                    if (!(n instanceof Double)) break block9;
                    double d = BoxesRunTime.unboxToDouble(n);
                    l = (long)d;
                    break block3;
                }
                if (!(n instanceof ScalaNumericConversions)) break block10;
                ScalaNumericConversions scalaNumericConversions = (ScalaNumericConversions)n;
                l = scalaNumericConversions.toLong();
            }
            return l;
        }
        throw new UnsupportedOperationException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is not a ScalaNumber"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{n})));
    }

    public boolean anyIsWhole(Object n) {
        block10: {
            boolean bl;
            block3: {
                block9: {
                    block8: {
                        block7: {
                            block6: {
                                block5: {
                                    block4: {
                                        block2: {
                                            if (!(n instanceof Byte)) break block2;
                                            bl = true;
                                            break block3;
                                        }
                                        if (!(n instanceof Short)) break block4;
                                        bl = true;
                                        break block3;
                                    }
                                    if (!(n instanceof Character)) break block5;
                                    bl = true;
                                    break block3;
                                }
                                if (!(n instanceof Integer)) break block6;
                                bl = true;
                                break block3;
                            }
                            if (!(n instanceof Long)) break block7;
                            bl = true;
                            break block3;
                        }
                        if (!(n instanceof Float)) break block8;
                        float f = BoxesRunTime.unboxToFloat(n);
                        Predef$ predef$ = Predef$.MODULE$;
                        bl = RichFloat$.MODULE$.isWhole$extension(f);
                        break block3;
                    }
                    if (!(n instanceof Double)) break block9;
                    double d = BoxesRunTime.unboxToDouble(n);
                    Predef$ predef$ = Predef$.MODULE$;
                    bl = RichDouble$.MODULE$.isWhole$extension(d);
                    break block3;
                }
                if (!(n instanceof ScalaNumericConversions)) break block10;
                ScalaNumericConversions scalaNumericConversions = (ScalaNumericConversions)n;
                bl = scalaNumericConversions.isWhole();
            }
            return bl;
        }
        throw new UnsupportedOperationException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is not a ScalaNumber"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{n})));
    }

    public boolean anyIsValidInt(Object n) {
        block10: {
            boolean bl;
            block3: {
                block9: {
                    block8: {
                        block7: {
                            block6: {
                                block5: {
                                    block4: {
                                        block2: {
                                            if (!(n instanceof Byte)) break block2;
                                            bl = true;
                                            break block3;
                                        }
                                        if (!(n instanceof Short)) break block4;
                                        bl = true;
                                        break block3;
                                    }
                                    if (!(n instanceof Character)) break block5;
                                    bl = true;
                                    break block3;
                                }
                                if (!(n instanceof Integer)) break block6;
                                bl = true;
                                break block3;
                            }
                            if (!(n instanceof Long)) break block7;
                            long l = BoxesRunTime.unboxToLong(n);
                            Predef$ predef$ = Predef$.MODULE$;
                            bl = RichLong$.MODULE$.isValidInt$extension(l);
                            break block3;
                        }
                        if (!(n instanceof Float)) break block8;
                        float f = BoxesRunTime.unboxToFloat(n);
                        Predef$ predef$ = Predef$.MODULE$;
                        bl = RichFloat$.MODULE$.isValidInt$extension(f);
                        break block3;
                    }
                    if (!(n instanceof Double)) break block9;
                    double d = BoxesRunTime.unboxToDouble(n);
                    Predef$ predef$ = Predef$.MODULE$;
                    bl = RichDouble$.MODULE$.isValidInt$extension(d);
                    break block3;
                }
                if (!(n instanceof ScalaNumericConversions)) break block10;
                ScalaNumericConversions scalaNumericConversions = (ScalaNumericConversions)n;
                bl = scalaNumericConversions.isValidInt();
            }
            return bl;
        }
        throw new UnsupportedOperationException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is not a ScalaNumber"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{n})));
    }

    public final double e$mDc$sp(Trig<Object> ev) {
        return ev.e$mcD$sp();
    }

    public final float e$mFc$sp(Trig<Object> ev) {
        return ev.e$mcF$sp();
    }

    public final double pi$mDc$sp(Trig<Object> ev) {
        return ev.pi$mcD$sp();
    }

    public final float pi$mFc$sp(Trig<Object> ev) {
        return ev.pi$mcF$sp();
    }

    public final double sin$mDc$sp(double a, Trig<Object> ev) {
        return ev.sin$mcD$sp(a);
    }

    public final float sin$mFc$sp(float a, Trig<Object> ev) {
        return ev.sin$mcF$sp(a);
    }

    public final double cos$mDc$sp(double a, Trig<Object> ev) {
        return ev.cos$mcD$sp(a);
    }

    public final float cos$mFc$sp(float a, Trig<Object> ev) {
        return ev.cos$mcF$sp(a);
    }

    public final double tan$mDc$sp(double a, Trig<Object> ev) {
        return ev.tan$mcD$sp(a);
    }

    public final float tan$mFc$sp(float a, Trig<Object> ev) {
        return ev.tan$mcF$sp(a);
    }

    public final double asin$mDc$sp(double a, Trig<Object> ev) {
        return ev.asin$mcD$sp(a);
    }

    public final float asin$mFc$sp(float a, Trig<Object> ev) {
        return ev.asin$mcF$sp(a);
    }

    public final double acos$mDc$sp(double a, Trig<Object> ev) {
        return ev.acos$mcD$sp(a);
    }

    public final float acos$mFc$sp(float a, Trig<Object> ev) {
        return ev.acos$mcF$sp(a);
    }

    public final double atan$mDc$sp(double a, Trig<Object> ev) {
        return ev.atan$mcD$sp(a);
    }

    public final float atan$mFc$sp(float a, Trig<Object> ev) {
        return ev.atan$mcF$sp(a);
    }

    public final double atan2$mDc$sp(double y, double x, Trig<Object> ev) {
        return ev.atan2$mcD$sp(y, x);
    }

    public final float atan2$mFc$sp(float y, float x, Trig<Object> ev) {
        return ev.atan2$mcF$sp(y, x);
    }

    public final double sinh$mDc$sp(double x, Trig<Object> ev) {
        return ev.sinh$mcD$sp(x);
    }

    public final float sinh$mFc$sp(float x, Trig<Object> ev) {
        return ev.sinh$mcF$sp(x);
    }

    public final double cosh$mDc$sp(double x, Trig<Object> ev) {
        return ev.cosh$mcD$sp(x);
    }

    public final float cosh$mFc$sp(float x, Trig<Object> ev) {
        return ev.cosh$mcF$sp(x);
    }

    public final double tanh$mDc$sp(double x, Trig<Object> ev) {
        return ev.tanh$mcD$sp(x);
    }

    public final float tanh$mFc$sp(float x, Trig<Object> ev) {
        return ev.tanh$mcF$sp(x);
    }

    public final double hypot$mDc$sp(double x, double y, Field<Object> f, NRoot<Object> n, Signed<Object> s2) {
        return s2.gt$mcD$sp(x, y) ? f.times$mcD$sp(this.abs$2(x, f, s2), n.sqrt$mcD$sp(BoxesRunTime.unboxToDouble(LiteralIntAdditiveSemigroupOps$.MODULE$.$plus$extension(implicits$.MODULE$.literalIntAdditiveSemigroupOps(1), BoxesRunTime.boxToDouble(f.pow$mcD$sp(f.div$mcD$sp(y, x), 2)), f)))) : f.times$mcD$sp(this.abs$2(y, f, s2), n.sqrt$mcD$sp(BoxesRunTime.unboxToDouble(LiteralIntAdditiveSemigroupOps$.MODULE$.$plus$extension(implicits$.MODULE$.literalIntAdditiveSemigroupOps(1), BoxesRunTime.boxToDouble(f.pow$mcD$sp(f.div$mcD$sp(x, y), 2)), f))));
    }

    public final float hypot$mFc$sp(float x, float y, Field<Object> f, NRoot<Object> n, Signed<Object> s2) {
        return s2.gt$mcF$sp(x, y) ? f.times$mcF$sp(this.abs$3(x, f, s2), n.sqrt$mcF$sp(BoxesRunTime.unboxToFloat(LiteralIntAdditiveSemigroupOps$.MODULE$.$plus$extension(implicits$.MODULE$.literalIntAdditiveSemigroupOps(1), BoxesRunTime.boxToFloat(f.pow$mcF$sp(f.div$mcF$sp(y, x), 2)), f)))) : f.times$mcF$sp(this.abs$3(y, f, s2), n.sqrt$mcF$sp(BoxesRunTime.unboxToFloat(LiteralIntAdditiveSemigroupOps$.MODULE$.$plus$extension(implicits$.MODULE$.literalIntAdditiveSemigroupOps(1), BoxesRunTime.boxToFloat(f.pow$mcF$sp(f.div$mcF$sp(x, y), 2)), f))));
    }

    private final BigInt loop$1(long lo, long hi, BigInt prod2) {
        while (lo <= hi) {
            prod2 = scala.package$.MODULE$.BigInt().apply(lo).$times(scala.package$.MODULE$.BigInt().apply(hi)).$times(prod2);
            --hi;
            ++lo;
        }
        return prod2;
    }

    private final BigInt loop$2(long lo, long hi, BigInt prod2) {
        while (lo <= hi) {
            prod2 = scala.package$.MODULE$.BigInt().apply(lo).$times(scala.package$.MODULE$.BigInt().apply(hi)).$times(prod2);
            --hi;
            ++lo;
        }
        return prod2;
    }

    private final BigInt loop$3(BigInt a, BigInt b, int i, long n$1) {
        while (true) {
            BigInt c = a.$plus(b);
            if (i < 0) {
                return b;
            }
            if ((n$1 >>> i & 1L) == 1L) {
                BigInt bigInt = a.$plus(c).$times(b);
                --i;
                b = b.$times(b).$plus(c.$times(c));
                a = bigInt;
                continue;
            }
            BigInt bigInt = a.$times(a).$plus(b.$times(b));
            --i;
            b = a.$plus(c).$times(b);
            a = bigInt;
        }
    }

    private final BigDecimal power$1(BigDecimal result2, BigDecimal base, BigInt exponent2) {
        while (exponent2.signum() != 0) {
            if (exponent2.testBit(0)) {
                BigDecimal bigDecimal = result2.$times(base);
                exponent2 = exponent2.$greater$greater(1);
                base = base.$times(base);
                result2 = bigDecimal;
                continue;
            }
            exponent2 = exponent2.$greater$greater(1);
            base = base.$times(base);
        }
        return result2;
    }

    private final BigDecimal doit$1(int precision, int leeway, BigDecimal k$1) {
        while (true) {
            MathContext mc = new MathContext(precision, RoundingMode.HALF_UP);
            int i = 2;
            BigDecimal sum2 = scala.package$.MODULE$.BigDecimal().apply(1, mc).$plus(k$1);
            BigDecimal factorial = scala.package$.MODULE$.BigDecimal().apply(2, mc);
            BigDecimal kpow = k$1.$times(k$1);
            BigDecimal term = kpow.$div(factorial).setScale(precision, BigDecimal$RoundingMode$.MODULE$.HALF_UP());
            while (term.signum() != 0 && i < leeway) {
                sum2 = sum2.$plus(term);
                factorial = factorial.$times(BigDecimal$.MODULE$.int2bigDecimal(++i));
                kpow = kpow.$times(k$1);
                term = kpow.$div(factorial).setScale(precision, BigDecimal$RoundingMode$.MODULE$.HALF_UP());
            }
            if (i <= leeway) {
                return sum2.setScale(k$1.mc().getPrecision() - sum2.precision() + sum2.scale(), BigDecimal$RoundingMode$.MODULE$.FLOOR());
            }
            leeway *= 1000;
            precision += 3;
        }
    }

    private final BigDecimal loop$4(BigDecimal x, BigDecimal n$2, BigDecimal limit$1) {
        BigDecimal xp;
        BigDecimal term;
        while ((term = (xp = this.exp(x)).$minus(n$2).$div(xp)).$greater(limit$1)) {
            x = x.$minus(term);
        }
        return x.$minus(term);
    }

    private final BigDecimal ln$1(BigDecimal n, int scale$1) {
        int scale2 = scale$1 + 1;
        BigDecimal limit = scala.package$.MODULE$.BigDecimal().apply(5).$times(scala.package$.MODULE$.BigDecimal().apply(10).pow(-scale2));
        return this.loop$4(n.setScale(scale2, BigDecimal$RoundingMode$.MODULE$.HALF_UP()), n, limit).setScale(scale$1, BigDecimal$RoundingMode$.MODULE$.HALF_UP());
    }

    private final Tuple2 rescale$1(BigDecimal x, int n) {
        while (!x.$less(BigDecimal$.MODULE$.int2bigDecimal(64))) {
            ++n;
            x = package$bigDecimal$.MODULE$.BigDecimalAlgebra().sqrt(x);
        }
        return new Tuple2<BigDecimal, Integer>(x, BoxesRunTime.boxToInteger(n));
    }

    private final BigInt bigIntPow$1(BigInt t, BigInt b, BigInt e) {
        while (e.signum() != 0) {
            if (e.testBit(0)) {
                BigInt bigInt = t.$times(b);
                e = e.$greater$greater(1);
                b = b.$times(b);
                t = bigInt;
                continue;
            }
            e = e.$greater$greater(1);
            b = b.$times(b);
        }
        return t;
    }

    private final long longPow$1(long t, long b, long e) {
        while (e != 0L) {
            if ((e & 1L) == 1L) {
                long l = t * b;
                e >>= (int)1L;
                b *= b;
                t = l;
                continue;
            }
            e >>= (int)1L;
            b *= b;
        }
        return t;
    }

    private final Object abs$1(Object n, Field f$1, Signed s$1) {
        return s$1.lt(n, f$1.zero()) ? f$1.negate(n) : n;
    }

    private final Tuple2 findRoot$1(Stream digits, BigInt y, BigInt r, int i, int k$2, BigInt radixPowK$1, int maxSize$1) {
        while (true) {
            BigInt y_ = y.$times(BigInt$.MODULE$.int2bigInt(this.radix()));
            BigInt a = this.undigitize((Seq<Object>)((Stream)digits).take(k$2), this.radix());
            BigInt target = radixPowK$1.$times(r).$plus(a).$plus(y_.pow(k$2));
            int b = this.intSearch((Function1<Object, Object>)((Object)new Serializable(k$2, y_, target){
                public static final long serialVersionUID = 0L;
                private final int k$2;
                private final BigInt y_$1;
                private final BigInt target$1;

                public final boolean apply(int b) {
                    return this.apply$mcZI$sp(b);
                }

                public boolean apply$mcZI$sp(int b) {
                    return this.y_$1.$plus(BigInt$.MODULE$.int2bigInt(b)).pow(this.k$2).$less$eq(this.target$1);
                }
                {
                    this.k$2 = k$2;
                    this.y_$1 = y_$1;
                    this.target$1 = target$1;
                }
            }));
            BigInt ny = y_.$plus(BigInt$.MODULE$.int2bigInt(b));
            if (i == maxSize$1) {
                return new Tuple2<Integer, BigInt>(BoxesRunTime.boxToInteger(i), ny);
            }
            BigInt nr = target.$minus(ny.pow(k$2));
            ++i;
            r = nr;
            y = ny;
            digits = ((Stream)digits).drop(k$2);
        }
    }

    private final double abs$2(double n, Field f$3, Signed s$2) {
        return s$2.lt$mcD$sp(n, f$3.zero$mcD$sp()) ? f$3.negate$mcD$sp(n) : n;
    }

    private final float abs$3(float n, Field f$4, Signed s$3) {
        return s$3.lt$mcF$sp(n, f$4.zero$mcF$sp()) ? f$4.negate$mcF$sp(n) : n;
    }

    private package$() {
        MODULE$ = this;
        this.radix = 1000000000;
    }
}

