/*
 * Decompiled with CFR 0.152.
 */
package spire.math;

import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.LinearSeqOptimized;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.util.matching.Regex;
import spire.algebra.AdditiveMonoid$class;
import spire.algebra.AdditiveSemigroup;
import spire.algebra.AdditiveSemigroup$class;
import spire.algebra.Eq;
import spire.algebra.Eq$class;
import spire.algebra.Monoid;
import spire.algebra.MultiplicativeSemigroup$class;
import spire.algebra.Order;
import spire.algebra.Ring;
import spire.algebra.Semigroup;
import spire.algebra.Semiring;
import spire.algebra.Semiring$class;
import spire.math.Above;
import spire.math.All;
import spire.math.Below;
import spire.math.Bounded;
import spire.math.Empty;
import spire.math.Interval;
import spire.math.Point;
import spire.math.Rational;
import spire.math.Rational$;
import spire.math.interval.Bound;
import spire.math.interval.Closed;
import spire.math.interval.EmptyBound;
import spire.math.interval.Open;
import spire.math.interval.Unbound;

public final class Interval$ {
    public static final Interval$ MODULE$;
    private final Regex NullRe;
    private final Regex SingleRe;
    private final Regex PairRe;

    static {
        new Interval$();
    }

    public <A> Interval<A> withFlags(A lower, A upper, int flags, Order<A> evidence$8) {
        return evidence$8.lt(lower, upper) ? new Bounded<A>(lower, upper, flags, evidence$8) : (evidence$8.eqv(lower, upper) && flags == 0 ? new Point<A>(lower, evidence$8) : this.empty(evidence$8));
    }

    public <A> Interval<A> empty(Order<A> o) {
        return new Empty<A>(o);
    }

    public <A> Interval<A> point(A a, Order<A> evidence$9) {
        return new Point<A>(a, evidence$9);
    }

    public <A> Interval<A> zero(Order<A> o, Semiring<A> r) {
        return new Point(r.zero(), o);
    }

    public <A> Interval<A> all(Order<A> evidence$10) {
        return new All<A>(evidence$10);
    }

    public <A> Interval<A> apply(A lower, A upper, Order<A> evidence$11) {
        return this.closed(lower, upper, evidence$11);
    }

    public final int closedLowerFlags() {
        return 0;
    }

    public final int openLowerFlags() {
        return 1;
    }

    public final int closedUpperFlags() {
        return 0;
    }

    public final int openUpperFlags() {
        return 2;
    }

    public <A> Interval<A> fromOrderedBounds(Bound<A> lower, Bound<A> upper, Order<A> evidence$12) {
        Tuple2<Bound<A>, Bound<A>> tuple22;
        block14: {
            Interval<A> interval2;
            block5: {
                block13: {
                    block12: {
                        block11: {
                            block10: {
                                block9: {
                                    block8: {
                                        block7: {
                                            block6: {
                                                block4: {
                                                    tuple22 = new Tuple2<Bound<A>, Bound<A>>(lower, upper);
                                                    if (!(tuple22._1() instanceof EmptyBound) || !(tuple22._2() instanceof EmptyBound)) break block4;
                                                    interval2 = this.empty(evidence$12);
                                                    break block5;
                                                }
                                                if (!(tuple22._1() instanceof Closed)) break block6;
                                                Closed closed = (Closed)tuple22._1();
                                                if (!(tuple22._2() instanceof Closed)) break block6;
                                                Closed closed2 = (Closed)tuple22._2();
                                                interval2 = new Bounded(closed.a(), closed2.a(), 0 | 0, evidence$12);
                                                break block5;
                                            }
                                            if (!(tuple22._1() instanceof Open)) break block7;
                                            Open open = (Open)tuple22._1();
                                            if (!(tuple22._2() instanceof Open)) break block7;
                                            Open open2 = (Open)tuple22._2();
                                            interval2 = new Bounded(open.a(), open2.a(), 1 | 2, evidence$12);
                                            break block5;
                                        }
                                        if (!(tuple22._1() instanceof Unbound) || !(tuple22._2() instanceof Open)) break block8;
                                        Open open = (Open)tuple22._2();
                                        interval2 = this.below(open.a(), evidence$12);
                                        break block5;
                                    }
                                    if (!(tuple22._1() instanceof Open)) break block9;
                                    Open open = (Open)tuple22._1();
                                    if (!(tuple22._2() instanceof Unbound)) break block9;
                                    interval2 = this.above(open.a(), evidence$12);
                                    break block5;
                                }
                                if (!(tuple22._1() instanceof Unbound) || !(tuple22._2() instanceof Closed)) break block10;
                                Closed closed = (Closed)tuple22._2();
                                interval2 = this.atOrBelow(closed.a(), evidence$12);
                                break block5;
                            }
                            if (!(tuple22._1() instanceof Closed)) break block11;
                            Closed closed = (Closed)tuple22._1();
                            if (!(tuple22._2() instanceof Unbound)) break block11;
                            interval2 = this.atOrAbove(closed.a(), evidence$12);
                            break block5;
                        }
                        if (!(tuple22._1() instanceof Closed)) break block12;
                        Closed closed = (Closed)tuple22._1();
                        if (!(tuple22._2() instanceof Open)) break block12;
                        Open open = (Open)tuple22._2();
                        interval2 = new Bounded(closed.a(), open.a(), 0 | 2, evidence$12);
                        break block5;
                    }
                    if (!(tuple22._1() instanceof Open)) break block13;
                    Open open = (Open)tuple22._1();
                    if (!(tuple22._2() instanceof Closed)) break block13;
                    Closed closed = (Closed)tuple22._2();
                    interval2 = new Bounded(open.a(), closed.a(), 1 | 0, evidence$12);
                    break block5;
                }
                if (!(tuple22._1() instanceof Unbound) || !(tuple22._2() instanceof Unbound)) break block14;
                interval2 = this.all(evidence$12);
            }
            return interval2;
        }
        boolean bl = tuple22._1() instanceof EmptyBound ? true : tuple22._2() instanceof EmptyBound;
        if (bl) {
            throw new IllegalArgumentException("invalid empty bound");
        }
        throw new MatchError(tuple22);
    }

    public <A> Interval<A> fromBounds(Bound<A> lower, Bound<A> upper, Order<A> evidence$13) {
        Tuple2<Bound<A>, Bound<A>> tuple22;
        block14: {
            Interval<A> interval2;
            block5: {
                block13: {
                    block12: {
                        block11: {
                            block10: {
                                block9: {
                                    block8: {
                                        block7: {
                                            block6: {
                                                block4: {
                                                    tuple22 = new Tuple2<Bound<A>, Bound<A>>(lower, upper);
                                                    if (!(tuple22._1() instanceof EmptyBound) || !(tuple22._2() instanceof EmptyBound)) break block4;
                                                    interval2 = this.empty(evidence$13);
                                                    break block5;
                                                }
                                                if (!(tuple22._1() instanceof Closed)) break block6;
                                                Closed closed = (Closed)tuple22._1();
                                                if (!(tuple22._2() instanceof Closed)) break block6;
                                                Closed closed2 = (Closed)tuple22._2();
                                                interval2 = this.closed(closed.a(), closed2.a(), evidence$13);
                                                break block5;
                                            }
                                            if (!(tuple22._1() instanceof Open)) break block7;
                                            Open open = (Open)tuple22._1();
                                            if (!(tuple22._2() instanceof Open)) break block7;
                                            Open open2 = (Open)tuple22._2();
                                            interval2 = this.open(open.a(), open2.a(), evidence$13);
                                            break block5;
                                        }
                                        if (!(tuple22._1() instanceof Unbound) || !(tuple22._2() instanceof Open)) break block8;
                                        Open open = (Open)tuple22._2();
                                        interval2 = this.below(open.a(), evidence$13);
                                        break block5;
                                    }
                                    if (!(tuple22._1() instanceof Open)) break block9;
                                    Open open = (Open)tuple22._1();
                                    if (!(tuple22._2() instanceof Unbound)) break block9;
                                    interval2 = this.above(open.a(), evidence$13);
                                    break block5;
                                }
                                if (!(tuple22._1() instanceof Unbound) || !(tuple22._2() instanceof Closed)) break block10;
                                Closed closed = (Closed)tuple22._2();
                                interval2 = this.atOrBelow(closed.a(), evidence$13);
                                break block5;
                            }
                            if (!(tuple22._1() instanceof Closed)) break block11;
                            Closed closed = (Closed)tuple22._1();
                            if (!(tuple22._2() instanceof Unbound)) break block11;
                            interval2 = this.atOrAbove(closed.a(), evidence$13);
                            break block5;
                        }
                        if (!(tuple22._1() instanceof Closed)) break block12;
                        Closed closed = (Closed)tuple22._1();
                        if (!(tuple22._2() instanceof Open)) break block12;
                        Open open = (Open)tuple22._2();
                        interval2 = this.openUpper(closed.a(), open.a(), evidence$13);
                        break block5;
                    }
                    if (!(tuple22._1() instanceof Open)) break block13;
                    Open open = (Open)tuple22._1();
                    if (!(tuple22._2() instanceof Closed)) break block13;
                    Closed closed = (Closed)tuple22._2();
                    interval2 = this.openLower(open.a(), closed.a(), evidence$13);
                    break block5;
                }
                if (!(tuple22._1() instanceof Unbound) || !(tuple22._2() instanceof Unbound)) break block14;
                interval2 = this.all(evidence$13);
            }
            return interval2;
        }
        boolean bl = tuple22._1() instanceof EmptyBound ? true : tuple22._2() instanceof EmptyBound;
        if (bl) {
            throw new IllegalArgumentException("invalid empty bound");
        }
        throw new MatchError(tuple22);
    }

    public <A> Interval<A> closed(A lower, A upper, Order<A> evidence$14) {
        int c = evidence$14.compare(lower, upper);
        return c < 0 ? new Bounded<A>(lower, upper, 0, evidence$14) : (c == 0 ? new Point<A>(lower, evidence$14) : this.empty(evidence$14));
    }

    public <A> Interval<A> open(A lower, A upper, Order<A> evidence$15) {
        return evidence$15.lt(lower, upper) ? new Bounded<A>(lower, upper, 3, evidence$15) : this.empty(evidence$15);
    }

    public <A> Interval<A> openLower(A lower, A upper, Order<A> evidence$16) {
        return evidence$16.lt(lower, upper) ? new Bounded<A>(lower, upper, 1, evidence$16) : this.empty(evidence$16);
    }

    public <A> Interval<A> openUpper(A lower, A upper, Order<A> evidence$17) {
        return evidence$17.lt(lower, upper) ? new Bounded<A>(lower, upper, 2, evidence$17) : this.empty(evidence$17);
    }

    public <A> Interval<A> above(A a, Order<A> evidence$18) {
        return new Above<A>(a, 1, evidence$18);
    }

    public <A> Interval<A> below(A a, Order<A> evidence$19) {
        return new Below<A>(a, 2, evidence$19);
    }

    public <A> Interval<A> atOrAbove(A a, Order<A> evidence$20) {
        return new Above<A>(a, 0, evidence$20);
    }

    public <A> Interval<A> atOrBelow(A a, Order<A> evidence$21) {
        return new Below<A>(a, 0, evidence$21);
    }

    private Regex NullRe() {
        return this.NullRe;
    }

    private Regex SingleRe() {
        return this.SingleRe;
    }

    private Regex PairRe() {
        return this.PairRe;
    }

    public Interval<Rational> apply(String s2) {
        block5: {
            block15: {
                Interval<Rational> interval2;
                block3: {
                    Interval<Rational> interval3;
                    block7: {
                        Tuple4 tuple42;
                        block14: {
                            block13: {
                                block12: {
                                    block11: {
                                        block10: {
                                            block9: {
                                                block8: {
                                                    block6: {
                                                        block4: {
                                                            block2: {
                                                                Option<List<String>> option2 = this.NullRe().unapplySeq(s2);
                                                                if (option2.isEmpty() || option2.get() == null || ((LinearSeqOptimized)option2.get()).lengthCompare(0) != 0) break block2;
                                                                interval2 = this.empty(Rational$.MODULE$.RationalAlgebra());
                                                                break block3;
                                                            }
                                                            Option<List<String>> option3 = this.SingleRe().unapplySeq(s2);
                                                            if (option3.isEmpty() || option3.get() == null || ((LinearSeqOptimized)option3.get()).lengthCompare(1) != 0) break block4;
                                                            interval2 = this.point(Rational$.MODULE$.apply((String)((LinearSeqOptimized)option3.get()).apply(0)), Rational$.MODULE$.RationalAlgebra());
                                                            break block3;
                                                        }
                                                        Option<List<String>> option4 = this.PairRe().unapplySeq(s2);
                                                        if (option4.isEmpty() || option4.get() == null || ((LinearSeqOptimized)option4.get()).lengthCompare(4) != 0) break block5;
                                                        tuple42 = new Tuple4(((LinearSeqOptimized)option4.get()).apply(0), ((LinearSeqOptimized)option4.get()).apply(1), ((LinearSeqOptimized)option4.get()).apply(2), ((LinearSeqOptimized)option4.get()).apply(3));
                                                        if (!"(".equals(tuple42._1()) || !"-\u221e".equals(tuple42._2()) || !"\u221e".equals(tuple42._3()) || !")".equals(tuple42._4())) break block6;
                                                        interval3 = this.all(Rational$.MODULE$.RationalAlgebra());
                                                        break block7;
                                                    }
                                                    if (!"(".equals(tuple42._1()) || !"-\u221e".equals(tuple42._2()) || !")".equals(tuple42._4())) break block8;
                                                    interval3 = this.below(Rational$.MODULE$.apply((String)tuple42._3()), Rational$.MODULE$.RationalAlgebra());
                                                    break block7;
                                                }
                                                if (!"(".equals(tuple42._1()) || !"-\u221e".equals(tuple42._2()) || !"]".equals(tuple42._4())) break block9;
                                                interval3 = this.atOrBelow(Rational$.MODULE$.apply((String)tuple42._3()), Rational$.MODULE$.RationalAlgebra());
                                                break block7;
                                            }
                                            if (!"(".equals(tuple42._1()) || !"\u221e".equals(tuple42._3()) || !")".equals(tuple42._4())) break block10;
                                            interval3 = this.above(Rational$.MODULE$.apply((String)tuple42._2()), Rational$.MODULE$.RationalAlgebra());
                                            break block7;
                                        }
                                        if (!"[".equals(tuple42._1()) || !"\u221e".equals(tuple42._3()) || !")".equals(tuple42._4())) break block11;
                                        interval3 = this.atOrAbove(Rational$.MODULE$.apply((String)tuple42._2()), Rational$.MODULE$.RationalAlgebra());
                                        break block7;
                                    }
                                    if (!"[".equals(tuple42._1()) || !"]".equals(tuple42._4())) break block12;
                                    interval3 = this.closed(Rational$.MODULE$.apply((String)tuple42._2()), Rational$.MODULE$.apply((String)tuple42._3()), Rational$.MODULE$.RationalAlgebra());
                                    break block7;
                                }
                                if (!"(".equals(tuple42._1()) || !")".equals(tuple42._4())) break block13;
                                interval3 = this.open(Rational$.MODULE$.apply((String)tuple42._2()), Rational$.MODULE$.apply((String)tuple42._3()), Rational$.MODULE$.RationalAlgebra());
                                break block7;
                            }
                            if (!"[".equals(tuple42._1()) || !")".equals(tuple42._4())) break block14;
                            interval3 = this.openUpper(Rational$.MODULE$.apply((String)tuple42._2()), Rational$.MODULE$.apply((String)tuple42._3()), Rational$.MODULE$.RationalAlgebra());
                            break block7;
                        }
                        if (!"(".equals(tuple42._1()) || !"]".equals(tuple42._4())) break block15;
                        interval3 = this.openLower(Rational$.MODULE$.apply((String)tuple42._2()), Rational$.MODULE$.apply((String)tuple42._3()), Rational$.MODULE$.RationalAlgebra());
                    }
                    interval2 = interval3;
                }
                return interval2;
            }
            throw new NumberFormatException(new StringBuilder().append((Object)"Impossible: ").append((Object)s2).toString());
        }
        throw new NumberFormatException(new StringBuilder().append((Object)"For input string: ").append((Object)s2).toString());
    }

    public <A> Eq<Interval<A>> eq(Eq<A> evidence$22) {
        return new Eq<Interval<A>>(){

            public boolean eqv$mcZ$sp(boolean x, boolean y) {
                return Eq$class.eqv$mcZ$sp(this, x, y);
            }

            public boolean eqv$mcB$sp(byte x, byte y) {
                return Eq$class.eqv$mcB$sp(this, x, y);
            }

            public boolean eqv$mcC$sp(char x, char y) {
                return Eq$class.eqv$mcC$sp(this, x, y);
            }

            public boolean eqv$mcD$sp(double x, double y) {
                return Eq$class.eqv$mcD$sp(this, x, y);
            }

            public boolean eqv$mcF$sp(float x, float y) {
                return Eq$class.eqv$mcF$sp(this, x, y);
            }

            public boolean eqv$mcI$sp(int x, int y) {
                return Eq$class.eqv$mcI$sp(this, x, y);
            }

            public boolean eqv$mcJ$sp(long x, long y) {
                return Eq$class.eqv$mcJ$sp(this, x, y);
            }

            public boolean eqv$mcS$sp(short x, short y) {
                return Eq$class.eqv$mcS$sp(this, x, y);
            }

            public boolean eqv$mcV$sp(BoxedUnit x, BoxedUnit y) {
                return Eq$class.eqv$mcV$sp(this, x, y);
            }

            public boolean neqv(Object x, Object y) {
                return Eq$class.neqv(this, x, y);
            }

            public boolean neqv$mcZ$sp(boolean x, boolean y) {
                return Eq$class.neqv$mcZ$sp(this, x, y);
            }

            public boolean neqv$mcB$sp(byte x, byte y) {
                return Eq$class.neqv$mcB$sp(this, x, y);
            }

            public boolean neqv$mcC$sp(char x, char y) {
                return Eq$class.neqv$mcC$sp(this, x, y);
            }

            public boolean neqv$mcD$sp(double x, double y) {
                return Eq$class.neqv$mcD$sp(this, x, y);
            }

            public boolean neqv$mcF$sp(float x, float y) {
                return Eq$class.neqv$mcF$sp(this, x, y);
            }

            public boolean neqv$mcI$sp(int x, int y) {
                return Eq$class.neqv$mcI$sp(this, x, y);
            }

            public boolean neqv$mcJ$sp(long x, long y) {
                return Eq$class.neqv$mcJ$sp(this, x, y);
            }

            public boolean neqv$mcS$sp(short x, short y) {
                return Eq$class.neqv$mcS$sp(this, x, y);
            }

            public boolean neqv$mcV$sp(BoxedUnit x, BoxedUnit y) {
                return Eq$class.neqv$mcV$sp(this, x, y);
            }

            public <B> Eq<B> on(Function1<B, Interval<A>> f) {
                return Eq$class.on(this, f);
            }

            public <B> Eq<B> on$mcZ$sp(Function1<B, Object> f) {
                return Eq$class.on$mcZ$sp(this, f);
            }

            public <B> Eq<B> on$mcB$sp(Function1<B, Object> f) {
                return Eq$class.on$mcB$sp(this, f);
            }

            public <B> Eq<B> on$mcC$sp(Function1<B, Object> f) {
                return Eq$class.on$mcC$sp(this, f);
            }

            public <B> Eq<B> on$mcD$sp(Function1<B, Object> f) {
                return Eq$class.on$mcD$sp(this, f);
            }

            public <B> Eq<B> on$mcF$sp(Function1<B, Object> f) {
                return Eq$class.on$mcF$sp(this, f);
            }

            public <B> Eq<B> on$mcI$sp(Function1<B, Object> f) {
                return Eq$class.on$mcI$sp(this, f);
            }

            public <B> Eq<B> on$mcJ$sp(Function1<B, Object> f) {
                return Eq$class.on$mcJ$sp(this, f);
            }

            public <B> Eq<B> on$mcS$sp(Function1<B, Object> f) {
                return Eq$class.on$mcS$sp(this, f);
            }

            public <B> Eq<B> on$mcV$sp(Function1<B, BoxedUnit> f) {
                return Eq$class.on$mcV$sp(this, f);
            }

            public Eq<Object> on$mZc$sp(Function1<Object, Interval<A>> f) {
                return Eq$class.on$mZc$sp(this, f);
            }

            public Eq<Object> on$mZcZ$sp(Function1<Object, Object> f) {
                return Eq$class.on$mZcZ$sp(this, f);
            }

            public Eq<Object> on$mZcB$sp(Function1<Object, Object> f) {
                return Eq$class.on$mZcB$sp(this, f);
            }

            public Eq<Object> on$mZcC$sp(Function1<Object, Object> f) {
                return Eq$class.on$mZcC$sp(this, f);
            }

            public Eq<Object> on$mZcD$sp(Function1<Object, Object> f) {
                return Eq$class.on$mZcD$sp(this, f);
            }

            public Eq<Object> on$mZcF$sp(Function1<Object, Object> f) {
                return Eq$class.on$mZcF$sp(this, f);
            }

            public Eq<Object> on$mZcI$sp(Function1<Object, Object> f) {
                return Eq$class.on$mZcI$sp(this, f);
            }

            public Eq<Object> on$mZcJ$sp(Function1<Object, Object> f) {
                return Eq$class.on$mZcJ$sp(this, f);
            }

            public Eq<Object> on$mZcS$sp(Function1<Object, Object> f) {
                return Eq$class.on$mZcS$sp(this, f);
            }

            public Eq<Object> on$mZcV$sp(Function1<Object, BoxedUnit> f) {
                return Eq$class.on$mZcV$sp(this, f);
            }

            public Eq<Object> on$mBc$sp(Function1<Object, Interval<A>> f) {
                return Eq$class.on$mBc$sp(this, f);
            }

            public Eq<Object> on$mBcZ$sp(Function1<Object, Object> f) {
                return Eq$class.on$mBcZ$sp(this, f);
            }

            public Eq<Object> on$mBcB$sp(Function1<Object, Object> f) {
                return Eq$class.on$mBcB$sp(this, f);
            }

            public Eq<Object> on$mBcC$sp(Function1<Object, Object> f) {
                return Eq$class.on$mBcC$sp(this, f);
            }

            public Eq<Object> on$mBcD$sp(Function1<Object, Object> f) {
                return Eq$class.on$mBcD$sp(this, f);
            }

            public Eq<Object> on$mBcF$sp(Function1<Object, Object> f) {
                return Eq$class.on$mBcF$sp(this, f);
            }

            public Eq<Object> on$mBcI$sp(Function1<Object, Object> f) {
                return Eq$class.on$mBcI$sp(this, f);
            }

            public Eq<Object> on$mBcJ$sp(Function1<Object, Object> f) {
                return Eq$class.on$mBcJ$sp(this, f);
            }

            public Eq<Object> on$mBcS$sp(Function1<Object, Object> f) {
                return Eq$class.on$mBcS$sp(this, f);
            }

            public Eq<Object> on$mBcV$sp(Function1<Object, BoxedUnit> f) {
                return Eq$class.on$mBcV$sp(this, f);
            }

            public Eq<Object> on$mCc$sp(Function1<Object, Interval<A>> f) {
                return Eq$class.on$mCc$sp(this, f);
            }

            public Eq<Object> on$mCcZ$sp(Function1<Object, Object> f) {
                return Eq$class.on$mCcZ$sp(this, f);
            }

            public Eq<Object> on$mCcB$sp(Function1<Object, Object> f) {
                return Eq$class.on$mCcB$sp(this, f);
            }

            public Eq<Object> on$mCcC$sp(Function1<Object, Object> f) {
                return Eq$class.on$mCcC$sp(this, f);
            }

            public Eq<Object> on$mCcD$sp(Function1<Object, Object> f) {
                return Eq$class.on$mCcD$sp(this, f);
            }

            public Eq<Object> on$mCcF$sp(Function1<Object, Object> f) {
                return Eq$class.on$mCcF$sp(this, f);
            }

            public Eq<Object> on$mCcI$sp(Function1<Object, Object> f) {
                return Eq$class.on$mCcI$sp(this, f);
            }

            public Eq<Object> on$mCcJ$sp(Function1<Object, Object> f) {
                return Eq$class.on$mCcJ$sp(this, f);
            }

            public Eq<Object> on$mCcS$sp(Function1<Object, Object> f) {
                return Eq$class.on$mCcS$sp(this, f);
            }

            public Eq<Object> on$mCcV$sp(Function1<Object, BoxedUnit> f) {
                return Eq$class.on$mCcV$sp(this, f);
            }

            public Eq<Object> on$mDc$sp(Function1<Object, Interval<A>> f) {
                return Eq$class.on$mDc$sp(this, f);
            }

            public Eq<Object> on$mDcZ$sp(Function1<Object, Object> f) {
                return Eq$class.on$mDcZ$sp(this, f);
            }

            public Eq<Object> on$mDcB$sp(Function1<Object, Object> f) {
                return Eq$class.on$mDcB$sp(this, f);
            }

            public Eq<Object> on$mDcC$sp(Function1<Object, Object> f) {
                return Eq$class.on$mDcC$sp(this, f);
            }

            public Eq<Object> on$mDcD$sp(Function1<Object, Object> f) {
                return Eq$class.on$mDcD$sp(this, f);
            }

            public Eq<Object> on$mDcF$sp(Function1<Object, Object> f) {
                return Eq$class.on$mDcF$sp(this, f);
            }

            public Eq<Object> on$mDcI$sp(Function1<Object, Object> f) {
                return Eq$class.on$mDcI$sp(this, f);
            }

            public Eq<Object> on$mDcJ$sp(Function1<Object, Object> f) {
                return Eq$class.on$mDcJ$sp(this, f);
            }

            public Eq<Object> on$mDcS$sp(Function1<Object, Object> f) {
                return Eq$class.on$mDcS$sp(this, f);
            }

            public Eq<Object> on$mDcV$sp(Function1<Object, BoxedUnit> f) {
                return Eq$class.on$mDcV$sp(this, f);
            }

            public Eq<Object> on$mFc$sp(Function1<Object, Interval<A>> f) {
                return Eq$class.on$mFc$sp(this, f);
            }

            public Eq<Object> on$mFcZ$sp(Function1<Object, Object> f) {
                return Eq$class.on$mFcZ$sp(this, f);
            }

            public Eq<Object> on$mFcB$sp(Function1<Object, Object> f) {
                return Eq$class.on$mFcB$sp(this, f);
            }

            public Eq<Object> on$mFcC$sp(Function1<Object, Object> f) {
                return Eq$class.on$mFcC$sp(this, f);
            }

            public Eq<Object> on$mFcD$sp(Function1<Object, Object> f) {
                return Eq$class.on$mFcD$sp(this, f);
            }

            public Eq<Object> on$mFcF$sp(Function1<Object, Object> f) {
                return Eq$class.on$mFcF$sp(this, f);
            }

            public Eq<Object> on$mFcI$sp(Function1<Object, Object> f) {
                return Eq$class.on$mFcI$sp(this, f);
            }

            public Eq<Object> on$mFcJ$sp(Function1<Object, Object> f) {
                return Eq$class.on$mFcJ$sp(this, f);
            }

            public Eq<Object> on$mFcS$sp(Function1<Object, Object> f) {
                return Eq$class.on$mFcS$sp(this, f);
            }

            public Eq<Object> on$mFcV$sp(Function1<Object, BoxedUnit> f) {
                return Eq$class.on$mFcV$sp(this, f);
            }

            public Eq<Object> on$mIc$sp(Function1<Object, Interval<A>> f) {
                return Eq$class.on$mIc$sp(this, f);
            }

            public Eq<Object> on$mIcZ$sp(Function1<Object, Object> f) {
                return Eq$class.on$mIcZ$sp(this, f);
            }

            public Eq<Object> on$mIcB$sp(Function1<Object, Object> f) {
                return Eq$class.on$mIcB$sp(this, f);
            }

            public Eq<Object> on$mIcC$sp(Function1<Object, Object> f) {
                return Eq$class.on$mIcC$sp(this, f);
            }

            public Eq<Object> on$mIcD$sp(Function1<Object, Object> f) {
                return Eq$class.on$mIcD$sp(this, f);
            }

            public Eq<Object> on$mIcF$sp(Function1<Object, Object> f) {
                return Eq$class.on$mIcF$sp(this, f);
            }

            public Eq<Object> on$mIcI$sp(Function1<Object, Object> f) {
                return Eq$class.on$mIcI$sp(this, f);
            }

            public Eq<Object> on$mIcJ$sp(Function1<Object, Object> f) {
                return Eq$class.on$mIcJ$sp(this, f);
            }

            public Eq<Object> on$mIcS$sp(Function1<Object, Object> f) {
                return Eq$class.on$mIcS$sp(this, f);
            }

            public Eq<Object> on$mIcV$sp(Function1<Object, BoxedUnit> f) {
                return Eq$class.on$mIcV$sp(this, f);
            }

            public Eq<Object> on$mJc$sp(Function1<Object, Interval<A>> f) {
                return Eq$class.on$mJc$sp(this, f);
            }

            public Eq<Object> on$mJcZ$sp(Function1<Object, Object> f) {
                return Eq$class.on$mJcZ$sp(this, f);
            }

            public Eq<Object> on$mJcB$sp(Function1<Object, Object> f) {
                return Eq$class.on$mJcB$sp(this, f);
            }

            public Eq<Object> on$mJcC$sp(Function1<Object, Object> f) {
                return Eq$class.on$mJcC$sp(this, f);
            }

            public Eq<Object> on$mJcD$sp(Function1<Object, Object> f) {
                return Eq$class.on$mJcD$sp(this, f);
            }

            public Eq<Object> on$mJcF$sp(Function1<Object, Object> f) {
                return Eq$class.on$mJcF$sp(this, f);
            }

            public Eq<Object> on$mJcI$sp(Function1<Object, Object> f) {
                return Eq$class.on$mJcI$sp(this, f);
            }

            public Eq<Object> on$mJcJ$sp(Function1<Object, Object> f) {
                return Eq$class.on$mJcJ$sp(this, f);
            }

            public Eq<Object> on$mJcS$sp(Function1<Object, Object> f) {
                return Eq$class.on$mJcS$sp(this, f);
            }

            public Eq<Object> on$mJcV$sp(Function1<Object, BoxedUnit> f) {
                return Eq$class.on$mJcV$sp(this, f);
            }

            public Eq<Object> on$mSc$sp(Function1<Object, Interval<A>> f) {
                return Eq$class.on$mSc$sp(this, f);
            }

            public Eq<Object> on$mScZ$sp(Function1<Object, Object> f) {
                return Eq$class.on$mScZ$sp(this, f);
            }

            public Eq<Object> on$mScB$sp(Function1<Object, Object> f) {
                return Eq$class.on$mScB$sp(this, f);
            }

            public Eq<Object> on$mScC$sp(Function1<Object, Object> f) {
                return Eq$class.on$mScC$sp(this, f);
            }

            public Eq<Object> on$mScD$sp(Function1<Object, Object> f) {
                return Eq$class.on$mScD$sp(this, f);
            }

            public Eq<Object> on$mScF$sp(Function1<Object, Object> f) {
                return Eq$class.on$mScF$sp(this, f);
            }

            public Eq<Object> on$mScI$sp(Function1<Object, Object> f) {
                return Eq$class.on$mScI$sp(this, f);
            }

            public Eq<Object> on$mScJ$sp(Function1<Object, Object> f) {
                return Eq$class.on$mScJ$sp(this, f);
            }

            public Eq<Object> on$mScS$sp(Function1<Object, Object> f) {
                return Eq$class.on$mScS$sp(this, f);
            }

            public Eq<Object> on$mScV$sp(Function1<Object, BoxedUnit> f) {
                return Eq$class.on$mScV$sp(this, f);
            }

            public Eq<BoxedUnit> on$mVc$sp(Function1<BoxedUnit, Interval<A>> f) {
                return Eq$class.on$mVc$sp(this, f);
            }

            public Eq<BoxedUnit> on$mVcZ$sp(Function1<BoxedUnit, Object> f) {
                return Eq$class.on$mVcZ$sp(this, f);
            }

            public Eq<BoxedUnit> on$mVcB$sp(Function1<BoxedUnit, Object> f) {
                return Eq$class.on$mVcB$sp(this, f);
            }

            public Eq<BoxedUnit> on$mVcC$sp(Function1<BoxedUnit, Object> f) {
                return Eq$class.on$mVcC$sp(this, f);
            }

            public Eq<BoxedUnit> on$mVcD$sp(Function1<BoxedUnit, Object> f) {
                return Eq$class.on$mVcD$sp(this, f);
            }

            public Eq<BoxedUnit> on$mVcF$sp(Function1<BoxedUnit, Object> f) {
                return Eq$class.on$mVcF$sp(this, f);
            }

            public Eq<BoxedUnit> on$mVcI$sp(Function1<BoxedUnit, Object> f) {
                return Eq$class.on$mVcI$sp(this, f);
            }

            public Eq<BoxedUnit> on$mVcJ$sp(Function1<BoxedUnit, Object> f) {
                return Eq$class.on$mVcJ$sp(this, f);
            }

            public Eq<BoxedUnit> on$mVcS$sp(Function1<BoxedUnit, Object> f) {
                return Eq$class.on$mVcS$sp(this, f);
            }

            public Eq<BoxedUnit> on$mVcV$sp(Function1<BoxedUnit, BoxedUnit> f) {
                return Eq$class.on$mVcV$sp(this, f);
            }

            public boolean eqv(Interval<A> x, Interval<A> y) {
                Interval<A> interval2 = x;
                return !(interval2 != null ? !interval2.equals(y) : y != null);
            }
            {
                Eq$class.$init$(this);
            }
        };
    }

    public <A> Semiring<Interval<A>> semiring(Ring<A> ev, Order<A> o) {
        return new Semiring<Interval<A>>(ev, o){
            private final Ring ev$3;
            private final Order o$1;

            public byte pow$mcB$sp(byte a, int n) {
                return Semiring$class.pow$mcB$sp(this, a, n);
            }

            public double pow$mcD$sp(double a, int n) {
                return Semiring$class.pow$mcD$sp(this, a, n);
            }

            public float pow$mcF$sp(float a, int n) {
                return Semiring$class.pow$mcF$sp(this, a, n);
            }

            public int pow$mcI$sp(int a, int n) {
                return Semiring$class.pow$mcI$sp(this, a, n);
            }

            public long pow$mcJ$sp(long a, int n) {
                return Semiring$class.pow$mcJ$sp(this, a, n);
            }

            public short pow$mcS$sp(short a, int n) {
                return Semiring$class.pow$mcS$sp(this, a, n);
            }

            public Semigroup<Interval<A>> multiplicative() {
                return MultiplicativeSemigroup$class.multiplicative(this);
            }

            public Semigroup<Object> multiplicative$mcB$sp() {
                return MultiplicativeSemigroup$class.multiplicative$mcB$sp(this);
            }

            public Semigroup<Object> multiplicative$mcD$sp() {
                return MultiplicativeSemigroup$class.multiplicative$mcD$sp(this);
            }

            public Semigroup<Object> multiplicative$mcF$sp() {
                return MultiplicativeSemigroup$class.multiplicative$mcF$sp(this);
            }

            public Semigroup<Object> multiplicative$mcI$sp() {
                return MultiplicativeSemigroup$class.multiplicative$mcI$sp(this);
            }

            public Semigroup<Object> multiplicative$mcJ$sp() {
                return MultiplicativeSemigroup$class.multiplicative$mcJ$sp(this);
            }

            public Semigroup<Object> multiplicative$mcS$sp() {
                return MultiplicativeSemigroup$class.multiplicative$mcS$sp(this);
            }

            public byte times$mcB$sp(byte x, byte y) {
                return MultiplicativeSemigroup$class.times$mcB$sp(this, x, y);
            }

            public double times$mcD$sp(double x, double y) {
                return MultiplicativeSemigroup$class.times$mcD$sp(this, x, y);
            }

            public float times$mcF$sp(float x, float y) {
                return MultiplicativeSemigroup$class.times$mcF$sp(this, x, y);
            }

            public int times$mcI$sp(int x, int y) {
                return MultiplicativeSemigroup$class.times$mcI$sp(this, x, y);
            }

            public long times$mcJ$sp(long x, long y) {
                return MultiplicativeSemigroup$class.times$mcJ$sp(this, x, y);
            }

            public short times$mcS$sp(short x, short y) {
                return MultiplicativeSemigroup$class.times$mcS$sp(this, x, y);
            }

            public Object prodn(Object a, int n) {
                return MultiplicativeSemigroup$class.prodn(this, a, n);
            }

            public byte prodn$mcB$sp(byte a, int n) {
                return MultiplicativeSemigroup$class.prodn$mcB$sp(this, a, n);
            }

            public double prodn$mcD$sp(double a, int n) {
                return MultiplicativeSemigroup$class.prodn$mcD$sp(this, a, n);
            }

            public float prodn$mcF$sp(float a, int n) {
                return MultiplicativeSemigroup$class.prodn$mcF$sp(this, a, n);
            }

            public int prodn$mcI$sp(int a, int n) {
                return MultiplicativeSemigroup$class.prodn$mcI$sp(this, a, n);
            }

            public long prodn$mcJ$sp(long a, int n) {
                return MultiplicativeSemigroup$class.prodn$mcJ$sp(this, a, n);
            }

            public short prodn$mcS$sp(short a, int n) {
                return MultiplicativeSemigroup$class.prodn$mcS$sp(this, a, n);
            }

            public Object prodnAboveOne(Object a, int n) {
                return MultiplicativeSemigroup$class.prodnAboveOne(this, a, n);
            }

            public byte prodnAboveOne$mcB$sp(byte a, int n) {
                return MultiplicativeSemigroup$class.prodnAboveOne$mcB$sp(this, a, n);
            }

            public double prodnAboveOne$mcD$sp(double a, int n) {
                return MultiplicativeSemigroup$class.prodnAboveOne$mcD$sp(this, a, n);
            }

            public float prodnAboveOne$mcF$sp(float a, int n) {
                return MultiplicativeSemigroup$class.prodnAboveOne$mcF$sp(this, a, n);
            }

            public int prodnAboveOne$mcI$sp(int a, int n) {
                return MultiplicativeSemigroup$class.prodnAboveOne$mcI$sp(this, a, n);
            }

            public long prodnAboveOne$mcJ$sp(long a, int n) {
                return MultiplicativeSemigroup$class.prodnAboveOne$mcJ$sp(this, a, n);
            }

            public short prodnAboveOne$mcS$sp(short a, int n) {
                return MultiplicativeSemigroup$class.prodnAboveOne$mcS$sp(this, a, n);
            }

            public Option<Interval<A>> prodOption(TraversableOnce<Interval<A>> as) {
                return MultiplicativeSemigroup$class.prodOption(this, as);
            }

            public Monoid<Interval<A>> additive() {
                return AdditiveMonoid$class.additive(this);
            }

            public Monoid<Object> additive$mcB$sp() {
                return AdditiveMonoid$class.additive$mcB$sp(this);
            }

            public Monoid<Object> additive$mcD$sp() {
                return AdditiveMonoid$class.additive$mcD$sp(this);
            }

            public Monoid<Object> additive$mcF$sp() {
                return AdditiveMonoid$class.additive$mcF$sp(this);
            }

            public Monoid<Object> additive$mcI$sp() {
                return AdditiveMonoid$class.additive$mcI$sp(this);
            }

            public Monoid<Object> additive$mcJ$sp() {
                return AdditiveMonoid$class.additive$mcJ$sp(this);
            }

            public Monoid<Object> additive$mcS$sp() {
                return AdditiveMonoid$class.additive$mcS$sp(this);
            }

            public byte zero$mcB$sp() {
                return AdditiveMonoid$class.zero$mcB$sp(this);
            }

            public double zero$mcD$sp() {
                return AdditiveMonoid$class.zero$mcD$sp(this);
            }

            public float zero$mcF$sp() {
                return AdditiveMonoid$class.zero$mcF$sp(this);
            }

            public int zero$mcI$sp() {
                return AdditiveMonoid$class.zero$mcI$sp(this);
            }

            public long zero$mcJ$sp() {
                return AdditiveMonoid$class.zero$mcJ$sp(this);
            }

            public short zero$mcS$sp() {
                return AdditiveMonoid$class.zero$mcS$sp(this);
            }

            public boolean isZero(Object a, Eq ev) {
                return AdditiveMonoid$class.isZero(this, a, ev);
            }

            public boolean isZero$mcB$sp(byte a, Eq<Object> ev) {
                return AdditiveMonoid$class.isZero$mcB$sp(this, a, ev);
            }

            public boolean isZero$mcD$sp(double a, Eq<Object> ev) {
                return AdditiveMonoid$class.isZero$mcD$sp(this, a, ev);
            }

            public boolean isZero$mcF$sp(float a, Eq<Object> ev) {
                return AdditiveMonoid$class.isZero$mcF$sp(this, a, ev);
            }

            public boolean isZero$mcI$sp(int a, Eq<Object> ev) {
                return AdditiveMonoid$class.isZero$mcI$sp(this, a, ev);
            }

            public boolean isZero$mcJ$sp(long a, Eq<Object> ev) {
                return AdditiveMonoid$class.isZero$mcJ$sp(this, a, ev);
            }

            public boolean isZero$mcS$sp(short a, Eq<Object> ev) {
                return AdditiveMonoid$class.isZero$mcS$sp(this, a, ev);
            }

            public Object sumn(Object a, int n) {
                return AdditiveMonoid$class.sumn(this, a, n);
            }

            public byte sumn$mcB$sp(byte a, int n) {
                return AdditiveMonoid$class.sumn$mcB$sp(this, a, n);
            }

            public double sumn$mcD$sp(double a, int n) {
                return AdditiveMonoid$class.sumn$mcD$sp(this, a, n);
            }

            public float sumn$mcF$sp(float a, int n) {
                return AdditiveMonoid$class.sumn$mcF$sp(this, a, n);
            }

            public int sumn$mcI$sp(int a, int n) {
                return AdditiveMonoid$class.sumn$mcI$sp(this, a, n);
            }

            public long sumn$mcJ$sp(long a, int n) {
                return AdditiveMonoid$class.sumn$mcJ$sp(this, a, n);
            }

            public short sumn$mcS$sp(short a, int n) {
                return AdditiveMonoid$class.sumn$mcS$sp(this, a, n);
            }

            public Object sum(TraversableOnce as) {
                return AdditiveMonoid$class.sum(this, as);
            }

            public byte sum$mcB$sp(TraversableOnce<Object> as) {
                return AdditiveMonoid$class.sum$mcB$sp(this, as);
            }

            public double sum$mcD$sp(TraversableOnce<Object> as) {
                return AdditiveMonoid$class.sum$mcD$sp(this, as);
            }

            public float sum$mcF$sp(TraversableOnce<Object> as) {
                return AdditiveMonoid$class.sum$mcF$sp(this, as);
            }

            public int sum$mcI$sp(TraversableOnce<Object> as) {
                return AdditiveMonoid$class.sum$mcI$sp(this, as);
            }

            public long sum$mcJ$sp(TraversableOnce<Object> as) {
                return AdditiveMonoid$class.sum$mcJ$sp(this, as);
            }

            public short sum$mcS$sp(TraversableOnce<Object> as) {
                return AdditiveMonoid$class.sum$mcS$sp(this, as);
            }

            public byte plus$mcB$sp(byte x, byte y) {
                return AdditiveSemigroup$class.plus$mcB$sp(this, x, y);
            }

            public double plus$mcD$sp(double x, double y) {
                return AdditiveSemigroup$class.plus$mcD$sp(this, x, y);
            }

            public float plus$mcF$sp(float x, float y) {
                return AdditiveSemigroup$class.plus$mcF$sp(this, x, y);
            }

            public int plus$mcI$sp(int x, int y) {
                return AdditiveSemigroup$class.plus$mcI$sp(this, x, y);
            }

            public long plus$mcJ$sp(long x, long y) {
                return AdditiveSemigroup$class.plus$mcJ$sp(this, x, y);
            }

            public short plus$mcS$sp(short x, short y) {
                return AdditiveSemigroup$class.plus$mcS$sp(this, x, y);
            }

            public Object sumnAboveOne(Object a, int n) {
                return AdditiveSemigroup$class.sumnAboveOne(this, a, n);
            }

            public byte sumnAboveOne$mcB$sp(byte a, int n) {
                return AdditiveSemigroup$class.sumnAboveOne$mcB$sp(this, a, n);
            }

            public double sumnAboveOne$mcD$sp(double a, int n) {
                return AdditiveSemigroup$class.sumnAboveOne$mcD$sp(this, a, n);
            }

            public float sumnAboveOne$mcF$sp(float a, int n) {
                return AdditiveSemigroup$class.sumnAboveOne$mcF$sp(this, a, n);
            }

            public int sumnAboveOne$mcI$sp(int a, int n) {
                return AdditiveSemigroup$class.sumnAboveOne$mcI$sp(this, a, n);
            }

            public long sumnAboveOne$mcJ$sp(long a, int n) {
                return AdditiveSemigroup$class.sumnAboveOne$mcJ$sp(this, a, n);
            }

            public short sumnAboveOne$mcS$sp(short a, int n) {
                return AdditiveSemigroup$class.sumnAboveOne$mcS$sp(this, a, n);
            }

            public Option<Interval<A>> sumOption(TraversableOnce<Interval<A>> as) {
                return AdditiveSemigroup$class.sumOption(this, as);
            }

            public Interval<A> zero() {
                return Interval$.MODULE$.point(this.ev$3.zero(), this.o$1);
            }

            public Interval<A> plus(Interval<A> x, Interval<A> y) {
                return x.$plus(y, (AdditiveSemigroup<Interval<A>>)this.ev$3);
            }

            public Interval<A> times(Interval<A> x, Interval<A> y) {
                return x.$times(y, (Semiring<Interval<A>>)this.ev$3);
            }

            public Interval<A> pow(Interval<A> x, int k) {
                return x.pow(k, this.ev$3);
            }
            {
                this.ev$3 = ev$3;
                this.o$1 = o$1;
                AdditiveSemigroup$class.$init$(this);
                AdditiveMonoid$class.$init$(this);
                MultiplicativeSemigroup$class.$init$(this);
                Semiring$class.$init$(this);
            }
        };
    }

    private Interval$() {
        MODULE$ = this;
        Predef$ predef$ = Predef$.MODULE$;
        this.NullRe = new StringOps("^ *\\( *\u00d8 *\\) *$").r();
        Predef$ predef$2 = Predef$.MODULE$;
        this.SingleRe = new StringOps("^ *\\[ *([^,]+) *\\] *$").r();
        Predef$ predef$3 = Predef$.MODULE$;
        this.PairRe = new StringOps("^ *(\\[|\\() *(.+?) *, *(.+?) *(\\]|\\)) *$").r();
    }
}

