/*
 * Decompiled with CFR 0.152.
 */
package spire.math.poly;

import java.util.Arrays;
import scala.Function2;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.runtime.BoxesRunTime;
import spire.algebra.Eq;
import spire.algebra.Field;
import spire.algebra.Rig;
import spire.algebra.Ring;
import spire.algebra.Rng;
import spire.algebra.Semiring;
import spire.math.Polynomial;
import spire.math.Polynomial$;
import spire.math.Polynomial$mcD$sp;
import spire.math.Polynomial$mcD$sp$class;
import spire.math.poly.PolyDense;
import spire.math.poly.PolySparse;
import spire.math.poly.PolySparse$;
import spire.math.poly.Term;
import spire.syntax.LiteralIntMultiplicativeSemigroupOps$;
import spire.syntax.package$field$;

public class PolySparse$mcD$sp
extends PolySparse<Object>
implements Polynomial$mcD$sp {
    public final double[] coeff$mcD$sp;

    @Override
    public List<Term<Object>> terms(Semiring<Object> ring, Eq<Object> eq2) {
        return Polynomial$mcD$sp$class.terms(this, ring, eq2);
    }

    @Override
    public List<Term<Object>> terms$mcD$sp(Semiring<Object> ring, Eq<Object> eq2) {
        return Polynomial$mcD$sp$class.terms$mcD$sp(this, ring, eq2);
    }

    @Override
    public Map<Object, Object> data(Semiring<Object> ring, Eq<Object> eq2) {
        return Polynomial$mcD$sp$class.data(this, ring, eq2);
    }

    @Override
    public Map<Object, Object> data$mcD$sp(Semiring<Object> ring, Eq<Object> eq2) {
        return Polynomial$mcD$sp$class.data$mcD$sp(this, ring, eq2);
    }

    @Override
    public Term<Object> maxTerm(Semiring<Object> ring) {
        return Polynomial$mcD$sp$class.maxTerm(this, ring);
    }

    @Override
    public Term<Object> maxTerm$mcD$sp(Semiring<Object> ring) {
        return Polynomial$mcD$sp$class.maxTerm$mcD$sp(this, ring);
    }

    @Override
    public Polynomial<Object> compose(Polynomial<Object> y, Rig<Object> ring, Eq<Object> eq2) {
        return Polynomial$mcD$sp$class.compose(this, y, ring, eq2);
    }

    @Override
    public Polynomial<Object> compose$mcD$sp(Polynomial<Object> y, Rig<Object> ring, Eq<Object> eq2) {
        return Polynomial$mcD$sp$class.compose$mcD$sp(this, y, ring, eq2);
    }

    @Override
    public Polynomial<Object> monic(Field<Object> f, Eq<Object> eq2) {
        return Polynomial$mcD$sp$class.monic(this, f, eq2);
    }

    @Override
    public Polynomial<Object> monic$mcD$sp(Field<Object> f, Eq<Object> eq2) {
        return Polynomial$mcD$sp$class.monic$mcD$sp(this, f, eq2);
    }

    @Override
    public Polynomial<Object> $minus(Polynomial<Object> rhs, Rng<Object> ring, Eq<Object> eq2) {
        return Polynomial$mcD$sp$class.$minus(this, rhs, ring, eq2);
    }

    @Override
    public Polynomial<Object> $minus$mcD$sp(Polynomial<Object> rhs, Rng<Object> ring, Eq<Object> eq2) {
        return Polynomial$mcD$sp$class.$minus$mcD$sp(this, rhs, ring, eq2);
    }

    @Override
    public Polynomial<Object> $div$tilde(Polynomial<Object> rhs, Field<Object> field2, Eq<Object> eq2) {
        return Polynomial$mcD$sp$class.$div$tilde(this, rhs, field2, eq2);
    }

    @Override
    public Polynomial<Object> $div$tilde$mcD$sp(Polynomial<Object> rhs, Field<Object> field2, Eq<Object> eq2) {
        return Polynomial$mcD$sp$class.$div$tilde$mcD$sp(this, rhs, field2, eq2);
    }

    @Override
    public Polynomial<Object> $percent(Polynomial<Object> rhs, Field<Object> field2, Eq<Object> eq2) {
        return Polynomial$mcD$sp$class.$percent(this, rhs, field2, eq2);
    }

    @Override
    public Polynomial<Object> $percent$mcD$sp(Polynomial<Object> rhs, Field<Object> field2, Eq<Object> eq2) {
        return Polynomial$mcD$sp$class.$percent$mcD$sp(this, rhs, field2, eq2);
    }

    @Override
    public Polynomial<Object> $times$times(int k, Rig<Object> ring, Eq<Object> eq2) {
        return Polynomial$mcD$sp$class.$times$times(this, k, ring, eq2);
    }

    @Override
    public Polynomial<Object> $times$times$mcD$sp(int k, Rig<Object> ring, Eq<Object> eq2) {
        return Polynomial$mcD$sp$class.$times$times$mcD$sp(this, k, ring, eq2);
    }

    @Override
    public Polynomial<Object> pow(int k, Rig<Object> ring, Eq<Object> eq2) {
        return Polynomial$mcD$sp$class.pow(this, k, ring, eq2);
    }

    @Override
    public Polynomial<Object> pow$mcD$sp(int k, Rig<Object> ring, Eq<Object> eq2) {
        return Polynomial$mcD$sp$class.pow$mcD$sp(this, k, ring, eq2);
    }

    @Override
    public Polynomial<Object> $colon$times(double k, Semiring<Object> ring, Eq<Object> eq2) {
        return Polynomial$mcD$sp$class.$colon$times(this, k, ring, eq2);
    }

    @Override
    public Polynomial<Object> $colon$times$mcD$sp(double k, Semiring<Object> ring, Eq<Object> eq2) {
        return Polynomial$mcD$sp$class.$colon$times$mcD$sp(this, k, ring, eq2);
    }

    @Override
    public Polynomial<Object> $colon$div(double k, Field<Object> field2, Eq<Object> eq2) {
        return Polynomial$mcD$sp$class.$colon$div(this, k, field2, eq2);
    }

    @Override
    public Polynomial<Object> $colon$div$mcD$sp(double k, Field<Object> field2, Eq<Object> eq2) {
        return Polynomial$mcD$sp$class.$colon$div$mcD$sp(this, k, field2, eq2);
    }

    @Override
    public double[] coeff$mcD$sp() {
        return this.coeff$mcD$sp;
    }

    public double[] coeff() {
        return this.coeff$mcD$sp();
    }

    @Override
    public PolyDense<Object> toDense(Semiring<Object> ring, Eq<Object> eq2) {
        return this.toDense$mcD$sp(ring, eq2);
    }

    @Override
    public PolyDense<Object> toDense$mcD$sp(Semiring<Object> ring, Eq<Object> eq2) {
        return Polynomial$.MODULE$.dense$mDc$sp(this.coeffsArray$mcD$sp(ring), ring, eq2, this.ct());
    }

    @Override
    public PolySparse<Object> toSparse(Semiring<Object> ring, Eq<Object> eq2) {
        return this.toSparse$mcD$sp(ring, eq2);
    }

    @Override
    public PolySparse<Object> toSparse$mcD$sp(Semiring<Object> ring, Eq<Object> eq2) {
        return this;
    }

    @Override
    public <U> void foreach(Function2<Object, Object, U> f) {
        this.foreach$mcD$sp(f);
    }

    @Override
    public <U> void foreach$mcD$sp(Function2<Object, Object, U> f) {
        for (int index$macro$193 = 0; index$macro$193 < this.exp().length; ++index$macro$193) {
            f.apply(BoxesRunTime.boxToInteger(this.exp()[index$macro$193]), BoxesRunTime.boxToDouble(this.coeff()[index$macro$193]));
        }
    }

    @Override
    public <U> void foreachNonZero(Function2<Object, Object, U> f, Semiring<Object> ring, Eq<Object> eq2) {
        this.foreachNonZero$mcD$sp(f, ring, eq2);
    }

    @Override
    public <U> void foreachNonZero$mcD$sp(Function2<Object, Object, U> f, Semiring<Object> ring, Eq<Object> eq2) {
        this.foreach$mcD$sp(f);
    }

    @Override
    public double[] coeffsArray(Semiring<Object> ring) {
        return this.coeffsArray$mcD$sp(ring);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public double[] coeffsArray$mcD$sp(Semiring<Object> ring) {
        double[] dArray;
        if (this.isZero()) {
            dArray = (double[])this.ct().newArray(0);
        } else {
            void var2_2;
            double[] cs = (double[])this.ct().newArray(this.degree() + 1);
            for (int index$macro$194 = 0; index$macro$194 < cs.length; ++index$macro$194) {
                cs[index$macro$194] = ring.zero$mcD$sp();
            }
            for (int index$macro$195 = 0; index$macro$195 < this.exp().length; ++index$macro$195) {
                cs[this.exp()[index$macro$195]] = this.coeff()[index$macro$195];
            }
            dArray = var2_2;
        }
        return dArray;
    }

    @Override
    public double nth(int n, Semiring<Object> ring) {
        return this.nth$mcD$sp(n, ring);
    }

    @Override
    public double nth$mcD$sp(int n, Semiring<Object> ring) {
        int i = Arrays.binarySearch(this.exp(), n);
        return i >= 0 ? this.coeff()[i] : ring.zero$mcD$sp();
    }

    @Override
    public double maxOrderTermCoeff(Semiring<Object> ring) {
        return this.maxOrderTermCoeff$mcD$sp(ring);
    }

    @Override
    public double maxOrderTermCoeff$mcD$sp(Semiring<Object> ring) {
        return this.isZero() ? ring.zero$mcD$sp() : this.coeff()[this.coeff().length - 1];
    }

    @Override
    public Polynomial<Object> reductum(Eq<Object> e, Semiring<Object> ring, ClassTag<Object> ct) {
        return this.reductum$mcD$sp(e, ring, ct);
    }

    @Override
    public Polynomial<Object> reductum$mcD$sp(Eq<Object> e, Semiring<Object> ring, ClassTag<Object> ct) {
        PolySparse$mcD$sp polySparse$mcD$sp;
        int i;
        for (i = this.coeff().length - 2; i >= 0 && e.eqv$mcD$sp(this.coeff()[i], ring.zero$mcD$sp()); --i) {
        }
        if (i < 0) {
            polySparse$mcD$sp = new PolySparse$mcD$sp(new int[0], (double[])ct.newArray(0), ct);
        } else {
            int len = i + 1;
            int[] es = new int[len];
            double[] cs = (double[])ct.newArray(len);
            System.arraycopy(this.coeff(), 0, cs, 0, len);
            System.arraycopy(this.exp(), 0, es, 0, len);
            polySparse$mcD$sp = new PolySparse$mcD$sp(es, cs, ct);
        }
        return polySparse$mcD$sp;
    }

    public final double[] expBits(double x, Semiring<Object> ring) {
        return this.expBits$mcD$sp(x, ring);
    }

    @Override
    public final double[] expBits$mcD$sp(double x, Semiring<Object> ring) {
        double[] bits2 = (double[])this.ct().newArray(package$.MODULE$.max(2, 32 - Integer.numberOfLeadingZeros(this.degree())));
        bits2[0] = x;
        if (bits2.length > 1) {
            bits2[1] = ring.pow$mcD$sp(x, 2);
        }
        for (int index$macro$196 = 2; index$macro$196 < bits2.length; ++index$macro$196) {
            double prev = bits2[index$macro$196 - 1];
            bits2[index$macro$196] = ring.times$mcD$sp(prev, prev);
        }
        return bits2;
    }

    public final double fastExp(double[] bits2, int e, int i, double acc, Semiring<Object> ring) {
        return this.fastExp$mcD$sp(bits2, e, i, acc, ring);
    }

    @Override
    public final double fastExp$mcD$sp(double[] bits2, int e, int i, double acc, Semiring<Object> ring) {
        while (e != 0) {
            int lb = Integer.numberOfTrailingZeros(e) + 1;
            int j = i + lb;
            acc = ring.times$mcD$sp(acc, bits2[j - 1]);
            i = j;
            e >>>= lb;
        }
        return acc;
    }

    public final double fastExp(double[] bits2, int e, Semiring<Object> ring) {
        return this.fastExp$mcD$sp(bits2, e, ring);
    }

    @Override
    public final double fastExp$mcD$sp(double[] bits2, int e, Semiring<Object> ring) {
        int lb = Integer.numberOfTrailingZeros(e) + 1;
        return this.fastExp$mcD$sp(bits2, e >>> lb, lb, bits2[lb - 1], ring);
    }

    @Override
    public double apply(double x, Semiring<Object> ring) {
        return this.apply$mcD$sp(x, ring);
    }

    @Override
    public double apply$mcD$sp(double x, Semiring<Object> ring) {
        double d;
        if (this.isZero()) {
            d = ring.zero$mcD$sp();
        } else if (this.exp().length == 1) {
            d = this.exp()[0] != 0 ? ring.times$mcD$sp(this.coeff()[0], ring.pow$mcD$sp(x, this.exp()[0])) : this.coeff()[0];
        } else {
            double[] bits2 = this.expBits$mcD$sp(x, ring);
            int e0 = this.exp()[0];
            double c0 = this.coeff()[0];
            double sum2 = e0 == 0 ? c0 : ring.times$mcD$sp(c0, this.fastExp$mcD$sp(bits2, e0, ring));
            for (int index$macro$197 = 1; index$macro$197 < this.exp().length; ++index$macro$197) {
                sum2 = ring.plus$mcD$sp(sum2, ring.times$mcD$sp(this.coeff()[index$macro$197], this.fastExp$mcD$sp(bits2, this.exp()[index$macro$197], ring)));
            }
            d = sum2;
        }
        return d;
    }

    @Override
    public Polynomial<Object> derivative(Ring<Object> ring, Eq<Object> eq2) {
        return this.derivative$mcD$sp(ring, eq2);
    }

    @Override
    public Polynomial<Object> derivative$mcD$sp(Ring<Object> ring, Eq<Object> eq2) {
        int i0 = this.exp()[0] == 0 ? 1 : 0;
        int[] es = new int[this.exp().length - i0];
        double[] cs = (double[])this.ct().newArray(es.length);
        this.loop$9(i0, 0, ring, es, cs);
        return PolySparse$.MODULE$.safe$mDc$sp(es, cs, ring, eq2, this.ct());
    }

    @Override
    public Polynomial<Object> integral(Field<Object> field2, Eq<Object> eq2) {
        return this.integral$mcD$sp(field2, eq2);
    }

    @Override
    public Polynomial<Object> integral$mcD$sp(Field<Object> field2, Eq<Object> eq2) {
        int[] es = new int[this.exp().length];
        double[] cs = (double[])this.ct().newArray(es.length);
        for (int index$macro$198 = 0; index$macro$198 < es.length; ++index$macro$198) {
            int e;
            es[index$macro$198] = e = this.exp()[index$macro$198] + 1;
            cs[index$macro$198] = field2.div$mcD$sp(this.coeff()[index$macro$198], field2.fromInt$mcD$sp(e));
        }
        return PolySparse$.MODULE$.safe$mDc$sp(es, cs, field2, eq2, this.ct());
    }

    @Override
    public Polynomial<Object> unary_$minus(Rng<Object> ring) {
        return this.unary_$minus$mcD$sp(ring);
    }

    @Override
    public Polynomial<Object> unary_$minus$mcD$sp(Rng<Object> ring) {
        double[] cs = (double[])this.ct().newArray(this.coeff().length);
        for (int index$macro$199 = 0; index$macro$199 < cs.length; ++index$macro$199) {
            cs[index$macro$199] = ring.negate$mcD$sp(this.coeff()[index$macro$199]);
        }
        return new PolySparse$mcD$sp(this.exp(), cs, this.ct());
    }

    @Override
    public Polynomial<Object> $plus(Polynomial<Object> rhs0, Semiring<Object> ring, Eq<Object> eq2) {
        return this.$plus$mcD$sp(rhs0, ring, eq2);
    }

    @Override
    public Polynomial<Object> $plus$mcD$sp(Polynomial<Object> rhs0, Semiring<Object> ring, Eq<Object> eq2) {
        PolySparse<Object> rhs = PolySparse$.MODULE$.apply$mDc$sp(rhs0, ring, eq2, this.ct());
        return PolySparse$.MODULE$.spire$math$poly$PolySparse$$addSparse(this, rhs, eq2, ring, this.ct());
    }

    @Override
    public Polynomial<Object> $times(Polynomial<Object> rhs0, Semiring<Object> ring, Eq<Object> eq2) {
        return this.$times$mcD$sp(rhs0, ring, eq2);
    }

    @Override
    public Polynomial<Object> $times$mcD$sp(Polynomial<Object> rhs0, Semiring<Object> ring, Eq<Object> eq2) {
        PolySparse<Object> rhs = PolySparse$.MODULE$.apply$mDc$sp(rhs0, ring, eq2, this.ct());
        return PolySparse$.MODULE$.spire$math$poly$PolySparse$$multiplySparse(this, rhs, ring, eq2, this.ct());
    }

    @Override
    public Tuple2<Polynomial<Object>, Polynomial<Object>> $div$percent(Polynomial<Object> rhs, Field<Object> field2, Eq<Object> eq2) {
        return this.$div$percent$mcD$sp(rhs, field2, eq2);
    }

    @Override
    public Tuple2<Polynomial<Object>, Polynomial<Object>> $div$percent$mcD$sp(Polynomial<Object> rhs, Field<Object> field2, Eq<Object> eq2) {
        boolean bl = !rhs.isZero();
        Predef$ predef$ = Predef$.MODULE$;
        if (!bl) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)"requirement failed: ").append((Object)"Can't divide by polynomial of zero!").toString());
        }
        return PolySparse$.MODULE$.spire$math$poly$PolySparse$$quotmodSparse(this, PolySparse$.MODULE$.apply$mDc$sp(rhs, field2, eq2, this.ct()), field2, eq2, this.ct());
    }

    @Override
    public Polynomial<Object> $times$colon(double k, Semiring<Object> ring, Eq<Object> eq2) {
        return this.$times$colon$mcD$sp(k, ring, eq2);
    }

    @Override
    public Polynomial<Object> $times$colon$mcD$sp(double k, Semiring<Object> ring, Eq<Object> eq2) {
        PolySparse$mcD$sp polySparse$mcD$sp;
        if (eq2.eqv$mcD$sp(k, ring.zero$mcD$sp())) {
            polySparse$mcD$sp = PolySparse$.MODULE$.zero$mDc$sp(ring, eq2, this.ct());
        } else {
            double[] cs = (double[])this.ct().newArray(this.coeff().length);
            for (int index$macro$200 = 0; index$macro$200 < cs.length; ++index$macro$200) {
                cs[index$macro$200] = ring.times$mcD$sp(k, this.coeff()[index$macro$200]);
            }
            polySparse$mcD$sp = new PolySparse$mcD$sp(this.exp(), cs, this.ct());
        }
        return polySparse$mcD$sp;
    }

    public <C> double[] copy$default$2() {
        return this.copy$default$2$mcD$sp();
    }

    @Override
    public <C> double[] copy$default$2$mcD$sp() {
        return this.coeff();
    }

    @Override
    public boolean specInstance$() {
        return true;
    }

    private final void loop$9(int i, int j, Ring ring$2, int[] es$8, double[] cs$8) {
        while (j < es$8.length) {
            int e = this.exp()[i];
            es$8[j] = e - 1;
            cs$8[j] = BoxesRunTime.unboxToDouble(LiteralIntMultiplicativeSemigroupOps$.MODULE$.$times$extension(package$field$.MODULE$.literalIntMultiplicativeSemigroupOps(e), BoxesRunTime.boxToDouble(this.coeff()[i]), ring$2));
            ++j;
            ++i;
        }
    }

    public PolySparse$mcD$sp(int[] exp, double[] coeff$mcD$sp, ClassTag<Object> ct) {
        this.coeff$mcD$sp = coeff$mcD$sp;
        super(exp, null, ct);
        Polynomial$mcD$sp$class.$init$(this);
    }
}

