/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.impl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.util.BiConsumer;
import org.apache.logging.log4j.util.ReadOnlyStringMap;
import org.apache.logging.log4j.util.StringMap;
import org.apache.logging.log4j.util.TriConsumer;

public class JdkMapAdapterStringMap
implements StringMap {
    private static final long serialVersionUID = -7348247784983193612L;
    private static final String FROZEN = "Frozen collection cannot be modified";
    private static final Comparator<? super String> NULL_FIRST_COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String left2, String right2) {
            if (left2 == null) {
                return -1;
            }
            if (right2 == null) {
                return 1;
            }
            return left2.compareTo(right2);
        }
    };
    private final Map<String, String> map;
    private boolean immutable = false;
    private transient String[] sortedKeys;
    private static TriConsumer<String, String, Map<String, String>> PUT_ALL = new TriConsumer<String, String, Map<String, String>>(){

        @Override
        public void accept(String key, String value2, Map<String, String> stringStringMap) {
            stringStringMap.put(key, value2);
        }
    };

    public JdkMapAdapterStringMap() {
        this(new HashMap<String, String>());
    }

    public JdkMapAdapterStringMap(Map<String, String> map2) {
        this.map = Objects.requireNonNull(map2, "map");
    }

    @Override
    public Map<String, String> toMap() {
        return this.map;
    }

    private void assertNotFrozen() {
        if (this.immutable) {
            throw new UnsupportedOperationException(FROZEN);
        }
    }

    @Override
    public boolean containsKey(String key) {
        return this.map.containsKey(key);
    }

    @Override
    public <V> void forEach(BiConsumer<String, ? super V> action) {
        String[] keys = this.getSortedKeys();
        for (int i = 0; i < keys.length; ++i) {
            action.accept(keys[i], this.map.get(keys[i]));
        }
    }

    @Override
    public <V, S> void forEach(TriConsumer<String, ? super V, S> action, S state) {
        String[] keys = this.getSortedKeys();
        for (int i = 0; i < keys.length; ++i) {
            action.accept(keys[i], this.map.get(keys[i]), state);
        }
    }

    private String[] getSortedKeys() {
        if (this.sortedKeys == null) {
            this.sortedKeys = this.map.keySet().toArray(new String[this.map.size()]);
            Arrays.sort(this.sortedKeys, NULL_FIRST_COMPARATOR);
        }
        return this.sortedKeys;
    }

    @Override
    public <V> V getValue(String key) {
        return (V)this.map.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public void clear() {
        if (this.map.isEmpty()) {
            return;
        }
        this.assertNotFrozen();
        this.map.clear();
        this.sortedKeys = null;
    }

    @Override
    public void freeze() {
        this.immutable = true;
    }

    @Override
    public boolean isFrozen() {
        return this.immutable;
    }

    @Override
    public void putAll(ReadOnlyStringMap source) {
        this.assertNotFrozen();
        source.forEach(PUT_ALL, this.map);
        this.sortedKeys = null;
    }

    @Override
    public void putValue(String key, Object value2) {
        this.assertNotFrozen();
        this.map.put(key, value2 == null ? null : String.valueOf(value2));
        this.sortedKeys = null;
    }

    @Override
    public void remove(String key) {
        if (!this.map.containsKey(key)) {
            return;
        }
        this.assertNotFrozen();
        this.map.remove(key);
        this.sortedKeys = null;
    }

    public String toString() {
        StringBuilder result2 = new StringBuilder(this.map.size() * 13);
        result2.append('{');
        String[] keys = this.getSortedKeys();
        for (int i = 0; i < keys.length; ++i) {
            if (i > 0) {
                result2.append(", ");
            }
            result2.append(keys[i]).append('=').append(this.map.get(keys[i]));
        }
        result2.append('}');
        return result2.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof JdkMapAdapterStringMap)) {
            return false;
        }
        JdkMapAdapterStringMap other = (JdkMapAdapterStringMap)object;
        return this.map.equals(other.map) && this.immutable == other.immutable;
    }

    @Override
    public int hashCode() {
        return this.map.hashCode() + (this.immutable ? 31 : 0);
    }
}

