/*
 * Decompiled with CFR 0.152.
 */
package spire.math;

import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$mcJJ$sp;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichFloat;
import spire.math.package$;

public final class FastComplex$ {
    public static final FastComplex$ MODULE$;
    private final long i;
    private final long one;
    private final long zero;

    static {
        new FastComplex$();
    }

    public final long apply(float real, float imag) {
        return (long)Float.floatToRawIntBits(real) & 0xFFFFFFFFL | ((long)Float.floatToRawIntBits(imag) & 0xFFFFFFFFL) << 32;
    }

    public final long apply(double real, double imag) {
        float f2 = (float)imag;
        return (long)Float.floatToRawIntBits((float)real) & 0xFFFFFFFFL | ((long)Float.floatToRawIntBits(f2) & 0xFFFFFFFFL) << 32;
    }

    public final int bits(float n) {
        return Float.floatToRawIntBits(n);
    }

    public final float bits(int n) {
        return Float.intBitsToFloat(n);
    }

    public final float real(long d) {
        return this.bits((int)(d & 0xFFFFFFFFFFFFFFFFL));
    }

    public final float imag(long d) {
        return this.bits((int)(d >>> 32));
    }

    public final long i() {
        return this.i;
    }

    public final long one() {
        return this.one;
    }

    public final long zero() {
        return this.zero;
    }

    public final long encode(float real, float imag) {
        return (long)this.bits(real) & 0xFFFFFFFFL | ((long)this.bits(imag) & 0xFFFFFFFFL) << 32;
    }

    public final long polar(float magnitude, float angle) {
        return this.encode(magnitude * (float)Math.cos(angle), magnitude * (float)Math.sin(angle));
    }

    public final Tuple2<Object, Object> decode(long d) {
        return new Tuple2<Object, Object>(BoxesRunTime.boxToFloat(Float.intBitsToFloat((int)(d & 0xFFFFFFFFFFFFFFFFL))), BoxesRunTime.boxToFloat(Float.intBitsToFloat((int)(d >>> 32))));
    }

    public final String toRepr(long d) {
        Predef$ predef$ = Predef$.MODULE$;
        return new StringOps("FastComplex(%s -> %s)").format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(d), this.decode(d)}));
    }

    public final float abs(long d) {
        float re = Float.intBitsToFloat((int)(d & 0xFFFFFFFFFFFFFFFFL));
        float im = Float.intBitsToFloat((int)(d >>> 32));
        return (float)Math.sqrt(re * re + im * im);
    }

    public final float angle(long d) {
        return (float)Math.atan2(Float.intBitsToFloat((int)(d >>> 32)), Float.intBitsToFloat((int)(d & 0xFFFFFFFFFFFFFFFFL)));
    }

    public final long conjugate(long d) {
        float f2 = -Float.intBitsToFloat((int)(d >>> 32));
        return (long)Float.floatToRawIntBits(Float.intBitsToFloat((int)(d & 0xFFFFFFFFFFFFFFFFL))) & 0xFFFFFFFFL | ((long)Float.floatToRawIntBits(f2) & 0xFFFFFFFFL) << 32;
    }

    public final boolean isWhole(long d) {
        return Float.intBitsToFloat((int)(d & 0xFFFFFFFFFFFFFFFFL)) % 1.0f == 0.0f && Float.intBitsToFloat((int)(d >>> 32)) % 1.0f == 0.0f;
    }

    public final int signum(long d) {
        float f2 = Float.intBitsToFloat((int)(d & 0xFFFFFFFFFFFFFFFFL));
        Predef$ predef$ = Predef$.MODULE$;
        return new RichFloat(f2).compare(BoxesRunTime.boxToFloat(0.0f));
    }

    public final long complexSignum(long d) {
        float m = this.abs(d);
        return m == 0.0f ? this.zero() : this.divide(d, (long)Float.floatToRawIntBits(m) & 0xFFFFFFFFL | ((long)Float.floatToRawIntBits(0.0f) & 0xFFFFFFFFL) << 32);
    }

    public final long negate(long a) {
        float f2 = -Float.intBitsToFloat((int)(a >>> 32));
        return (long)Float.floatToRawIntBits(-Float.intBitsToFloat((int)(a & 0xFFFFFFFFFFFFFFFFL))) & 0xFFFFFFFFL | ((long)Float.floatToRawIntBits(f2) & 0xFFFFFFFFL) << 32;
    }

    public final long add(long a, long b) {
        float f2 = Float.intBitsToFloat((int)(a >>> 32)) + Float.intBitsToFloat((int)(b >>> 32));
        return (long)Float.floatToRawIntBits(Float.intBitsToFloat((int)(a & 0xFFFFFFFFFFFFFFFFL)) + Float.intBitsToFloat((int)(b & 0xFFFFFFFFFFFFFFFFL))) & 0xFFFFFFFFL | ((long)Float.floatToRawIntBits(f2) & 0xFFFFFFFFL) << 32;
    }

    public final long subtract(long a, long b) {
        float f2 = Float.intBitsToFloat((int)(a >>> 32)) - Float.intBitsToFloat((int)(b >>> 32));
        return (long)Float.floatToRawIntBits(Float.intBitsToFloat((int)(a & 0xFFFFFFFFFFFFFFFFL)) - Float.intBitsToFloat((int)(b & 0xFFFFFFFFFFFFFFFFL))) & 0xFFFFFFFFL | ((long)Float.floatToRawIntBits(f2) & 0xFFFFFFFFL) << 32;
    }

    public final long multiply(long a, long b) {
        float re_a = Float.intBitsToFloat((int)(a & 0xFFFFFFFFFFFFFFFFL));
        float im_a = Float.intBitsToFloat((int)(a >>> 32));
        float re_b = Float.intBitsToFloat((int)(b & 0xFFFFFFFFFFFFFFFFL));
        float im_b = Float.intBitsToFloat((int)(b >>> 32));
        float f2 = im_a * re_b + re_a * im_b;
        return (long)Float.floatToRawIntBits(re_a * re_b - im_a * im_b) & 0xFFFFFFFFL | ((long)Float.floatToRawIntBits(f2) & 0xFFFFFFFFL) << 32;
    }

    public final long divide(long a, long b) {
        long l;
        float abs_im_b;
        float re_a = Float.intBitsToFloat((int)(a & 0xFFFFFFFFFFFFFFFFL));
        float im_a = Float.intBitsToFloat((int)(a >>> 32));
        float re_b = Float.intBitsToFloat((int)(b & 0xFFFFFFFFFFFFFFFFL));
        float im_b = Float.intBitsToFloat((int)(b >>> 32));
        float abs_re_b = Math.abs(re_b);
        if (abs_re_b >= (abs_im_b = Math.abs(im_b))) {
            if (abs_re_b == 0.0f) {
                throw new ArithmeticException("/0");
            }
            float ratio = im_b / re_b;
            float denom = re_b + im_b * ratio;
            float f2 = (im_a - re_a * ratio) / denom;
            l = (long)Float.floatToRawIntBits((re_a + im_a * ratio) / denom) & 0xFFFFFFFFL | ((long)Float.floatToRawIntBits(f2) & 0xFFFFFFFFL) << 32;
        } else {
            if (abs_im_b == 0.0f) {
                throw new ArithmeticException("/0");
            }
            float ratio = re_b / im_b;
            float denom = re_b * ratio + im_b;
            float f3 = (im_a * ratio - re_a) / denom;
            l = (long)Float.floatToRawIntBits((re_a * ratio + im_a) / denom) & 0xFFFFFFFFL | ((long)Float.floatToRawIntBits(f3) & 0xFFFFFFFFL) << 32;
        }
        return l;
    }

    public final long quot(long a, long b) {
        return (long)Float.floatToRawIntBits((float)Math.floor(Float.intBitsToFloat((int)(this.divide(a, b) & 0xFFFFFFFFFFFFFFFFL)))) & 0xFFFFFFFFL | ((long)Float.floatToRawIntBits(0.0f) & 0xFFFFFFFFL) << 32;
    }

    public final long mod(long a, long b) {
        return this.subtract(a, this.multiply(b, this.quot(a, b)));
    }

    public final Tuple2<Object, Object> quotmod(long a, long b) {
        long q = this.quot(a, b);
        return new Tuple2$mcJJ$sp(q, this.subtract(a, this.multiply(b, this.quot(a, b))));
    }

    public final long pow(long a, long b) {
        long l;
        if (b == this.zero()) {
            l = (long)Float.floatToRawIntBits(1.0f) & 0xFFFFFFFFL | ((long)Float.floatToRawIntBits(0.0f) & 0xFFFFFFFFL) << 32;
        } else if (a == this.zero()) {
            if (Float.intBitsToFloat((int)(b >>> 32)) != 0.0f || Float.intBitsToFloat((int)(b & 0xFFFFFFFFFFFFFFFFL)) < 0.0f) {
                throw new Exception("raising 0 to negative/complex power");
            }
            l = this.zero();
        } else if (Float.intBitsToFloat((int)(b >>> 32)) != 0.0f) {
            float im_b = Float.intBitsToFloat((int)(b >>> 32));
            float re_b = Float.intBitsToFloat((int)(b & 0xFFFFFFFFFFFFFFFFL));
            float len = (float)(Math.pow(this.abs(a), re_b) / package$.MODULE$.exp(this.angle(a) * im_b));
            float phase = (float)((double)(this.angle(a) * re_b) + package$.MODULE$.log(this.abs(a)) * (double)im_b);
            l = this.encode(len * (float)Math.cos(phase), len * (float)Math.sin(phase));
        } else {
            float len = (float)Math.pow(this.abs(a), Float.intBitsToFloat((int)(b & 0xFFFFFFFFFFFFFFFFL)));
            float phase = this.angle(a) * Float.intBitsToFloat((int)(b & 0xFFFFFFFFFFFFFFFFL));
            l = this.encode(len * (float)Math.cos(phase), len * (float)Math.sin(phase));
        }
        return l;
    }

    private FastComplex$() {
        MODULE$ = this;
        this.i = (long)Float.floatToRawIntBits(0.0f) & 0xFFFFFFFFL | ((long)Float.floatToRawIntBits(1.0f) & 0xFFFFFFFFL) << 32;
        this.one = (long)Float.floatToRawIntBits(1.0f) & 0xFFFFFFFFL | ((long)Float.floatToRawIntBits(0.0f) & 0xFFFFFFFFL) << 32;
        this.zero = (long)Float.floatToRawIntBits(0.0f) & 0xFFFFFFFFL | ((long)Float.floatToRawIntBits(0.0f) & 0xFFFFFFFFL) << 32;
    }
}

