/*
 * Decompiled with CFR 0.152.
 */
package spire.math.poly;

import scala.Array$;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag;
import scala.runtime.BoxesRunTime;
import spire.algebra.Eq;
import spire.algebra.Field;
import spire.algebra.Rig;
import spire.algebra.Ring;
import spire.algebra.Rng;
import spire.algebra.Semiring;
import spire.math.Polynomial;
import spire.math.Polynomial$;
import spire.math.Polynomial$mcD$sp;
import spire.math.Polynomial$mcD$sp$class;
import spire.math.poly.PolyDense;
import spire.math.poly.PolyDense$;
import spire.math.poly.PolySparse;
import spire.math.poly.Term;
import spire.std.package$array$;

public class PolyDense$mcD$sp
extends PolyDense<Object>
implements Polynomial$mcD$sp {
    public final double[] coeffs$mcD$sp;

    @Override
    public List<Term<Object>> terms(Semiring<Object> ring, Eq<Object> eq2) {
        return Polynomial$mcD$sp$class.terms(this, ring, eq2);
    }

    @Override
    public List<Term<Object>> terms$mcD$sp(Semiring<Object> ring, Eq<Object> eq2) {
        return Polynomial$mcD$sp$class.terms$mcD$sp(this, ring, eq2);
    }

    @Override
    public Map<Object, Object> data(Semiring<Object> ring, Eq<Object> eq2) {
        return Polynomial$mcD$sp$class.data(this, ring, eq2);
    }

    @Override
    public Map<Object, Object> data$mcD$sp(Semiring<Object> ring, Eq<Object> eq2) {
        return Polynomial$mcD$sp$class.data$mcD$sp(this, ring, eq2);
    }

    @Override
    public Term<Object> maxTerm(Semiring<Object> ring) {
        return Polynomial$mcD$sp$class.maxTerm(this, ring);
    }

    @Override
    public Term<Object> maxTerm$mcD$sp(Semiring<Object> ring) {
        return Polynomial$mcD$sp$class.maxTerm$mcD$sp(this, ring);
    }

    @Override
    public Polynomial<Object> compose(Polynomial<Object> y, Rig<Object> ring, Eq<Object> eq2) {
        return Polynomial$mcD$sp$class.compose(this, y, ring, eq2);
    }

    @Override
    public Polynomial<Object> compose$mcD$sp(Polynomial<Object> y, Rig<Object> ring, Eq<Object> eq2) {
        return Polynomial$mcD$sp$class.compose$mcD$sp(this, y, ring, eq2);
    }

    @Override
    public Polynomial<Object> monic(Field<Object> f2, Eq<Object> eq2) {
        return Polynomial$mcD$sp$class.monic(this, f2, eq2);
    }

    @Override
    public Polynomial<Object> monic$mcD$sp(Field<Object> f2, Eq<Object> eq2) {
        return Polynomial$mcD$sp$class.monic$mcD$sp(this, f2, eq2);
    }

    @Override
    public Polynomial<Object> $minus(Polynomial<Object> rhs, Rng<Object> ring, Eq<Object> eq2) {
        return Polynomial$mcD$sp$class.$minus(this, rhs, ring, eq2);
    }

    @Override
    public Polynomial<Object> $minus$mcD$sp(Polynomial<Object> rhs, Rng<Object> ring, Eq<Object> eq2) {
        return Polynomial$mcD$sp$class.$minus$mcD$sp(this, rhs, ring, eq2);
    }

    @Override
    public Polynomial<Object> $div$tilde(Polynomial<Object> rhs, Field<Object> field2, Eq<Object> eq2) {
        return Polynomial$mcD$sp$class.$div$tilde(this, rhs, field2, eq2);
    }

    @Override
    public Polynomial<Object> $div$tilde$mcD$sp(Polynomial<Object> rhs, Field<Object> field2, Eq<Object> eq2) {
        return Polynomial$mcD$sp$class.$div$tilde$mcD$sp(this, rhs, field2, eq2);
    }

    @Override
    public Polynomial<Object> $percent(Polynomial<Object> rhs, Field<Object> field2, Eq<Object> eq2) {
        return Polynomial$mcD$sp$class.$percent(this, rhs, field2, eq2);
    }

    @Override
    public Polynomial<Object> $percent$mcD$sp(Polynomial<Object> rhs, Field<Object> field2, Eq<Object> eq2) {
        return Polynomial$mcD$sp$class.$percent$mcD$sp(this, rhs, field2, eq2);
    }

    @Override
    public Polynomial<Object> $times$times(int k, Rig<Object> ring, Eq<Object> eq2) {
        return Polynomial$mcD$sp$class.$times$times(this, k, ring, eq2);
    }

    @Override
    public Polynomial<Object> $times$times$mcD$sp(int k, Rig<Object> ring, Eq<Object> eq2) {
        return Polynomial$mcD$sp$class.$times$times$mcD$sp(this, k, ring, eq2);
    }

    @Override
    public Polynomial<Object> pow(int k, Rig<Object> ring, Eq<Object> eq2) {
        return Polynomial$mcD$sp$class.pow(this, k, ring, eq2);
    }

    @Override
    public Polynomial<Object> pow$mcD$sp(int k, Rig<Object> ring, Eq<Object> eq2) {
        return Polynomial$mcD$sp$class.pow$mcD$sp(this, k, ring, eq2);
    }

    @Override
    public Polynomial<Object> $colon$times(double k, Semiring<Object> ring, Eq<Object> eq2) {
        return Polynomial$mcD$sp$class.$colon$times(this, k, ring, eq2);
    }

    @Override
    public Polynomial<Object> $colon$times$mcD$sp(double k, Semiring<Object> ring, Eq<Object> eq2) {
        return Polynomial$mcD$sp$class.$colon$times$mcD$sp(this, k, ring, eq2);
    }

    @Override
    public Polynomial<Object> $colon$div(double k, Field<Object> field2, Eq<Object> eq2) {
        return Polynomial$mcD$sp$class.$colon$div(this, k, field2, eq2);
    }

    @Override
    public Polynomial<Object> $colon$div$mcD$sp(double k, Field<Object> field2, Eq<Object> eq2) {
        return Polynomial$mcD$sp$class.$colon$div$mcD$sp(this, k, field2, eq2);
    }

    @Override
    public double[] coeffs$mcD$sp() {
        return this.coeffs$mcD$sp;
    }

    public double[] coeffs() {
        return this.coeffs$mcD$sp();
    }

    @Override
    public PolySparse<Object> toSparse(Semiring<Object> ring, Eq<Object> eq2) {
        return this.toSparse$mcD$sp(ring, eq2);
    }

    @Override
    public PolySparse<Object> toSparse$mcD$sp(Semiring<Object> ring, Eq<Object> eq2) {
        return Polynomial$.MODULE$.sparse$mDc$sp(this.data$mcD$sp(ring, eq2), ring, eq2, this.ct());
    }

    @Override
    public PolyDense<Object> toDense(Semiring<Object> ring, Eq<Object> eq2) {
        return this.toDense$mcD$sp(ring, eq2);
    }

    @Override
    public PolyDense<Object> toDense$mcD$sp(Semiring<Object> ring, Eq<Object> eq2) {
        return this;
    }

    @Override
    public <U> void foreach(Function2<Object, Object, U> f2) {
        this.foreach$mcD$sp(f2);
    }

    @Override
    public <U> void foreach$mcD$sp(Function2<Object, Object, U> f2) {
        for (int index$macro$180 = 0; index$macro$180 < this.coeffs().length; ++index$macro$180) {
            f2.apply(BoxesRunTime.boxToInteger(index$macro$180), BoxesRunTime.boxToDouble(this.coeffs()[index$macro$180]));
        }
    }

    @Override
    public <U> void foreachNonZero(Function2<Object, Object, U> f2, Semiring<Object> ring, Eq<Object> eq2) {
        this.foreachNonZero$mcD$sp(f2, ring, eq2);
    }

    @Override
    public <U> void foreachNonZero$mcD$sp(Function2<Object, Object, U> f2, Semiring<Object> ring, Eq<Object> eq2) {
        for (int index$macro$181 = 0; index$macro$181 < this.coeffs().length; ++index$macro$181) {
            double c = this.coeffs()[index$macro$181];
            if (!eq2.neqv$mcD$sp(c, ring.zero$mcD$sp())) continue;
            f2.apply(BoxesRunTime.boxToInteger(index$macro$181), BoxesRunTime.boxToDouble(c));
        }
    }

    @Override
    public double[] coeffsArray(Semiring<Object> ring) {
        return this.coeffsArray$mcD$sp(ring);
    }

    @Override
    public double[] coeffsArray$mcD$sp(Semiring<Object> ring) {
        return this.coeffs();
    }

    @Override
    public double nth(int n, Semiring<Object> ring) {
        return this.nth$mcD$sp(n, ring);
    }

    @Override
    public double nth$mcD$sp(int n, Semiring<Object> ring) {
        return n < this.coeffs().length ? this.coeffs()[n] : ring.zero$mcD$sp();
    }

    @Override
    public double maxOrderTermCoeff(Semiring<Object> ring) {
        return this.maxOrderTermCoeff$mcD$sp(ring);
    }

    @Override
    public double maxOrderTermCoeff$mcD$sp(Semiring<Object> ring) {
        return this.isZero() ? ring.zero$mcD$sp() : this.coeffs()[this.degree()];
    }

    @Override
    public Polynomial<Object> reductum(Eq<Object> e, Semiring<Object> ring, ClassTag<Object> ct) {
        return this.reductum$mcD$sp(e, ring, ct);
    }

    @Override
    public Polynomial<Object> reductum$mcD$sp(Eq<Object> e, Semiring<Object> ring, ClassTag<Object> ct) {
        PolyDense$mcD$sp polyDense$mcD$sp;
        int i;
        for (i = this.coeffs().length - 2; i >= 0 && e.eqv$mcD$sp(this.coeffs()[i], ring.zero$mcD$sp()); --i) {
        }
        if (i < 0) {
            polyDense$mcD$sp = new PolyDense$mcD$sp((double[])ct.newArray(0), ct);
        } else {
            double[] arr = (double[])ct.newArray(i + 1);
            System.arraycopy(this.coeffs(), 0, arr, 0, i + 1);
            polyDense$mcD$sp = new PolyDense$mcD$sp(arr, ct);
        }
        return polyDense$mcD$sp;
    }

    @Override
    public double apply(double x, Semiring<Object> ring) {
        return this.apply$mcD$sp(x, ring);
    }

    @Override
    public double apply$mcD$sp(double x, Semiring<Object> ring) {
        double d;
        if (this.isZero()) {
            return ring.zero$mcD$sp();
        }
        int even = this.coeffs().length - 1;
        int odd = this.coeffs().length - 2;
        if ((even & 1) == 1) {
            even = odd;
            odd = this.coeffs().length - 1;
        }
        double c0 = this.coeffs()[even];
        double x2 = ring.pow$mcD$sp(x, 2);
        for (int index$macro$182 = even - 2; index$macro$182 >= 0; index$macro$182 -= 2) {
            c0 = ring.plus$mcD$sp(this.coeffs()[index$macro$182], ring.times$mcD$sp(c0, x2));
        }
        if (odd >= 1) {
            double c1 = this.coeffs()[odd];
            for (int index$macro$183 = odd - 2; index$macro$183 >= 1; index$macro$183 -= 2) {
                c1 = ring.plus$mcD$sp(this.coeffs()[index$macro$183], ring.times$mcD$sp(c1, x2));
            }
            d = ring.plus$mcD$sp(c0, ring.times$mcD$sp(c1, x));
        } else {
            d = c0;
        }
        return d;
    }

    @Override
    public Polynomial<Object> derivative(Ring<Object> ring, Eq<Object> eq2) {
        return this.derivative$mcD$sp(ring, eq2);
    }

    @Override
    public Polynomial<Object> derivative$mcD$sp(Ring<Object> ring, Eq<Object> eq2) {
        if (this.isZero()) {
            return this;
        }
        double[] cs = (double[])this.ct().newArray(this.degree());
        int j = this.coeffs().length - 1;
        for (int index$macro$184 = cs.length - 1; index$macro$184 >= 0; --index$macro$184) {
            cs[index$macro$184] = ring.times$mcD$sp(ring.fromInt$mcD$sp(j), this.coeffs()[j]);
            --j;
        }
        return Polynomial$.MODULE$.dense$mDc$sp(cs, ring, eq2, this.ct());
    }

    @Override
    public Polynomial<Object> integral(Field<Object> field2, Eq<Object> eq2) {
        return this.integral$mcD$sp(field2, eq2);
    }

    @Override
    public Polynomial<Object> integral$mcD$sp(Field<Object> field2, Eq<Object> eq2) {
        double[] cs = (double[])this.ct().newArray(this.coeffs().length + 1);
        cs[0] = field2.zero$mcD$sp();
        for (int index$macro$185 = 0; index$macro$185 < this.coeffs().length; ++index$macro$185) {
            cs[index$macro$185 + 1] = field2.div$mcD$sp(this.coeffs()[index$macro$185], field2.fromInt$mcD$sp(index$macro$185 + 1));
        }
        return Polynomial$.MODULE$.dense$mDc$sp(cs, field2, eq2, this.ct());
    }

    @Override
    public Polynomial<Object> unary_$minus(Rng<Object> ring) {
        return this.unary_$minus$mcD$sp(ring);
    }

    @Override
    public Polynomial<Object> unary_$minus$mcD$sp(Rng<Object> ring) {
        double[] negArray = (double[])this.ct().newArray(this.coeffs().length);
        for (int index$macro$186 = 0; index$macro$186 < this.coeffs().length; ++index$macro$186) {
            negArray[index$macro$186] = ring.negate$mcD$sp(this.coeffs()[index$macro$186]);
        }
        return new PolyDense$mcD$sp(negArray, this.ct());
    }

    @Override
    public Polynomial<Object> $plus(Polynomial<Object> rhs, Semiring<Object> ring, Eq<Object> eq2) {
        return this.$plus$mcD$sp(rhs, ring, eq2);
    }

    @Override
    public Polynomial<Object> $plus$mcD$sp(Polynomial<Object> rhs, Semiring<Object> ring, Eq<Object> eq2) {
        return PolyDense$.MODULE$.spire$math$poly$PolyDense$$plusDense(this, rhs, ring, eq2, this.ct());
    }

    @Override
    public Polynomial<Object> $times(Polynomial<Object> rhs, Semiring<Object> ring, Eq<Object> eq2) {
        return this.$times$mcD$sp(rhs, ring, eq2);
    }

    @Override
    public Polynomial<Object> $times$mcD$sp(Polynomial<Object> rhs, Semiring<Object> ring, Eq<Object> eq2) {
        if (rhs.isZero()) {
            return rhs;
        }
        if (this.isZero()) {
            return this;
        }
        double[] lcs = this.coeffsArray$mcD$sp(ring);
        double[] rcs = rhs.coeffsArray$mcD$sp(ring);
        double[] cs = (double[])this.ct().newArray(lcs.length + rcs.length - 1);
        for (int index$macro$187 = 0; index$macro$187 < cs.length; ++index$macro$187) {
            cs[index$macro$187] = ring.zero$mcD$sp();
        }
        for (int index$macro$189 = 0; index$macro$189 < lcs.length; ++index$macro$189) {
            double c = lcs[index$macro$189];
            int k = index$macro$189;
            for (int index$macro$188 = 0; index$macro$188 < rcs.length; ++index$macro$188) {
                cs[k] = ring.plus$mcD$sp(cs[k], ring.times$mcD$sp(c, rcs[index$macro$188]));
                ++k;
            }
        }
        return Polynomial$.MODULE$.dense$mDc$sp(cs, ring, eq2, this.ct());
    }

    @Override
    public Tuple2<Polynomial<Object>, Polynomial<Object>> $div$percent(Polynomial<Object> rhs, Field<Object> field2, Eq<Object> eq2) {
        return this.$div$percent$mcD$sp(rhs, field2, eq2);
    }

    @Override
    public Tuple2<Polynomial<Object>, Polynomial<Object>> $div$percent$mcD$sp(Polynomial<Object> rhs, Field<Object> field2, Eq<Object> eq2) {
        Tuple2 tuple22;
        double[] cs = rhs.coeffsArray$mcD$sp(field2);
        if (cs.length == 0) {
            throw new ArithmeticException("/ by zero polynomial");
        }
        if (cs.length == 1) {
            double c = cs[0];
            PolyDense<Object> q = Polynomial$.MODULE$.dense$mDc$sp((double[])Predef$.MODULE$.genericArrayOps(this.coeffs()).map(new Serializable(this, field2, c){
                public final Field field$2;
                public final double c$2;

                public final double apply(double x$23) {
                    return this.field$2.div$mcD$sp(x$23, this.c$2);
                }

                public double apply$mcDD$sp(double x$23) {
                    return this.field$2.div$mcD$sp(x$23, this.c$2);
                }
                {
                    this.field$2 = field$2;
                    this.c$2 = c$2;
                }
            }, Array$.MODULE$.canBuildFrom(this.ct())), field2, eq2, this.ct());
            PolyDense<Object> r = Polynomial$.MODULE$.dense$mDc$sp((double[])this.ct().newArray(0), field2, eq2, this.ct());
            tuple22 = new Tuple2<PolyDense<Object>, PolyDense<Object>>(q, r);
        } else {
            tuple22 = this.eval$2((double[])this.ct().newArray(0), (double[])Predef$.MODULE$.genericArrayOps(this.coeffs()).reverse(), this.degree() - rhs.degree(), rhs, field2, eq2);
        }
        return tuple22;
    }

    @Override
    public Polynomial<Object> $times$colon(double k, Semiring<Object> ring, Eq<Object> eq2) {
        return this.$times$colon$mcD$sp(k, ring, eq2);
    }

    @Override
    public Polynomial<Object> $times$colon$mcD$sp(double k, Semiring<Object> ring, Eq<Object> eq2) {
        PolyDense<Object> polyDense;
        if (eq2.eqv$mcD$sp(k, ring.zero$mcD$sp())) {
            polyDense = Polynomial$.MODULE$.dense$mDc$sp((double[])this.ct().newArray(0), ring, eq2, this.ct());
        } else {
            double[] cs = (double[])this.ct().newArray(this.coeffs().length);
            for (int index$macro$190 = 0; index$macro$190 < cs.length; ++index$macro$190) {
                cs[index$macro$190] = ring.times$mcD$sp(k, this.coeffs()[index$macro$190]);
            }
            polyDense = Polynomial$.MODULE$.dense$mDc$sp(cs, ring, eq2, this.ct());
        }
        return polyDense;
    }

    @Override
    public boolean specInstance$() {
        return true;
    }

    private final double[] zipSum$2(double[] lcs, double[] rcs, Ring r, Field field$2) {
        return (double[])Predef$.MODULE$.genericArrayOps(package$array$.MODULE$.ArrayInnerProductSpace$mDc$sp(field$2, this.ct()).plus(lcs, rcs)).tail();
    }

    private final Polynomial polyFromCoeffsLE$2(double[] cs, Field field$2, Eq eq$2) {
        return Polynomial$.MODULE$.dense$mDc$sp(cs, field$2, eq$2, this.ct());
    }

    private final Polynomial polyFromCoeffsBE$2(double[] cs, Field field$2, Eq eq$2) {
        double[] ncs = (double[])Predef$.MODULE$.genericArrayOps(cs).dropWhile(new Serializable(this, field$2, eq$2){
            public final Field field$2;
            public final Eq eq$2;

            public final boolean apply(double x$21) {
                return this.eq$2.eqv$mcD$sp(x$21, this.field$2.zero$mcD$sp());
            }

            public boolean apply$mcZD$sp(double x$21) {
                return this.eq$2.eqv$mcD$sp(x$21, this.field$2.zero$mcD$sp());
            }
            {
                this.field$2 = field$2;
                this.eq$2 = eq$2;
            }
        });
        return Polynomial$.MODULE$.dense$mDc$sp((double[])Predef$.MODULE$.genericArrayOps(ncs).reverse(), field$2, eq$2, this.ct());
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Tuple2 eval$2(double[] q, double[] u, int n, Polynomial rhs$2, Field field$2, Eq eq$2) {
        while (!Predef$.MODULE$.genericArrayOps(u).isEmpty() && n >= 0) {
            double[] uprime;
            void var7_7;
            double v0 = rhs$2.isZero() ? field$2.zero$mcD$sp() : rhs$2.maxOrderTermCoeff$mcD$sp(field$2);
            try {
                double q0 = field$2.div$mcD$sp(u[0], v0);
                uprime = this.zipSum$2(u, (double[])Predef$.MODULE$.genericArrayOps(Predef$.MODULE$.genericArrayOps(rhs$2.coeffsArray$mcD$sp(field$2)).reverse()).map(new Serializable(this, field$2, (double)var7_7){
                    private final Field field$2;
                    private final double q0$2;

                    public final double apply(double x$22) {
                        return this.apply$mcDD$sp(x$22);
                    }

                    public double apply$mcDD$sp(double x$22) {
                        return this.field$2.times$mcD$sp(x$22, this.field$2.negate$mcD$sp(this.q0$2));
                    }
                    {
                        this.field$2 = field$2;
                        this.q0$2 = q0$2;
                    }
                }, Array$.MODULE$.canBuildFrom(this.ct())), field$2, field$2);
            }
            catch (Exception exception) {
                Predef$ predef$ = Predef$.MODULE$;
                Predef$.MODULE$.println(new StringOps("%s %s").format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToBoolean(rhs$2.isZero()), BoxesRunTime.boxToDouble(v0)})));
                Predef$ predef$2 = Predef$.MODULE$;
                Predef$.MODULE$.println(new StringOps("%s / %s exploded").format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToDouble(u[0]), BoxesRunTime.boxToDouble(v0)})));
                throw exception;
            }
            --n;
            u = uprime;
            q = (double[])Predef$.MODULE$.genericArrayOps(Array$.MODULE$.apply(Predef$.MODULE$.genericWrapArray(new double[]{var7_7}), this.ct())).$plus$plus(Predef$.MODULE$.genericArrayOps(q), Array$.MODULE$.canBuildFrom(this.ct()));
        }
        return new Tuple2<Polynomial, Polynomial>(this.polyFromCoeffsLE$2(q, field$2, eq$2), this.polyFromCoeffsBE$2(u, field$2, eq$2));
    }

    public PolyDense$mcD$sp(double[] coeffs$mcD$sp, ClassTag<Object> ct) {
        this.coeffs$mcD$sp = coeffs$mcD$sp;
        super(null, ct);
        Polynomial$mcD$sp$class.$init$(this);
    }
}

