/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.flatfile.lexical.formats;

import com.mulesoft.flatfile.lexical.ErrorHandler;
import com.mulesoft.flatfile.lexical.LexerBase;
import com.mulesoft.flatfile.lexical.LexicalException;
import com.mulesoft.flatfile.lexical.TypeFormat;
import com.mulesoft.flatfile.lexical.WriterBase;
import java.io.IOException;

public abstract class TypeFormatBase
implements TypeFormat {
    protected static final char[] SPACES = "                   ".toCharArray();
    protected static final char[] ZEROES = "0000000000000000000".toCharArray();
    protected final String typeCode;
    protected final int minLength;
    protected final int maxLength;

    public TypeFormatBase(String code, int min2, int max2) {
        if (max2 < min2) {
            throw new IllegalArgumentException("Maximum length cannot be less than minimum length");
        }
        if (min2 < 0) {
            throw new IllegalArgumentException("Negative length is not allowed");
        }
        this.typeCode = code;
        this.minLength = min2;
        this.maxLength = max2;
    }

    @Override
    public String typeCode() {
        return this.typeCode;
    }

    @Override
    public int minLength() {
        return this.minLength;
    }

    @Override
    public int maxLength() {
        return this.maxLength;
    }

    protected void wrongType(Object obj, ErrorHandler handler) throws LexicalException {
        if (obj == null) {
            handler.error(this, ErrorHandler.ErrorCondition.WRONG_TYPE, "null value not allowed");
        } else {
            handler.error(this, ErrorHandler.ErrorCondition.WRONG_TYPE, "incompatible type for supplied value object: " + obj.getClass().getName());
        }
    }

    protected void tooShort(int length, ErrorHandler handler) throws LexicalException {
        handler.error(this, ErrorHandler.ErrorCondition.TOO_SHORT, "effective length " + length + " is less than " + this.minLength);
    }

    protected void tooLong(int length, ErrorHandler handler) throws LexicalException {
        handler.error(this, ErrorHandler.ErrorCondition.TOO_LONG, "effective length " + length + " is greater than " + this.maxLength);
    }

    protected void invalidCharacter(char chr, ErrorHandler handler) throws LexicalException {
        handler.error(this, ErrorHandler.ErrorCondition.INVALID_CHARACTER, "character '" + chr + "' not allowed");
    }

    protected void noValuePresent(LexerBase lexer) throws LexicalException {
        lexer.error(this, ErrorHandler.ErrorCondition.INVALID_FORMAT, "no value present");
    }

    protected void invalidInput(LexerBase lexer) throws LexicalException {
        lexer.error(this, ErrorHandler.ErrorCondition.INVALID_FORMAT, "input does not match format");
    }

    public void checkInputLength(LexerBase lexer) throws LexicalException {
        StringBuilder builder = lexer.tokenBuilder();
        int length = builder.length();
        if (length < this.minLength) {
            this.tooShort(length, lexer);
        }
        if (length > this.maxLength) {
            this.tooLong(length, lexer);
            builder.setLength(this.maxLength);
        }
    }

    public String checkOutputLength(String token2, WriterBase writer) throws LexicalException {
        int length = token2.length();
        if (length < this.minLength) {
            this.tooShort(length, writer);
        }
        if (length > this.maxLength) {
            this.tooLong(length, writer);
            return token2.substring(0, this.maxLength);
        }
        return token2;
    }

    public String checkOutputMaxLength(String token2, WriterBase writer) throws LexicalException {
        int length = token2.length();
        if (length > this.maxLength) {
            this.tooLong(length, writer);
            return token2.substring(0, this.maxLength);
        }
        return token2;
    }

    public void verifyDigits(LexerBase lexer) throws LexicalException {
        StringBuilder builder = lexer.tokenBuilder();
        for (int i = 0; i < builder.length(); ++i) {
            char chr = builder.charAt(i);
            if (chr >= '0' && chr <= '9') continue;
            this.invalidCharacter(chr, lexer);
            builder.deleteCharAt(i--);
        }
    }

    protected static void stripSpaceLeft(StringBuilder builder) {
        int index2;
        for (index2 = 0; index2 < builder.length() && builder.charAt(index2) == ' '; ++index2) {
        }
        if (index2 > 0) {
            builder.delete(0, index2);
        }
    }

    protected static void stripSpaceRight(StringBuilder builder) {
        int index2;
        for (index2 = builder.length() - 1; index2 >= 0 && builder.charAt(index2) == ' '; --index2) {
        }
        if (index2 < builder.length() - 1) {
            builder.delete(index2 + 1, builder.length());
        }
    }

    protected static void writePadding(int count2, char[] padding2, WriterBase writer) throws IOException {
        int use;
        for (int remain = count2; remain > 0; remain -= use) {
            use = Math.min(remain, padding2.length);
            writer.writeUnchecked(padding2, 0, use);
        }
    }

    public static void fillPadding(int count2, char[] padding2, StringBuilder builder) {
        int use;
        for (int remain = count2; remain > 0; remain -= use) {
            use = Math.min(remain, padding2.length);
            builder.append(padding2, 0, use);
        }
    }

    protected static void appendTwoDigit(int num, StringBuilder builder) {
        if (num < 10) {
            builder.append('0');
        }
        builder.append(num);
    }

    protected static void appendFourDigit(int num, StringBuilder builder) {
        if (num < 1000) {
            builder.append('0');
            if (num < 100) {
                builder.append('0');
                if (num < 10) {
                    builder.append('0');
                }
            }
        }
        builder.append(num);
    }
}

