/*
 * Decompiled with CFR 0.152.
 */
package spire.math;

import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.BigInt;
import scala.math.ScalaNumber;
import scala.runtime.BoxesRunTime;
import spire.math.Rational;
import spire.math.Rational$;
import spire.math.Real;
import spire.math.Real$;
import spire.math.SafeLong;
import spire.math.SafeLong$;

public abstract class Real$class {
    public static Rational toRational(Real $this, int p) {
        Rational rational2;
        if ($this instanceof Real.Exact) {
            Real.Exact exact = (Real.Exact)$this;
            rational2 = exact.n();
        } else {
            rational2 = Rational$.MODULE$.apply($this.apply(p), SafeLong$.MODULE$.two().pow(p));
        }
        return rational2;
    }

    public static Rational toRational(Real $this) {
        return $this.toRational(Real$.MODULE$.bits());
    }

    public static double doubleValue(Real $this) {
        return $this.toRational().toDouble();
    }

    public static float floatValue(Real $this) {
        return $this.toRational().toFloat();
    }

    public static int intValue(Real $this) {
        return $this.toRational().toInt();
    }

    public static long longValue(Real $this) {
        return $this.toRational().toLong();
    }

    public static Object underlying(Real $this) {
        return $this;
    }

    public static int hashCode(Real $this) {
        return $this.toRational().hashCode();
    }

    public static boolean equals(Real $this, Object y) {
        boolean bl;
        if (y instanceof Real) {
            Real real = (Real)y;
            bl = $this.eqv(real);
        } else {
            bl = $this.toRational().equals(y);
        }
        return bl;
    }

    public static boolean eqv(Real $this, Real y) {
        return $this.compare(y) == 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int compare(Real $this, Real y) {
        Tuple2<Real, Real> tuple22 = new Tuple2<Real, Real>($this, y);
        if (!(tuple22._1() instanceof Real.Exact)) return $this.$minus(y).signum();
        Real.Exact exact = (Real.Exact)tuple22._1();
        if (!(tuple22._2() instanceof Real.Exact)) return $this.$minus(y).signum();
        Real.Exact exact2 = (Real.Exact)tuple22._2();
        return exact.n().compare(exact2.n());
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public static Real min(Real $this, Real y) {
        void var7_7;
        Tuple2<Real, Real> tuple22 = new Tuple2<Real, Real>($this, y);
        if (tuple22._1() instanceof Real.Exact) {
            Real.Exact exact = (Real.Exact)tuple22._1();
            if (tuple22._2() instanceof Real.Exact) {
                Real.Exact exact2 = (Real.Exact)tuple22._2();
                Real.Exact exact3 = new Real.Exact(exact.n().min(exact2.n()));
                return var7_7;
            }
        }
        Serializable serializable = new Serializable($this, y){
            private final /* synthetic */ Real $outer;
            private final Real y$2;

            public final SafeLong apply(int p) {
                return this.$outer.apply(p).min(this.y$2.apply(p));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.y$2 = y$2;
            }
        };
        Real$ real$ = Real$.MODULE$;
        Real.Inexact inexact = new Real.Inexact((Function1<Object, SafeLong>)((Object)serializable));
        return var7_7;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public static Real max(Real $this, Real y) {
        void var7_7;
        Tuple2<Real, Real> tuple22 = new Tuple2<Real, Real>($this, y);
        if (tuple22._1() instanceof Real.Exact) {
            Real.Exact exact = (Real.Exact)tuple22._1();
            if (tuple22._2() instanceof Real.Exact) {
                Real.Exact exact2 = (Real.Exact)tuple22._2();
                Real.Exact exact3 = new Real.Exact(exact.n().max(exact2.n()));
                return var7_7;
            }
        }
        Serializable serializable = new Serializable($this, y){
            private final /* synthetic */ Real $outer;
            private final Real y$3;

            public final SafeLong apply(int p) {
                return this.$outer.apply(p).max(this.y$3.apply(p));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.y$3 = y$3;
            }
        };
        Real$ real$ = Real$.MODULE$;
        Real.Inexact inexact = new Real.Inexact((Function1<Object, SafeLong>)((Object)serializable));
        return var7_7;
    }

    public static Real abs(Real $this) {
        ScalaNumber scalaNumber;
        if ($this instanceof Real.Exact) {
            Real.Exact exact = (Real.Exact)$this;
            scalaNumber = new Real.Exact(exact.n().abs());
        } else {
            Serializable serializable = new Serializable($this){
                private final /* synthetic */ Real $outer;

                public final SafeLong apply(int p) {
                    return this.$outer.apply(p).abs();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            };
            Real$ real$ = Real$.MODULE$;
            scalaNumber = new Real.Inexact((Function1<Object, SafeLong>)((Object)serializable));
        }
        return scalaNumber;
    }

    public static int signum(Real $this) {
        int n;
        if ($this instanceof Real.Exact) {
            Real.Exact exact = (Real.Exact)$this;
            n = exact.n().signum();
        } else {
            n = $this.apply(Real$.MODULE$.bits()).signum();
        }
        return n;
    }

    public static Real unary_$minus(Real $this) {
        ScalaNumber scalaNumber;
        if ($this instanceof Real.Exact) {
            Real.Exact exact = (Real.Exact)$this;
            scalaNumber = new Real.Exact(exact.n().unary_$minus());
        } else {
            Serializable serializable = new Serializable($this){
                private final /* synthetic */ Real $outer;

                public final SafeLong apply(int p) {
                    return this.$outer.apply(p).unary_$minus();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            };
            Real$ real$ = Real$.MODULE$;
            scalaNumber = new Real.Inexact((Function1<Object, SafeLong>)((Object)serializable));
        }
        return scalaNumber;
    }

    public static Real reciprocal(Real $this) {
        ScalaNumber scalaNumber;
        if ($this instanceof Real.Exact) {
            Real.Exact exact = (Real.Exact)$this;
            scalaNumber = new Real.Exact(exact.n().reciprocal());
        } else {
            Serializable serializable = new Serializable($this){
                private final /* synthetic */ Real $outer;

                public final SafeLong apply(int p) {
                    int s2 = Real$class.findNonzero$1(this.$outer, 0);
                    return Real$.MODULE$.roundUp(Rational$.MODULE$.apply(SafeLong$.MODULE$.two().pow(2 * p + 2 * s2 + 2), this.$outer.apply(p + 2 * s2 + 2)));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            };
            Real$ real$ = Real$.MODULE$;
            scalaNumber = new Real.Inexact((Function1<Object, SafeLong>)((Object)serializable));
        }
        return scalaNumber;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public static Real $plus(Real $this, Real y) {
        void var13_9;
        Tuple2<Real, Real> tuple22 = new Tuple2<Real, Real>($this, y);
        if (tuple22._1() instanceof Real.Exact) {
            Real.Exact exact = (Real.Exact)tuple22._1();
            if (tuple22._2() instanceof Real.Exact) {
                Real.Exact exact2 = (Real.Exact)tuple22._2();
                Real.Exact exact3 = new Real.Exact(exact.n().$plus(exact2.n()));
                return var13_9;
            }
        }
        if (tuple22._1() instanceof Real.Exact) {
            Real.Exact exact = (Real.Exact)tuple22._1();
            Rational rational2 = exact.n();
            Rational rational3 = Rational$.MODULE$.zero();
            boolean bl = rational3 != rational2 ? (rational3 != null ? (!(rational3 instanceof Number) ? (!(rational3 instanceof Character) ? rational3.equals(rational2) : BoxesRunTime.equalsCharObject((Character)((Object)rational3), rational2)) : BoxesRunTime.equalsNumObject(rational3, rational2)) : false) : true;
            if (bl) {
                Real real = y;
                return var13_9;
            }
        }
        if (tuple22._2() instanceof Real.Exact) {
            Real.Exact exact = (Real.Exact)tuple22._2();
            Rational rational4 = exact.n();
            Rational rational5 = Rational$.MODULE$.zero();
            boolean bl = rational5 != rational4 ? (rational5 != null ? (!(rational5 instanceof Number) ? (!(rational5 instanceof Character) ? rational5.equals(rational4) : BoxesRunTime.equalsCharObject((Character)((Object)rational5), rational4)) : BoxesRunTime.equalsNumObject(rational5, rational4)) : false) : true;
            if (bl) {
                Real real = $this;
                return var13_9;
            }
        }
        Serializable serializable = new Serializable($this, y){
            private final /* synthetic */ Real $outer;
            private final Real y$4;

            public final SafeLong apply(int p) {
                return Real$.MODULE$.roundUp(Rational$.MODULE$.apply(this.$outer.apply(p + 2).$plus(this.y$4.apply(p + 2)), SafeLong$.MODULE$.apply(4L)));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.y$4 = y$4;
            }
        };
        Real$ real$ = Real$.MODULE$;
        Real.Inexact inexact = new Real.Inexact((Function1<Object, SafeLong>)((Object)serializable));
        return var13_9;
    }

    public static Real $minus(Real $this, Real y) {
        return $this.$plus(y.unary_$minus());
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public static Real $times(Real $this, Real y) {
        void var19_11;
        Tuple2<Real, Real> tuple22 = new Tuple2<Real, Real>($this, y);
        if (tuple22._1() instanceof Real.Exact) {
            Real.Exact exact = (Real.Exact)tuple22._1();
            if (tuple22._2() instanceof Real.Exact) {
                Real.Exact exact2 = (Real.Exact)tuple22._2();
                Real.Exact exact3 = new Real.Exact(exact.n().$times(exact2.n()));
                return var19_11;
            }
        }
        if (tuple22._1() instanceof Real.Exact) {
            Real.Exact exact = (Real.Exact)tuple22._1();
            Rational rational2 = exact.n();
            Rational rational3 = Rational$.MODULE$.zero();
            boolean bl = rational3 != rational2 ? (rational3 != null ? (!(rational3 instanceof Number) ? (!(rational3 instanceof Character) ? rational3.equals(rational2) : BoxesRunTime.equalsCharObject((Character)((Object)rational3), rational2)) : BoxesRunTime.equalsNumObject(rational3, rational2)) : false) : true;
            if (bl) {
                Real real = Real$.MODULE$.zero();
                return var19_11;
            }
        }
        if (tuple22._2() instanceof Real.Exact) {
            Real.Exact exact = (Real.Exact)tuple22._2();
            Rational rational4 = exact.n();
            Rational rational5 = Rational$.MODULE$.zero();
            boolean bl = rational5 != rational4 ? (rational5 != null ? (!(rational5 instanceof Number) ? (!(rational5 instanceof Character) ? rational5.equals(rational4) : BoxesRunTime.equalsCharObject((Character)((Object)rational5), rational4)) : BoxesRunTime.equalsNumObject(rational5, rational4)) : false) : true;
            if (bl) {
                Real real = Real$.MODULE$.zero();
                return var19_11;
            }
        }
        if (tuple22._1() instanceof Real.Exact) {
            Real.Exact exact = (Real.Exact)tuple22._1();
            Rational rational6 = exact.n();
            Rational rational7 = Rational$.MODULE$.one();
            boolean bl = rational7 != rational6 ? (rational7 != null ? (!(rational7 instanceof Number) ? (!(rational7 instanceof Character) ? rational7.equals(rational6) : BoxesRunTime.equalsCharObject((Character)((Object)rational7), rational6)) : BoxesRunTime.equalsNumObject(rational7, rational6)) : false) : true;
            if (bl) {
                Real real = y;
                return var19_11;
            }
        }
        if (tuple22._2() instanceof Real.Exact) {
            Real.Exact exact = (Real.Exact)tuple22._2();
            Rational rational8 = exact.n();
            Rational rational9 = Rational$.MODULE$.one();
            boolean bl = rational9 != rational8 ? (rational9 != null ? (!(rational9 instanceof Number) ? (!(rational9 instanceof Character) ? rational9.equals(rational8) : BoxesRunTime.equalsCharObject((Character)((Object)rational9), rational8)) : BoxesRunTime.equalsNumObject(rational9, rational8)) : false) : true;
            if (bl) {
                Real real = $this;
                return var19_11;
            }
        }
        Serializable serializable = new Serializable($this, y){
            private final /* synthetic */ Real $outer;
            private final Real y$5;

            public final SafeLong apply(int p) {
                SafeLong x0 = this.$outer.apply(0).abs().$plus(2L);
                SafeLong y0 = this.y$5.apply(0).abs().$plus(2L);
                int sx = Real$.MODULE$.sizeInBase(x0, 2) + 3;
                int sy = Real$.MODULE$.sizeInBase(y0, 2) + 3;
                return Real$.MODULE$.roundUp(Rational$.MODULE$.apply(this.$outer.apply(p + sy).$times(this.y$5.apply(p + sx)), SafeLong$.MODULE$.two().pow(p + sx + sy)));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.y$5 = y$5;
            }
        };
        Real$ real$ = Real$.MODULE$;
        Real.Inexact inexact = new Real.Inexact((Function1<Object, SafeLong>)((Object)serializable));
        return var19_11;
    }

    public static Real $times$times(Real $this, int k) {
        return $this.pow(k);
    }

    public static Real pow(Real $this, int k) {
        Real real;
        if ($this instanceof Real.Exact) {
            Real.Exact exact = (Real.Exact)$this;
            real = new Real.Exact(exact.n().pow(k));
        } else {
            real = k < 0 ? $this.reciprocal().pow(-k) : (k == 0 ? Real$.MODULE$.one() : (k == 1 ? $this : Real$class.loop$1($this, $this, k - 1, $this)));
        }
        return real;
    }

    public static Real $div(Real $this, Real y) {
        return $this.$times(y.reciprocal());
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public static Real $percent(Real $this, Real y) {
        void var7_7;
        Tuple2<Real, Real> tuple22 = new Tuple2<Real, Real>($this, y);
        if (tuple22._1() instanceof Real.Exact) {
            Real.Exact exact = (Real.Exact)tuple22._1();
            if (tuple22._2() instanceof Real.Exact) {
                Real.Exact exact2 = (Real.Exact)tuple22._2();
                Real.Exact exact3 = new Real.Exact(exact.n().$percent(exact2.n()));
                return var7_7;
            }
        }
        Serializable serializable = new Serializable($this, y){
            private final /* synthetic */ Real $outer;
            private final Real y$6;

            public final SafeLong apply(int p) {
                Real d = this.$outer.$div(this.y$6);
                SafeLong s2 = d.apply(2);
                Real d2 = s2.$greater$eq(SafeLong$.MODULE$.apply(0L)) ? d.floor() : d.ceil();
                return this.$outer.$minus(d2.$times(this.y$6)).apply(p);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.y$6 = y$6;
            }
        };
        Real$ real$ = Real$.MODULE$;
        Real.Inexact inexact = new Real.Inexact((Function1<Object, SafeLong>)((Object)serializable));
        return var7_7;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public static Real $div$tilde(Real $this, Real y) {
        void var7_7;
        Tuple2<Real, Real> tuple22 = new Tuple2<Real, Real>($this, y);
        if (tuple22._1() instanceof Real.Exact) {
            Real.Exact exact = (Real.Exact)tuple22._1();
            if (tuple22._2() instanceof Real.Exact) {
                Real.Exact exact2 = (Real.Exact)tuple22._2();
                Real.Exact exact3 = new Real.Exact(exact.n().$div$tilde(exact2.n()));
                return var7_7;
            }
        }
        Serializable serializable = new Serializable($this, y){
            private final /* synthetic */ Real $outer;
            private final Real y$7;

            public final SafeLong apply(int p) {
                Real d = this.$outer.$div(this.y$7);
                SafeLong s2 = d.apply(2);
                Real d2 = s2.$greater$eq(SafeLong$.MODULE$.apply(0L)) ? d.floor() : d.ceil();
                return d2.apply(p);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.y$7 = y$7;
            }
        };
        Real$ real$ = Real$.MODULE$;
        Real.Inexact inexact = new Real.Inexact((Function1<Object, SafeLong>)((Object)serializable));
        return var7_7;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public static Real gcd(Real $this, Real y) {
        void var7_7;
        Tuple2<Real, Real> tuple22 = new Tuple2<Real, Real>($this, y);
        if (tuple22._1() instanceof Real.Exact) {
            Real.Exact exact = (Real.Exact)tuple22._1();
            if (tuple22._2() instanceof Real.Exact) {
                Real.Exact exact2 = (Real.Exact)tuple22._2();
                Real.Exact exact3 = new Real.Exact(exact.n().gcd(exact2.n()));
                return var7_7;
            }
        }
        Serializable serializable = new Serializable($this, y){
            private final /* synthetic */ Real $outer;
            private final Real y$8;

            public final SafeLong apply(int p) {
                Rational g = this.$outer.toRational(p).gcd(this.y$8.toRational(p));
                return Real$.MODULE$.roundUp(g.$times(Rational$.MODULE$.apply(SafeLong$.MODULE$.two().pow(p))));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.y$8 = y$8;
            }
        };
        Real$ real$ = Real$.MODULE$;
        Real.Inexact inexact = new Real.Inexact((Function1<Object, SafeLong>)((Object)serializable));
        return var7_7;
    }

    public static Real ceil(Real $this) {
        ScalaNumber scalaNumber;
        if ($this instanceof Real.Exact) {
            Real.Exact exact = (Real.Exact)$this;
            scalaNumber = new Real.Exact(exact.n().ceil());
        } else {
            Serializable serializable = new Serializable($this){
                private final /* synthetic */ Real $outer;

                public final SafeLong apply(int p) {
                    SafeLong m;
                    SafeLong n = this.$outer.apply(p);
                    SafeLong t = SafeLong$.MODULE$.two().pow(p);
                    SafeLong safeLong = m = n.$percent(t);
                    Integer n2 = BoxesRunTime.boxToInteger(0);
                    return safeLong != null && safeLong.equals(n2) ? n : (n.signum() >= 0 ? n.$plus(t).$minus(m) : n.$minus(m));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            };
            Real$ real$ = Real$.MODULE$;
            scalaNumber = new Real.Inexact((Function1<Object, SafeLong>)((Object)serializable));
        }
        return scalaNumber;
    }

    public static Real floor(Real $this) {
        ScalaNumber scalaNumber;
        if ($this instanceof Real.Exact) {
            Real.Exact exact = (Real.Exact)$this;
            scalaNumber = new Real.Exact(exact.n().floor());
        } else {
            Serializable serializable = new Serializable($this){
                private final /* synthetic */ Real $outer;

                public final SafeLong apply(int p) {
                    SafeLong n = this.$outer.apply(p);
                    SafeLong t = SafeLong$.MODULE$.two().pow(p);
                    SafeLong m = n.$percent(t);
                    return n.signum() >= 0 ? n.$minus(m) : n.$minus(t).$minus(m);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            };
            Real$ real$ = Real$.MODULE$;
            scalaNumber = new Real.Inexact((Function1<Object, SafeLong>)((Object)serializable));
        }
        return scalaNumber;
    }

    public static Real round(Real $this) {
        ScalaNumber scalaNumber;
        if ($this instanceof Real.Exact) {
            Real.Exact exact = (Real.Exact)$this;
            scalaNumber = new Real.Exact(exact.n().round());
        } else {
            Serializable serializable = new Serializable($this){
                private final /* synthetic */ Real $outer;

                public final SafeLong apply(int p) {
                    SafeLong n = this.$outer.apply(p);
                    SafeLong t = SafeLong$.MODULE$.two().pow(p);
                    SafeLong h = t.$div(2L);
                    SafeLong m = n.$percent(t);
                    return m.$less(h) ? n.$minus(m) : n.$minus(m).$plus(t);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            };
            Real$ real$ = Real$.MODULE$;
            scalaNumber = new Real.Inexact((Function1<Object, SafeLong>)((Object)serializable));
        }
        return scalaNumber;
    }

    public static boolean isWhole(Real $this) {
        boolean bl;
        if ($this instanceof Real.Exact) {
            Real.Exact exact = (Real.Exact)$this;
            bl = exact.n().isWhole();
        } else {
            SafeLong n = $this.apply(Real$.MODULE$.bits());
            SafeLong t = SafeLong$.MODULE$.two().pow(Real$.MODULE$.bits());
            SafeLong safeLong = n.$percent(t);
            Integer n2 = BoxesRunTime.boxToInteger(0);
            bl = safeLong != null && safeLong.equals(n2);
        }
        return bl;
    }

    public static Real sqrt(Real $this) {
        Serializable serializable = new Serializable($this){
            private final /* synthetic */ Real $outer;

            public final SafeLong apply(int p) {
                return (SafeLong)SafeLong$.MODULE$.SafeLongAlgebra().sqrt(this.$outer.apply(p * 2));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        Real$ real$ = Real$.MODULE$;
        return new Real.Inexact((Function1<Object, SafeLong>)((Object)serializable));
    }

    public static Real nroot(Real $this, int k) {
        Serializable serializable = new Serializable($this, k){
            private final /* synthetic */ Real $outer;
            private final int k$1;

            public final SafeLong apply(int p) {
                return SafeLong$.MODULE$.SafeLongAlgebra().nroot(this.$outer.apply(p * this.k$1), this.k$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.k$1 = k$1;
            }
        };
        Real$ real$ = Real$.MODULE$;
        return new Real.Inexact((Function1<Object, SafeLong>)((Object)serializable));
    }

    public static Real fpow(Real $this, Rational r) {
        Serializable serializable = new Serializable($this, r){
            private final /* synthetic */ Real $outer;
            private final Rational r$2;

            public final SafeLong apply(int p) {
                Rational r2 = this.r$2.limitToInt();
                BigInt n = r2.numerator();
                BigInt d = r2.denominator();
                return this.$outer.pow(n.toInt()).nroot(d.toInt()).apply(p);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.r$2 = r$2;
            }
        };
        Real$ real$ = Real$.MODULE$;
        return new Real.Inexact((Function1<Object, SafeLong>)((Object)serializable));
    }

    public static Real fpow(Real $this, Real y) {
        Real real;
        if (y instanceof Real.Exact) {
            Real.Exact exact = (Real.Exact)y;
            real = $this.fpow(exact.n());
        } else {
            Serializable serializable = new Serializable($this, y){
                private final /* synthetic */ Real $outer;
                private final Real y$9;

                public final SafeLong apply(int p) {
                    return this.$outer.fpow(Rational$.MODULE$.apply(this.y$9.apply(p), SafeLong$.MODULE$.two().pow(p))).apply(p);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.y$9 = y$9;
                }
            };
            Real$ real$ = Real$.MODULE$;
            real = new Real.Inexact((Function1<Object, SafeLong>)((Object)serializable));
        }
        return real;
    }

    public static String toString(Real $this) {
        String string2;
        if ($this instanceof Real.Exact) {
            Real.Exact exact = (Real.Exact)$this;
            string2 = exact.n().toString();
        } else {
            string2 = $this.getString(Real$.MODULE$.digits());
        }
        return string2;
    }

    public static String repr(Real $this) {
        String string2;
        if ($this instanceof Real.Exact) {
            Real.Exact exact = (Real.Exact)$this;
            string2 = new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Exact(", ")"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{exact.n().toString()}));
        } else {
            string2 = new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Inexact(", ")"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{$this.toRational()}));
        }
        return string2;
    }

    public static String getString(Real $this, int d) {
        String string2;
        Tuple2<String, String> tuple22;
        int b = Real$.MODULE$.digitsToBits(d);
        Rational r = Rational$.MODULE$.apply($this.apply(b).$times(SafeLong$.MODULE$.ten().pow(d)), SafeLong$.MODULE$.two().pow(b));
        SafeLong m = Real$.MODULE$.roundUp(r);
        int n = m.signum();
        switch (n) {
            default: {
                throw new MatchError(BoxesRunTime.boxToInteger(n));
            }
            case 1: {
                tuple22 = new Tuple2<String, String>("", m.toString());
                break;
            }
            case 0: {
                tuple22 = new Tuple2<String, String>("", "0");
                break;
            }
            case -1: {
                tuple22 = new Tuple2<String, String>("-", m.abs().toString());
            }
        }
        Tuple2<String, String> tuple23 = tuple22;
        Tuple2<String, String> tuple24 = new Tuple2<String, String>(tuple23._1(), tuple23._2());
        String sign = tuple24._1();
        String str = tuple24._2();
        int i = str.length() - d;
        if (i > 0) {
            string2 = new StringBuilder().append((Object)sign).append((Object)str.substring(0, i)).append((Object)".").append((Object)str.substring(i)).toString();
        } else {
            Predef$ predef$ = Predef$.MODULE$;
            string2 = new StringBuilder().append((Object)sign).append((Object)"0.").append((Object)new StringOps("0").$times(-i)).append((Object)str).toString();
        }
        String s2 = string2;
        return s2.replaceAll("0+$", "").replaceAll("\\.$", "");
    }

    public static final int findNonzero$1(Real $this, int i) {
        while (!SafeLong$.MODULE$.three().$less$eq($this.apply(i).abs())) {
            ++i;
        }
        return i;
    }

    private static final Real loop$1(Real $this, Real b, int k, Real extra) {
        while (k != 1) {
            extra = (k & 1) == 1 ? b.$times(extra) : extra;
            k >>>= 1;
            b = b.$times(b);
        }
        return b.$times(extra);
    }

    public static void $init$(Real $this) {
    }
}

