/*
 * Decompiled with CFR 0.152.
 */
package spire.math;

import java.math.MathContext;
import java.math.RoundingMode;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.math.BigDecimal;
import scala.math.BigDecimal$;
import scala.math.BigDecimal$RoundingMode$;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.math.ScalaNumericConversions;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;
import scala.runtime.RichFloat$;
import scala.runtime.RichLong$;
import spire.algebra.EuclideanRing;
import spire.algebra.Field;
import spire.algebra.IsReal;
import spire.algebra.NRoot;
import spire.algebra.Order;
import spire.algebra.Signed;
import spire.algebra.Signed$;
import spire.algebra.Trig;
import spire.implicits$;
import spire.std.package$bigDecimal$;
import spire.syntax.LiteralIntAdditiveSemigroupOps$;

public final class package$ {
    public static final package$ MODULE$;

    static {
        new package$();
    }

    public final byte abs(byte n) {
        return (byte)Math.abs(n);
    }

    public final short abs(short n) {
        return (short)Math.abs(n);
    }

    public final int abs(int n) {
        return Math.abs(n);
    }

    public final long abs(long n) {
        return Math.abs(n);
    }

    public final float abs(float n) {
        return Math.abs(n);
    }

    public final double abs(double n) {
        return Math.abs(n);
    }

    public final <A> A abs(A a, Signed<A> ev) {
        return ev.abs(a);
    }

    public final float ceil(float n) {
        return (float)Math.ceil(n);
    }

    public final double ceil(double n) {
        return Math.ceil(n);
    }

    public final BigDecimal ceil(BigDecimal n) {
        return n.setScale(0, BigDecimal$RoundingMode$.MODULE$.CEILING());
    }

    public final <A> A ceil(A a, IsReal<A> ev) {
        return ev.ceil(a);
    }

    public BigInt choose(long n, long k) {
        if (n < 0L || k < 0L) {
            throw new IllegalArgumentException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"n=", ", k=", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(n), BoxesRunTime.boxToLong(k)})));
        }
        if (k == 0L || k == n) {
            return scala.package$.MODULE$.BigInt().apply(1);
        }
        if (k > n) {
            return scala.package$.MODULE$.BigInt().apply(0);
        }
        if (n - k > k) {
            return this.choose(n, n - k);
        }
        return (n - k & 1L) == 1L ? this.loop$1(k + 1L, n - 1L, scala.package$.MODULE$.BigInt().apply(n)).$div(this.fact(n - k)) : this.loop$1(k + 1L, n, scala.package$.MODULE$.BigInt().apply(1)).$div(this.fact(n - k));
    }

    public BigInt fact(long n) {
        if (n < 0L) {
            throw new IllegalArgumentException(((Object)BoxesRunTime.boxToLong(n)).toString());
        }
        return (n & 1L) == 1L ? this.loop$2(1L, n - 1L, scala.package$.MODULE$.BigInt().apply(n)) : this.loop$2(2L, n - 1L, scala.package$.MODULE$.BigInt().apply(n));
    }

    public BigInt fib(long n) {
        int i;
        if (n < 0L) {
            throw new IllegalArgumentException(((Object)BoxesRunTime.boxToLong(n)).toString());
        }
        for (i = 63; (n >>> i & 1L) == 0L && i >= 0; --i) {
        }
        return this.loop$3(scala.package$.MODULE$.BigInt().apply(1), scala.package$.MODULE$.BigInt().apply(0), i, n);
    }

    public final float floor(float n) {
        return (float)Math.floor(n);
    }

    public final double floor(double n) {
        return Math.floor(n);
    }

    public final BigDecimal floor(BigDecimal n) {
        return n.setScale(0, BigDecimal$RoundingMode$.MODULE$.FLOOR());
    }

    public final <A> A floor(A a, IsReal<A> ev) {
        return ev.floor(a);
    }

    public final float round(float a) {
        return Math.abs(a) >= 1.6777216E7f ? a : (float)Math.round(a);
    }

    public final double round(double a) {
        return Math.abs(a) >= 4.503599627370496E15 ? a : (double)Math.round(a);
    }

    public final BigDecimal round(BigDecimal a) {
        return a.setScale(0, BigDecimal$RoundingMode$.MODULE$.HALF_UP());
    }

    public final <A> A round(A a, IsReal<A> ev) {
        return ev.round(a);
    }

    public final double exp(double n) {
        return Math.exp(n);
    }

    public final BigDecimal exp(int k, int precision) {
        MathContext mc = new MathContext(precision + 1, RoundingMode.HALF_UP);
        int i = 2;
        BigInt num = scala.package$.MODULE$.BigInt().apply(2);
        BigInt denom = scala.package$.MODULE$.BigInt().apply(1);
        BigInt limit = scala.package$.MODULE$.BigInt().apply(10).pow(precision);
        while (denom.$less(limit)) {
            denom = denom.$times(BigInt$.MODULE$.int2bigInt(i));
            num = num.$times(BigInt$.MODULE$.int2bigInt(i)).$plus(scala.package$.MODULE$.BigInt().apply(1));
            ++i;
        }
        BigDecimal sum2 = scala.package$.MODULE$.BigDecimal().apply(num, mc).$div(scala.package$.MODULE$.BigDecimal().apply(denom, mc));
        return sum2.setScale(precision - sum2.precision() + sum2.scale(), BigDecimal$RoundingMode$.MODULE$.FLOOR()).pow(k);
    }

    public final BigDecimal exp(BigDecimal k) {
        if (k.signum() == 0) {
            return scala.package$.MODULE$.BigDecimal().apply(1);
        }
        if (k.signum() == -1) {
            return scala.package$.MODULE$.BigDecimal().apply(1).$div(this.exp(k.unary_$minus()));
        }
        BigDecimal whole = k.setScale(0, BigDecimal$RoundingMode$.MODULE$.FLOOR());
        if (whole.signum() > 1) {
            BigDecimal part = this.exp(scala.package$.MODULE$.BigDecimal().apply(1).$plus(k.$minus(whole).$div(whole)));
            return this.power$1(scala.package$.MODULE$.BigDecimal().apply(1), part, whole.toBigInt());
        }
        k.mc().getPrecision();
        BigDecimal r = this.doit$1(k.mc().getPrecision() + 3, 1000, k);
        return new BigDecimal(r.bigDecimal(), k.mc());
    }

    public final <A> A exp(A a, Trig<A> t) {
        return t.exp(a);
    }

    public final double log(double n) {
        return Math.log(n);
    }

    public final double log(double n, int base) {
        return Math.log(n) / Math.log(base);
    }

    public final BigDecimal log(BigDecimal n) {
        int scale = n.mc().getPrecision();
        if (n.signum() < 1) {
            throw new IllegalArgumentException("argument <= 0");
        }
        Tuple2 tuple22 = this.rescale$1(n, 0);
        if (tuple22 != null) {
            Tuple2 tuple23 = new Tuple2(tuple22._1(), BoxesRunTime.boxToInteger(tuple22._2$mcI$sp()));
            BigDecimal x = (BigDecimal)tuple23._1();
            int i = tuple23._2$mcI$sp();
            return this.ln$1(x, scale).$times(scala.package$.MODULE$.BigDecimal().apply(2).pow(i)).setScale(scale, BigDecimal$RoundingMode$.MODULE$.HALF_UP());
        }
        throw new MatchError(tuple22);
    }

    public BigDecimal log(BigDecimal n, int base) {
        return this.log(n).$div(this.log(scala.package$.MODULE$.BigDecimal().apply(base)));
    }

    public final <A> A log(A a, Trig<A> t) {
        return t.log(a);
    }

    public final <A> A log(A a, int base, Field<A> f, Trig<A> t) {
        return f.div(t.log(a), t.log(f.fromInt(base)));
    }

    public final BigDecimal pow(BigDecimal base, BigDecimal exponent) {
        return exponent.abs().$less$eq(BigDecimal$.MODULE$.int2bigDecimal(99999999)) && exponent.isWhole() ? base.pow(exponent.toInt()) : this.exp(this.log(base).$times(exponent));
    }

    public final BigInt pow(BigInt base, BigInt ex) {
        BigInt bigInt;
        if (ex.signum() < 0) {
            Integer n;
            if (base.signum() == 0) {
                throw new ArithmeticException("zero can't be raised to negative power");
            }
            Integer n2 = BoxesRunTime.boxToInteger(1);
            bigInt = (base != n2 ? (base != null ? (!(base instanceof Number) ? (!(base instanceof Character) ? ((Object)base).equals(n2) : BoxesRunTime.equalsCharObject((Character)((Object)base), n2)) : BoxesRunTime.equalsNumObject(base, n2)) : false) : true) ? base : ((base != (n = BoxesRunTime.boxToInteger(-1)) ? (base != null ? (!(base instanceof Number) ? (!(base instanceof Character) ? ((Object)base).equals(n) : BoxesRunTime.equalsCharObject((Character)((Object)base), n)) : BoxesRunTime.equalsNumObject(base, n)) : false) : true) ? (ex.testBit(0) ? scala.package$.MODULE$.BigInt().apply(1) : base) : scala.package$.MODULE$.BigInt().apply(0));
        } else {
            bigInt = ex.isValidInt() ? base.pow(ex.toInt()) : this.bigIntPow$1(scala.package$.MODULE$.BigInt().apply(1), base, ex);
        }
        return bigInt;
    }

    public final long pow(long base, long exponent) {
        long l;
        if (exponent < 0L) {
            if (base == 0L) {
                throw new ArithmeticException("zero can't be raised to negative power");
            }
            l = base == 1L ? 1L : (base == -1L ? ((exponent & 1L) == 0L ? -1L : 1L) : 0L);
        } else {
            l = this.longPow$1(1L, base, exponent);
        }
        return l;
    }

    public final double pow(double base, double exponent) {
        return Math.pow(base, exponent);
    }

    public final long gcd(long _x, long _y) {
        if (_x == 0L) {
            return Math.abs(_y);
        }
        if (_y == 0L) {
            return Math.abs(_x);
        }
        int xz = Long.numberOfTrailingZeros(_x);
        long x = Math.abs(_x >> xz);
        int yz = Long.numberOfTrailingZeros(_y);
        long y = Math.abs(_y >> yz);
        while (x != y) {
            if (x > y) {
                long l = x - y;
                x = l >> Long.numberOfTrailingZeros(l);
                continue;
            }
            long l = y - x;
            y = l >> Long.numberOfTrailingZeros(l);
        }
        return xz < yz ? x << xz : x << yz;
    }

    public final BigInt gcd(BigInt a, BigInt b) {
        return a.gcd(b);
    }

    public final <A> A gcd(A x, A y, EuclideanRing<A> ev) {
        return ev.gcd(x, y);
    }

    public final <A> A gcd(Seq<A> xs, EuclideanRing<A> ev) {
        return xs.foldLeft(ev.zero(), new Serializable(ev){
            private final EuclideanRing ev$1;

            public final A apply(A x, A y) {
                return package$.MODULE$.gcd(y, x, this.ev$1);
            }
            {
                this.ev$1 = ev$1;
            }
        });
    }

    public final <A> A gcd(A x, A y, A z, Seq<A> rest, EuclideanRing<A> ev) {
        return this.gcd(this.gcd(this.gcd(x, y, ev), z, ev), this.gcd(rest, ev), ev);
    }

    public final long lcm(long x, long y) {
        return x / this.gcd(x, y) * y;
    }

    public final BigInt lcm(BigInt a, BigInt b) {
        return a.$div(a.gcd(b)).$times(b);
    }

    public final <A> A lcm(A x, A y, EuclideanRing<A> ev) {
        return ev.lcm(x, y);
    }

    public final byte min(byte x, byte y) {
        return (byte)Math.min(x, y);
    }

    public final short min(short x, short y) {
        return (short)Math.min(x, y);
    }

    public final int min(int x, int y) {
        return Math.min(x, y);
    }

    public final long min(long x, long y) {
        return Math.min(x, y);
    }

    public final float min(float x, float y) {
        return Math.min(x, y);
    }

    public final double min(double x, double y) {
        return Math.min(x, y);
    }

    public final <A> A min(A x, A y, Order<A> ev) {
        return ev.min(x, y);
    }

    public final byte max(byte x, byte y) {
        return (byte)Math.max(x, y);
    }

    public final short max(short x, short y) {
        return (short)Math.max(x, y);
    }

    public final int max(int x, int y) {
        return Math.max(x, y);
    }

    public final long max(long x, long y) {
        return Math.max(x, y);
    }

    public final float max(float x, float y) {
        return Math.max(x, y);
    }

    public final double max(double x, double y) {
        return Math.max(x, y);
    }

    public final <A> A max(A x, A y, Order<A> ev) {
        return ev.max(x, y);
    }

    public final double signum(double x) {
        return Math.signum(x);
    }

    public final float signum(float x) {
        return Math.signum(x);
    }

    public final <A> int signum(A a, Signed<A> ev) {
        return ev.signum(a);
    }

    public final double sqrt(double x) {
        return Math.sqrt(x);
    }

    public final <A> A sqrt(A a, NRoot<A> ev) {
        return ev.sqrt(a);
    }

    public final double e() {
        return Math.E;
    }

    public final <A> A e(Trig<A> ev) {
        return ev.e();
    }

    public final double pi() {
        return Math.PI;
    }

    public final <A> A pi(Trig<A> ev) {
        return ev.pi();
    }

    public final <A> A sin(A a, Trig<A> ev) {
        return ev.sin(a);
    }

    public final <A> A cos(A a, Trig<A> ev) {
        return ev.cos(a);
    }

    public final <A> A tan(A a, Trig<A> ev) {
        return ev.tan(a);
    }

    public final <A> A asin(A a, Trig<A> ev) {
        return ev.asin(a);
    }

    public final <A> A acos(A a, Trig<A> ev) {
        return ev.acos(a);
    }

    public final <A> A atan(A a, Trig<A> ev) {
        return ev.atan(a);
    }

    public final <A> A atan2(A y, A x, Trig<A> ev) {
        return ev.atan2(y, x);
    }

    public final <A> A sinh(A x, Trig<A> ev) {
        return ev.sinh(x);
    }

    public final <A> A cosh(A x, Trig<A> ev) {
        return ev.cosh(x);
    }

    public final <A> A tanh(A x, Trig<A> ev) {
        return ev.tanh(x);
    }

    public final double cbrt(double x) {
        return Math.cbrt(x);
    }

    public final double copySign(double m, double s2) {
        return Math.copySign(m, s2);
    }

    public final float copySign(float m, float s2) {
        return Math.copySign(m, s2);
    }

    public final double cosh(double x) {
        return Math.cosh(x);
    }

    public final double expm1(double x) {
        return Math.expm1(x);
    }

    public final int getExponent(double x) {
        return Math.getExponent(x);
    }

    public final int getExponent(float x) {
        return Math.getExponent(x);
    }

    public final double IEEEremainder(double x, double d) {
        return Math.IEEEremainder(x, d);
    }

    public final double log10(double x) {
        return Math.log10(x);
    }

    public final double log1p(double x) {
        return Math.log1p(x);
    }

    public final double nextAfter(double x, double y) {
        return Math.nextAfter(x, y);
    }

    public final float nextAfter(float x, float y) {
        return Math.nextAfter(x, (double)y);
    }

    public final double nextUp(double x) {
        return Math.nextUp(x);
    }

    public final float nextUp(float x) {
        return Math.nextUp(x);
    }

    public final double random() {
        return Math.random();
    }

    public final double rint(double x) {
        return Math.rint(x);
    }

    public final double scalb(double d, int s2) {
        return Math.scalb(d, s2);
    }

    public final float scalb(float d, int s2) {
        return Math.scalb(d, s2);
    }

    public final double toDegrees(double a) {
        return Math.toDegrees(a);
    }

    public final double toRadians(double a) {
        return Math.toRadians(a);
    }

    public final double ulp(double x) {
        return Math.ulp(x);
    }

    public final double ulp(float x) {
        return Math.ulp(x);
    }

    public final <A> A hypot(A x, A y, Field<A> f, NRoot<A> n, Order<A> o) {
        return o.gt(x, y) ? f.times(Signed$.MODULE$.orderedRingIsSigned(o, f).abs(x), n.sqrt(LiteralIntAdditiveSemigroupOps$.MODULE$.$plus$extension(implicits$.MODULE$.literalIntAdditiveSemigroupOps(1), f.pow(f.div(y, x), 2), f))) : f.times(Signed$.MODULE$.orderedRingIsSigned(o, f).abs(y), n.sqrt(LiteralIntAdditiveSemigroupOps$.MODULE$.$plus$extension(implicits$.MODULE$.literalIntAdditiveSemigroupOps(1), f.pow(f.div(x, y), 2), f)));
    }

    public boolean anyIsZero(Object n) {
        ScalaNumericConversions scalaNumericConversions;
        Integer n2 = BoxesRunTime.boxToInteger(0);
        boolean bl = (n != n2 ? (n != null ? (!(n instanceof Number) ? (!(n instanceof Character) ? n.equals(n2) : BoxesRunTime.equalsCharObject((Character)n, n2)) : BoxesRunTime.equalsNumObject((Number)n, n2)) : false) : true) ? true : (n instanceof ScalaNumericConversions ? (scalaNumericConversions = (ScalaNumericConversions)n).isValidInt() && scalaNumericConversions.toInt() == 0 : false);
        return bl;
    }

    public double anyToDouble(Object n) {
        block10: {
            double d;
            block3: {
                block9: {
                    double d2;
                    block8: {
                        block7: {
                            block6: {
                                block5: {
                                    block4: {
                                        block2: {
                                            if (!(n instanceof Byte)) break block2;
                                            byte by2 = BoxesRunTime.unboxToByte(n);
                                            d = by2;
                                            break block3;
                                        }
                                        if (!(n instanceof Short)) break block4;
                                        short s2 = BoxesRunTime.unboxToShort(n);
                                        d = s2;
                                        break block3;
                                    }
                                    if (!(n instanceof Character)) break block5;
                                    char c = BoxesRunTime.unboxToChar(n);
                                    d = c;
                                    break block3;
                                }
                                if (!(n instanceof Integer)) break block6;
                                int n2 = BoxesRunTime.unboxToInt(n);
                                d = n2;
                                break block3;
                            }
                            if (!(n instanceof Long)) break block7;
                            long l = BoxesRunTime.unboxToLong(n);
                            d = l;
                            break block3;
                        }
                        if (!(n instanceof Float)) break block8;
                        float f = BoxesRunTime.unboxToFloat(n);
                        d = f;
                        break block3;
                    }
                    if (!(n instanceof Double)) break block9;
                    d = d2 = BoxesRunTime.unboxToDouble(n);
                    break block3;
                }
                if (!(n instanceof ScalaNumericConversions)) break block10;
                ScalaNumericConversions scalaNumericConversions = (ScalaNumericConversions)n;
                d = scalaNumericConversions.toDouble();
            }
            return d;
        }
        throw new UnsupportedOperationException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is not a ScalaNumber"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{n})));
    }

    public long anyToLong(Object n) {
        block10: {
            long l;
            block3: {
                block9: {
                    block8: {
                        block7: {
                            long l2;
                            block6: {
                                block5: {
                                    block4: {
                                        block2: {
                                            if (!(n instanceof Byte)) break block2;
                                            byte by2 = BoxesRunTime.unboxToByte(n);
                                            l = by2;
                                            break block3;
                                        }
                                        if (!(n instanceof Short)) break block4;
                                        short s2 = BoxesRunTime.unboxToShort(n);
                                        l = s2;
                                        break block3;
                                    }
                                    if (!(n instanceof Character)) break block5;
                                    char c = BoxesRunTime.unboxToChar(n);
                                    l = c;
                                    break block3;
                                }
                                if (!(n instanceof Integer)) break block6;
                                int n2 = BoxesRunTime.unboxToInt(n);
                                l = n2;
                                break block3;
                            }
                            if (!(n instanceof Long)) break block7;
                            l = l2 = BoxesRunTime.unboxToLong(n);
                            break block3;
                        }
                        if (!(n instanceof Float)) break block8;
                        float f = BoxesRunTime.unboxToFloat(n);
                        l = (long)f;
                        break block3;
                    }
                    if (!(n instanceof Double)) break block9;
                    double d = BoxesRunTime.unboxToDouble(n);
                    l = (long)d;
                    break block3;
                }
                if (!(n instanceof ScalaNumericConversions)) break block10;
                ScalaNumericConversions scalaNumericConversions = (ScalaNumericConversions)n;
                l = scalaNumericConversions.toLong();
            }
            return l;
        }
        throw new UnsupportedOperationException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is not a ScalaNumber"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{n})));
    }

    public boolean anyIsWhole(Object n) {
        block10: {
            boolean bl;
            block3: {
                block9: {
                    block8: {
                        block7: {
                            block6: {
                                block5: {
                                    block4: {
                                        block2: {
                                            if (!(n instanceof Byte)) break block2;
                                            bl = true;
                                            break block3;
                                        }
                                        if (!(n instanceof Short)) break block4;
                                        bl = true;
                                        break block3;
                                    }
                                    if (!(n instanceof Character)) break block5;
                                    bl = true;
                                    break block3;
                                }
                                if (!(n instanceof Integer)) break block6;
                                bl = true;
                                break block3;
                            }
                            if (!(n instanceof Long)) break block7;
                            bl = true;
                            break block3;
                        }
                        if (!(n instanceof Float)) break block8;
                        float f = BoxesRunTime.unboxToFloat(n);
                        Predef$ predef$ = Predef$.MODULE$;
                        bl = RichFloat$.MODULE$.isWhole$extension(f);
                        break block3;
                    }
                    if (!(n instanceof Double)) break block9;
                    double d = BoxesRunTime.unboxToDouble(n);
                    Predef$ predef$ = Predef$.MODULE$;
                    bl = RichDouble$.MODULE$.isWhole$extension(d);
                    break block3;
                }
                if (!(n instanceof ScalaNumericConversions)) break block10;
                ScalaNumericConversions scalaNumericConversions = (ScalaNumericConversions)n;
                bl = scalaNumericConversions.isWhole();
            }
            return bl;
        }
        throw new UnsupportedOperationException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is not a ScalaNumber"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{n})));
    }

    public boolean anyIsValidInt(Object n) {
        block10: {
            boolean bl;
            block3: {
                block9: {
                    block8: {
                        block7: {
                            block6: {
                                block5: {
                                    block4: {
                                        block2: {
                                            if (!(n instanceof Byte)) break block2;
                                            bl = true;
                                            break block3;
                                        }
                                        if (!(n instanceof Short)) break block4;
                                        bl = true;
                                        break block3;
                                    }
                                    if (!(n instanceof Character)) break block5;
                                    bl = true;
                                    break block3;
                                }
                                if (!(n instanceof Integer)) break block6;
                                bl = true;
                                break block3;
                            }
                            if (!(n instanceof Long)) break block7;
                            long l = BoxesRunTime.unboxToLong(n);
                            Predef$ predef$ = Predef$.MODULE$;
                            bl = RichLong$.MODULE$.isValidInt$extension(l);
                            break block3;
                        }
                        if (!(n instanceof Float)) break block8;
                        float f = BoxesRunTime.unboxToFloat(n);
                        Predef$ predef$ = Predef$.MODULE$;
                        bl = RichFloat$.MODULE$.isValidInt$extension(f);
                        break block3;
                    }
                    if (!(n instanceof Double)) break block9;
                    double d = BoxesRunTime.unboxToDouble(n);
                    Predef$ predef$ = Predef$.MODULE$;
                    bl = RichDouble$.MODULE$.isValidInt$extension(d);
                    break block3;
                }
                if (!(n instanceof ScalaNumericConversions)) break block10;
                ScalaNumericConversions scalaNumericConversions = (ScalaNumericConversions)n;
                bl = scalaNumericConversions.isValidInt();
            }
            return bl;
        }
        throw new UnsupportedOperationException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is not a ScalaNumber"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{n})));
    }

    public final double e$mDc$sp(Trig<Object> ev) {
        return ev.e$mcD$sp();
    }

    public final float e$mFc$sp(Trig<Object> ev) {
        return ev.e$mcF$sp();
    }

    public final double pi$mDc$sp(Trig<Object> ev) {
        return ev.pi$mcD$sp();
    }

    public final float pi$mFc$sp(Trig<Object> ev) {
        return ev.pi$mcF$sp();
    }

    public final double sin$mDc$sp(double a, Trig<Object> ev) {
        return ev.sin$mcD$sp(a);
    }

    public final float sin$mFc$sp(float a, Trig<Object> ev) {
        return ev.sin$mcF$sp(a);
    }

    public final double cos$mDc$sp(double a, Trig<Object> ev) {
        return ev.cos$mcD$sp(a);
    }

    public final float cos$mFc$sp(float a, Trig<Object> ev) {
        return ev.cos$mcF$sp(a);
    }

    public final double tan$mDc$sp(double a, Trig<Object> ev) {
        return ev.tan$mcD$sp(a);
    }

    public final float tan$mFc$sp(float a, Trig<Object> ev) {
        return ev.tan$mcF$sp(a);
    }

    public final double asin$mDc$sp(double a, Trig<Object> ev) {
        return ev.asin$mcD$sp(a);
    }

    public final float asin$mFc$sp(float a, Trig<Object> ev) {
        return ev.asin$mcF$sp(a);
    }

    public final double acos$mDc$sp(double a, Trig<Object> ev) {
        return ev.acos$mcD$sp(a);
    }

    public final float acos$mFc$sp(float a, Trig<Object> ev) {
        return ev.acos$mcF$sp(a);
    }

    public final double atan$mDc$sp(double a, Trig<Object> ev) {
        return ev.atan$mcD$sp(a);
    }

    public final float atan$mFc$sp(float a, Trig<Object> ev) {
        return ev.atan$mcF$sp(a);
    }

    public final double atan2$mDc$sp(double y, double x, Trig<Object> ev) {
        return ev.atan2$mcD$sp(y, x);
    }

    public final float atan2$mFc$sp(float y, float x, Trig<Object> ev) {
        return ev.atan2$mcF$sp(y, x);
    }

    public final double sinh$mDc$sp(double x, Trig<Object> ev) {
        return ev.sinh$mcD$sp(x);
    }

    public final float sinh$mFc$sp(float x, Trig<Object> ev) {
        return ev.sinh$mcF$sp(x);
    }

    public final double cosh$mDc$sp(double x, Trig<Object> ev) {
        return ev.cosh$mcD$sp(x);
    }

    public final float cosh$mFc$sp(float x, Trig<Object> ev) {
        return ev.cosh$mcF$sp(x);
    }

    public final double tanh$mDc$sp(double x, Trig<Object> ev) {
        return ev.tanh$mcD$sp(x);
    }

    public final float tanh$mFc$sp(float x, Trig<Object> ev) {
        return ev.tanh$mcF$sp(x);
    }

    public final double hypot$mDc$sp(double x, double y, Field<Object> f, NRoot<Object> n, Order<Object> o) {
        return o.gt$mcD$sp(x, y) ? f.times$mcD$sp(Signed$.MODULE$.orderedRingIsSigned(o, f).abs$mcD$sp(x), n.sqrt$mcD$sp(BoxesRunTime.unboxToDouble(LiteralIntAdditiveSemigroupOps$.MODULE$.$plus$extension(implicits$.MODULE$.literalIntAdditiveSemigroupOps(1), BoxesRunTime.boxToDouble(f.pow$mcD$sp(f.div$mcD$sp(y, x), 2)), f)))) : f.times$mcD$sp(Signed$.MODULE$.orderedRingIsSigned(o, f).abs$mcD$sp(y), n.sqrt$mcD$sp(BoxesRunTime.unboxToDouble(LiteralIntAdditiveSemigroupOps$.MODULE$.$plus$extension(implicits$.MODULE$.literalIntAdditiveSemigroupOps(1), BoxesRunTime.boxToDouble(f.pow$mcD$sp(f.div$mcD$sp(x, y), 2)), f))));
    }

    public final float hypot$mFc$sp(float x, float y, Field<Object> f, NRoot<Object> n, Order<Object> o) {
        return o.gt$mcF$sp(x, y) ? f.times$mcF$sp(Signed$.MODULE$.orderedRingIsSigned(o, f).abs$mcF$sp(x), n.sqrt$mcF$sp(BoxesRunTime.unboxToFloat(LiteralIntAdditiveSemigroupOps$.MODULE$.$plus$extension(implicits$.MODULE$.literalIntAdditiveSemigroupOps(1), BoxesRunTime.boxToFloat(f.pow$mcF$sp(f.div$mcF$sp(y, x), 2)), f)))) : f.times$mcF$sp(Signed$.MODULE$.orderedRingIsSigned(o, f).abs$mcF$sp(y), n.sqrt$mcF$sp(BoxesRunTime.unboxToFloat(LiteralIntAdditiveSemigroupOps$.MODULE$.$plus$extension(implicits$.MODULE$.literalIntAdditiveSemigroupOps(1), BoxesRunTime.boxToFloat(f.pow$mcF$sp(f.div$mcF$sp(x, y), 2)), f))));
    }

    private final BigInt loop$1(long lo, long hi, BigInt prod2) {
        while (lo <= hi) {
            prod2 = scala.package$.MODULE$.BigInt().apply(lo).$times(scala.package$.MODULE$.BigInt().apply(hi)).$times(prod2);
            --hi;
            ++lo;
        }
        return prod2;
    }

    private final BigInt loop$2(long lo, long hi, BigInt prod2) {
        while (lo <= hi) {
            prod2 = scala.package$.MODULE$.BigInt().apply(lo).$times(scala.package$.MODULE$.BigInt().apply(hi)).$times(prod2);
            --hi;
            ++lo;
        }
        return prod2;
    }

    private final BigInt loop$3(BigInt a, BigInt b, int i, long n$1) {
        while (true) {
            BigInt c = a.$plus(b);
            if (i < 0) {
                return b;
            }
            if ((n$1 >>> i & 1L) == 1L) {
                BigInt bigInt = a.$plus(c).$times(b);
                --i;
                b = b.$times(b).$plus(c.$times(c));
                a = bigInt;
                continue;
            }
            BigInt bigInt = a.$times(a).$plus(b.$times(b));
            --i;
            b = a.$plus(c).$times(b);
            a = bigInt;
        }
    }

    private final BigDecimal power$1(BigDecimal result2, BigDecimal base, BigInt exponent) {
        while (exponent.signum() != 0) {
            if (exponent.testBit(0)) {
                BigDecimal bigDecimal = result2.$times(base);
                exponent = exponent.$greater$greater(1);
                base = base.$times(base);
                result2 = bigDecimal;
                continue;
            }
            exponent = exponent.$greater$greater(1);
            base = base.$times(base);
        }
        return result2;
    }

    private final BigDecimal doit$1(int precision, int leeway, BigDecimal k$1) {
        while (true) {
            MathContext mc = new MathContext(precision, RoundingMode.HALF_UP);
            int i = 2;
            BigDecimal sum2 = scala.package$.MODULE$.BigDecimal().apply(1, mc).$plus(k$1);
            BigDecimal factorial = scala.package$.MODULE$.BigDecimal().apply(2, mc);
            BigDecimal kpow = k$1.$times(k$1);
            BigDecimal term = kpow.$div(factorial).setScale(precision, BigDecimal$RoundingMode$.MODULE$.HALF_UP());
            while (term.signum() != 0 && i < leeway) {
                sum2 = sum2.$plus(term);
                factorial = factorial.$times(BigDecimal$.MODULE$.int2bigDecimal(++i));
                kpow = kpow.$times(k$1);
                term = kpow.$div(factorial).setScale(precision, BigDecimal$RoundingMode$.MODULE$.HALF_UP());
            }
            if (i <= leeway) {
                return sum2.setScale(k$1.mc().getPrecision() - sum2.precision() + sum2.scale(), BigDecimal$RoundingMode$.MODULE$.FLOOR());
            }
            Predef$ predef$ = Predef$.MODULE$;
            Predef$.MODULE$.println(new StringOps("  restarted %s").format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(i)})));
            leeway *= 1000;
            precision += 3;
        }
    }

    private final BigDecimal loop$4(BigDecimal x, BigDecimal n$2, BigDecimal limit$1) {
        BigDecimal xp;
        BigDecimal term;
        while ((term = (xp = this.exp(x)).$minus(n$2).$div(xp)).$greater(limit$1)) {
            x = x.$minus(term);
        }
        return x.$minus(term);
    }

    private final BigDecimal ln$1(BigDecimal n, int scale$1) {
        int scale2 = scale$1 + 1;
        BigDecimal limit = scala.package$.MODULE$.BigDecimal().apply(5).$times(scala.package$.MODULE$.BigDecimal().apply(10).pow(-scale2));
        return this.loop$4(n.setScale(scale2, BigDecimal$RoundingMode$.MODULE$.HALF_UP()), n, limit).setScale(scale$1, BigDecimal$RoundingMode$.MODULE$.HALF_UP());
    }

    private final Tuple2 rescale$1(BigDecimal x, int n) {
        while (!x.$less(BigDecimal$.MODULE$.int2bigDecimal(64))) {
            ++n;
            x = package$bigDecimal$.MODULE$.BigDecimalAlgebra().sqrt(x);
        }
        return new Tuple2<BigDecimal, Integer>(x, BoxesRunTime.boxToInteger(n));
    }

    private final BigInt bigIntPow$1(BigInt t, BigInt b, BigInt e) {
        while (e.signum() != 0) {
            if (e.testBit(0)) {
                BigInt bigInt = t.$times(b);
                e = e.$greater$greater(1);
                b = b.$times(b);
                t = bigInt;
                continue;
            }
            e = e.$greater$greater(1);
            b = b.$times(b);
        }
        return t;
    }

    private final long longPow$1(long t, long b, long e) {
        while (e != 0L) {
            if ((e & 1L) == 1L) {
                long l = t * b;
                e >>= (int)1L;
                b *= b;
                t = l;
                continue;
            }
            e >>= (int)1L;
            b *= b;
        }
        return t;
    }

    private package$() {
        MODULE$ = this;
    }
}

