/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.net;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.net.SocketOptions;
import org.apache.logging.log4j.core.net.TcpSocketManager;
import org.apache.logging.log4j.core.net.ssl.SslConfiguration;
import org.apache.logging.log4j.util.Strings;

public class SslSocketManager
extends TcpSocketManager {
    public static final int DEFAULT_PORT = 6514;
    private static final SslSocketManagerFactory FACTORY = new SslSocketManagerFactory();
    private final SslConfiguration sslConfig;

    @Deprecated
    public SslSocketManager(String name, OutputStream os, Socket sock, SslConfiguration sslConfig, InetAddress inetAddress, String host, int port, int connectTimeoutMillis, int reconnectionDelayMillis, boolean immediateFail, Layout<? extends Serializable> layout, int bufferSize) {
        super(name, os, sock, inetAddress, host, port, connectTimeoutMillis, reconnectionDelayMillis, immediateFail, layout, bufferSize, null);
        this.sslConfig = sslConfig;
    }

    public SslSocketManager(String name, OutputStream os, Socket sock, SslConfiguration sslConfig, InetAddress inetAddress, String host, int port, int connectTimeoutMillis, int reconnectionDelayMillis, boolean immediateFail, Layout<? extends Serializable> layout, int bufferSize, SocketOptions socketOptions) {
        super(name, os, sock, inetAddress, host, port, connectTimeoutMillis, reconnectionDelayMillis, immediateFail, layout, bufferSize, socketOptions);
        this.sslConfig = sslConfig;
    }

    @Deprecated
    public static SslSocketManager getSocketManager(SslConfiguration sslConfig, String host, int port, int connectTimeoutMillis, int reconnectDelayMillis, boolean immediateFail, Layout<? extends Serializable> layout, int bufferSize) {
        return SslSocketManager.getSocketManager(sslConfig, host, port, connectTimeoutMillis, reconnectDelayMillis, immediateFail, layout, bufferSize, null);
    }

    public static SslSocketManager getSocketManager(SslConfiguration sslConfig, String host, int port, int connectTimeoutMillis, int reconnectDelayMillis, boolean immediateFail, Layout<? extends Serializable> layout, int bufferSize, SocketOptions socketOptions) {
        if (Strings.isEmpty(host)) {
            throw new IllegalArgumentException("A host name is required");
        }
        if (port <= 0) {
            port = 6514;
        }
        if (reconnectDelayMillis == 0) {
            reconnectDelayMillis = 30000;
        }
        String name = "TLS:" + host + ':' + port;
        return (SslSocketManager)SslSocketManager.getManager(name, new SslFactoryData(sslConfig, host, port, connectTimeoutMillis, reconnectDelayMillis, immediateFail, layout, bufferSize, socketOptions), FACTORY);
    }

    @Override
    protected Socket createSocket(String host, int port) throws IOException {
        SSLSocketFactory socketFactory = SslSocketManager.createSslSocketFactory(this.sslConfig);
        InetSocketAddress address = new InetSocketAddress(host, port);
        Socket newSocket = socketFactory.createSocket();
        newSocket.connect(address, this.getConnectTimeoutMillis());
        return newSocket;
    }

    private static SSLSocketFactory createSslSocketFactory(SslConfiguration sslConf) {
        SSLSocketFactory socketFactory = sslConf != null ? sslConf.getSslSocketFactory() : (SSLSocketFactory)SSLSocketFactory.getDefault();
        return socketFactory;
    }

    static Socket createSocket(String host, int port, int connectTimeoutMillis, SslConfiguration sslConfiguration, SocketOptions socketOptions) throws IOException {
        SSLSocketFactory socketFactory = SslSocketManager.createSslSocketFactory(sslConfiguration);
        SSLSocket socket = (SSLSocket)socketFactory.createSocket();
        if (socketOptions != null) {
            socketOptions.apply(socket);
        }
        socket.connect(new InetSocketAddress(host, port), connectTimeoutMillis);
        if (socketOptions != null) {
            socketOptions.apply(socket);
        }
        return socket;
    }

    private static class SslSocketManagerFactory
    extends TcpSocketManager.TcpSocketManagerFactory<SslSocketManager, SslFactoryData> {
        private SslSocketManagerFactory() {
        }

        @Override
        SslSocketManager createManager(String name, OutputStream os, Socket socket, InetAddress inetAddress, SslFactoryData data2) {
            return new SslSocketManager(name, os, socket, data2.sslConfiguration, inetAddress, data2.host, data2.port, data2.connectTimeoutMillis, data2.reconnectDelayMillis, data2.immediateFail, data2.layout, data2.bufferSize, data2.socketOptions);
        }

        @Override
        Socket createSocket(SslFactoryData data2) throws IOException {
            return SslSocketManager.createSocket(data2.host, data2.port, data2.connectTimeoutMillis, data2.sslConfiguration, data2.socketOptions);
        }
    }

    private static class SslFactoryData
    extends TcpSocketManager.FactoryData {
        protected SslConfiguration sslConfiguration;

        public SslFactoryData(SslConfiguration sslConfiguration, String host, int port, int connectTimeoutMillis, int reconnectDelayMillis, boolean immediateFail, Layout<? extends Serializable> layout, int bufferSize, SocketOptions socketOptions) {
            super(host, port, connectTimeoutMillis, reconnectDelayMillis, immediateFail, layout, bufferSize, socketOptions);
            this.sslConfiguration = sslConfiguration;
        }

        @Override
        public String toString() {
            return "SslFactoryData [sslConfiguration=" + this.sslConfiguration + ", host=" + this.host + ", port=" + this.port + ", connectTimeoutMillis=" + this.connectTimeoutMillis + ", reconnectDelayMillis=" + this.reconnectDelayMillis + ", immediateFail=" + this.immediateFail + ", layout=" + this.layout + ", bufferSize=" + this.bufferSize + ", socketOptions=" + this.socketOptions + "]";
        }
    }
}

