/*
 * Decompiled with CFR 0.152.
 */
package spire.math;

import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple2$mcJJ$sp;
import scala.collection.LinearSeqOptimized;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.BigDecimal;
import scala.math.BigDecimal$;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.util.matching.Regex;
import spire.math.ApproximationContext;
import spire.math.BigRationals;
import spire.math.BigRationals$;
import spire.math.DecimalNumber;
import spire.math.FloatNumber;
import spire.math.IntNumber;
import spire.math.LongRationals;
import spire.math.LongRationals$;
import spire.math.Number;
import spire.math.Number$;
import spire.math.NumberTag;
import spire.math.Rational;
import spire.math.RationalAlgebra;
import spire.math.RationalInstances;
import spire.math.RationalInstances$class;
import spire.math.RationalIsNRoot0;
import spire.math.RationalNumber;
import spire.math.SafeLong;
import spire.math.SafeLong$;
import spire.math.SafeLongBigInt;
import spire.math.SafeLongLong;
import spire.math.package$;

public final class Rational$
implements RationalInstances,
Serializable {
    public static final Rational$ MODULE$;
    private final Regex RationalString;
    private final Regex IntegerString;
    private final Rational zero;
    private final Rational one;
    private final RationalAlgebra RationalAlgebra;
    private final NumberTag.LargeTag<Rational> RationalTag;

    static {
        new Rational$();
    }

    @Override
    public final RationalAlgebra RationalAlgebra() {
        return this.RationalAlgebra;
    }

    @Override
    public final NumberTag.LargeTag<Rational> RationalTag() {
        return this.RationalTag;
    }

    @Override
    public final void spire$math$RationalInstances$_setter_$RationalAlgebra_$eq(RationalAlgebra x$1) {
        this.RationalAlgebra = x$1;
    }

    @Override
    public final void spire$math$RationalInstances$_setter_$RationalTag_$eq(NumberTag.LargeTag x$1) {
        this.RationalTag = x$1;
    }

    @Override
    public RationalIsNRoot0 RationalIsNRoot(ApproximationContext<Rational> c) {
        return RationalInstances$class.RationalIsNRoot(this, c);
    }

    private Regex RationalString() {
        return this.RationalString;
    }

    private Regex IntegerString() {
        return this.IntegerString;
    }

    public Rational zero() {
        return this.zero;
    }

    public Rational one() {
        return this.one;
    }

    public Rational apply(SafeLong n, SafeLong d) {
        SafeLong safeLong;
        block9: {
            Rational rational2;
            block8: {
                SafeLong g;
                block4: {
                    SafeLong safeLong2;
                    block7: {
                        Rational rational3;
                        block6: {
                            SafeLongLong safeLongLong;
                            block5: {
                                if (d.$less(SafeLong$.MODULE$.apply(0L))) {
                                    return this.apply(n.unary_$minus(), d.unary_$minus());
                                }
                                g = n.gcd(d);
                                safeLong = n.$div(g);
                                if (!(safeLong instanceof SafeLongLong)) break block4;
                                safeLongLong = (SafeLongLong)safeLong;
                                safeLong2 = d.$div(g);
                                if (!(safeLong2 instanceof SafeLongLong)) break block5;
                                SafeLongLong safeLongLong2 = (SafeLongLong)safeLong2;
                                rational3 = new LongRationals.LongRational(safeLongLong.x(), safeLongLong2.x());
                                break block6;
                            }
                            if (!(safeLong2 instanceof SafeLongBigInt)) break block7;
                            SafeLongBigInt safeLongBigInt = (SafeLongBigInt)safeLong2;
                            rational3 = new BigRationals.BigRational(BigInt$.MODULE$.long2bigInt(safeLongLong.x()), safeLongBigInt.x());
                        }
                        rational2 = rational3;
                        break block8;
                    }
                    throw new MatchError(safeLong2);
                }
                if (!(safeLong instanceof SafeLongBigInt)) break block9;
                SafeLongBigInt safeLongBigInt = (SafeLongBigInt)safeLong;
                rational2 = new BigRationals.BigRational(safeLongBigInt.x(), d.$div(g).toBigInt());
            }
            return rational2;
        }
        throw new MatchError(safeLong);
    }

    public Rational apply(long n, long d) {
        return LongRationals$.MODULE$.build$mcJ$sp(n, d);
    }

    public Rational apply(BigInt n, BigInt d) {
        return BigRationals$.MODULE$.build(n, d);
    }

    public Rational unsafeBuild(long n, long d) {
        return LongRationals$.MODULE$.unsafeBuild(n, d);
    }

    public Rational unsafeBuild(BigInt n, BigInt d) {
        return BigRationals$.MODULE$.unsafeBuild(n, d);
    }

    public Rational apply(int x) {
        return LongRationals$.MODULE$.build$mcJ$sp(x, 1L);
    }

    public Rational apply(long x) {
        return LongRationals$.MODULE$.build$mcJ$sp(x, 1L);
    }

    public Rational apply(BigInt x) {
        return BigRationals$.MODULE$.build(x, scala.package$.MODULE$.BigInt().apply(1));
    }

    public Rational apply(float x) {
        return this.apply((double)x);
    }

    public Rational apply(double x) {
        Rational rational2;
        if (x == 0.0) {
            rational2 = this.zero();
        } else {
            long bits2 = Double.doubleToLongBits(x);
            long value2 = bits2 >> 63 < 0L ? -(bits2 & 0xFFFFFFFFFFFFFL | 0x10000000000000L) : bits2 & 0xFFFFFFFFFFFFFL | 0x10000000000000L;
            int exp = (int)(bits2 >> 52 & 0x7FFL) - 1075;
            rational2 = exp > 10 ? this.apply(scala.package$.MODULE$.BigInt().apply(value2).$less$less(exp), scala.package$.MODULE$.BigInt().apply(1)) : (exp >= 0 ? this.apply(value2 << exp, 1L) : (exp >= -52 && ((-1L << -exp ^ 0xFFFFFFFFFFFFFFFFL) & value2) == 0L ? this.apply(value2 >> -exp, 1L) : this.apply(scala.package$.MODULE$.BigInt().apply(value2), scala.package$.MODULE$.BigInt().apply(1).$less$less(-exp))));
        }
        return rational2;
    }

    public Rational apply(BigDecimal x) {
        Rational rational2;
        if (x.ulp().$greater$eq(BigDecimal$.MODULE$.int2bigDecimal(1))) {
            rational2 = BigRationals$.MODULE$.build(x.toBigInt(), BigInt$.MODULE$.int2bigInt(1));
        } else {
            BigInt n = x.$div(x.ulp()).toBigInt();
            BigInt d = scala.package$.MODULE$.BigDecimal().apply(1.0).$div(x.ulp()).toBigInt();
            rational2 = BigRationals$.MODULE$.build(n, d);
        }
        return rational2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Rational apply(String r) {
        String string2 = r;
        Option<List<String>> option2 = this.RationalString().unapplySeq(r);
        if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(2) == 0) {
            return this.apply(scala.package$.MODULE$.BigInt().apply((String)((LinearSeqOptimized)option2.get()).apply(0)), scala.package$.MODULE$.BigInt().apply((String)((LinearSeqOptimized)option2.get()).apply(1)));
        }
        Option<List<String>> option3 = this.IntegerString().unapplySeq(r);
        if (!option3.isEmpty() && option3.get() != null && ((LinearSeqOptimized)option3.get()).lengthCompare(1) == 0) {
            return this.apply(scala.package$.MODULE$.BigInt().apply((String)((LinearSeqOptimized)option3.get()).apply(0)));
        }
        try {
            return this.apply(scala.package$.MODULE$.BigDecimal().apply(r));
        }
        catch (NumberFormatException numberFormatException) {
            throw new NumberFormatException(new StringBuilder().append((Object)"For input string: ").append((Object)string2).toString());
        }
    }

    public Rational apply(SafeLong n) {
        block4: {
            Rational rational2;
            block3: {
                block2: {
                    if (!(n instanceof SafeLongLong)) break block2;
                    SafeLongLong safeLongLong = (SafeLongLong)n;
                    rational2 = LongRationals$.MODULE$.unsafeBuild(safeLongLong.x(), 1L);
                    break block3;
                }
                if (!(n instanceof SafeLongBigInt)) break block4;
                SafeLongBigInt safeLongBigInt = (SafeLongBigInt)n;
                rational2 = BigRationals$.MODULE$.unsafeBuild(safeLongBigInt.x(), scala.package$.MODULE$.BigInt().apply(1));
            }
            return rational2;
        }
        throw new MatchError(n);
    }

    public Rational apply(Number x) {
        block6: {
            Rational rational2;
            block4: {
                block5: {
                    block3: {
                        while (x instanceof RationalNumber) {
                            RationalNumber rationalNumber = (RationalNumber)x;
                            x = Number$.MODULE$.apply(rationalNumber.n());
                        }
                        if (!(x instanceof IntNumber)) break block3;
                        IntNumber intNumber = (IntNumber)x;
                        rational2 = this.apply(intNumber.n());
                        break block4;
                    }
                    if (!(x instanceof FloatNumber)) break block5;
                    FloatNumber floatNumber = (FloatNumber)x;
                    rational2 = this.apply(floatNumber.n());
                    break block4;
                }
                if (!(x instanceof DecimalNumber)) break block6;
                DecimalNumber decimalNumber = (DecimalNumber)x;
                rational2 = this.apply(decimalNumber.n());
            }
            return rational2;
        }
        throw new MatchError(x);
    }

    public Tuple2<BigInt, BigInt> nroot(BigInt x, int n) {
        return this.findnroot$1(scala.package$.MODULE$.BigInt().apply(0), (x.bitLength() + n - 1) / n, x, n);
    }

    public Tuple2<Object, Object> nroot(long x, int n) {
        return this.findnroot$2(0L, 1L << (65 - n) / n, x, n);
    }

    private Object readResolve() {
        return MODULE$;
    }

    private final Tuple2 findnroot$1(BigInt prev, int add2, BigInt x$3, int n$2) {
        Tuple2<BigInt, BigInt> tuple22;
        BigInt cl;
        BigInt fl;
        BigInt max2;
        BigInt min2;
        while (true) {
            min2 = prev.setBit(add2);
            max2 = min2.$plus(BigInt$.MODULE$.int2bigInt(1));
            fl = min2.pow(n$2);
            cl = max2.pow(n$2);
            if (fl.$greater(x$3)) {
                --add2;
                continue;
            }
            if (!cl.$less(x$3)) break;
            --add2;
            prev = min2;
        }
        BigInt bigInt = cl;
        if (!(bigInt != null ? !((Object)bigInt).equals(x$3) : x$3 != null)) {
            tuple22 = new Tuple2<BigInt, BigInt>(max2, max2);
        } else {
            BigInt bigInt2 = fl;
            tuple22 = !(bigInt2 != null ? !((Object)bigInt2).equals(x$3) : x$3 != null) ? new Tuple2<BigInt, BigInt>(min2, min2) : new Tuple2<BigInt, BigInt>(min2, max2);
        }
        return tuple22;
    }

    private final Tuple2 findnroot$2(long prev, long add2, long x$2, int n$1) {
        long cl;
        long fl;
        long max2;
        long min2;
        while (true) {
            min2 = prev | add2;
            max2 = min2 + 1L;
            fl = package$.MODULE$.pow(min2, n$1);
            cl = package$.MODULE$.pow(max2, n$1);
            if (fl <= 0L || fl > x$2) {
                add2 >>= 1;
                continue;
            }
            if (cl >= x$2) break;
            add2 >>= 1;
            prev = min2;
        }
        return cl == x$2 ? new Tuple2$mcJJ$sp(max2, max2) : (fl == x$2 ? new Tuple2$mcJJ$sp(min2, min2) : new Tuple2$mcJJ$sp(min2, max2));
    }

    private Rational$() {
        MODULE$ = this;
        RationalInstances$class.$init$(this);
        Predef$ predef$ = Predef$.MODULE$;
        this.RationalString = new StringOps("^(-?\\d+)/(-?\\d+)$").r();
        Predef$ predef$2 = Predef$.MODULE$;
        this.IntegerString = new StringOps("^(-?\\d+)$").r();
        this.zero = new LongRationals.LongRational(0L, 1L);
        this.one = new LongRationals.LongRational(1L, 1L);
    }
}

