/*
 * Decompiled with CFR 0.152.
 */
package spire.math;

import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$mcDD$sp;
import scala.math.BigDecimal;
import scala.math.BigInt;
import scala.package$;
import scala.runtime.BoxesRunTime;
import spire.algebra.Eq;
import spire.algebra.Field;
import spire.algebra.IsReal;
import spire.algebra.Rig;
import spire.algebra.Ring;
import spire.algebra.Rng;
import spire.algebra.Semiring;
import spire.algebra.Semiring$;
import spire.algebra.Trig;
import spire.algebra.Trig$;
import spire.math.Complex;
import spire.math.Complex$mcD$sp;
import spire.math.Complex$mcF$sp;
import spire.math.ComplexAlgebra;
import spire.math.ComplexInstances;
import spire.math.ComplexInstances$class;
import spire.math.ComplexInstances0$class;
import spire.math.ComplexInstances1$class;
import spire.math.Fractional;

public final class Complex$
implements ComplexInstances,
Serializable {
    public static final Complex$ MODULE$;

    static {
        new Complex$();
    }

    @Override
    public <A> ComplexAlgebra<A> ComplexAlgebra(Fractional<A> evidence$8, Trig<A> evidence$9, IsReal<A> evidence$10) {
        return ComplexInstances$class.ComplexAlgebra(this, evidence$8, evidence$9, evidence$10);
    }

    @Override
    public ComplexAlgebra<Object> ComplexAlgebra$mDc$sp(Fractional<Object> evidence$8, Trig<Object> evidence$9, IsReal<Object> evidence$10) {
        return ComplexInstances$class.ComplexAlgebra$mDc$sp(this, evidence$8, evidence$9, evidence$10);
    }

    @Override
    public ComplexAlgebra<Object> ComplexAlgebra$mFc$sp(Fractional<Object> evidence$8, Trig<Object> evidence$9, IsReal<Object> evidence$10) {
        return ComplexInstances$class.ComplexAlgebra$mFc$sp(this, evidence$8, evidence$9, evidence$10);
    }

    @Override
    public <A> Eq<Complex<A>> ComplexEq(Eq<A> evidence$11) {
        return ComplexInstances$class.ComplexEq(this, evidence$11);
    }

    @Override
    public <A> Field<Complex<A>> ComplexField(Field<A> evidence$6, IsReal<A> evidence$7) {
        return ComplexInstances1$class.ComplexField(this, evidence$6, evidence$7);
    }

    @Override
    public <A> Ring<Complex<A>> ComplexRing(Ring<A> evidence$4, IsReal<A> evidence$5) {
        return ComplexInstances0$class.ComplexRing(this, evidence$4, evidence$5);
    }

    public <T> Complex<T> i(Rig<T> T2) {
        return new Complex(T2.zero(), T2.one());
    }

    public <T> Complex<T> one(Rig<T> T2) {
        return new Complex(T2.one(), T2.zero());
    }

    public <T> Complex<T> zero(Semiring<T> T2) {
        return new Complex(T2.zero(), T2.zero());
    }

    public <T> Complex<T> fromInt(int n, Ring<T> f2) {
        return new Complex<T>(f2.fromInt(n), f2.zero());
    }

    public Complex<Object> intToComplex(int n) {
        return new Complex$mcD$sp(n, 0.0);
    }

    public Complex<Object> longToComplex(long n) {
        return new Complex$mcD$sp(n, 0.0);
    }

    public Complex<Object> floatToComplex(float n) {
        return new Complex$mcF$sp(n, 0.0f);
    }

    public Complex<Object> doubleToComplex(double n) {
        return new Complex$mcD$sp(n, 0.0);
    }

    public Complex<BigDecimal> bigIntToComplex(BigInt n) {
        return this.bigDecimalToComplex(package$.MODULE$.BigDecimal().apply(n));
    }

    public Complex<BigDecimal> bigDecimalToComplex(BigDecimal n) {
        return new Complex<BigDecimal>(n, package$.MODULE$.BigDecimal().apply(0));
    }

    public <T> Complex<T> polar(T magnitude, T angle, Field<T> evidence$1, Trig<T> evidence$2) {
        Trig$ trig$ = Trig$.MODULE$;
        Trig$ trig$2 = Trig$.MODULE$;
        return new Complex<T>(evidence$1.times(magnitude, evidence$2.cos(angle)), evidence$1.times(magnitude, evidence$2.sin(angle)));
    }

    public <T> Complex<T> apply(T real, Semiring<T> evidence$3) {
        Semiring$ semiring$ = Semiring$.MODULE$;
        return new Complex<T>(real, evidence$3.zero());
    }

    public <T> Complex<T> rootOfUnity(int n, int x, Field<T> f2, Trig<T> t, IsReal<T> r) {
        if (x == 0) {
            return this.one(f2);
        }
        if (n % 2 == 0) {
            if (x == n / 2) {
                return this.one(f2).unary_$minus(f2);
            }
            if (n % 4 == 0) {
                if (x == n / 4) {
                    return this.i(f2);
                }
                if (x == n * 3 / 4) {
                    return this.i(f2).unary_$minus(f2);
                }
            }
        }
        return this.polar(f2.one(), f2.div(f2.times(f2.times(t.pi(), f2.fromInt(2)), f2.fromInt(x)), f2.fromInt(n)), f2, t);
    }

    public <T> Complex<T>[] rootsOfUnity(int n, Field<T> f2, Trig<T> t, IsReal<T> r) {
        Complex<T> sum2;
        Complex[] roots2 = new Complex[n];
        roots2[0] = sum2 = this.one(f2);
        int west = n % 2 == 0 ? n / 2 : -1;
        int north = n % 4 == 0 ? n / 4 : -1;
        int south = n % 4 == 0 ? 3 * n / 4 : -1;
        int last2 = n - 1;
        for (int x = 1; x < last2; ++x) {
            Complex<Object> complex2 = north == x ? this.i(f2) : (west == x ? this.one(f2).unary_$minus(f2) : (south == x ? this.i(f2).unary_$minus(f2) : this.polar(f2.one(), f2.div(f2.times(f2.times(t.pi(), f2.fromInt(2)), f2.fromInt(x)), f2.fromInt(n)), f2, t)));
            roots2[x] = complex2;
            sum2 = sum2.$plus(complex2, (Semiring<T>)f2);
        }
        roots2[last2] = this.zero(f2).$minus(sum2, (Rng<T>)f2);
        return roots2;
    }

    public <T> Complex<T> apply(T real, T imag) {
        return new Complex<T>(real, imag);
    }

    public <T> Option<Tuple2<T, T>> unapply(Complex<T> x$0) {
        return x$0 == null ? None$.MODULE$ : new Some<Tuple2<T, T>>(new Tuple2<T, T>(x$0.real(), x$0.imag()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public Complex<Object> i$mDc$sp(Rig<Object> T2) {
        return new Complex$mcD$sp(T2.zero$mcD$sp(), T2.one$mcD$sp());
    }

    public Complex<Object> i$mFc$sp(Rig<Object> T2) {
        return new Complex$mcF$sp(T2.zero$mcF$sp(), T2.one$mcF$sp());
    }

    public Complex<Object> one$mDc$sp(Rig<Object> T2) {
        return new Complex$mcD$sp(T2.one$mcD$sp(), T2.zero$mcD$sp());
    }

    public Complex<Object> one$mFc$sp(Rig<Object> T2) {
        return new Complex$mcF$sp(T2.one$mcF$sp(), T2.zero$mcF$sp());
    }

    public Complex<Object> zero$mDc$sp(Semiring<Object> T2) {
        return new Complex$mcD$sp(T2.zero$mcD$sp(), T2.zero$mcD$sp());
    }

    public Complex<Object> zero$mFc$sp(Semiring<Object> T2) {
        return new Complex$mcF$sp(T2.zero$mcF$sp(), T2.zero$mcF$sp());
    }

    public Complex<Object> fromInt$mDc$sp(int n, Ring<Object> f2) {
        return new Complex$mcD$sp(f2.fromInt$mcD$sp(n), f2.zero$mcD$sp());
    }

    public Complex<Object> fromInt$mFc$sp(int n, Ring<Object> f2) {
        return new Complex$mcF$sp(f2.fromInt$mcF$sp(n), f2.zero$mcF$sp());
    }

    public Complex<Object> polar$mDc$sp(double magnitude, double angle, Field<Object> evidence$1, Trig<Object> evidence$2) {
        Trig$ trig$ = Trig$.MODULE$;
        Trig$ trig$2 = Trig$.MODULE$;
        return new Complex$mcD$sp(evidence$1.times$mcD$sp(magnitude, evidence$2.cos$mcD$sp(angle)), evidence$1.times$mcD$sp(magnitude, evidence$2.sin$mcD$sp(angle)));
    }

    public Complex<Object> polar$mFc$sp(float magnitude, float angle, Field<Object> evidence$1, Trig<Object> evidence$2) {
        Trig$ trig$ = Trig$.MODULE$;
        Trig$ trig$2 = Trig$.MODULE$;
        return new Complex$mcF$sp(evidence$1.times$mcF$sp(magnitude, evidence$2.cos$mcF$sp(angle)), evidence$1.times$mcF$sp(magnitude, evidence$2.sin$mcF$sp(angle)));
    }

    public Complex<Object> apply$mDc$sp(double real, Semiring<Object> evidence$3) {
        Semiring$ semiring$ = Semiring$.MODULE$;
        return new Complex$mcD$sp(real, evidence$3.zero$mcD$sp());
    }

    public Complex<Object> apply$mFc$sp(float real, Semiring<Object> evidence$3) {
        Semiring$ semiring$ = Semiring$.MODULE$;
        return new Complex$mcF$sp(real, evidence$3.zero$mcF$sp());
    }

    public Complex<Object> rootOfUnity$mDc$sp(int n, int x, Field<Object> f2, Trig<Object> t, IsReal<Object> r) {
        if (x == 0) {
            return this.one$mDc$sp(f2);
        }
        if (n % 2 == 0) {
            if (x == n / 2) {
                return this.one$mDc$sp(f2).unary_$minus$mcD$sp(f2);
            }
            if (n % 4 == 0) {
                if (x == n / 4) {
                    return this.i$mDc$sp(f2);
                }
                if (x == n * 3 / 4) {
                    return this.i$mDc$sp(f2).unary_$minus$mcD$sp(f2);
                }
            }
        }
        return this.polar$mDc$sp(f2.one$mcD$sp(), f2.div$mcD$sp(f2.times$mcD$sp(f2.times$mcD$sp(t.pi$mcD$sp(), f2.fromInt$mcD$sp(2)), f2.fromInt$mcD$sp(x)), f2.fromInt$mcD$sp(n)), f2, t);
    }

    public Complex<Object> rootOfUnity$mFc$sp(int n, int x, Field<Object> f2, Trig<Object> t, IsReal<Object> r) {
        if (x == 0) {
            return this.one$mFc$sp(f2);
        }
        if (n % 2 == 0) {
            if (x == n / 2) {
                return this.one$mFc$sp(f2).unary_$minus$mcF$sp(f2);
            }
            if (n % 4 == 0) {
                if (x == n / 4) {
                    return this.i$mFc$sp(f2);
                }
                if (x == n * 3 / 4) {
                    return this.i$mFc$sp(f2).unary_$minus$mcF$sp(f2);
                }
            }
        }
        return this.polar$mFc$sp(f2.one$mcF$sp(), f2.div$mcF$sp(f2.times$mcF$sp(f2.times$mcF$sp(t.pi$mcF$sp(), f2.fromInt$mcF$sp(2)), f2.fromInt$mcF$sp(x)), f2.fromInt$mcF$sp(n)), f2, t);
    }

    public Complex<Object>[] rootsOfUnity$mDc$sp(int n, Field<Object> f2, Trig<Object> t, IsReal<Object> r) {
        Complex<Object> sum2;
        Complex[] roots2 = new Complex[n];
        roots2[0] = sum2 = this.one$mDc$sp(f2);
        int west = n % 2 == 0 ? n / 2 : -1;
        int north = n % 4 == 0 ? n / 4 : -1;
        int south = n % 4 == 0 ? 3 * n / 4 : -1;
        int last2 = n - 1;
        for (int x = 1; x < last2; ++x) {
            Complex<Object> complex2 = north == x ? this.i$mDc$sp(f2) : (west == x ? this.one$mDc$sp(f2).unary_$minus$mcD$sp(f2) : (south == x ? this.i$mDc$sp(f2).unary_$minus$mcD$sp(f2) : this.polar$mDc$sp(f2.one$mcD$sp(), f2.div$mcD$sp(f2.times$mcD$sp(f2.times$mcD$sp(t.pi$mcD$sp(), f2.fromInt$mcD$sp(2)), f2.fromInt$mcD$sp(x)), f2.fromInt$mcD$sp(n)), f2, t)));
            roots2[x] = complex2;
            sum2 = sum2.$plus$mcD$sp(complex2, f2);
        }
        roots2[last2] = this.zero$mDc$sp(f2).$minus$mcD$sp(sum2, f2);
        return roots2;
    }

    public Complex<Object>[] rootsOfUnity$mFc$sp(int n, Field<Object> f2, Trig<Object> t, IsReal<Object> r) {
        Complex<Object> sum2;
        Complex[] roots2 = new Complex[n];
        roots2[0] = sum2 = this.one$mFc$sp(f2);
        int west = n % 2 == 0 ? n / 2 : -1;
        int north = n % 4 == 0 ? n / 4 : -1;
        int south = n % 4 == 0 ? 3 * n / 4 : -1;
        int last2 = n - 1;
        for (int x = 1; x < last2; ++x) {
            Complex<Object> complex2 = north == x ? this.i$mFc$sp(f2) : (west == x ? this.one$mFc$sp(f2).unary_$minus$mcF$sp(f2) : (south == x ? this.i$mFc$sp(f2).unary_$minus$mcF$sp(f2) : this.polar$mFc$sp(f2.one$mcF$sp(), f2.div$mcF$sp(f2.times$mcF$sp(f2.times$mcF$sp(t.pi$mcF$sp(), f2.fromInt$mcF$sp(2)), f2.fromInt$mcF$sp(x)), f2.fromInt$mcF$sp(n)), f2, t)));
            roots2[x] = complex2;
            sum2 = sum2.$plus$mcF$sp(complex2, f2);
        }
        roots2[last2] = this.zero$mFc$sp(f2).$minus$mcF$sp(sum2, f2);
        return roots2;
    }

    public Complex<Object> apply$mDc$sp(double real, double imag) {
        return new Complex$mcD$sp(real, imag);
    }

    public Complex<Object> apply$mFc$sp(float real, float imag) {
        return new Complex$mcF$sp(real, imag);
    }

    public Option<Tuple2<Object, Object>> unapply$mDc$sp(Complex<Object> x$0) {
        return x$0 == null ? None$.MODULE$ : new Some<Tuple2$mcDD$sp>(new Tuple2$mcDD$sp(x$0.real$mcD$sp(), x$0.imag$mcD$sp()));
    }

    public Option<Tuple2<Object, Object>> unapply$mFc$sp(Complex<Object> x$0) {
        return x$0 == null ? None$.MODULE$ : new Some<Tuple2<Float, Float>>(new Tuple2<Float, Float>(BoxesRunTime.boxToFloat(x$0.real$mcF$sp()), BoxesRunTime.boxToFloat(x$0.imag$mcF$sp())));
    }

    private Complex$() {
        MODULE$ = this;
        ComplexInstances0$class.$init$(this);
        ComplexInstances1$class.$init$(this);
        ComplexInstances$class.$init$(this);
    }
}

