/*
 * Decompiled with CFR 0.152.
 */
package spire.math;

import scala.Tuple2;
import scala.Tuple2$mcDD$sp;
import spire.algebra.AdditiveMonoid;
import spire.algebra.Eq;
import spire.algebra.Field;
import spire.algebra.IsReal;
import spire.algebra.NRoot;
import spire.algebra.Order;
import spire.algebra.Rng;
import spire.algebra.Semiring;
import spire.algebra.Trig;
import spire.math.Complex;
import spire.math.Complex$;
import spire.math.Quaternion;
import spire.math.Quaternion$mcD$sp;
import spire.math.package$;

public final class Complex$mcD$sp
extends Complex<Object> {
    public static final long serialVersionUID = 0L;
    public final double real$mcD$sp;
    public final double imag$mcD$sp;

    @Override
    public double real$mcD$sp() {
        return this.real$mcD$sp;
    }

    @Override
    public double real() {
        return this.real$mcD$sp();
    }

    @Override
    public double imag$mcD$sp() {
        return this.imag$mcD$sp;
    }

    @Override
    public double imag() {
        return this.imag$mcD$sp();
    }

    @Override
    public int signum(IsReal<Object> o) {
        return this.signum$mcD$sp(o);
    }

    @Override
    public int signum$mcD$sp(IsReal<Object> o) {
        int n;
        int n2 = o.signum$mcD$sp(this.real());
        switch (n2) {
            default: {
                n = n2;
                break;
            }
            case 0: {
                n = o.signum$mcD$sp(this.imag());
            }
        }
        return n;
    }

    @Override
    public Complex<Object> complexSignum(Field<Object> f2, IsReal<Object> o, NRoot<Object> n) {
        return this.complexSignum$mcD$sp(f2, o, n);
    }

    @Override
    public Complex<Object> complexSignum$mcD$sp(Field<Object> f2, IsReal<Object> o, NRoot<Object> n) {
        return this.isZero$mcD$sp(o) ? this : this.$div$mcD$sp(this.abs$mcD$sp(f2, o, n), f2);
    }

    @Override
    public double abs(Field<Object> f2, IsReal<Object> o, NRoot<Object> n) {
        return this.abs$mcD$sp(f2, o, n);
    }

    @Override
    public double abs$mcD$sp(Field<Object> f2, IsReal<Object> o, NRoot<Object> n) {
        return n.sqrt$mcD$sp(f2.plus$mcD$sp(f2.times$mcD$sp(this.real(), this.real()), f2.times$mcD$sp(this.imag(), this.imag())));
    }

    @Override
    public double arg(Field<Object> f2, Trig<Object> t, IsReal<Object> o) {
        return this.arg$mcD$sp(f2, t, o);
    }

    @Override
    public double arg$mcD$sp(Field<Object> f2, Trig<Object> t, IsReal<Object> o) {
        return this.isZero$mcD$sp(o) ? f2.zero$mcD$sp() : t.atan2$mcD$sp(this.imag(), this.real());
    }

    @Override
    public double norm(Field<Object> f2, NRoot<Object> n, Order<Object> o) {
        return this.norm$mcD$sp(f2, n, o);
    }

    @Override
    public double norm$mcD$sp(Field<Object> f2, NRoot<Object> n, Order<Object> o) {
        return package$.MODULE$.hypot$mDc$sp(this.real(), this.imag(), f2, n, o);
    }

    @Override
    public Complex<Object> conjugate(Rng<Object> f2) {
        return this.conjugate$mcD$sp(f2);
    }

    @Override
    public Complex<Object> conjugate$mcD$sp(Rng<Object> f2) {
        return new Complex$mcD$sp(this.real(), f2.negate$mcD$sp(this.imag()));
    }

    @Override
    public Tuple2<Object, Object> asTuple() {
        return this.asTuple$mcD$sp();
    }

    @Override
    public Tuple2<Object, Object> asTuple$mcD$sp() {
        return new Tuple2$mcDD$sp(this.real(), this.imag());
    }

    @Override
    public Tuple2<Object, Object> asPolarTuple(Field<Object> f2, NRoot<Object> n, Trig<Object> t, IsReal<Object> o) {
        return this.asPolarTuple$mcD$sp(f2, n, t, o);
    }

    @Override
    public Tuple2<Object, Object> asPolarTuple$mcD$sp(Field<Object> f2, NRoot<Object> n, Trig<Object> t, IsReal<Object> o) {
        return new Tuple2$mcDD$sp(this.abs$mcD$sp(f2, o, n), this.arg$mcD$sp(f2, t, o));
    }

    @Override
    public boolean isZero(IsReal<Object> o) {
        return this.isZero$mcD$sp(o);
    }

    @Override
    public boolean isZero$mcD$sp(IsReal<Object> o) {
        return o.isSignZero$mcD$sp(this.real()) && o.isSignZero$mcD$sp(this.imag());
    }

    @Override
    public boolean isImaginary(IsReal<Object> o) {
        return this.isImaginary$mcD$sp(o);
    }

    @Override
    public boolean isImaginary$mcD$sp(IsReal<Object> o) {
        return o.isSignZero$mcD$sp(this.real());
    }

    @Override
    public boolean isReal(IsReal<Object> o) {
        return this.isReal$mcD$sp(o);
    }

    @Override
    public boolean isReal$mcD$sp(IsReal<Object> o) {
        return o.isSignZero$mcD$sp(this.imag());
    }

    @Override
    public boolean eqv(Complex<Object> b, Eq<Object> o) {
        return this.eqv$mcD$sp(b, o);
    }

    @Override
    public boolean eqv$mcD$sp(Complex<Object> b, Eq<Object> o) {
        return o.eqv$mcD$sp(this.real(), b.real$mcD$sp()) && o.eqv$mcD$sp(this.imag(), b.imag$mcD$sp());
    }

    @Override
    public boolean neqv(Complex<Object> b, Eq<Object> o) {
        return this.neqv$mcD$sp(b, o);
    }

    @Override
    public boolean neqv$mcD$sp(Complex<Object> b, Eq<Object> o) {
        return o.neqv$mcD$sp(this.real(), b.real$mcD$sp()) || o.neqv$mcD$sp(this.imag(), b.imag$mcD$sp());
    }

    @Override
    public Complex<Object> unary_$minus(Rng<Object> r) {
        return this.unary_$minus$mcD$sp(r);
    }

    @Override
    public Complex<Object> unary_$minus$mcD$sp(Rng<Object> r) {
        return new Complex$mcD$sp(r.negate$mcD$sp(this.real()), r.negate$mcD$sp(this.imag()));
    }

    @Override
    public Complex<Object> $plus(double rhs, Semiring<Object> r) {
        return this.$plus$mcD$sp(rhs, r);
    }

    @Override
    public Complex<Object> $plus$mcD$sp(double rhs, Semiring<Object> r) {
        return new Complex$mcD$sp(r.plus$mcD$sp(this.real(), rhs), this.imag());
    }

    @Override
    public Complex<Object> $minus(double rhs, Rng<Object> r) {
        return this.$minus$mcD$sp(rhs, r);
    }

    @Override
    public Complex<Object> $minus$mcD$sp(double rhs, Rng<Object> r) {
        return new Complex$mcD$sp(r.minus$mcD$sp(this.real(), rhs), this.imag());
    }

    @Override
    public Complex<Object> $times(double rhs, Semiring<Object> r) {
        return this.$times$mcD$sp(rhs, r);
    }

    @Override
    public Complex<Object> $times$mcD$sp(double rhs, Semiring<Object> r) {
        return new Complex$mcD$sp(r.times$mcD$sp(this.real(), rhs), r.times$mcD$sp(this.imag(), rhs));
    }

    @Override
    public Complex<Object> $div(double rhs, Field<Object> r) {
        return this.$div$mcD$sp(rhs, r);
    }

    @Override
    public Complex<Object> $div$mcD$sp(double rhs, Field<Object> r) {
        return new Complex$mcD$sp(r.div$mcD$sp(this.real(), rhs), r.div$mcD$sp(this.imag(), rhs));
    }

    @Override
    public Complex<Object> $div$tilde(double rhs, Field<Object> f2, IsReal<Object> o) {
        return this.$div$tilde$mcD$sp(rhs, f2, o);
    }

    @Override
    public Complex<Object> $div$tilde$mcD$sp(double rhs, Field<Object> f2, IsReal<Object> o) {
        return this.$div$mcD$sp(rhs, f2).floor$mcD$sp(o);
    }

    @Override
    public Complex<Object> $percent(double rhs, Field<Object> f2, IsReal<Object> o) {
        return this.$percent$mcD$sp(rhs, f2, o);
    }

    @Override
    public Complex<Object> $percent$mcD$sp(double rhs, Field<Object> f2, IsReal<Object> o) {
        return this.$minus$mcD$sp(this.$div$tilde$mcD$sp(rhs, f2, o).$times$mcD$sp(rhs, f2), f2);
    }

    @Override
    public Tuple2<Complex<Object>, Complex<Object>> $div$percent(double rhs, Field<Object> f2, IsReal<Object> o) {
        return this.$div$percent$mcD$sp(rhs, f2, o);
    }

    @Override
    public Tuple2<Complex<Object>, Complex<Object>> $div$percent$mcD$sp(double rhs, Field<Object> f2, IsReal<Object> o) {
        Complex<Object> q = this.$div$tilde$mcD$sp(rhs, f2, o);
        return new Tuple2<Complex<Object>, Complex<Object>>(q, this.$minus$mcD$sp(q.$times$mcD$sp(rhs, f2), f2));
    }

    @Override
    public Complex<Object> $times$times(double e, Field<Object> f2, NRoot<Object> n, Trig<Object> t, IsReal<Object> o) {
        return this.$times$times$mcD$sp(e, f2, n, t, o);
    }

    @Override
    public Complex<Object> $times$times$mcD$sp(double e, Field<Object> f2, NRoot<Object> n, Trig<Object> t, IsReal<Object> o) {
        return this.pow$mcD$sp(e, f2, n, t, o);
    }

    @Override
    public Complex<Object> pow(double e, Field<Object> f2, NRoot<Object> n, Trig<Object> t, IsReal<Object> o) {
        return this.pow$mcD$sp(e, f2, n, t, o);
    }

    @Override
    public Complex<Object> pow$mcD$sp(double e, Field<Object> f2, NRoot<Object> n, Trig<Object> t, IsReal<Object> o) {
        Complex<Object> complex2;
        if (o.isSignZero$mcD$sp(e)) {
            complex2 = Complex$.MODULE$.one$mDc$sp(f2);
        } else if (this.isZero$mcD$sp(o)) {
            if (o.lt$mcD$sp(e, f2.zero$mcD$sp())) {
                throw new Exception("raising 0 to negative/complex power");
            }
            complex2 = Complex$.MODULE$.zero$mDc$sp(f2);
        } else {
            complex2 = Complex$.MODULE$.polar$mDc$sp(n.fpow$mcD$sp(this.abs$mcD$sp(f2, o, n), e), f2.times$mcD$sp(this.arg$mcD$sp(f2, t, o), e), f2, t);
        }
        return complex2;
    }

    @Override
    public Complex<Object> $plus(Complex<Object> b, Semiring<Object> r) {
        return this.$plus$mcD$sp(b, r);
    }

    @Override
    public Complex<Object> $plus$mcD$sp(Complex<Object> b, Semiring<Object> r) {
        return new Complex$mcD$sp(r.plus$mcD$sp(this.real(), b.real$mcD$sp()), r.plus$mcD$sp(this.imag(), b.imag$mcD$sp()));
    }

    @Override
    public Complex<Object> $minus(Complex<Object> b, Rng<Object> r) {
        return this.$minus$mcD$sp(b, r);
    }

    @Override
    public Complex<Object> $minus$mcD$sp(Complex<Object> b, Rng<Object> r) {
        return new Complex$mcD$sp(r.minus$mcD$sp(this.real(), b.real$mcD$sp()), r.minus$mcD$sp(this.imag(), b.imag$mcD$sp()));
    }

    @Override
    public Complex<Object> $times(Complex<Object> b, Rng<Object> r) {
        return this.$times$mcD$sp(b, r);
    }

    @Override
    public Complex<Object> $times$mcD$sp(Complex<Object> b, Rng<Object> r) {
        return new Complex$mcD$sp(r.minus$mcD$sp(r.times$mcD$sp(this.real(), b.real$mcD$sp()), r.times$mcD$sp(this.imag(), b.imag$mcD$sp())), r.plus$mcD$sp(r.times$mcD$sp(this.imag(), b.real$mcD$sp()), r.times$mcD$sp(this.real(), b.imag$mcD$sp())));
    }

    @Override
    public Complex<Object> $div(Complex<Object> b, Field<Object> f2, IsReal<Object> o) {
        return this.$div$mcD$sp(b, f2, o);
    }

    @Override
    public Complex<Object> $div$mcD$sp(Complex<Object> b, Field<Object> f2, IsReal<Object> o) {
        Complex$mcD$sp complex$mcD$sp;
        double abs_bimag;
        double abs_breal = o.abs$mcD$sp(b.real$mcD$sp());
        if (o.gteqv$mcD$sp(abs_breal, abs_bimag = o.abs$mcD$sp(b.imag$mcD$sp()))) {
            if (o.eqv$mcD$sp(abs_breal, f2.zero$mcD$sp())) {
                throw new Exception("/ by zero");
            }
            double ratio = f2.div$mcD$sp(b.imag$mcD$sp(), b.real$mcD$sp());
            double denom = f2.plus$mcD$sp(b.real$mcD$sp(), f2.times$mcD$sp(b.imag$mcD$sp(), ratio));
            complex$mcD$sp = new Complex$mcD$sp(f2.div$mcD$sp(f2.plus$mcD$sp(this.real(), f2.times$mcD$sp(this.imag(), ratio)), denom), f2.div$mcD$sp(f2.minus$mcD$sp(this.imag(), f2.times$mcD$sp(this.real(), ratio)), denom));
        } else {
            if (o.eqv$mcD$sp(abs_bimag, f2.zero$mcD$sp())) {
                throw new Exception("/ by zero");
            }
            double ratio = f2.div$mcD$sp(b.real$mcD$sp(), b.imag$mcD$sp());
            double denom = f2.plus$mcD$sp(f2.times$mcD$sp(b.real$mcD$sp(), ratio), b.imag$mcD$sp());
            complex$mcD$sp = new Complex$mcD$sp(f2.div$mcD$sp(f2.plus$mcD$sp(f2.times$mcD$sp(this.real(), ratio), this.imag()), denom), f2.div$mcD$sp(f2.minus$mcD$sp(f2.times$mcD$sp(this.imag(), ratio), this.real()), denom));
        }
        return complex$mcD$sp;
    }

    @Override
    public Complex<Object> $div$tilde(Complex<Object> b, Field<Object> f2, IsReal<Object> o) {
        return this.$div$tilde$mcD$sp(b, f2, o);
    }

    @Override
    public Complex<Object> $div$tilde$mcD$sp(Complex<Object> b, Field<Object> f2, IsReal<Object> o) {
        Complex<Object> d = this.$div$mcD$sp(b, f2, o);
        return new Complex$mcD$sp(o.floor$mcD$sp(d.real$mcD$sp()), o.floor$mcD$sp(d.imag$mcD$sp()));
    }

    @Override
    public Complex<Object> $percent(Complex<Object> b, Field<Object> f2, IsReal<Object> o) {
        return this.$percent$mcD$sp(b, f2, o);
    }

    @Override
    public Complex<Object> $percent$mcD$sp(Complex<Object> b, Field<Object> f2, IsReal<Object> o) {
        return this.$minus$mcD$sp(this.$div$tilde$mcD$sp(b, f2, o).$times$mcD$sp(b, f2), f2);
    }

    @Override
    public Tuple2<Complex<Object>, Complex<Object>> $div$percent(Complex<Object> b, Field<Object> f2, IsReal<Object> o) {
        return this.$div$percent$mcD$sp(b, f2, o);
    }

    @Override
    public Tuple2<Complex<Object>, Complex<Object>> $div$percent$mcD$sp(Complex<Object> b, Field<Object> f2, IsReal<Object> o) {
        Complex<Object> q = this.$div$tilde$mcD$sp(b, f2, o);
        return new Tuple2<Complex<Object>, Complex<Object>>(q, this.$minus$mcD$sp(q.$times$mcD$sp(b, f2), f2));
    }

    @Override
    public Complex<Object> $times$times(int b, Field<Object> f2, NRoot<Object> n, Trig<Object> t, IsReal<Object> o) {
        return this.$times$times$mcD$sp(b, f2, n, t, o);
    }

    @Override
    public Complex<Object> $times$times$mcD$sp(int b, Field<Object> f2, NRoot<Object> n, Trig<Object> t, IsReal<Object> o) {
        return this.pow$mcD$sp(b, f2, n, t, o);
    }

    @Override
    public Complex<Object> nroot(int k, Field<Object> f2, NRoot<Object> n, Trig<Object> t, IsReal<Object> o) {
        return this.nroot$mcD$sp(k, f2, n, t, o);
    }

    @Override
    public Complex<Object> nroot$mcD$sp(int k, Field<Object> f2, NRoot<Object> n, Trig<Object> t, IsReal<Object> o) {
        return this.isZero$mcD$sp(o) ? Complex$.MODULE$.zero$mDc$sp(f2) : this.pow$mcD$sp(new Complex$mcD$sp(f2.reciprocal$mcD$sp(f2.fromInt$mcD$sp(k)), f2.zero$mcD$sp()), f2, n, t, o);
    }

    @Override
    public Complex<Object> pow(int b, Field<Object> f2, NRoot<Object> n, Trig<Object> t, IsReal<Object> o) {
        return this.pow$mcD$sp(b, f2, n, t, o);
    }

    @Override
    public Complex<Object> pow$mcD$sp(int b, Field<Object> f2, NRoot<Object> n, Trig<Object> t, IsReal<Object> o) {
        return this.isZero$mcD$sp(o) ? Complex$.MODULE$.zero$mDc$sp(f2) : Complex$.MODULE$.polar$mDc$sp(f2.pow$mcD$sp(this.abs$mcD$sp(f2, o, n), b), f2.times$mcD$sp(this.arg$mcD$sp(f2, t, o), f2.fromInt$mcD$sp(b)), f2, t);
    }

    @Override
    public Complex<Object> $times$times(Complex<Object> b, Field<Object> f2, NRoot<Object> n, Trig<Object> t, IsReal<Object> o) {
        return this.$times$times$mcD$sp(b, f2, n, t, o);
    }

    @Override
    public Complex<Object> $times$times$mcD$sp(Complex<Object> b, Field<Object> f2, NRoot<Object> n, Trig<Object> t, IsReal<Object> o) {
        return this.pow$mcD$sp(b, f2, n, t, o);
    }

    @Override
    public Complex<Object> pow(Complex<Object> b, Field<Object> f2, NRoot<Object> n, Trig<Object> t, IsReal<Object> o) {
        return this.pow$mcD$sp(b, f2, n, t, o);
    }

    @Override
    public Complex<Object> pow$mcD$sp(Complex<Object> b, Field<Object> f2, NRoot<Object> n, Trig<Object> t, IsReal<Object> o) {
        Complex<Object> complex2;
        if (b.isZero$mcD$sp(o)) {
            complex2 = Complex$.MODULE$.one$mDc$sp(f2);
        } else if (this.isZero$mcD$sp(o)) {
            if (o.neqv$mcD$sp(b.imag$mcD$sp(), f2.zero$mcD$sp()) || o.lt$mcD$sp(b.real$mcD$sp(), f2.zero$mcD$sp())) {
                throw new Exception("raising 0 to negative/complex power");
            }
            complex2 = Complex$.MODULE$.zero$mDc$sp(f2);
        } else if (o.neqv$mcD$sp(b.imag$mcD$sp(), f2.zero$mcD$sp())) {
            double len = f2.div$mcD$sp(n.fpow$mcD$sp(this.abs$mcD$sp(f2, o, n), b.real$mcD$sp()), t.exp$mcD$sp(f2.times$mcD$sp(this.arg$mcD$sp(f2, t, o), b.imag$mcD$sp())));
            double phase = f2.plus$mcD$sp(f2.times$mcD$sp(this.arg$mcD$sp(f2, t, o), b.real$mcD$sp()), f2.times$mcD$sp(t.log$mcD$sp(this.abs$mcD$sp(f2, o, n)), b.imag$mcD$sp()));
            complex2 = Complex$.MODULE$.polar$mDc$sp(len, phase, f2, t);
        } else {
            complex2 = Complex$.MODULE$.polar$mDc$sp(n.fpow$mcD$sp(this.abs$mcD$sp(f2, o, n), b.real$mcD$sp()), f2.times$mcD$sp(this.arg$mcD$sp(f2, t, o), b.real$mcD$sp()), f2, t);
        }
        return complex2;
    }

    @Override
    public Complex<Object> log(Field<Object> f2, NRoot<Object> n, Trig<Object> t, IsReal<Object> o) {
        return this.log$mcD$sp(f2, n, t, o);
    }

    @Override
    public Complex<Object> log$mcD$sp(Field<Object> f2, NRoot<Object> n, Trig<Object> t, IsReal<Object> o) {
        if (this.isZero$mcD$sp(o)) {
            throw new IllegalArgumentException("log(0) undefined");
        }
        return new Complex$mcD$sp(t.log$mcD$sp(this.abs$mcD$sp(f2, o, n)), this.arg$mcD$sp(f2, t, o));
    }

    @Override
    public Complex<Object> sqrt(Field<Object> f2, NRoot<Object> n0, IsReal<Object> o) {
        return this.sqrt$mcD$sp(f2, n0, o);
    }

    @Override
    public Complex<Object> sqrt$mcD$sp(Field<Object> f2, NRoot<Object> n0, IsReal<Object> o) {
        Complex$mcD$sp complex$mcD$sp;
        if (this.isZero$mcD$sp(o)) {
            complex$mcD$sp = Complex$.MODULE$.zero$mDc$sp(f2);
        } else {
            double two = f2.fromInt$mcD$sp(2);
            double a = n0.sqrt$mcD$sp(f2.div$mcD$sp(f2.plus$mcD$sp(this.abs$mcD$sp(f2, o, n0), o.abs$mcD$sp(this.real())), two));
            int n = o.signum$mcD$sp(this.imag());
            switch (n) {
                default: {
                    double b = n0.sqrt$mcD$sp(f2.div$mcD$sp(f2.minus$mcD$sp(this.abs$mcD$sp(f2, o, n0), o.abs$mcD$sp(this.real())), two));
                    if (n < 0) {
                        complex$mcD$sp = new Complex$mcD$sp(a, f2.negate$mcD$sp(b));
                        break;
                    }
                    complex$mcD$sp = new Complex$mcD$sp(a, b);
                    break;
                }
                case 0: {
                    complex$mcD$sp = o.lt$mcD$sp(this.real(), f2.zero$mcD$sp()) ? new Complex$mcD$sp(f2.zero$mcD$sp(), a) : new Complex$mcD$sp(a, f2.zero$mcD$sp());
                }
            }
        }
        return complex$mcD$sp;
    }

    @Override
    public Complex<Object> floor(IsReal<Object> o) {
        return this.floor$mcD$sp(o);
    }

    @Override
    public Complex<Object> floor$mcD$sp(IsReal<Object> o) {
        return new Complex$mcD$sp(o.floor$mcD$sp(this.real()), o.floor$mcD$sp(this.imag()));
    }

    @Override
    public Complex<Object> ceil(IsReal<Object> o) {
        return this.ceil$mcD$sp(o);
    }

    @Override
    public Complex<Object> ceil$mcD$sp(IsReal<Object> o) {
        return new Complex$mcD$sp(o.ceil$mcD$sp(this.real()), o.ceil$mcD$sp(this.imag()));
    }

    @Override
    public Complex<Object> round(IsReal<Object> o) {
        return this.round$mcD$sp(o);
    }

    @Override
    public Complex<Object> round$mcD$sp(IsReal<Object> o) {
        return new Complex$mcD$sp(o.round$mcD$sp(this.real()), o.round$mcD$sp(this.imag()));
    }

    @Override
    public Complex<Object> acos(Field<Object> f2, NRoot<Object> n, Trig<Object> t, IsReal<Object> o) {
        return this.acos$mcD$sp(f2, n, t, o);
    }

    @Override
    public Complex<Object> acos$mcD$sp(Field<Object> f2, NRoot<Object> n, Trig<Object> t, IsReal<Object> o) {
        Complex<Object> z2 = this.$times$mcD$sp(this, f2);
        Complex<Object> s2 = new Complex$mcD$sp(f2.minus$mcD$sp(f2.one$mcD$sp(), z2.real$mcD$sp()), f2.negate$mcD$sp(z2.imag$mcD$sp())).sqrt$mcD$sp(f2, n, o);
        Complex<Object> l = new Complex$mcD$sp(f2.plus$mcD$sp(this.real(), s2.imag$mcD$sp()), f2.plus$mcD$sp(this.imag(), s2.real$mcD$sp())).log$mcD$sp(f2, n, t, o);
        return new Complex$mcD$sp(l.imag$mcD$sp(), f2.negate$mcD$sp(l.real$mcD$sp()));
    }

    @Override
    public Complex<Object> asin(Field<Object> f2, NRoot<Object> n, Trig<Object> t, IsReal<Object> o) {
        return this.asin$mcD$sp(f2, n, t, o);
    }

    @Override
    public Complex<Object> asin$mcD$sp(Field<Object> f2, NRoot<Object> n, Trig<Object> t, IsReal<Object> o) {
        Complex<Object> z2 = this.$times$mcD$sp(this, f2);
        Complex<Object> s2 = new Complex$mcD$sp(f2.minus$mcD$sp(f2.one$mcD$sp(), z2.real$mcD$sp()), f2.negate$mcD$sp(z2.imag$mcD$sp())).sqrt$mcD$sp(f2, n, o);
        Complex<Object> l = new Complex$mcD$sp(f2.plus$mcD$sp(s2.real$mcD$sp(), f2.negate$mcD$sp(this.imag())), f2.plus$mcD$sp(s2.imag$mcD$sp(), this.real())).log$mcD$sp(f2, n, t, o);
        return new Complex$mcD$sp(l.imag$mcD$sp(), f2.negate$mcD$sp(l.real$mcD$sp()));
    }

    @Override
    public Complex<Object> atan(Field<Object> f2, NRoot<Object> r, Trig<Object> t, IsReal<Object> o) {
        return this.atan$mcD$sp(f2, r, t, o);
    }

    @Override
    public Complex<Object> atan$mcD$sp(Field<Object> f2, NRoot<Object> r, Trig<Object> t, IsReal<Object> o) {
        Complex$mcD$sp n = new Complex$mcD$sp(this.real(), f2.plus$mcD$sp(this.imag(), f2.one$mcD$sp()));
        Complex$mcD$sp d = new Complex$mcD$sp(f2.negate$mcD$sp(this.real()), f2.minus$mcD$sp(f2.one$mcD$sp(), this.imag()));
        Complex<Object> l = ((Complex)n).$div$mcD$sp(d, f2, o).log$mcD$sp(f2, r, t, o);
        return new Complex$mcD$sp(f2.div$mcD$sp(l.imag$mcD$sp(), f2.fromInt$mcD$sp(-2)), f2.div$mcD$sp(l.real$mcD$sp(), f2.fromInt$mcD$sp(2)));
    }

    @Override
    public Complex<Object> exp(Field<Object> f2, Trig<Object> t) {
        return this.exp$mcD$sp(f2, t);
    }

    @Override
    public Complex<Object> exp$mcD$sp(Field<Object> f2, Trig<Object> t) {
        return new Complex$mcD$sp(f2.times$mcD$sp(t.exp$mcD$sp(this.real()), t.cos$mcD$sp(this.imag())), f2.times$mcD$sp(t.exp$mcD$sp(this.real()), t.sin$mcD$sp(this.imag())));
    }

    @Override
    public Complex<Object> sin(Field<Object> f2, Trig<Object> t) {
        return this.sin$mcD$sp(f2, t);
    }

    @Override
    public Complex<Object> sin$mcD$sp(Field<Object> f2, Trig<Object> t) {
        return new Complex$mcD$sp(f2.times$mcD$sp(t.sin$mcD$sp(this.real()), t.cosh$mcD$sp(this.imag())), f2.times$mcD$sp(t.cos$mcD$sp(this.real()), t.sinh$mcD$sp(this.imag())));
    }

    @Override
    public Complex<Object> sinh(Field<Object> f2, Trig<Object> t) {
        return this.sinh$mcD$sp(f2, t);
    }

    @Override
    public Complex<Object> sinh$mcD$sp(Field<Object> f2, Trig<Object> t) {
        return new Complex$mcD$sp(f2.times$mcD$sp(t.sinh$mcD$sp(this.real()), t.cos$mcD$sp(this.imag())), f2.times$mcD$sp(t.cosh$mcD$sp(this.real()), t.sin$mcD$sp(this.imag())));
    }

    @Override
    public Complex<Object> cos(Field<Object> f2, Trig<Object> t) {
        return this.cos$mcD$sp(f2, t);
    }

    @Override
    public Complex<Object> cos$mcD$sp(Field<Object> f2, Trig<Object> t) {
        return new Complex$mcD$sp(f2.times$mcD$sp(t.cos$mcD$sp(this.real()), t.cosh$mcD$sp(this.imag())), f2.times$mcD$sp(f2.negate$mcD$sp(t.sin$mcD$sp(this.real())), t.sinh$mcD$sp(this.imag())));
    }

    @Override
    public Complex<Object> cosh(Field<Object> f2, Trig<Object> t) {
        return this.cosh$mcD$sp(f2, t);
    }

    @Override
    public Complex<Object> cosh$mcD$sp(Field<Object> f2, Trig<Object> t) {
        return new Complex$mcD$sp(f2.times$mcD$sp(t.cosh$mcD$sp(this.real()), t.cos$mcD$sp(this.imag())), f2.times$mcD$sp(t.sinh$mcD$sp(this.real()), t.sin$mcD$sp(this.imag())));
    }

    @Override
    public Complex<Object> tan(Field<Object> f2, Trig<Object> t) {
        return this.tan$mcD$sp(f2, t);
    }

    @Override
    public Complex<Object> tan$mcD$sp(Field<Object> f2, Trig<Object> t) {
        double r2 = f2.plus$mcD$sp(this.real(), this.real());
        double i2 = f2.plus$mcD$sp(this.imag(), this.imag());
        double d = f2.plus$mcD$sp(t.cos$mcD$sp(r2), t.cosh$mcD$sp(i2));
        return new Complex$mcD$sp(f2.div$mcD$sp(t.sin$mcD$sp(r2), d), f2.div$mcD$sp(t.sinh$mcD$sp(i2), d));
    }

    @Override
    public Complex<Object> tanh(Field<Object> f2, Trig<Object> t) {
        return this.tanh$mcD$sp(f2, t);
    }

    @Override
    public Complex<Object> tanh$mcD$sp(Field<Object> f2, Trig<Object> t) {
        double r2 = f2.plus$mcD$sp(this.real(), this.real());
        double i2 = f2.plus$mcD$sp(this.imag(), this.imag());
        double d = f2.plus$mcD$sp(t.cos$mcD$sp(r2), t.cosh$mcD$sp(i2));
        return new Complex$mcD$sp(f2.div$mcD$sp(t.sinh$mcD$sp(r2), d), f2.div$mcD$sp(t.sin$mcD$sp(i2), d));
    }

    @Override
    public Quaternion<Object> toQuaternion(AdditiveMonoid<Object> ev) {
        return this.toQuaternion$mcD$sp(ev);
    }

    @Override
    public Quaternion<Object> toQuaternion$mcD$sp(AdditiveMonoid<Object> ev) {
        return new Quaternion$mcD$sp(this.real(), this.imag(), ev.zero$mcD$sp(), ev.zero$mcD$sp());
    }

    @Override
    public <T> double copy$default$1() {
        return this.copy$default$1$mcD$sp();
    }

    @Override
    public <T> double copy$default$1$mcD$sp() {
        return this.real();
    }

    @Override
    public <T> double copy$default$2() {
        return this.copy$default$2$mcD$sp();
    }

    @Override
    public <T> double copy$default$2$mcD$sp() {
        return this.imag();
    }

    @Override
    public boolean specInstance$() {
        return true;
    }

    public Complex$mcD$sp(double real$mcD$sp, double imag$mcD$sp) {
        this.real$mcD$sp = real$mcD$sp;
        this.imag$mcD$sp = imag$mcD$sp;
        super(null, null);
    }
}

