/*
 * Decompiled with CFR 0.152.
 */
package spire.math;

import scala.Tuple2;
import scala.runtime.BoxesRunTime;
import spire.algebra.AdditiveMonoid;
import spire.algebra.Eq;
import spire.algebra.Field;
import spire.algebra.IsReal;
import spire.algebra.NRoot;
import spire.algebra.Order;
import spire.algebra.Rng;
import spire.algebra.Semiring;
import spire.algebra.Trig;
import spire.math.Complex;
import spire.math.Complex$;
import spire.math.Quaternion;
import spire.math.Quaternion$mcF$sp;
import spire.math.package$;

public final class Complex$mcF$sp
extends Complex<Object> {
    public static final long serialVersionUID = 0L;
    public final float real$mcF$sp;
    public final float imag$mcF$sp;

    @Override
    public float real$mcF$sp() {
        return this.real$mcF$sp;
    }

    @Override
    public float real() {
        return this.real$mcF$sp();
    }

    @Override
    public float imag$mcF$sp() {
        return this.imag$mcF$sp;
    }

    @Override
    public float imag() {
        return this.imag$mcF$sp();
    }

    @Override
    public int signum(IsReal<Object> o) {
        return this.signum$mcF$sp(o);
    }

    @Override
    public int signum$mcF$sp(IsReal<Object> o) {
        int n;
        int n2 = o.signum$mcF$sp(this.real());
        switch (n2) {
            default: {
                n = n2;
                break;
            }
            case 0: {
                n = o.signum$mcF$sp(this.imag());
            }
        }
        return n;
    }

    @Override
    public Complex<Object> complexSignum(Field<Object> f2, IsReal<Object> o, NRoot<Object> n) {
        return this.complexSignum$mcF$sp(f2, o, n);
    }

    @Override
    public Complex<Object> complexSignum$mcF$sp(Field<Object> f2, IsReal<Object> o, NRoot<Object> n) {
        return this.isZero$mcF$sp(o) ? this : this.$div$mcF$sp(this.abs$mcF$sp(f2, o, n), f2);
    }

    @Override
    public float abs(Field<Object> f2, IsReal<Object> o, NRoot<Object> n) {
        return this.abs$mcF$sp(f2, o, n);
    }

    @Override
    public float abs$mcF$sp(Field<Object> f2, IsReal<Object> o, NRoot<Object> n) {
        return n.sqrt$mcF$sp(f2.plus$mcF$sp(f2.times$mcF$sp(this.real(), this.real()), f2.times$mcF$sp(this.imag(), this.imag())));
    }

    @Override
    public float arg(Field<Object> f2, Trig<Object> t, IsReal<Object> o) {
        return this.arg$mcF$sp(f2, t, o);
    }

    @Override
    public float arg$mcF$sp(Field<Object> f2, Trig<Object> t, IsReal<Object> o) {
        return this.isZero$mcF$sp(o) ? f2.zero$mcF$sp() : t.atan2$mcF$sp(this.imag(), this.real());
    }

    @Override
    public float norm(Field<Object> f2, NRoot<Object> n, Order<Object> o) {
        return this.norm$mcF$sp(f2, n, o);
    }

    @Override
    public float norm$mcF$sp(Field<Object> f2, NRoot<Object> n, Order<Object> o) {
        return package$.MODULE$.hypot$mFc$sp(this.real(), this.imag(), f2, n, o);
    }

    @Override
    public Complex<Object> conjugate(Rng<Object> f2) {
        return this.conjugate$mcF$sp(f2);
    }

    @Override
    public Complex<Object> conjugate$mcF$sp(Rng<Object> f2) {
        return new Complex$mcF$sp(this.real(), f2.negate$mcF$sp(this.imag()));
    }

    @Override
    public Tuple2<Object, Object> asTuple() {
        return this.asTuple$mcF$sp();
    }

    @Override
    public Tuple2<Object, Object> asTuple$mcF$sp() {
        return new Tuple2<Object, Object>(BoxesRunTime.boxToFloat(this.real()), BoxesRunTime.boxToFloat(this.imag()));
    }

    @Override
    public Tuple2<Object, Object> asPolarTuple(Field<Object> f2, NRoot<Object> n, Trig<Object> t, IsReal<Object> o) {
        return this.asPolarTuple$mcF$sp(f2, n, t, o);
    }

    @Override
    public Tuple2<Object, Object> asPolarTuple$mcF$sp(Field<Object> f2, NRoot<Object> n, Trig<Object> t, IsReal<Object> o) {
        return new Tuple2<Object, Object>(BoxesRunTime.boxToFloat(this.abs$mcF$sp(f2, o, n)), BoxesRunTime.boxToFloat(this.arg$mcF$sp(f2, t, o)));
    }

    @Override
    public boolean isZero(IsReal<Object> o) {
        return this.isZero$mcF$sp(o);
    }

    @Override
    public boolean isZero$mcF$sp(IsReal<Object> o) {
        return o.isSignZero$mcF$sp(this.real()) && o.isSignZero$mcF$sp(this.imag());
    }

    @Override
    public boolean isImaginary(IsReal<Object> o) {
        return this.isImaginary$mcF$sp(o);
    }

    @Override
    public boolean isImaginary$mcF$sp(IsReal<Object> o) {
        return o.isSignZero$mcF$sp(this.real());
    }

    @Override
    public boolean isReal(IsReal<Object> o) {
        return this.isReal$mcF$sp(o);
    }

    @Override
    public boolean isReal$mcF$sp(IsReal<Object> o) {
        return o.isSignZero$mcF$sp(this.imag());
    }

    @Override
    public boolean eqv(Complex<Object> b, Eq<Object> o) {
        return this.eqv$mcF$sp(b, o);
    }

    @Override
    public boolean eqv$mcF$sp(Complex<Object> b, Eq<Object> o) {
        return o.eqv$mcF$sp(this.real(), b.real$mcF$sp()) && o.eqv$mcF$sp(this.imag(), b.imag$mcF$sp());
    }

    @Override
    public boolean neqv(Complex<Object> b, Eq<Object> o) {
        return this.neqv$mcF$sp(b, o);
    }

    @Override
    public boolean neqv$mcF$sp(Complex<Object> b, Eq<Object> o) {
        return o.neqv$mcF$sp(this.real(), b.real$mcF$sp()) || o.neqv$mcF$sp(this.imag(), b.imag$mcF$sp());
    }

    @Override
    public Complex<Object> unary_$minus(Rng<Object> r) {
        return this.unary_$minus$mcF$sp(r);
    }

    @Override
    public Complex<Object> unary_$minus$mcF$sp(Rng<Object> r) {
        return new Complex$mcF$sp(r.negate$mcF$sp(this.real()), r.negate$mcF$sp(this.imag()));
    }

    @Override
    public Complex<Object> $plus(float rhs, Semiring<Object> r) {
        return this.$plus$mcF$sp(rhs, r);
    }

    @Override
    public Complex<Object> $plus$mcF$sp(float rhs, Semiring<Object> r) {
        return new Complex$mcF$sp(r.plus$mcF$sp(this.real(), rhs), this.imag());
    }

    @Override
    public Complex<Object> $minus(float rhs, Rng<Object> r) {
        return this.$minus$mcF$sp(rhs, r);
    }

    @Override
    public Complex<Object> $minus$mcF$sp(float rhs, Rng<Object> r) {
        return new Complex$mcF$sp(r.minus$mcF$sp(this.real(), rhs), this.imag());
    }

    @Override
    public Complex<Object> $times(float rhs, Semiring<Object> r) {
        return this.$times$mcF$sp(rhs, r);
    }

    @Override
    public Complex<Object> $times$mcF$sp(float rhs, Semiring<Object> r) {
        return new Complex$mcF$sp(r.times$mcF$sp(this.real(), rhs), r.times$mcF$sp(this.imag(), rhs));
    }

    @Override
    public Complex<Object> $div(float rhs, Field<Object> r) {
        return this.$div$mcF$sp(rhs, r);
    }

    @Override
    public Complex<Object> $div$mcF$sp(float rhs, Field<Object> r) {
        return new Complex$mcF$sp(r.div$mcF$sp(this.real(), rhs), r.div$mcF$sp(this.imag(), rhs));
    }

    @Override
    public Complex<Object> $div$tilde(float rhs, Field<Object> f2, IsReal<Object> o) {
        return this.$div$tilde$mcF$sp(rhs, f2, o);
    }

    @Override
    public Complex<Object> $div$tilde$mcF$sp(float rhs, Field<Object> f2, IsReal<Object> o) {
        return this.$div$mcF$sp(rhs, f2).floor$mcF$sp(o);
    }

    @Override
    public Complex<Object> $percent(float rhs, Field<Object> f2, IsReal<Object> o) {
        return this.$percent$mcF$sp(rhs, f2, o);
    }

    @Override
    public Complex<Object> $percent$mcF$sp(float rhs, Field<Object> f2, IsReal<Object> o) {
        return this.$minus$mcF$sp(this.$div$tilde$mcF$sp(rhs, f2, o).$times$mcF$sp(rhs, f2), f2);
    }

    @Override
    public Tuple2<Complex<Object>, Complex<Object>> $div$percent(float rhs, Field<Object> f2, IsReal<Object> o) {
        return this.$div$percent$mcF$sp(rhs, f2, o);
    }

    @Override
    public Tuple2<Complex<Object>, Complex<Object>> $div$percent$mcF$sp(float rhs, Field<Object> f2, IsReal<Object> o) {
        Complex<Object> q = this.$div$tilde$mcF$sp(rhs, f2, o);
        return new Tuple2<Complex<Object>, Complex<Object>>(q, this.$minus$mcF$sp(q.$times$mcF$sp(rhs, f2), f2));
    }

    @Override
    public Complex<Object> $times$times(float e, Field<Object> f2, NRoot<Object> n, Trig<Object> t, IsReal<Object> o) {
        return this.$times$times$mcF$sp(e, f2, n, t, o);
    }

    @Override
    public Complex<Object> $times$times$mcF$sp(float e, Field<Object> f2, NRoot<Object> n, Trig<Object> t, IsReal<Object> o) {
        return this.pow$mcF$sp(e, f2, n, t, o);
    }

    @Override
    public Complex<Object> pow(float e, Field<Object> f2, NRoot<Object> n, Trig<Object> t, IsReal<Object> o) {
        return this.pow$mcF$sp(e, f2, n, t, o);
    }

    @Override
    public Complex<Object> pow$mcF$sp(float e, Field<Object> f2, NRoot<Object> n, Trig<Object> t, IsReal<Object> o) {
        Complex<Object> complex2;
        if (o.isSignZero$mcF$sp(e)) {
            complex2 = Complex$.MODULE$.one$mFc$sp(f2);
        } else if (this.isZero$mcF$sp(o)) {
            if (o.lt$mcF$sp(e, f2.zero$mcF$sp())) {
                throw new Exception("raising 0 to negative/complex power");
            }
            complex2 = Complex$.MODULE$.zero$mFc$sp(f2);
        } else {
            complex2 = Complex$.MODULE$.polar$mFc$sp(n.fpow$mcF$sp(this.abs$mcF$sp(f2, o, n), e), f2.times$mcF$sp(this.arg$mcF$sp(f2, t, o), e), f2, t);
        }
        return complex2;
    }

    @Override
    public Complex<Object> $plus(Complex<Object> b, Semiring<Object> r) {
        return this.$plus$mcF$sp(b, r);
    }

    @Override
    public Complex<Object> $plus$mcF$sp(Complex<Object> b, Semiring<Object> r) {
        return new Complex$mcF$sp(r.plus$mcF$sp(this.real(), b.real$mcF$sp()), r.plus$mcF$sp(this.imag(), b.imag$mcF$sp()));
    }

    @Override
    public Complex<Object> $minus(Complex<Object> b, Rng<Object> r) {
        return this.$minus$mcF$sp(b, r);
    }

    @Override
    public Complex<Object> $minus$mcF$sp(Complex<Object> b, Rng<Object> r) {
        return new Complex$mcF$sp(r.minus$mcF$sp(this.real(), b.real$mcF$sp()), r.minus$mcF$sp(this.imag(), b.imag$mcF$sp()));
    }

    @Override
    public Complex<Object> $times(Complex<Object> b, Rng<Object> r) {
        return this.$times$mcF$sp(b, r);
    }

    @Override
    public Complex<Object> $times$mcF$sp(Complex<Object> b, Rng<Object> r) {
        return new Complex$mcF$sp(r.minus$mcF$sp(r.times$mcF$sp(this.real(), b.real$mcF$sp()), r.times$mcF$sp(this.imag(), b.imag$mcF$sp())), r.plus$mcF$sp(r.times$mcF$sp(this.imag(), b.real$mcF$sp()), r.times$mcF$sp(this.real(), b.imag$mcF$sp())));
    }

    @Override
    public Complex<Object> $div(Complex<Object> b, Field<Object> f2, IsReal<Object> o) {
        return this.$div$mcF$sp(b, f2, o);
    }

    @Override
    public Complex<Object> $div$mcF$sp(Complex<Object> b, Field<Object> f2, IsReal<Object> o) {
        Complex$mcF$sp complex$mcF$sp;
        float abs_bimag;
        float abs_breal = o.abs$mcF$sp(b.real$mcF$sp());
        if (o.gteqv$mcF$sp(abs_breal, abs_bimag = o.abs$mcF$sp(b.imag$mcF$sp()))) {
            if (o.eqv$mcF$sp(abs_breal, f2.zero$mcF$sp())) {
                throw new Exception("/ by zero");
            }
            float ratio = f2.div$mcF$sp(b.imag$mcF$sp(), b.real$mcF$sp());
            float denom = f2.plus$mcF$sp(b.real$mcF$sp(), f2.times$mcF$sp(b.imag$mcF$sp(), ratio));
            complex$mcF$sp = new Complex$mcF$sp(f2.div$mcF$sp(f2.plus$mcF$sp(this.real(), f2.times$mcF$sp(this.imag(), ratio)), denom), f2.div$mcF$sp(f2.minus$mcF$sp(this.imag(), f2.times$mcF$sp(this.real(), ratio)), denom));
        } else {
            if (o.eqv$mcF$sp(abs_bimag, f2.zero$mcF$sp())) {
                throw new Exception("/ by zero");
            }
            float ratio = f2.div$mcF$sp(b.real$mcF$sp(), b.imag$mcF$sp());
            float denom = f2.plus$mcF$sp(f2.times$mcF$sp(b.real$mcF$sp(), ratio), b.imag$mcF$sp());
            complex$mcF$sp = new Complex$mcF$sp(f2.div$mcF$sp(f2.plus$mcF$sp(f2.times$mcF$sp(this.real(), ratio), this.imag()), denom), f2.div$mcF$sp(f2.minus$mcF$sp(f2.times$mcF$sp(this.imag(), ratio), this.real()), denom));
        }
        return complex$mcF$sp;
    }

    @Override
    public Complex<Object> $div$tilde(Complex<Object> b, Field<Object> f2, IsReal<Object> o) {
        return this.$div$tilde$mcF$sp(b, f2, o);
    }

    @Override
    public Complex<Object> $div$tilde$mcF$sp(Complex<Object> b, Field<Object> f2, IsReal<Object> o) {
        Complex<Object> d = this.$div$mcF$sp(b, f2, o);
        return new Complex$mcF$sp(o.floor$mcF$sp(d.real$mcF$sp()), o.floor$mcF$sp(d.imag$mcF$sp()));
    }

    @Override
    public Complex<Object> $percent(Complex<Object> b, Field<Object> f2, IsReal<Object> o) {
        return this.$percent$mcF$sp(b, f2, o);
    }

    @Override
    public Complex<Object> $percent$mcF$sp(Complex<Object> b, Field<Object> f2, IsReal<Object> o) {
        return this.$minus$mcF$sp(this.$div$tilde$mcF$sp(b, f2, o).$times$mcF$sp(b, f2), f2);
    }

    @Override
    public Tuple2<Complex<Object>, Complex<Object>> $div$percent(Complex<Object> b, Field<Object> f2, IsReal<Object> o) {
        return this.$div$percent$mcF$sp(b, f2, o);
    }

    @Override
    public Tuple2<Complex<Object>, Complex<Object>> $div$percent$mcF$sp(Complex<Object> b, Field<Object> f2, IsReal<Object> o) {
        Complex<Object> q = this.$div$tilde$mcF$sp(b, f2, o);
        return new Tuple2<Complex<Object>, Complex<Object>>(q, this.$minus$mcF$sp(q.$times$mcF$sp(b, f2), f2));
    }

    @Override
    public Complex<Object> $times$times(int b, Field<Object> f2, NRoot<Object> n, Trig<Object> t, IsReal<Object> o) {
        return this.$times$times$mcF$sp(b, f2, n, t, o);
    }

    @Override
    public Complex<Object> $times$times$mcF$sp(int b, Field<Object> f2, NRoot<Object> n, Trig<Object> t, IsReal<Object> o) {
        return this.pow$mcF$sp(b, f2, n, t, o);
    }

    @Override
    public Complex<Object> nroot(int k, Field<Object> f2, NRoot<Object> n, Trig<Object> t, IsReal<Object> o) {
        return this.nroot$mcF$sp(k, f2, n, t, o);
    }

    @Override
    public Complex<Object> nroot$mcF$sp(int k, Field<Object> f2, NRoot<Object> n, Trig<Object> t, IsReal<Object> o) {
        return this.isZero$mcF$sp(o) ? Complex$.MODULE$.zero$mFc$sp(f2) : this.pow$mcF$sp(new Complex$mcF$sp(f2.reciprocal$mcF$sp(f2.fromInt$mcF$sp(k)), f2.zero$mcF$sp()), f2, n, t, o);
    }

    @Override
    public Complex<Object> pow(int b, Field<Object> f2, NRoot<Object> n, Trig<Object> t, IsReal<Object> o) {
        return this.pow$mcF$sp(b, f2, n, t, o);
    }

    @Override
    public Complex<Object> pow$mcF$sp(int b, Field<Object> f2, NRoot<Object> n, Trig<Object> t, IsReal<Object> o) {
        return this.isZero$mcF$sp(o) ? Complex$.MODULE$.zero$mFc$sp(f2) : Complex$.MODULE$.polar$mFc$sp(f2.pow$mcF$sp(this.abs$mcF$sp(f2, o, n), b), f2.times$mcF$sp(this.arg$mcF$sp(f2, t, o), f2.fromInt$mcF$sp(b)), f2, t);
    }

    @Override
    public Complex<Object> $times$times(Complex<Object> b, Field<Object> f2, NRoot<Object> n, Trig<Object> t, IsReal<Object> o) {
        return this.$times$times$mcF$sp(b, f2, n, t, o);
    }

    @Override
    public Complex<Object> $times$times$mcF$sp(Complex<Object> b, Field<Object> f2, NRoot<Object> n, Trig<Object> t, IsReal<Object> o) {
        return this.pow$mcF$sp(b, f2, n, t, o);
    }

    @Override
    public Complex<Object> pow(Complex<Object> b, Field<Object> f2, NRoot<Object> n, Trig<Object> t, IsReal<Object> o) {
        return this.pow$mcF$sp(b, f2, n, t, o);
    }

    @Override
    public Complex<Object> pow$mcF$sp(Complex<Object> b, Field<Object> f2, NRoot<Object> n, Trig<Object> t, IsReal<Object> o) {
        Complex<Object> complex2;
        if (b.isZero$mcF$sp(o)) {
            complex2 = Complex$.MODULE$.one$mFc$sp(f2);
        } else if (this.isZero$mcF$sp(o)) {
            if (o.neqv$mcF$sp(b.imag$mcF$sp(), f2.zero$mcF$sp()) || o.lt$mcF$sp(b.real$mcF$sp(), f2.zero$mcF$sp())) {
                throw new Exception("raising 0 to negative/complex power");
            }
            complex2 = Complex$.MODULE$.zero$mFc$sp(f2);
        } else if (o.neqv$mcF$sp(b.imag$mcF$sp(), f2.zero$mcF$sp())) {
            float len = f2.div$mcF$sp(n.fpow$mcF$sp(this.abs$mcF$sp(f2, o, n), b.real$mcF$sp()), t.exp$mcF$sp(f2.times$mcF$sp(this.arg$mcF$sp(f2, t, o), b.imag$mcF$sp())));
            float phase = f2.plus$mcF$sp(f2.times$mcF$sp(this.arg$mcF$sp(f2, t, o), b.real$mcF$sp()), f2.times$mcF$sp(t.log$mcF$sp(this.abs$mcF$sp(f2, o, n)), b.imag$mcF$sp()));
            complex2 = Complex$.MODULE$.polar$mFc$sp(len, phase, f2, t);
        } else {
            complex2 = Complex$.MODULE$.polar$mFc$sp(n.fpow$mcF$sp(this.abs$mcF$sp(f2, o, n), b.real$mcF$sp()), f2.times$mcF$sp(this.arg$mcF$sp(f2, t, o), b.real$mcF$sp()), f2, t);
        }
        return complex2;
    }

    @Override
    public Complex<Object> log(Field<Object> f2, NRoot<Object> n, Trig<Object> t, IsReal<Object> o) {
        return this.log$mcF$sp(f2, n, t, o);
    }

    @Override
    public Complex<Object> log$mcF$sp(Field<Object> f2, NRoot<Object> n, Trig<Object> t, IsReal<Object> o) {
        if (this.isZero$mcF$sp(o)) {
            throw new IllegalArgumentException("log(0) undefined");
        }
        return new Complex$mcF$sp(t.log$mcF$sp(this.abs$mcF$sp(f2, o, n)), this.arg$mcF$sp(f2, t, o));
    }

    @Override
    public Complex<Object> sqrt(Field<Object> f2, NRoot<Object> n0, IsReal<Object> o) {
        return this.sqrt$mcF$sp(f2, n0, o);
    }

    @Override
    public Complex<Object> sqrt$mcF$sp(Field<Object> f2, NRoot<Object> n0, IsReal<Object> o) {
        Complex$mcF$sp complex$mcF$sp;
        if (this.isZero$mcF$sp(o)) {
            complex$mcF$sp = Complex$.MODULE$.zero$mFc$sp(f2);
        } else {
            float two = f2.fromInt$mcF$sp(2);
            float a = n0.sqrt$mcF$sp(f2.div$mcF$sp(f2.plus$mcF$sp(this.abs$mcF$sp(f2, o, n0), o.abs$mcF$sp(this.real())), two));
            int n = o.signum$mcF$sp(this.imag());
            switch (n) {
                default: {
                    float b = n0.sqrt$mcF$sp(f2.div$mcF$sp(f2.minus$mcF$sp(this.abs$mcF$sp(f2, o, n0), o.abs$mcF$sp(this.real())), two));
                    if (n < 0) {
                        complex$mcF$sp = new Complex$mcF$sp(a, f2.negate$mcF$sp(b));
                        break;
                    }
                    complex$mcF$sp = new Complex$mcF$sp(a, b);
                    break;
                }
                case 0: {
                    complex$mcF$sp = o.lt$mcF$sp(this.real(), f2.zero$mcF$sp()) ? new Complex$mcF$sp(f2.zero$mcF$sp(), a) : new Complex$mcF$sp(a, f2.zero$mcF$sp());
                }
            }
        }
        return complex$mcF$sp;
    }

    @Override
    public Complex<Object> floor(IsReal<Object> o) {
        return this.floor$mcF$sp(o);
    }

    @Override
    public Complex<Object> floor$mcF$sp(IsReal<Object> o) {
        return new Complex$mcF$sp(o.floor$mcF$sp(this.real()), o.floor$mcF$sp(this.imag()));
    }

    @Override
    public Complex<Object> ceil(IsReal<Object> o) {
        return this.ceil$mcF$sp(o);
    }

    @Override
    public Complex<Object> ceil$mcF$sp(IsReal<Object> o) {
        return new Complex$mcF$sp(o.ceil$mcF$sp(this.real()), o.ceil$mcF$sp(this.imag()));
    }

    @Override
    public Complex<Object> round(IsReal<Object> o) {
        return this.round$mcF$sp(o);
    }

    @Override
    public Complex<Object> round$mcF$sp(IsReal<Object> o) {
        return new Complex$mcF$sp(o.round$mcF$sp(this.real()), o.round$mcF$sp(this.imag()));
    }

    @Override
    public Complex<Object> acos(Field<Object> f2, NRoot<Object> n, Trig<Object> t, IsReal<Object> o) {
        return this.acos$mcF$sp(f2, n, t, o);
    }

    @Override
    public Complex<Object> acos$mcF$sp(Field<Object> f2, NRoot<Object> n, Trig<Object> t, IsReal<Object> o) {
        Complex<Object> z2 = this.$times$mcF$sp(this, f2);
        Complex<Object> s2 = new Complex$mcF$sp(f2.minus$mcF$sp(f2.one$mcF$sp(), z2.real$mcF$sp()), f2.negate$mcF$sp(z2.imag$mcF$sp())).sqrt$mcF$sp(f2, n, o);
        Complex<Object> l = new Complex$mcF$sp(f2.plus$mcF$sp(this.real(), s2.imag$mcF$sp()), f2.plus$mcF$sp(this.imag(), s2.real$mcF$sp())).log$mcF$sp(f2, n, t, o);
        return new Complex$mcF$sp(l.imag$mcF$sp(), f2.negate$mcF$sp(l.real$mcF$sp()));
    }

    @Override
    public Complex<Object> asin(Field<Object> f2, NRoot<Object> n, Trig<Object> t, IsReal<Object> o) {
        return this.asin$mcF$sp(f2, n, t, o);
    }

    @Override
    public Complex<Object> asin$mcF$sp(Field<Object> f2, NRoot<Object> n, Trig<Object> t, IsReal<Object> o) {
        Complex<Object> z2 = this.$times$mcF$sp(this, f2);
        Complex<Object> s2 = new Complex$mcF$sp(f2.minus$mcF$sp(f2.one$mcF$sp(), z2.real$mcF$sp()), f2.negate$mcF$sp(z2.imag$mcF$sp())).sqrt$mcF$sp(f2, n, o);
        Complex<Object> l = new Complex$mcF$sp(f2.plus$mcF$sp(s2.real$mcF$sp(), f2.negate$mcF$sp(this.imag())), f2.plus$mcF$sp(s2.imag$mcF$sp(), this.real())).log$mcF$sp(f2, n, t, o);
        return new Complex$mcF$sp(l.imag$mcF$sp(), f2.negate$mcF$sp(l.real$mcF$sp()));
    }

    @Override
    public Complex<Object> atan(Field<Object> f2, NRoot<Object> r, Trig<Object> t, IsReal<Object> o) {
        return this.atan$mcF$sp(f2, r, t, o);
    }

    @Override
    public Complex<Object> atan$mcF$sp(Field<Object> f2, NRoot<Object> r, Trig<Object> t, IsReal<Object> o) {
        Complex$mcF$sp n = new Complex$mcF$sp(this.real(), f2.plus$mcF$sp(this.imag(), f2.one$mcF$sp()));
        Complex$mcF$sp d = new Complex$mcF$sp(f2.negate$mcF$sp(this.real()), f2.minus$mcF$sp(f2.one$mcF$sp(), this.imag()));
        Complex<Object> l = ((Complex)n).$div$mcF$sp(d, f2, o).log$mcF$sp(f2, r, t, o);
        return new Complex$mcF$sp(f2.div$mcF$sp(l.imag$mcF$sp(), f2.fromInt$mcF$sp(-2)), f2.div$mcF$sp(l.real$mcF$sp(), f2.fromInt$mcF$sp(2)));
    }

    @Override
    public Complex<Object> exp(Field<Object> f2, Trig<Object> t) {
        return this.exp$mcF$sp(f2, t);
    }

    @Override
    public Complex<Object> exp$mcF$sp(Field<Object> f2, Trig<Object> t) {
        return new Complex$mcF$sp(f2.times$mcF$sp(t.exp$mcF$sp(this.real()), t.cos$mcF$sp(this.imag())), f2.times$mcF$sp(t.exp$mcF$sp(this.real()), t.sin$mcF$sp(this.imag())));
    }

    @Override
    public Complex<Object> sin(Field<Object> f2, Trig<Object> t) {
        return this.sin$mcF$sp(f2, t);
    }

    @Override
    public Complex<Object> sin$mcF$sp(Field<Object> f2, Trig<Object> t) {
        return new Complex$mcF$sp(f2.times$mcF$sp(t.sin$mcF$sp(this.real()), t.cosh$mcF$sp(this.imag())), f2.times$mcF$sp(t.cos$mcF$sp(this.real()), t.sinh$mcF$sp(this.imag())));
    }

    @Override
    public Complex<Object> sinh(Field<Object> f2, Trig<Object> t) {
        return this.sinh$mcF$sp(f2, t);
    }

    @Override
    public Complex<Object> sinh$mcF$sp(Field<Object> f2, Trig<Object> t) {
        return new Complex$mcF$sp(f2.times$mcF$sp(t.sinh$mcF$sp(this.real()), t.cos$mcF$sp(this.imag())), f2.times$mcF$sp(t.cosh$mcF$sp(this.real()), t.sin$mcF$sp(this.imag())));
    }

    @Override
    public Complex<Object> cos(Field<Object> f2, Trig<Object> t) {
        return this.cos$mcF$sp(f2, t);
    }

    @Override
    public Complex<Object> cos$mcF$sp(Field<Object> f2, Trig<Object> t) {
        return new Complex$mcF$sp(f2.times$mcF$sp(t.cos$mcF$sp(this.real()), t.cosh$mcF$sp(this.imag())), f2.times$mcF$sp(f2.negate$mcF$sp(t.sin$mcF$sp(this.real())), t.sinh$mcF$sp(this.imag())));
    }

    @Override
    public Complex<Object> cosh(Field<Object> f2, Trig<Object> t) {
        return this.cosh$mcF$sp(f2, t);
    }

    @Override
    public Complex<Object> cosh$mcF$sp(Field<Object> f2, Trig<Object> t) {
        return new Complex$mcF$sp(f2.times$mcF$sp(t.cosh$mcF$sp(this.real()), t.cos$mcF$sp(this.imag())), f2.times$mcF$sp(t.sinh$mcF$sp(this.real()), t.sin$mcF$sp(this.imag())));
    }

    @Override
    public Complex<Object> tan(Field<Object> f2, Trig<Object> t) {
        return this.tan$mcF$sp(f2, t);
    }

    @Override
    public Complex<Object> tan$mcF$sp(Field<Object> f2, Trig<Object> t) {
        float r2 = f2.plus$mcF$sp(this.real(), this.real());
        float i2 = f2.plus$mcF$sp(this.imag(), this.imag());
        float d = f2.plus$mcF$sp(t.cos$mcF$sp(r2), t.cosh$mcF$sp(i2));
        return new Complex$mcF$sp(f2.div$mcF$sp(t.sin$mcF$sp(r2), d), f2.div$mcF$sp(t.sinh$mcF$sp(i2), d));
    }

    @Override
    public Complex<Object> tanh(Field<Object> f2, Trig<Object> t) {
        return this.tanh$mcF$sp(f2, t);
    }

    @Override
    public Complex<Object> tanh$mcF$sp(Field<Object> f2, Trig<Object> t) {
        float r2 = f2.plus$mcF$sp(this.real(), this.real());
        float i2 = f2.plus$mcF$sp(this.imag(), this.imag());
        float d = f2.plus$mcF$sp(t.cos$mcF$sp(r2), t.cosh$mcF$sp(i2));
        return new Complex$mcF$sp(f2.div$mcF$sp(t.sinh$mcF$sp(r2), d), f2.div$mcF$sp(t.sin$mcF$sp(i2), d));
    }

    @Override
    public Quaternion<Object> toQuaternion(AdditiveMonoid<Object> ev) {
        return this.toQuaternion$mcF$sp(ev);
    }

    @Override
    public Quaternion<Object> toQuaternion$mcF$sp(AdditiveMonoid<Object> ev) {
        return new Quaternion$mcF$sp(this.real(), this.imag(), ev.zero$mcF$sp(), ev.zero$mcF$sp());
    }

    @Override
    public <T> float copy$default$1() {
        return this.copy$default$1$mcF$sp();
    }

    @Override
    public <T> float copy$default$1$mcF$sp() {
        return this.real();
    }

    @Override
    public <T> float copy$default$2() {
        return this.copy$default$2$mcF$sp();
    }

    @Override
    public <T> float copy$default$2$mcF$sp() {
        return this.imag();
    }

    @Override
    public boolean specInstance$() {
        return true;
    }

    public Complex$mcF$sp(float real$mcF$sp, float imag$mcF$sp) {
        this.real$mcF$sp = real$mcF$sp;
        this.imag$mcF$sp = imag$mcF$sp;
        super(null, null);
    }
}

