/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.flatfile.schema.test;

import com.mulesoft.flatfile.schema.SchemaJavaValues;
import com.mulesoft.flatfile.schema.model.EdiForm;
import com.mulesoft.flatfile.schema.model.EdiSchema;
import com.mulesoft.flatfile.schema.tools.Decode997;
import com.mulesoft.flatfile.schema.tools.Decode999;
import com.mulesoft.flatfile.schema.tools.DocumentTest;
import com.mulesoft.flatfile.schema.tools.DocumentTest$;
import com.mulesoft.flatfile.schema.tools.DocumentTestX12;
import com.mulesoft.flatfile.schema.tools.YamlSupport;
import com.mulesoft.flatfile.schema.x12.X12SchemaDefs;
import java.io.ByteArrayInputStream;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TestX12Document {
    private static final String CHARSET = "ISO8859-1";

    private static void printAcknowledgments(Map<String, Object> result2, boolean ack999, EdiForm form) {
        List acks = (List)result2.get(SchemaJavaValues.functionalAcksGenerated());
        if (acks != null) {
            for (Map ack : acks) {
                if (ack999) {
                    System.out.println(Decode999.decode(ack, form));
                    continue;
                }
                System.out.println(Decode997.decode(ack, form));
            }
        }
    }

    private static void checkWrite(DocumentTest test, String text, Map<String, Object> result2) {
        String input = DocumentTest$.MODULE$.stripLineBreaks(text);
        String output = DocumentTest$.MODULE$.stripLineBreaks(test.printDoc(result2));
        System.out.println("\nOutput comparison:");
        if (output.length() != input.length()) {
            System.out.println("Different lengths (" + output.length() + " vs " + input.length() + ")");
        }
        int length = Math.min(input.length(), output.length());
        int index = -1;
        while (++index < length && input.charAt(index) == output.charAt(index)) {
        }
        if (index < length) {
            System.out.println("Different text starting at " + index);
            int base = Math.max(index - 40, 0);
            int limit = Math.min(index + 40, length);
            System.out.println("output '" + output.substring(base, limit) + "'");
            System.out.println("input  '" + input.substring(base, limit) + "'");
        }
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            throw new IllegalArgumentException("Missing required argument(s): schema-path file-path [997/999] [all/error] [print/noprint]");
        }
        if (args.length > 4) {
            throw new IllegalArgumentException("Too many argument(s): schema-path file-path [997/999] [all/error] [print/noprint]");
        }
        boolean ack999 = args.length > 2 && "999".equals(args[2]);
        boolean allSets = args.length > 3 && "all".equals(args[3]);
        boolean print = args.length > 4 && "print".equals(args[4]);
        EdiSchema schema = DocumentTest$.MODULE$.loadSchema(args[0]);
        DocumentTestX12 test = new DocumentTestX12(schema, allSets, ack999);
        try {
            String input = DocumentTest$.MODULE$.readAsString(args[1]);
            ByteArrayInputStream is = new ByteArrayInputStream(input.getBytes(CHARSET));
            Map<String, Object> result2 = test.parse(is);
            System.out.println("\nInterchange acknowledgement(s):");
            System.out.println(test.printInterchangeAcks("*>U\n", (List)result2.get(SchemaJavaValues.interchangeAcksGenerated())));
            System.out.println("Functional acknowledgement(s):");
            TestX12Document.printAcknowledgments(result2, ack999, schema.ediVersion().ediForm());
            test.prepareOutput(result2);
            if (!result2.containsKey(SchemaJavaValues.delimiterCharacters())) {
                result2.put(SchemaJavaValues.delimiterCharacters(), "*>U~");
            }
            HashMap<String, Object> copy = new HashMap<String, Object>(result2);
            String delims = (String)copy.get(SchemaJavaValues.delimiterCharacters());
            delims = delims.substring(0, 3) + "\n" + delims.substring(4);
            copy.put(SchemaJavaValues.delimiterCharacters(), delims);
            System.out.println("Acknowledgment message(s):");
            System.out.println(test.printAck(copy));
            boolean hasdata = false;
            Map versions = (Map)result2.get(X12SchemaDefs.transactionsMap());
            if (versions != null && versions.size() > 0) {
                Iterator iter = versions.values().iterator();
                Map version = (Map)iter.next();
                boolean bl = hasdata = !version.isEmpty();
            }
            if (hasdata) {
                if (print) {
                    StringWriter writer = new StringWriter();
                    YamlSupport.writeMap(result2, writer);
                    String output = writer.toString();
                    System.out.println("Message data:");
                    System.out.println(output);
                }
                TestX12Document.checkWrite(test, input, result2);
            } else {
                System.out.println("Message data not present in result");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

