/*
 * Decompiled with CFR 0.152.
 */
package org.mule.flatfile.metadata.schema;

import com.mulesoft.flatfile.schema.model.GroupComponent;
import com.mulesoft.flatfile.schema.model.ReferenceComponent;
import com.mulesoft.flatfile.schema.model.Structure;
import com.mulesoft.flatfile.schema.model.StructureComponent;
import com.mulesoft.flatfile.schema.model.StructureSequence;
import java.util.List;
import java.util.Map;
import org.mule.flatfile.metadata.schema.FieldAnnotationFactory;
import org.mule.flatfile.metadata.schema.SchemaUtils;
import org.mule.flatfile.metadata.schema.SegmentHandler;
import org.mule.flatfile.metadata.schema.TypeConverterFactory;
import org.mule.metadata.api.annotation.LabelAnnotation;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.builder.ObjectFieldTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import scala.collection.JavaConverters;
import scala.collection.Seq;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StructureHandler {
    private final Structure structure;
    private final Map<String, FieldAnnotationFactory> fieldAnnotators;
    private final Map<String, MetadataType> typeConverter;

    public StructureHandler(Structure struct, MetadataFormat format, Map<String, FieldAnnotationFactory> annoFacts) {
        this.structure = struct;
        this.fieldAnnotators = annoFacts;
        this.typeConverter = TypeConverterFactory.buildTypeConverter(format);
    }

    public void buildStructure(ObjectTypeBuilder typeBuilder) {
        List comps = JavaConverters.seqAsJavaList((Seq)((StructureSequence)this.structure.heading().get()).items());
        new StructureComponentsFieldFactory(comps).execute(typeBuilder);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StructureComponentsFieldFactory {
        private final List<StructureComponent> components;

        public StructureComponentsFieldFactory(List<StructureComponent> comps) {
            this.components = comps;
        }

        private LabelAnnotation buildLabelAnnotation(String key, String name) {
            if (name != null && name.length() > 0) {
                return new LabelAnnotation(key + " - " + name);
            }
            return new LabelAnnotation(key);
        }

        public void execute(ObjectTypeBuilder object) {
            for (StructureComponent comp : this.components) {
                LabelAnnotation labelAnnotation;
                if (!SchemaUtils.includeForUsage(comp.usage())) continue;
                ObjectFieldTypeBuilder fieldBuilder = object.addField();
                fieldBuilder.key(comp.key());
                ObjectTypeBuilder objectBuilder = fieldBuilder.value().objectType();
                if (comp instanceof ReferenceComponent) {
                    ReferenceComponent refc = (ReferenceComponent)comp;
                    SegmentHandler seghand = new SegmentHandler(refc.segment(), StructureHandler.this.typeConverter, (Map<String, FieldAnnotationFactory>)StructureHandler.this.fieldAnnotators);
                    seghand.buildSegment(objectBuilder);
                    labelAnnotation = this.buildLabelAnnotation(refc.key(), refc.segment().name());
                } else if (comp instanceof GroupComponent) {
                    GroupComponent grpc = (GroupComponent)comp;
                    List comps = JavaConverters.seqAsJavaList((Seq)grpc.seq().items());
                    new StructureComponentsFieldFactory(comps).execute(objectBuilder);
                    labelAnnotation = this.buildLabelAnnotation(grpc.key(), grpc.ident());
                } else {
                    throw new IllegalStateException("Unexpected type for flat file schema: " + comp.getClass().getName());
                }
                if (comp.count() == 1) {
                    fieldBuilder.value((TypeBuilder)objectBuilder);
                } else {
                    fieldBuilder.value().arrayType().of((TypeBuilder)objectBuilder);
                }
                if (labelAnnotation == null) continue;
                fieldBuilder.withKeyAnnotation((TypeAnnotation)labelAnnotation);
            }
        }
    }
}

