/*
 * Decompiled with CFR 0.152.
 */
package org.mule.flatfile.metadata.schema;

import com.mulesoft.flatfile.schema.fftypes.BinaryFormat;
import com.mulesoft.flatfile.schema.fftypes.BooleanFormat;
import com.mulesoft.flatfile.schema.fftypes.DecimalFormat;
import com.mulesoft.flatfile.schema.fftypes.IntegerFormat;
import com.mulesoft.flatfile.schema.fftypes.LocalDateFormat;
import com.mulesoft.flatfile.schema.fftypes.LocalDateTimeFormat;
import com.mulesoft.flatfile.schema.fftypes.LocalTimeFormat;
import com.mulesoft.flatfile.schema.fftypes.PackedDecimalFormat;
import com.mulesoft.flatfile.schema.fftypes.StringFormat;
import com.mulesoft.flatfile.schema.fftypes.ZonedFormat;
import java.util.HashMap;
import java.util.Map;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TypeConverterFactory {
    private TypeConverterFactory() {
    }

    public static Map<String, MetadataType> buildTypeConverter(MetadataFormat format) {
        HashMap<String, MetadataType> typeConvert = new HashMap<String, MetadataType>();
        BaseTypeBuilder typeBuilder = new BaseTypeBuilder(format);
        typeConvert.put(BinaryFormat.code(), (MetadataType)typeBuilder.numberType().integer().build());
        typeConvert.put(BooleanFormat.code(), (MetadataType)typeBuilder.booleanType().build());
        typeConvert.put(LocalDateFormat.code(), (MetadataType)typeBuilder.dateType().build());
        typeConvert.put(LocalDateTimeFormat.code(), (MetadataType)typeBuilder.dateTimeType().build());
        typeConvert.put(IntegerFormat.code(), (MetadataType)typeBuilder.numberType().integer().build());
        typeConvert.put(DecimalFormat.code(), (MetadataType)typeBuilder.numberType().id("double").build());
        typeConvert.put(PackedDecimalFormat.code(), (MetadataType)typeBuilder.numberType().id("double").build());
        typeConvert.put(StringFormat.code(), (MetadataType)typeBuilder.stringType().build());
        typeConvert.put(LocalTimeFormat.code(), (MetadataType)typeBuilder.dateTimeType().build());
        typeConvert.put(ZonedFormat.code(), (MetadataType)typeBuilder.numberType().id("double").build());
        return typeConvert;
    }
}

