/*
 * Decompiled with CFR 0.152.
 */
package org.mule.flatfile.metadata.schema;

import com.mulesoft.flatfile.lexical.TypeFormatConstants;
import com.mulesoft.flatfile.schema.model.GroupComponent;
import com.mulesoft.flatfile.schema.model.LoopWrapperComponent;
import com.mulesoft.flatfile.schema.model.ReferenceComponent;
import com.mulesoft.flatfile.schema.model.Segment;
import com.mulesoft.flatfile.schema.model.Structure;
import com.mulesoft.flatfile.schema.model.StructureComponent;
import com.mulesoft.flatfile.schema.model.StructureSequence;
import com.mulesoft.flatfile.schema.model.Usage;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mule.flatfile.metadata.schema.FieldAnnotationFactory;
import org.mule.flatfile.metadata.schema.SchemaUtils;
import org.mule.flatfile.metadata.schema.SegmentHandler;
import org.mule.flatfile.metadata.schema.TypeConverterFactory;
import org.mule.metadata.api.annotation.LabelAnnotation;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.builder.ObjectFieldTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import scala.collection.JavaConverters;
import scala.collection.Seq;

public class StructureHandler {
    private final Map<Segment, MetadataType> segmentTypes = new HashMap<Segment, MetadataType>();
    private final SegmentHandler segmentHandler;

    public StructureHandler(MetadataFormat format, Map<TypeFormatConstants.GenericType, FieldAnnotationFactory> annoFacts) {
        Map<TypeFormatConstants.GenericType, MetadataType> types = TypeConverterFactory.buildTypeConverter(format);
        this.segmentHandler = new SegmentHandler(types, annoFacts);
    }

    public int buildStructure(Structure struct, ObjectTypeBuilder typeBuilder) {
        List comps = JavaConverters.seqAsJavaList((Seq)((StructureSequence)struct.heading().get()).items());
        return new StructureComponentsFieldFactory(comps).execute(typeBuilder);
    }

    public int buildSegment(Segment segment, ObjectFieldTypeBuilder field) {
        int count = 0;
        MetadataType type = this.segmentTypes.get(segment);
        if (type == null) {
            ObjectTypeBuilder builder = field.value().objectType();
            count = this.segmentHandler.buildSegment(segment, builder);
            type = builder.build();
            this.segmentTypes.put(segment, type);
        }
        field.value(type);
        return count;
    }

    private class StructureComponentsFieldFactory {
        private final List<StructureComponent> components;
        private int valueCount;

        public StructureComponentsFieldFactory(List<StructureComponent> comps) {
            this.components = comps;
        }

        private LabelAnnotation buildLabelAnnotation(String key, String name) {
            if (name != null && name.length() > 0) {
                return new LabelAnnotation(key + " - " + name);
            }
            return new LabelAnnotation(key);
        }

        private MetadataType buildGroup(GroupComponent group, ObjectTypeBuilder builder) {
            List comps = JavaConverters.seqAsJavaList((Seq)group.seq().items());
            this.valueCount += new StructureComponentsFieldFactory(comps).execute(builder);
            return builder.build();
        }

        public int execute(ObjectTypeBuilder object) {
            this.valueCount = 0;
            for (StructureComponent comp : this.components) {
                GroupComponent group;
                MetadataType compType;
                LabelAnnotation labelAnnotation;
                if (!SchemaUtils.includeForUsage(comp.usage())) continue;
                ObjectFieldTypeBuilder fieldBuilder = object.addField();
                fieldBuilder.key(comp.key());
                if (comp instanceof ReferenceComponent) {
                    ReferenceComponent refc = (ReferenceComponent)comp;
                    Segment segment = refc.segment();
                    labelAnnotation = this.buildLabelAnnotation(refc.key(), segment.name());
                    compType = (MetadataType)StructureHandler.this.segmentTypes.get(segment);
                    if (compType == null) {
                        ObjectTypeBuilder segBuilder = fieldBuilder.value().objectType();
                        int count = StructureHandler.this.segmentHandler.buildSegment(segment, segBuilder);
                        compType = segBuilder.build();
                        StructureHandler.this.segmentTypes.put(segment, compType);
                        this.valueCount += count;
                    }
                } else if (comp instanceof GroupComponent) {
                    group = (GroupComponent)comp;
                    compType = this.buildGroup(group, fieldBuilder.value().objectType());
                    labelAnnotation = this.buildLabelAnnotation(group.key(), group.ident());
                } else if (comp instanceof LoopWrapperComponent) {
                    group = ((LoopWrapperComponent)comp).wrapped();
                    compType = this.buildGroup(group, fieldBuilder.value().objectType());
                    labelAnnotation = this.buildLabelAnnotation(group.key(), group.ident());
                } else {
                    throw new IllegalStateException("Unexpected type for schema metadata: " + comp.getClass().getName());
                }
                if (comp.count() == 1) {
                    fieldBuilder.value(compType);
                } else {
                    fieldBuilder.value().arrayType().of(compType);
                }
                if (comp.usage() == Usage.MandatoryUsage$.MODULE$) {
                    fieldBuilder.required();
                }
                if (labelAnnotation == null) continue;
                fieldBuilder.withKeyAnnotation((TypeAnnotation)labelAnnotation);
            }
            return this.valueCount;
        }
    }
}

