/*
 * Decompiled with CFR 0.152.
 */
package org.mule.flatfile.metadata.schema;

import com.mulesoft.flatfile.lexical.TypeFormat;
import com.mulesoft.flatfile.lexical.TypeFormatConstants;
import com.mulesoft.flatfile.schema.model.BaseCompositeComponent;
import com.mulesoft.flatfile.schema.model.BaseElementComponent;
import com.mulesoft.flatfile.schema.model.Composite;
import com.mulesoft.flatfile.schema.model.Element;
import com.mulesoft.flatfile.schema.model.Segment;
import com.mulesoft.flatfile.schema.model.SegmentComponent;
import com.mulesoft.flatfile.schema.model.Usage$;
import java.util.List;
import java.util.Map;
import org.mule.flatfile.metadata.schema.FieldAnnotationFactory;
import org.mule.flatfile.metadata.schema.SchemaUtils;
import org.mule.flatfile.metadata.schema.TypeConverterFactory;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.builder.ObjectFieldTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import scala.collection.JavaConverters;
import scala.collection.Seq;

public class SegmentHandler {
    private final Map<TypeFormatConstants.GenericType, MetadataType> typeConvert;
    private final Segment segment;
    private final Map<TypeFormatConstants.GenericType, FieldAnnotationFactory> fieldAnnotators;

    public SegmentHandler(Segment seg, Map<TypeFormatConstants.GenericType, MetadataType> metaTypes, Map<TypeFormatConstants.GenericType, FieldAnnotationFactory> annoFacts) {
        this.segment = seg;
        this.typeConvert = metaTypes;
        this.fieldAnnotators = annoFacts;
    }

    public SegmentHandler(Segment seg, MetadataFormat format, Map<TypeFormatConstants.GenericType, FieldAnnotationFactory> annoFacts) {
        this(seg, TypeConverterFactory.buildTypeConverter(format), annoFacts);
    }

    public void buildSegment(ObjectTypeBuilder typeBuilder) {
        List comps = JavaConverters.seqAsJavaList((Seq)this.segment.components());
        new SegmentComponentsFieldFactory(comps).execute(typeBuilder);
    }

    private class SegmentComponentsFieldFactory {
        private final List<SegmentComponent> components;

        public SegmentComponentsFieldFactory(List<SegmentComponent> comps) {
            this.components = comps;
        }

        public void execute(ObjectTypeBuilder object) {
            this.addComponentFields(object, this.components);
        }

        private void addComponentField(ObjectTypeBuilder object, SegmentComponent comp) {
            Element element = ((BaseElementComponent)comp).element();
            TypeFormat typeFormat = element.typeFormat();
            TypeFormatConstants.GenericType typeCode = typeFormat.genericType();
            MetadataType metadataType = (MetadataType)SegmentHandler.this.typeConvert.get(typeCode);
            ObjectFieldTypeBuilder fieldBuilder = object.addField();
            if (comp.count() == 1) {
                fieldBuilder.key(comp.key());
                fieldBuilder.value(metadataType);
                FieldAnnotationFactory fieldAnnotationFactory = (FieldAnnotationFactory)SegmentHandler.this.fieldAnnotators.get(typeCode);
                if (fieldAnnotationFactory != null) {
                    TypeAnnotation typeAnnotation = fieldAnnotationFactory.create(typeFormat);
                    fieldBuilder.with(typeAnnotation);
                }
            } else {
                fieldBuilder.key(comp.key());
                fieldBuilder.value().arrayType().of(metadataType);
            }
            this.setUsageDetails(comp, fieldBuilder);
        }

        private void addComponentFields(ObjectTypeBuilder object, List<SegmentComponent> comps) {
            for (SegmentComponent comp : comps) {
                if (!SchemaUtils.includeForUsage(comp.usage())) continue;
                if (comp instanceof BaseElementComponent) {
                    this.addComponentField(object, comp);
                    continue;
                }
                if (comp instanceof BaseCompositeComponent) {
                    Composite composite = ((BaseCompositeComponent)comp).composite();
                    List subcomps = JavaConverters.seqAsJavaList((Seq)composite.components());
                    ObjectFieldTypeBuilder fieldBuilder = object.addField();
                    fieldBuilder.key(comp.key());
                    ObjectTypeBuilder objectBuilder = fieldBuilder.value().objectType();
                    new SegmentComponentsFieldFactory(subcomps).execute(objectBuilder);
                    if (comp.count() == 1) {
                        fieldBuilder.value((TypeBuilder)objectBuilder);
                    } else {
                        fieldBuilder.value().arrayType().of((TypeBuilder)objectBuilder);
                    }
                    this.setUsageDetails(comp, fieldBuilder);
                    continue;
                }
                throw new IllegalStateException("Segment component of unknown type");
            }
        }

        private void setUsageDetails(SegmentComponent comp, ObjectFieldTypeBuilder fieldBuilder) {
            fieldBuilder.description(comp.name());
            if (comp.usage() == Usage$.MODULE$.convertUsage("M")) {
                fieldBuilder.required();
            }
        }
    }
}

