/*
 * Decompiled with CFR 0.152.
 */
package org.mule.flatfile.metadata.schema;

import com.mulesoft.flatfile.lexical.TypeFormatConstants;
import com.mulesoft.flatfile.schema.model.GroupComponent;
import com.mulesoft.flatfile.schema.model.LoopWrapperComponent;
import com.mulesoft.flatfile.schema.model.ReferenceComponent;
import com.mulesoft.flatfile.schema.model.Structure;
import com.mulesoft.flatfile.schema.model.StructureComponent;
import com.mulesoft.flatfile.schema.model.StructureSequence;
import com.mulesoft.flatfile.schema.model.Usage$;
import java.util.List;
import java.util.Map;
import org.mule.flatfile.metadata.schema.FieldAnnotationFactory;
import org.mule.flatfile.metadata.schema.SchemaUtils;
import org.mule.flatfile.metadata.schema.SegmentHandler;
import org.mule.flatfile.metadata.schema.TypeConverterFactory;
import org.mule.metadata.api.annotation.LabelAnnotation;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.builder.ObjectFieldTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import scala.collection.JavaConverters;
import scala.collection.Seq;

public class StructureHandler {
    private final Structure structure;
    private final Map<TypeFormatConstants.GenericType, FieldAnnotationFactory> fieldAnnotators;
    private final Map<TypeFormatConstants.GenericType, MetadataType> typeConverter;

    public StructureHandler(Structure struct, MetadataFormat format, Map<TypeFormatConstants.GenericType, FieldAnnotationFactory> annoFacts) {
        this.structure = struct;
        this.fieldAnnotators = annoFacts;
        this.typeConverter = TypeConverterFactory.buildTypeConverter(format);
    }

    public void buildStructure(ObjectTypeBuilder typeBuilder) {
        List comps = JavaConverters.seqAsJavaList((Seq)((StructureSequence)this.structure.heading().get()).items());
        new StructureComponentsFieldFactory(comps).execute(typeBuilder);
    }

    private class StructureComponentsFieldFactory {
        private final List<StructureComponent> components;

        public StructureComponentsFieldFactory(List<StructureComponent> comps) {
            this.components = comps;
        }

        private LabelAnnotation buildLabelAnnotation(String key, String name) {
            if (name != null && name.length() > 0) {
                return new LabelAnnotation(key + " - " + name);
            }
            return new LabelAnnotation(key);
        }

        private LabelAnnotation buildGroup(GroupComponent group, ObjectTypeBuilder builder) {
            List comps = JavaConverters.seqAsJavaList((Seq)group.seq().items());
            new StructureComponentsFieldFactory(comps).execute(builder);
            return this.buildLabelAnnotation(group.key(), group.ident());
        }

        public void execute(ObjectTypeBuilder object) {
            for (StructureComponent comp : this.components) {
                LabelAnnotation labelAnnotation;
                if (!SchemaUtils.includeForUsage(comp.usage())) continue;
                ObjectFieldTypeBuilder fieldBuilder = object.addField();
                fieldBuilder.key(comp.key());
                ObjectTypeBuilder objectBuilder = fieldBuilder.value().objectType();
                if (comp instanceof ReferenceComponent) {
                    ReferenceComponent refc = (ReferenceComponent)comp;
                    SegmentHandler seghand = new SegmentHandler(refc.segment(), StructureHandler.this.typeConverter, (Map<TypeFormatConstants.GenericType, FieldAnnotationFactory>)StructureHandler.this.fieldAnnotators);
                    seghand.buildSegment(objectBuilder);
                    labelAnnotation = this.buildLabelAnnotation(refc.key(), refc.segment().name());
                } else if (comp instanceof GroupComponent) {
                    labelAnnotation = this.buildGroup((GroupComponent)comp, objectBuilder);
                } else if (comp instanceof LoopWrapperComponent) {
                    labelAnnotation = this.buildGroup(((LoopWrapperComponent)comp).wrapped(), objectBuilder);
                } else {
                    throw new IllegalStateException("Unexpected type for schema metadata: " + comp.getClass().getName());
                }
                if (comp.count() == 1) {
                    fieldBuilder.value((TypeBuilder)objectBuilder);
                } else {
                    fieldBuilder.value().arrayType().of((TypeBuilder)objectBuilder);
                }
                if (comp.usage() == Usage$.MODULE$.convertUsage("M")) {
                    fieldBuilder.required();
                }
                if (labelAnnotation == null) continue;
                fieldBuilder.withKeyAnnotation((TypeAnnotation)labelAnnotation);
            }
        }
    }
}

