/*
 * Decompiled with CFR 0.152.
 */
package org.mule.flatfile.metadata.schema;

import com.mulesoft.flatfile.lexical.TypeFormat;
import com.mulesoft.flatfile.lexical.TypeFormatConstants;
import com.mulesoft.flatfile.schema.model.BaseCompositeComponent;
import com.mulesoft.flatfile.schema.model.BaseElementComponent;
import com.mulesoft.flatfile.schema.model.Composite;
import com.mulesoft.flatfile.schema.model.EdiForm;
import com.mulesoft.flatfile.schema.model.Element;
import com.mulesoft.flatfile.schema.model.Segment;
import com.mulesoft.flatfile.schema.model.SegmentComponent;
import com.mulesoft.flatfile.schema.model.Usage;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mule.flatfile.metadata.schema.FieldAnnotationFactory;
import org.mule.flatfile.metadata.schema.SchemaUtils;
import org.mule.flatfile.metadata.schema.TypeConverterFactory;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.builder.ObjectFieldTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import scala.collection.JavaConverters;
import scala.collection.Seq;

public class SegmentHandler {
    private final EdiForm ediForm;
    private final Map<TypeFormatConstants.GenericType, MetadataType> typeConvert;
    private final Map<TypeFormatConstants.GenericType, FieldAnnotationFactory> fieldAnnotators;
    private final Map<Composite, MetadataType> compositeTypes;

    public SegmentHandler(EdiForm form, Map<TypeFormatConstants.GenericType, MetadataType> metaTypes, Map<TypeFormatConstants.GenericType, FieldAnnotationFactory> annoFacts) {
        this.ediForm = form;
        this.typeConvert = metaTypes;
        this.fieldAnnotators = annoFacts;
        this.compositeTypes = new HashMap<Composite, MetadataType>();
    }

    public SegmentHandler(EdiForm form, MetadataFormat format, Map<TypeFormatConstants.GenericType, FieldAnnotationFactory> annoFacts) {
        this(form, TypeConverterFactory.buildTypeConverter(format), annoFacts);
    }

    public int buildSegment(Segment seg, ObjectTypeBuilder typeBuilder) {
        List comps = JavaConverters.seqAsJavaList((Seq)seg.components());
        return new SegmentComponentsFieldFactory(comps).execute(typeBuilder);
    }

    private class SegmentComponentsFieldFactory {
        private final List<SegmentComponent> components;
        private int valueCount;

        public SegmentComponentsFieldFactory(List<SegmentComponent> comps) {
            this.components = comps;
        }

        public int execute(ObjectTypeBuilder object) {
            this.valueCount = 0;
            this.addComponentFields(object, this.components);
            return this.valueCount;
        }

        private void addComponentField(ObjectTypeBuilder object, SegmentComponent comp) {
            Element element = ((BaseElementComponent)comp).element();
            TypeFormat typeFormat = element.typeFormat();
            TypeFormatConstants.GenericType typeCode = typeFormat.genericType();
            MetadataType metadataType = (MetadataType)SegmentHandler.this.typeConvert.get(typeCode);
            ObjectFieldTypeBuilder fieldBuilder = object.addField();
            if (comp.count() == 1) {
                fieldBuilder.key(comp.key());
                fieldBuilder.value(metadataType);
                FieldAnnotationFactory fieldAnnotationFactory = (FieldAnnotationFactory)SegmentHandler.this.fieldAnnotators.get(typeCode);
                if (fieldAnnotationFactory != null) {
                    TypeAnnotation typeAnnotation = fieldAnnotationFactory.create(typeFormat);
                    fieldBuilder.with(typeAnnotation);
                }
            } else {
                fieldBuilder.key(comp.key());
                fieldBuilder.value().arrayType().of(metadataType);
            }
            this.setUsageDetails(comp, fieldBuilder);
            ++this.valueCount;
        }

        private MetadataType buildComposite(List<SegmentComponent> comps, ObjectTypeBuilder builder) {
            int subCount = new SegmentComponentsFieldFactory(comps).execute(builder);
            ObjectType type = builder.build();
            this.valueCount += subCount;
            return type;
        }

        private void addComponentFields(ObjectTypeBuilder object, List<SegmentComponent> comps) {
            for (SegmentComponent comp : comps) {
                if (!SchemaUtils.includeForUsage(comp.usage())) continue;
                if (comp instanceof BaseElementComponent) {
                    this.addComponentField(object, comp);
                    continue;
                }
                if (comp instanceof BaseCompositeComponent) {
                    Composite composite = ((BaseCompositeComponent)comp).composite();
                    List subcomps = JavaConverters.seqAsJavaList((Seq)composite.components());
                    if (SegmentHandler.this.ediForm.inlineComposites() && comp.count() == 1) {
                        int subCount = new SegmentComponentsFieldFactory(subcomps).execute(object);
                        this.valueCount += subCount;
                        continue;
                    }
                    ObjectFieldTypeBuilder fieldBuilder = object.addField();
                    fieldBuilder.key(comp.key());
                    if (comp.count() == 1) {
                        fieldBuilder.value(this.buildComposite(subcomps, fieldBuilder.value().objectType()));
                    } else {
                        MetadataType type = (MetadataType)SegmentHandler.this.compositeTypes.get(composite);
                        if (type == null) {
                            type = this.buildComposite(subcomps, fieldBuilder.value().objectType());
                            SegmentHandler.this.compositeTypes.put(composite, type);
                        }
                        fieldBuilder.value().arrayType().of(type);
                    }
                    this.setUsageDetails(comp, fieldBuilder);
                    continue;
                }
                throw new IllegalStateException("Segment component of unknown type");
            }
        }

        private void setUsageDetails(SegmentComponent comp, ObjectFieldTypeBuilder fieldBuilder) {
            fieldBuilder.description(comp.name());
            if (comp.usage() == Usage.MandatoryUsage$.MODULE$) {
                fieldBuilder.required();
            }
        }
    }
}

