/*
 * Decompiled with CFR 0.152.
 */
package org.mule.flatfile.metadata.schema;

import com.mulesoft.flatfile.lexical.TypeFormatConstants;
import com.mulesoft.flatfile.schema.SchemaJavaValues;
import com.mulesoft.flatfile.schema.model.EdiForm;
import com.mulesoft.flatfile.schema.model.GroupComponent;
import com.mulesoft.flatfile.schema.model.LoopWrapperComponent;
import com.mulesoft.flatfile.schema.model.ReferenceComponent;
import com.mulesoft.flatfile.schema.model.Segment;
import com.mulesoft.flatfile.schema.model.Structure;
import com.mulesoft.flatfile.schema.model.StructureComponent;
import com.mulesoft.flatfile.schema.model.StructureSequence;
import com.mulesoft.flatfile.schema.model.Usage;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mule.flatfile.metadata.schema.FieldAnnotationFactory;
import org.mule.flatfile.metadata.schema.SchemaUtils;
import org.mule.flatfile.metadata.schema.SegmentHandler;
import org.mule.flatfile.metadata.schema.TypeConverterFactory;
import org.mule.metadata.api.annotation.LabelAnnotation;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectFieldTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import scala.collection.JavaConverters;
import scala.collection.Seq;

public class StructureHandler {
    private final Map<Segment, MetadataType> segmentTypes = new HashMap<Segment, MetadataType>();
    private final EdiForm ediForm;
    private final SegmentHandler segmentHandler;
    private final MetadataType stringType;

    public StructureHandler(MetadataFormat format, EdiForm form, Map<TypeFormatConstants.GenericType, FieldAnnotationFactory> annoFacts) {
        this.ediForm = form;
        Map<TypeFormatConstants.GenericType, MetadataType> types = TypeConverterFactory.buildTypeConverter(format);
        this.segmentHandler = new SegmentHandler(form, format, types, annoFacts);
        this.stringType = new BaseTypeBuilder(format).stringType().build();
    }

    public MetadataType getStringType() {
        return this.stringType;
    }

    private MetadataType buildSection(String key, StructureSequence seq, ObjectTypeBuilder container) {
        ObjectFieldTypeBuilder headerField = container.addField();
        headerField.key(key);
        List comps = JavaConverters.seqAsJavaList((Seq)seq.items());
        return new StructureComponentsFieldFactory(comps).execute(headerField.value().objectType());
    }

    public MetadataType buildStructure(Structure struct, boolean read, ObjectTypeBuilder typeBuilder) {
        if (read) {
            typeBuilder.addField().required().key(SchemaJavaValues.structureId()).description("Structure identifier").value(this.stringType);
            typeBuilder.addField().required().key(SchemaJavaValues.structureName()).description("Structure name").value(this.stringType);
        }
        if (struct.version().ediForm().layout().sectioned()) {
            struct.heading().foreach(seq -> this.buildSection(SchemaJavaValues.structureHeading(), (StructureSequence)seq, typeBuilder));
            struct.detail().foreach(seq -> this.buildSection(SchemaJavaValues.structureDetail(), (StructureSequence)seq, typeBuilder));
            struct.summary().foreach(seq -> this.buildSection(SchemaJavaValues.structureSummary(), (StructureSequence)seq, typeBuilder));
        } else if (struct.heading().nonEmpty()) {
            this.buildSection(SchemaJavaValues.structureHeading(), (StructureSequence)struct.heading().get(), typeBuilder);
        } else {
            throw new IllegalArgumentException("Missing required 'header' section for structure " + struct.ident());
        }
        return typeBuilder.build();
    }

    public MetadataType buildSegment(Segment segment, ObjectFieldTypeBuilder field) {
        MetadataType type = this.segmentTypes.get(segment);
        if (type == null) {
            ObjectTypeBuilder builder = field.value().objectType();
            this.segmentHandler.buildSegment(segment, builder);
            type = builder.build();
            this.segmentTypes.put(segment, type);
        }
        field.value(type);
        return type;
    }

    private class StructureComponentsFieldFactory {
        private final List<StructureComponent> components;
        private int valueCount;

        public StructureComponentsFieldFactory(List<StructureComponent> comps) {
            this.components = comps;
        }

        private LabelAnnotation buildLabelAnnotation(String key, String name) {
            if (name != null && name.length() > 0) {
                return new LabelAnnotation(key + " - " + name);
            }
            return new LabelAnnotation(key);
        }

        private MetadataType buildGroup(GroupComponent group, ObjectTypeBuilder builder) {
            List comps = JavaConverters.seqAsJavaList((Seq)group.seq().items());
            new StructureComponentsFieldFactory(comps).execute(builder);
            return builder.build();
        }

        public MetadataType execute(ObjectTypeBuilder object) {
            for (StructureComponent comp : this.components) {
                MetadataType compType;
                LabelAnnotation labelAnnotation;
                if (!SchemaUtils.includeForUsage(comp.usage()) || comp instanceof ReferenceComponent && StructureHandler.this.ediForm.isEnvelopeSegment(((ReferenceComponent)comp).segment().tag())) continue;
                ObjectFieldTypeBuilder fieldBuilder = object.addField();
                fieldBuilder.key(comp.key());
                int count = comp.count();
                if (comp instanceof ReferenceComponent) {
                    ReferenceComponent refc = (ReferenceComponent)comp;
                    Segment segment = refc.segment();
                    labelAnnotation = this.buildLabelAnnotation(refc.key(), segment.name());
                    compType = (MetadataType)StructureHandler.this.segmentTypes.get(segment);
                    if (compType == null) {
                        ObjectTypeBuilder segBuilder = fieldBuilder.value().objectType();
                        StructureHandler.this.segmentHandler.buildSegment(segment, segBuilder);
                        compType = segBuilder.build();
                        StructureHandler.this.segmentTypes.put(segment, compType);
                    }
                } else if (comp instanceof GroupComponent) {
                    GroupComponent group = (GroupComponent)comp;
                    compType = this.buildGroup(group, fieldBuilder.value().objectType());
                    labelAnnotation = this.buildLabelAnnotation(group.key(), group.ident());
                } else if (comp instanceof LoopWrapperComponent) {
                    LoopWrapperComponent loop = (LoopWrapperComponent)comp;
                    GroupComponent group = loop.wrapped();
                    compType = this.buildGroup(group, fieldBuilder.value().objectType());
                    labelAnnotation = this.buildLabelAnnotation(group.key(), group.ident());
                    count = group.count();
                } else {
                    throw new IllegalStateException("Unexpected type for schema metadata: " + comp.getClass().getName());
                }
                if (count == 1) {
                    fieldBuilder.value(compType);
                } else {
                    fieldBuilder.value().arrayType().of(compType);
                }
                if (comp.usage() == Usage.MandatoryUsage$.MODULE$) {
                    fieldBuilder.required();
                }
                if (labelAnnotation == null) continue;
                fieldBuilder.withKeyAnnotation((TypeAnnotation)labelAnnotation);
            }
            return object.build();
        }
    }
}

