/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest.beans;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;
import org.hamcrest.beans.PropertyUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HasPropertyWithValue<T>
extends TypeSafeDiagnosingMatcher<T> {
    private final String propertyName;
    private final Matcher<?> valueMatcher;

    public HasPropertyWithValue(String propertyName, Matcher<?> valueMatcher) {
        this.propertyName = propertyName;
        this.valueMatcher = valueMatcher;
    }

    public boolean matchesSafely(T bean, Description mismatchDescription) {
        try {
            Method readMethod = this.findReadMethod(bean, mismatchDescription);
            if (readMethod == null) {
                return false;
            }
            Object propertyValue = readMethod.invoke(bean, PropertyUtil.NO_ARGUMENTS);
            boolean valueMatches = this.valueMatcher.matches(propertyValue);
            if (!valueMatches) {
                mismatchDescription.appendText("property \"" + this.propertyName + "\" ");
                this.valueMatcher.describeMismatch(propertyValue, mismatchDescription);
            }
            return valueMatches;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        catch (IllegalAccessException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            return false;
        }
    }

    private Method findReadMethod(Object argument, Description mismatchDescription) throws IllegalArgumentException {
        PropertyDescriptor property = PropertyUtil.getPropertyDescriptor(this.propertyName, argument);
        if (null == property) {
            mismatchDescription.appendText("No property \"" + this.propertyName + "\"");
            return null;
        }
        Method readMethod = property.getReadMethod();
        if (null == readMethod) {
            mismatchDescription.appendText("property \"" + this.propertyName + "\" is not readable");
        }
        return readMethod;
    }

    public void describeTo(Description description) {
        description.appendText("hasProperty(");
        description.appendValue((Object)this.propertyName);
        description.appendText(", ");
        description.appendDescriptionOf(this.valueMatcher);
        description.appendText(")");
    }

    @Factory
    public static <T> Matcher<T> hasProperty(String propertyName, Matcher<?> value) {
        return new HasPropertyWithValue<T>(propertyName, value);
    }
}

