/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.restassured.config;

import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.Validate;

public class ConnectionConfig {
    private final CloseIdleConnectionConfig closeIdleConnectionConfig;

    public ConnectionConfig() {
        this(null);
    }

    public ConnectionConfig(CloseIdleConnectionConfig closeIdleConnectionConfig) {
        this.closeIdleConnectionConfig = closeIdleConnectionConfig;
    }

    public ConnectionConfig closeIdleConnectionsAfterEachResponse() {
        return new ConnectionConfig(new CloseIdleConnectionConfig(0L, TimeUnit.NANOSECONDS));
    }

    public ConnectionConfig closeIdleConnectionsAfterEachResponseAfter(long idleTime, TimeUnit timeUnit) {
        return new ConnectionConfig(new CloseIdleConnectionConfig(idleTime, timeUnit));
    }

    public ConnectionConfig closeIdleConnectionsAfterEachResponseAfter(CloseIdleConnectionConfig closeIdleConnectionConfig) {
        return new ConnectionConfig(closeIdleConnectionConfig);
    }

    public ConnectionConfig dontCloseIdleConnectionsAfterEachResponse() {
        return new ConnectionConfig(null);
    }

    public CloseIdleConnectionConfig closeIdleConnectionConfig() {
        return this.closeIdleConnectionConfig;
    }

    public boolean shouldCloseIdleConnectionsAfterEachResponse() {
        return this.closeIdleConnectionConfig() != null;
    }

    public static ConnectionConfig connectionConfig() {
        return new ConnectionConfig();
    }

    public ConnectionConfig and() {
        return this;
    }

    public static class CloseIdleConnectionConfig {
        private final long idleTime;
        private final TimeUnit timeUnit;

        public CloseIdleConnectionConfig(long idleTime, TimeUnit timeUnit) {
            if (idleTime < 0L) {
                throw new IllegalArgumentException("Idle time cannot be less than 0.");
            }
            Validate.notNull((Object)((Object)timeUnit), (String)"Timeunit cannot be null", (Object[])new Object[0]);
            this.idleTime = idleTime;
            this.timeUnit = timeUnit;
        }

        public long getIdleTime() {
            return this.idleTime;
        }

        public TimeUnit getTimeUnit() {
            return this.timeUnit;
        }
    }
}

