/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.processor.DynamicPipelineException;
import org.mule.api.processor.MessageProcessor;
import org.mule.construct.Flow;
import org.mule.module.apikit.AbstractConfiguration;
import org.mule.module.apikit.FlowMapping;
import org.mule.module.apikit.FlowResolver;
import org.mule.module.apikit.HttpRestRequest;
import org.mule.module.apikit.exception.ApikitRuntimeException;
import org.mule.module.apikit.transform.ApikitResponseTransformer;
import org.raml.model.Action;
import org.raml.model.Resource;
import org.raml.parser.loader.CompositeResourceLoader;
import org.raml.parser.loader.DefaultResourceLoader;
import org.raml.parser.loader.FileResourceLoader;
import org.raml.parser.loader.ResourceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Configuration
extends AbstractConfiguration {
    public static final String DEFAULT_CONSOLE_PATH = "console";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private boolean consoleEnabled = true;
    private String consolePath = "console";
    private List<FlowMapping> flowMappings = new ArrayList<FlowMapping>();
    private Map<String, Flow> restFlowMap;
    private Map<String, Flow> restFlowMapUnwrapped;
    private Map<String, Resource> flatResourceTree = new HashMap<String, Resource>();

    public boolean isConsoleEnabled() {
        return this.consoleEnabled;
    }

    public void setConsoleEnabled(boolean consoleEnabled) {
        this.consoleEnabled = consoleEnabled;
    }

    public String getConsolePath() {
        return this.consolePath;
    }

    public void setConsolePath(String consolePath) {
        this.consolePath = consolePath;
    }

    public List<FlowMapping> getFlowMappings() {
        return this.flowMappings;
    }

    public void setFlowMappings(List<FlowMapping> flowMappings) {
        this.flowMappings = flowMappings;
    }

    @Override
    protected HttpRestRequest getHttpRestRequest(MuleEvent event) {
        return new HttpRestRequest(event, this);
    }

    @Override
    public ResourceLoader getRamlResourceLoader() {
        DefaultResourceLoader loader = new DefaultResourceLoader();
        String appHome = (String)this.muleContext.getRegistry().get("app.home");
        if (appHome != null) {
            loader = new CompositeResourceLoader(new ResourceLoader[]{new FileResourceLoader(appHome), loader});
        }
        return loader;
    }

    @Override
    protected void initializeRestFlowMap() {
        this.flattenResourceTree(this.getApi().getResources());
        if (this.restFlowMap == null) {
            this.restFlowMap = new HashMap<String, Flow>();
            Collection flows = this.muleContext.getRegistry().lookupObjects(Flow.class);
            for (Flow flow : flows) {
                String key = this.getRestFlowKey(flow.getName());
                if (key == null) continue;
                this.restFlowMap.put(key, flow);
            }
            for (FlowMapping mapping : this.getFlowMappings()) {
                this.restFlowMap.put(mapping.getKey(), mapping.getFlow());
            }
            this.logMissingMappings();
            this.restFlowMapUnwrapped = new HashMap<String, Flow>(this.restFlowMap);
        }
    }

    private void flattenResourceTree(Map<String, Resource> resources) {
        for (Resource resource : resources.values()) {
            this.flatResourceTree.put(resource.getUri(), resource);
            if (resource.getResources() == null) continue;
            this.flattenResourceTree(resource.getResources());
        }
    }

    private void logMissingMappings() {
        for (Resource resource : this.flatResourceTree.values()) {
            String fullResource = resource.getUri();
            for (Action action : resource.getActions().values()) {
                String method = action.getType().name().toLowerCase();
                String key = method + ":" + fullResource;
                if (this.restFlowMap.get(key) != null) continue;
                if (action.hasBody()) {
                    for (String contentType : action.getBody().keySet()) {
                        if (this.restFlowMap.get(key + ":" + contentType) != null) continue;
                        this.logger.warn(String.format("Action-Resource-ContentType triplet has no implementation -> %s:%s:%s ", method, fullResource, contentType));
                    }
                    continue;
                }
                this.logger.warn(String.format("Action-Resource pair has no implementation -> %s:%s ", method, fullResource));
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("==== RestFlows defined:");
            for (String key : this.restFlowMap.keySet()) {
                this.logger.debug("\t\t" + key);
            }
        }
    }

    private void addResponseTransformers(Collection<Flow> flows) {
        for (Flow flow : flows) {
            try {
                flow.dynamicPipeline(null).injectAfter(new MessageProcessor[]{new ApikitResponseTransformer()}).resetAndUpdate();
            }
            catch (DynamicPipelineException e) {
            }
            catch (MuleException e) {
                throw new ApikitRuntimeException(e);
            }
        }
    }

    @Override
    public Set<String> getFlowActionRefs(Flow flow) {
        Set<String> flowActionRefs = super.getFlowActionRefs(flow);
        for (Map.Entry<String, Flow> entry : this.restFlowMapUnwrapped.entrySet()) {
            if (flow != entry.getValue()) continue;
            flowActionRefs.add(entry.getKey());
        }
        return flowActionRefs;
    }

    public Map<String, Flow> getRawRestFlowMap() {
        return this.restFlowMap;
    }

    private String getRestFlowKey(String name) {
        String[] coords = name.split(":");
        String[] methods = new String[]{"get", "put", "post", "delete", "head", "patch", "options"};
        if (coords.length < 2 || coords.length > 4 || !Arrays.asList(methods).contains(coords[0]) || !coords[1].startsWith("/")) {
            return null;
        }
        if (coords.length == 4) {
            if (coords[3].equals(this.getName())) {
                return this.validateRestFlowKeyAgainstApi(coords[0], coords[1], coords[2]);
            }
            return null;
        }
        if (coords.length == 3) {
            if (coords[2].equals(this.getName())) {
                return this.validateRestFlowKeyAgainstApi(coords[0], coords[1]);
            }
            return this.validateRestFlowKeyAgainstApi(coords[0], coords[1], coords[2]);
        }
        return this.validateRestFlowKeyAgainstApi(coords[0], coords[1]);
    }

    private String validateRestFlowKeyAgainstApi(String ... coords) {
        Action action;
        Resource apiResource;
        String method = coords[0];
        String resource = coords[1];
        String type = coords.length == 3 ? coords[2] : null;
        String key = String.format("%s:%s", method, resource);
        if (type != null) {
            key = key + ":" + type;
        }
        if ((apiResource = this.flatResourceTree.get(resource)) != null && (action = apiResource.getAction(method)) != null) {
            if (type == null) {
                return key;
            }
            if (action.hasBody() && action.getBody().get(type) != null) {
                return key;
            }
        }
        this.logger.warn(String.format("Flow named \"%s\" does not match any RAML descriptor resource", key));
        return null;
    }

    @Override
    protected FlowResolver getFlowResolver(AbstractConfiguration abstractConfiguration, String key) {
        return new RouterFlowResolver((Configuration)abstractConfiguration, key);
    }

    @Override
    public void start() throws MuleException {
        this.addResponseTransformers(this.restFlowMap.values());
    }

    private static class RouterFlowResolver
    implements FlowResolver {
        private static final String WRAPPER_FLOW_SUFFIX = "-gateway-wrapper";
        private Map<String, Flow> restFlowMap;
        private String key;
        private Flow targetFlow;
        private Flow wrapperFlow;

        RouterFlowResolver(Configuration configuration, String key) {
            this.restFlowMap = configuration.restFlowMap;
            this.key = key;
            this.targetFlow = this.restFlowMap.get(key);
        }

        @Override
        public Flow getFlow() {
            if (this.wrapperFlow != null) {
                return this.wrapperFlow;
            }
            if (this.targetFlow == null) {
                return null;
            }
            this.wrapperFlow = this.wrapFlow();
            this.restFlowMap.put(this.key, this.wrapperFlow);
            return this.wrapperFlow;
        }

        private Flow wrapFlow() {
            String flowName = this.targetFlow.getName() + WRAPPER_FLOW_SUFFIX;
            MuleContext muleContext = this.targetFlow.getMuleContext();
            Flow wrapper = new Flow(flowName, muleContext);
            wrapper.setMessageProcessors(Collections.singletonList(new MessageProcessor(){

                public MuleEvent process(MuleEvent muleEvent) throws MuleException {
                    return RouterFlowResolver.this.targetFlow.process(muleEvent);
                }
            }));
            try {
                muleContext.getRegistry().registerFlowConstruct((FlowConstruct)wrapper);
                if (!wrapper.isStarted()) {
                    wrapper.start();
                }
            }
            catch (MuleException e) {
                throw new RuntimeException("Error registering flow " + flowName, e);
            }
            return wrapper;
        }
    }
}

