/*
 * Decompiled with CFR 0.152.
 */
package org.mule.example.geomail.components;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ReceivedHeader {
    private String id;
    private String from;
    private String by;
    private String via;
    private String with;
    private String _for;
    private String timestamp;

    public static ReceivedHeader getInstance(String receivedHeader) {
        String fromPattern = "(?:from (.*?))?";
        String byPattern = "(?:by (.*?))?";
        String viaPattern = "(?:via (.*?))?";
        String withPattern = "(?:with (.*?))?";
        String idPattern = "(?:id (.*?))?";
        String forPattern = "(?:for (.*?))?";
        String timePattern = ";(.*)";
        String pattern = fromPattern + byPattern + viaPattern + withPattern + idPattern + forPattern + timePattern;
        Matcher matcher = Pattern.compile(pattern, 32).matcher(receivedHeader);
        ReceivedHeader result = null;
        if (matcher.find()) {
            result = new ReceivedHeader();
            result.setFrom(matcher.group(1));
            result.setBy(matcher.group(2));
            result.setVia(matcher.group(3));
            result.setWith(matcher.group(4));
            result.setId(matcher.group(5));
            result.setFor(matcher.group(6));
            result.setTimestamp(matcher.group(7));
        }
        return result;
    }

    public String getId() {
        return this.id;
    }

    private void setId(String id) {
        this.id = id != null ? id.trim() : null;
    }

    public String getFrom() {
        return this.from;
    }

    private void setFrom(String from) {
        this.from = from != null ? from.trim() : null;
    }

    public String getBy() {
        return this.by;
    }

    private void setBy(String by) {
        this.by = by != null ? by.trim() : null;
    }

    public String getVia() {
        return this.via;
    }

    private void setVia(String via) {
        this.via = via != null ? via.trim() : null;
    }

    public String getWith() {
        return this.with;
    }

    private void setWith(String with) {
        this.with = with != null ? with.trim() : null;
    }

    public String getFor() {
        return this._for;
    }

    public void setFor(String _for) {
        this._for = _for != null ? _for.trim() : null;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    private void setTimestamp(String timestamp) {
        this.timestamp = timestamp.trim();
    }

    public String toString() {
        return "Received {\n  " + (this.getId() != null ? "id: " + this.getId() + "\n  " : "") + (this.getFrom() != null ? "from: " + this.getFrom() + "\n  " : "") + (this.getBy() != null ? "by: " + this.getBy() + "\n  " : "") + (this.getVia() != null ? "via: " + this.getVia() + "\n  " : "") + (this.getWith() != null ? "with: " + this.getWith() + "\n  " : "") + (this.getFor() != null ? "for: " + this.getFor() + "\n  " : "") + "date-time: " + this.getTimestamp() + "\n  " + "}";
    }
}

