/*
 * Decompiled with CFR 0.152.
 */
package org.mule.example.geomail.components;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.Message;
import org.mule.DefaultMuleMessage;
import org.mule.api.DefaultMuleException;
import org.mule.api.MuleEventContext;
import org.mule.api.MuleMessage;
import org.mule.api.lifecycle.Callable;
import org.mule.example.geomail.components.ReceivedHeader;

public class Mail
implements Callable {
    public Object onCall(MuleEventContext eventContext) throws Exception {
        MuleMessage message = eventContext.getMessage();
        Message mail = (Message)message.getPayload();
        String from = mail.getFrom()[0].toString();
        String[] received = mail.getHeader("Received");
        ArrayList<String> list = new ArrayList<String>();
        for (int i = received.length - 1; i >= 0; --i) {
            String ip;
            ReceivedHeader receivedHeader = ReceivedHeader.getInstance((String)received[i]);
            if (receivedHeader == null || receivedHeader.getFrom() == null || receivedHeader.getFrom().startsWith("localhost") || receivedHeader.getFrom().startsWith("127.0.0.1") || (ip = this.getFromIP(receivedHeader)) == null) continue;
            list.add(ip);
        }
        if (list.isEmpty()) {
            throw new DefaultMuleException("Received e-mail does not provide sender IP information.");
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("from.email.address", from);
        DefaultMuleMessage result = new DefaultMuleMessage(list, properties, eventContext.getMuleContext());
        return result;
    }

    private String getFromIP(ReceivedHeader receivedHeader) {
        String result = null;
        Matcher matcher = Pattern.compile(".*\\(.*\\[(.*?)\\]\\)", 32).matcher(receivedHeader.getFrom());
        if (matcher.matches()) {
            result = matcher.group(1);
        }
        return result;
    }
}

