/*
 * Decompiled with CFR 0.152.
 */
package org.mule.example.geomail.components;

import org.apache.log4j.Logger;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEventContext;
import org.mule.api.MuleMessage;
import org.mule.api.lifecycle.Callable;
import org.mule.example.geomail.dao.Sender;
import org.mule.example.geomail.dao.SenderDao;

public class Storage
implements Callable {
    private static final Logger log = Logger.getLogger((String)Storage.class.getName());
    private SenderDao senderDao;

    public Object onCall(MuleEventContext context) throws Exception {
        MuleMessage message = context.getMessage();
        log.info((Object)("GroupSize: " + message.getCorrelationGroupSize()));
        log.info((Object)("Correlation ID: " + message.getCorrelationId()));
        log.info((Object)("Sequence Number: " + message.getCorrelationSequence()));
        String from = (String)message.getOutboundProperty("from.email.address");
        Sender sender = (Sender)message.getPayload();
        sender.setEmail(from);
        if (this.getSenderDao().getSender(sender.getIp()) != null) {
            log.warn((Object)("Sender '" + sender + "' should not be in the Database."));
        } else {
            this.getSenderDao().addSender(sender);
            log.warn((Object)("Sender '" + sender + "' successfully added to the Database."));
        }
        DefaultMuleMessage resultMessage = new DefaultMuleMessage((Object)sender, context.getMuleContext());
        resultMessage.setCorrelationGroupSize(message.getCorrelationGroupSize());
        resultMessage.setCorrelationId(message.getCorrelationId());
        resultMessage.setCorrelationSequence(message.getCorrelationSequence());
        return resultMessage;
    }

    public SenderDao getSenderDao() {
        return this.senderDao;
    }

    public void setSenderDao(SenderDao senderDao) {
        this.senderDao = senderDao;
    }
}

