/*
 * Decompiled with CFR 0.152.
 */
package org.mule.exchange.core;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.multipart.FormDataMultiPart;
import com.sun.jersey.multipart.impl.MultiPartWriter;
import javax.ws.rs.core.MediaType;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.jaxrs.JacksonJsonProvider;
import org.codehaus.jackson.map.DeserializationConfig;
import org.mule.exchange.exceptions.ConflictException;
import org.mule.exchange.mapping.ObjectMapper;

public class ExchangeClient {
    private static final String DEFAULT_URL = "https://anypoint.mulesoft.com";
    private Log logger = LogFactory.getLog(this.getClass());
    private Client client;
    private String url;
    private String coreServicesAccessToken;

    private ClientConfig getJerseyConfig() {
        DefaultClientConfig clientConfig = new DefaultClientConfig();
        clientConfig.getClasses().add(JacksonJsonProvider.class);
        clientConfig.getClasses().add(MultiPartWriter.class);
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        JacksonJsonProvider jsonProvider = new JacksonJsonProvider((org.codehaus.jackson.map.ObjectMapper)mapper);
        clientConfig.getSingletons().add(jsonProvider);
        return clientConfig;
    }

    protected Exception buildException(ClientResponse clientResponse) throws Exception {
        String message = "";
        message = ClientResponse.Status.BAD_REQUEST.equals((Object)clientResponse.getClientResponseStatus()) ? (String)clientResponse.getEntity(String.class) : clientResponse.getClientResponseStatus().getReasonPhrase();
        return new Exception(message);
    }

    public ExchangeClient(String coreServicesAccessToken) {
        this(coreServicesAccessToken, DEFAULT_URL);
    }

    public ExchangeClient(String coreServicesAccessToken, String url) {
        this.url = url;
        this.coreServicesAccessToken = coreServicesAccessToken;
        this.client = Client.create((ClientConfig)this.getJerseyConfig());
    }

    public String getUrl() {
        if (StringUtils.isBlank((String)this.url)) {
            this.url = DEFAULT_URL;
        }
        return this.url;
    }

    private WebResource.Builder authorizeResource(WebResource pathResource) throws Exception {
        return pathResource.header("Authorization", (Object)("Bearer " + this.coreServicesAccessToken));
    }

    public String registerAsset(String organizationId, String assetGroup, String assetId, String assetVersion, String assetName, String classifier, String apiVersion) throws Exception {
        String path = "exchange/api/v1/assets";
        this.logger.debug((Object)("Hitting " + path));
        FormDataMultiPart asset = new FormDataMultiPart().field("organizationId", organizationId).field("groupId", assetGroup).field("assetId", assetId).field("version", assetVersion).field("name", assetName).field("classifier", classifier).field("apiVersion", apiVersion).field("asset", "undefined");
        ClientResponse clientResponse = (ClientResponse)((WebResource.Builder)this.authorizeResource(this.client.resource(this.getUrl()).path(path)).type(MediaType.MULTIPART_FORM_DATA_TYPE)).post(ClientResponse.class, (Object)asset);
        if (ClientResponse.Status.CREATED.equals((Object)clientResponse.getClientResponseStatus())) {
            String response = (String)clientResponse.getEntity(String.class);
            return response;
        }
        if (ClientResponse.Status.CONFLICT.equals((Object)clientResponse.getClientResponseStatus())) {
            throw new ConflictException();
        }
        throw this.buildException(clientResponse);
    }

    public static void main(String[] args) throws Exception {
        ExchangeClient coso = new ExchangeClient("e3ea734f-7bb5-40fb-9180-7143a7659fb4");
        coso.registerAsset("d60b5d1a-a55b-4e58-adf8-12a2038c7cbe", "d60b5d1a-a55b-4e58-adf8-12a2038c7cbe", "jdbc-dgw", "1.0.0", "JDBC DGW", "http", "v1");
    }
}

