/*
 * Decompiled with CFR 0.152.
 */
package requesterpj.internal.connection.provider;

import com.mulesoft.connectivity.rest.commons.api.connection.RestConnectionProvider;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import requesterpj.internal.connection.RequesterConnection;

public class RequesterConnectionProvider
extends RestConnectionProvider<RequesterConnection> {
    @DisplayName(value="Base Uri")
    @Summary(value="Parameter base URI. Each instance or tenant gets its own base URI.")
    @Parameter
    @Optional
    private String baseUri;

    public String getBaseUri() {
        return this.baseUri;
    }

    protected RequesterConnection createConnection(HttpClient httpClient) {
        return new RequesterConnection(httpClient, this.getBaseUri());
    }

    public ConnectionValidationResult validate(RequesterConnection connection) {
        String fullUri = connection.getBaseUri();
        HttpRequest build = HttpRequest.builder().uri(fullUri).method(HttpConstants.Method.GET).build();
        try {
            int statusCode = connection.getHttpClient().send(build).getStatusCode();
            if (statusCode > 300 || statusCode < 200) {
                return ConnectionValidationResult.failure((String)("Invalid status code: " + statusCode), (Exception)new Exception("Invalid status code: " + statusCode));
            }
            return ConnectionValidationResult.success();
        }
        catch (Exception e) {
            return ConnectionValidationResult.failure((String)e.getMessage(), (Exception)new Exception("Unexpected error has occurred"));
        }
    }
}

