/*
 * Decompiled with CFR 0.152.
 */
package requesterpj.internal.operation;

import com.mulesoft.connectivity.rest.commons.api.operation.BaseRestOperation;
import java.io.InputStream;
import java.util.concurrent.CompletableFuture;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import requesterpj.internal.config.RequesterConfig;
import requesterpj.internal.connection.RequesterConnection;

public class HttpRequestTransformedOutputOperation
extends BaseRestOperation {
    private static final String APPLICATION_JSON = "application/json";

    @MediaType(value="application/json")
    public void getHttpTransformedOutput(@Config RequesterConfig config, @Connection RequesterConnection connection, CompletionCallback<InputStream, Object> callback, String endpoint) {
        String fullUri = connection.getBaseUri() + "/" + endpoint;
        HttpRequest build = HttpRequest.builder().uri(fullUri).method(HttpConstants.Method.GET).build();
        CompletableFuture httpResponseCompletableFuture = connection.getHttpClient().sendAsync(build, HttpRequestOptions.builder().followsRedirect(true).build());
        httpResponseCompletableFuture.whenComplete((response, exception) -> {
            if (exception != null) {
                callback.error(exception);
            } else if (response.getStatusCode() > 300 || response.getStatusCode() < 200) {
                callback.error((Throwable)new Exception("Invalid status code: " + response.getStatusCode()));
            } else {
                InputStream content = response.getEntity().getContent();
                TypedValue tvInput = new TypedValue((Object)content, DataType.JSON_STRING);
                TypedValue typedValue = this.getExpressionLanguage().evaluate("#[{mensaje: payload.message, pifia: payload.error}]", BindingContext.builder().addBinding("payload", tvInput).build());
                CursorStreamProvider value = (CursorStreamProvider)typedValue.getValue();
                Result result = Result.builder().output((Object)value.openCursor()).build();
                callback.success(result);
            }
        });
    }
}

